/*******************
** Eldarea MUDLib **
********************
**
** secure/explorelist.c - explore list object
**
** CVS DATA
** $Date: 2001/02/06 08:55:13 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: explorelist.c,v $
** Revision 1.2  2001/02/06 08:55:13  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "/std/shells/filesys/asynchron";

#include <properties.h>
#include <wizlevels.h>
#include <clock.h>
#include <player/explore.h>

#define PLAYER 0
#define PROCENT 1
#define GENDER 2
#define SEER 3
#define LEVEL 4
#define QP 5
#define XP 6
#define AGE 7

#define MAXLIST 100
#define WAITTIME 500
#define START_TIME 841548600  //1.September 1996
#undef DAY
#define DAY 86400
#define LIST "/etc/forscherliste.gen"

mapping properties;
int age;
mixed *list;

void get_list();
void calculate_ep(string player);
void output(int called);


/*************************************/
/* Funktion create()                 */
/*                                   */
/* Erstellung einer Liste beim Laden */
/*************************************/
void create()
{
  seteuid(getuid(this_object()));
  if (this_interactive()) {
    write(break_string("\nListenupdate muss manuell angeworfen werden, wenn "
      "Automatik zu weit in Zukunft! Dazu muss in diesem Objekt get_list() "
      "aufgerufen werden (Achtung: Erzeugt fuer 2 Minuten Megalag) und danach "
      "das Skript ~mud/bin/forscher2 um eine Klartextliste zu erzeugen. Von "
      "dieser Vorgehensweise wird abgeraten.\n\n", 78,0,1));
    call_out("renew_list",1,1);
  } else call_out("renew_list",1);
}


/**************************************************************************/
/* Funktion: void renew_list(int dont_do)                                            */
/*                                                                        */
/* Die Funktion steuert die Intervalle, in denen eine neue Liste erstellt */
/* werden soll. Die call_outs wurden nicht in get_list() eingetragen,     */
/* da jene Funktion auch per Hand aufrufbar sein soll.                    */
/**************************************************************************/
void renew_list(int dont_do)
{
  int diff, call_time;

  if (!dont_do) get_list();

  // Um (0 Uhr + 5 Stunden)
  call_time=CLOCK->get_0_oclock(time())+5*3600;
  call_time-=time();

  if (call_time<10*60) // Nicht in 10 Minuten nochmal, dann erst naechsten Tag
    call_time+=DAY;

  call_out("renew_list",call_time);
  if (dont_do) write("\nNeue Forscherliste in "+ctime(call_time)[11..18]+
    " Stunden. Klartext 30 Minuten spaeter.\n");
  // Mehr als 24 Stunden sollte nicht moeglich sein, keine Abfrage darauf
}


/***********************************************************************/
/* Funktion: void get_list()                                           */
/*                                                                     */
/* Diese Funktion wird vom Reset aufgerufen und startet die asynchrone */
/* Verarbeitung zur Erstellung der Liste                               */
/***********************************************************************/
void get_list()
{
  int i;
  string *players;

  list = ({});

  /**********************************************************/
  /* Namen der Spieler werden ermittelt und fuer jeden wird */
  /* calculate_ep() aufgerufen                              */
  /**********************************************************/
  for (i='a';i<='z';i++)
    asynchron(get_dir("/save/"+sprintf("%c",i)+"/*.o"), #'calculate_ep);

  output(0);
}


/*****************************************************************************/
/* Funktion: void calculate_ep(string)                                       */
/*                                                                           */
/* Diese Funktion ermittelt die Properties aus den Spieler-Save-Files.       */
/* Es wird ein Array zusammengestellt, welcher die Werte beinhaltet,         */
/* die Spaeter in der Liste erscheinen sollen.                               */
/* Ein Element des Arrays hat folgende Form:                                 */
/*   list[i] = ({ player, procent, gender, seer, level, qp, xp, age }),      */
/*                                                                           */
/* player : Name des Spielers                                                */
/* procent: Prozentwert der breits gefundenen Forschungspunkte               */
/* gender : Geschlecht des Spielers (nur MALE oder FEMALE)                   */
/* seer   : Kennung (1=Seher, 0=Spieler)                                     */
/* level  : Level des Spielers                                               */
/* qp     : Abenteuerpunkte des Spielers                                     */
/* xp     : Erfahrungspunkte des Spielers                                    */
/* age    : Alter des Spielers in Sekunden (direkt aus dem Save-File)        */
/*                                                                           */
/* Die Liste wird anschliessend in einer anderen Funktion nach den Prozenten */
/* sortiert.                                                                 */
/*                                                                           */
/* Als Argument dient der Spielername.                                       */
/*****************************************************************************/
void calculate_ep(string player)
{
  int i, k, ep, max_ep, procent, gender, level, seer, xp, qp;
  string explored;
  mixed *values;

  properties = ([]);
  age = 0;

  restore_object("/save/"+player[0..0]+"/"+(player=player[0..<3]));

  if (!properties)
    return;

  /****************************************/
  /* Magier erscheinen nicht in der Liste */
  /****************************************/
  if (IS_LEARNER(player) || properties[P_TESTPLAYER])
    return;

  /***********************************************************************/
  /* Wenn der Spieler die Property mit den Forschungspunkten hat, werden */
  /* die Werte ermittelt                                                 */
  /***********************************************************************/
  if (member(properties,P_EXPLORED) && (explored=properties[P_EXPLORED])!="")
  {
    ep = 0;

    if (!stringp(explored)) return;
    if (explored[0]!='&') { // Altes P_EXPLORED
      for (k=strlen(explored),i=0;i<k;i++)
        if ((explored[i..i]=="1") && (sizeof(values=EXPLOREMASTER->QueryEPNumber(i))) && 
         (values[ACTIVE])) 
          ep+=values[POINTS];
    } else { // Neues P_EXPLORED
      explored=explored[1..];
      for (i=strlen(explored)*6; i--;) {
        if (test_bit(explored, i) && sizeof(values=EXPLOREMASTER->QueryEPNumber(i))
          && values[ACTIVE]) {
          ep+=values[POINTS];
        }
      }
    }

    if (!ep)
      return;

    if (!(max_ep=EXPLOREMASTER->QueryMaxEP())) 
      procent = 100;
    else
      procent = (int)(ep * 100 / max_ep);

    if (properties[P_GENDER]==FEMALE)
      gender = FEMALE;
    else
      gender = MALE;

    gender = ((properties[P_GENDER]==FEMALE)?FEMALE:MALE);
    seer = (IS_SEER(player)?1:0);
    level = properties[P_LEVEL];
    qp = properties[P_QP];
    xp = properties[P_XP];

    list += ({ ({ player , procent , gender , seer , level , qp , xp , age }) });
  }
}


/**************************************************************************/
/* Funktion: void ouptut()                                                */
/*                                                                        */
/* Die Funktion Ausgabe wartet, bis die asynchrone Verarbeitung der Liste */
/* beendet ist und gibt dann die Liste in dem richtgen Format aus.        */
/**************************************************************************/
void output(int called)
{
  int i, j, k, x, text;

  /****************************************************************/
  /* Es wird eine Weile gewartet, bis die asynchrone Verarbeitung */
  /* fertig ist                                                   */
  /****************************************************************/
  if (!called)
  {
    call_out("output",WAITTIME,++called);
    return;
  }

  /****************************************************************************/
  /* Die Liste wird nach den Prozentwerten fuer die Forschungspunkte sortiert */
  /****************************************************************************/
  list = sort_array(list, lambda( ({'a,'b}), ({#'<, ({#'[,'a,1}), ({#'[,'b,1}) }) ));

  /***********************************************/
  /* Die Liste wird in ein neues File ausgegeben */
  /***********************************************/
  rm(LIST);

  //write_file(LIST, "\n                    Die Topliste der Wunderland-Forscher\n\n"
  //  +"                                    vom\n\n                        "+dtime(time())+"\n"
  //  +"Number, Name, Gender, Level, QP, XP, Age, is_seer, Text\n\n");

  for (((x=sizeof(list))>MAXLIST?j=MAXLIST:j=x),k=(j-1),i=0;i<j;i++)
  {
    switch(list[i][PROCENT])
    {
      case 0..5   : text = 1; break;
      case 6..10  : text = 2; break;
      case 11..15 : text = 3; break;
      case 16..20 : text = 4; break;
      case 21..25 : text = 5; break;
      case 26..30 : text = 6; break;
      case 31..35 : text = 7; break;
      case 36..40 : text = 8; break;
      case 41..45 : text = 9; break;
      case 46..50 : text = 10; break;
      case 51..55 : text = 11; break;
      case 56..60 : text = 12; break;
      case 61..65 : text = 13; break;
      case 66..70 : text = 14; break;
      case 71..75 : text = 15; break;
      case 76..80 : text = 16; break;
      case 81..85 : text = 17; break;
      case 86..90 : text = 18; break;
      case 91..95 : text = 19; break;
      case 96..100: text = 20; break;
      default     : text = 21; break;
    }

    write_file(LIST, sprintf("%d %s %d %d %d %d %d %d %d\n",
      i+1, list[i][PLAYER], list[i][GENDER], list[i][LEVEL], list[i][QP], list[i][XP],
      list[i][AGE], list[i][SEER], text));
  }
}


/***********************************************************/
/* Funktion: void remove()                                 */
/*                                                         */
/* Bevor das Objekt zerstoert wird, muessen alle call_outs */
/* beseitigt werden.                                       */
/***********************************************************/
void remove()
{
  while(remove_call_out("asynchron")!=-1);
  while(remove_call_out("output")!=-1);
  while(remove_call_out("renew_list")!=-1);

  destruct(this_object());
}
