/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: exploremaster.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// SECURE/EXPLORMASTER.C --- exploremaster object 
//
// Author: Bongo@Wunderland
//
/*
 * $Date: 1999/11/05 12:30:45 $
 * $Revision: 1.1.1.1 $
 * $Log: exploremaster.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:45  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:12  en
 * MUDLib CVS Preperation
 *
 * Revision 1.13  1998/07/17 13:25:27  Holger
 * Hmm. Hatte noch paar Debug-Msgs vergessen
 *
 * Revision 1.12  1998/07/17 13:15:57  Holger
 * Paar Aenderungen an den 'berechtigten' Levels (RMs etc.) Umbau
 * von asy_ep_list() und einbau get_dep_list(). Deaktivierung der
 * Auto-Anmeldung von NPCs
 *
 * Revision 1.11  1997/08/08 09:57:19  Bongo
 * query_npc_ep() eingefuegt
 *
 * Revision 1.10  1997/08/08 07:36:50  Bongo
 * Listenerstellung auf asynchrone Verarbeitung umgestellt.
 *
 * Revision 1.9  1997/02/28 08:36:54  Bongo
 * Speed up
 *
 * Revision 1.8  1997/02/03 16:38:54  Bongo
 * QuerySeerEP() eingebaut um MIN_EP_FOR_SEER auszugeben
 *
 * Revision 1.7  1996/11/20 11:10:30  Bongo
 * catch bei call_other eingebaut
 *
 * Revision 1.6  1996/09/16 14:15:34  Bongo  
 * Added Funktion CheckMaxEP()
 *
 * Revision 1.5  1996/09/16 08:10:53  Bongo
 * *** empty log message ***
 *
 */

inherit "std/shells/filesys/asynchron";

#pragma strong_types

#define NEED_PROTOTYPES

#include <properties.h>
#include <wizlevels.h>
#include <config.h>
#include <exploremaster.h>

int max_EP;
string *explore_obj;
int *ep;
int *activity;

void save_info() {
  save_object( EXPLORE );
}

private static varargs int secure(mixed what) {
  if(!(previous_object()))
    return 0;
  if(!this_interactive())
    return 0;
  if(this_interactive()!=this_player())
    return 0;
  if(IS_ARCH(this_player()))
    return 1;
  if(what && what=to_string(what)){
    if(!IS_LORD(this_player()))
      return 0;
    if(MASTER->valid_write(what, geteuid(this_interactive())))
      return 1;
  }
  return 0;
}

void create() {
  seteuid(getuid(this_object()));
  if(!restore_object( EXPLORE )) {
    explore_obj=({});
    ep=({});
    activity=({});
    max_EP=0;
  }
  CheckMaxEP();
}

/************************************************/
/* void asy_ep_list()                           */
/*                                              */
/* Asynchrone Verarbeitung der Listenerstellung */
/************************************************/
varargs void asy_ep_list(int i, string path) {
  if(!stringp(path) || !strlen(path))
    write_file(FORSCHUNG,sprintf("%d.   %-60s    %d     %d\n",i,explore_obj[i],
      ep[i],activity[i]));
  else {
    write_file(DFORSCHUNG(path),sprintf("%d.   %-60s    %d     %d\n",i,explore_obj[i],
      ep[i],activity[i]));
  }
}
   
/*********************************************************/
/* int get_ep_list()                                     */
/*                                                       */
/* Es wird eine uebersichtliche Liste aller angemeldeten */
/* Objekte erstellt und abgespeichert                    */
/*********************************************************/
int get_ep_list() {
  int *idx, i,j;
  while(remove_call_out(#'asynchron)!=-1);
  rm(FORSCHUNG);
  if(catch(write_file(FORSCHUNG,
    "Angemeldete Forschungs-Objekte\n------------------------------\n\n")))
      return -3;
  j=sizeof(explore_obj);
  if (!explore_obj || !j) {
    write_file(FORSCHUNG,"Zur Zeit sind keine Objekte angemeldet.\n");
    return 1;
  }
  idx = ({});
  for(i=0;i<j;i++)
    idx += ({ i });
  write_file(FORSCHUNG,"Stelle,   Objekt,   EP-Anzahl,   aktiv/deaktiv\n");
  write_file(FORSCHUNG,"==============================================\n");
  asynchron(idx, #'asy_ep_list);
  return 1;
}

/*********************************************************/
/* int get_dep_list(string region) (Holger)              */
/*                                                       */
/* Es wird eine uebersichtliche Liste aller angemeldeten */
/* Objekte der Region erstellt und nach                  */
/* /d/region/LORD/forschung abgespeichert                */
/*********************************************************/
int get_dep_list(string region) {
  int *idx, i,j;
  if(!region || !strlen(region))
    return -2;
  if(member_array(region, MASTER->get_domains())<0)
    return -1;
  if(!secure(DFORSCHUNG(region)))
    return 0;
  while(remove_call_out(#'asynchron)!=-1);
  rm(DFORSCHUNG(region));
  if(catch(write_file(DFORSCHUNG(region),
    "Angemeldete Forschungs-Objekte\n------------------------------\n\n")))
      return -3;
  j=sizeof(explore_obj);
  if(!explore_obj || !j) {
    write_file(FORSCHUNG,"Zur Zeit sind keine Objekte angemeldet.\n");
    return 1;
  }
  idx = ({});
  for(i=0;i<j;i++)
    if(strstr(explore_obj[i],"/"+DOMAINDIR+"/"+region)==0)
      idx += ({ i });
  write_file(DFORSCHUNG(region),"Stelle,   Objekt,   EP-Anzahl,   aktiv/deaktiv\n");
  write_file(DFORSCHUNG(region),"==============================================\n");
  asynchron(idx, #'asy_ep_list, ({region}));
  return 1;
}

/**************************************************************/
/* int AddEP(string epobject, int points)                     */
/*                                                            */
/* Anmeldung eines Objekts                                    */
/*                                                            */
/* epobject --> Filename des Objekts, welches die Funktion    */
/*              this_player()->GiveEP() beinhaltet            */
/* points ----> Anzahl der Punkte, die vergeben werden sollen */
/*                                                            */
/* Returnwerte:                                               */
/*  1 --> Objekt ist angemeldet worden                        */
/*  0 --> Keine Berechtigung zum Anmelden                     */
/* -1 --> Fehler im Array-Handling aufgetaucht                */
/* -2 --> Falsche Argumente wurden uebergeben                 */
/* -3 --> Objekt ist bereits angemeldet                       */
/* -4 --> Die Punktanzahl ist nicht im erlaubten bereich      */
/* -5 --> Objekt kann nicht geladen werden                    */ 
/**************************************************************/
int AddEP(string epobject, int points) {
  if(!epobject || !stringp(epobject) || !points || !intp(points))
    return -2;
  if(!secure(epobject)) 
    return 0;
  if(!CheckArrays()) 
    return -1;
  if(member(explore_obj,epobject)!=-1) 
    return -3;
  if(points<OBJECT_MIN || points>OBJECT_MAX) 
    return -4;
  if(catch(call_other(epobject,"???")) || !find_object(epobject)) 
    return -5;
  explore_obj+=({ epobject });
  ep+=({ points });
  activity+=({ 1 });
  max_EP+=points;
  save_info();
  EPLOG(sprintf("AddEP: Object: %s\n  Points: %d Activity: %d  Wizard: %s",
                  epobject,points,1,geteuid(this_interactive())));
  get_ep_list();
  return 1;
}

/****************************************************************/
/* int ActivateEP(string epobject)                              */
/*                                                              */
/* Aktivieren eines Objekts                                     */
/* Nur aktivierte Objekte werden bei der Gesamtanzahl an        */
/* zu bekommenden Forschungspunkten mit einberechnet.           */
/* Daran orientiert sich auch die bereits erhaltene Gesamtmenge */
/* eines Spielers. (Sie veraendert sich auch nachtraeglich)     */
/*                                                              */
/* epobject --> Objekt, das bereits angemeldet ist und nun      */
/*              aktiviert werden soll                           */
/*                                                              */
/* Returnwerte:                                                 */
/*  1 --> Objekt  ist aktiviert worden                          */
/*  0 --> Keine Berechtigung zum Aktivieren                     */
/* -1 --> Fehler im Array-Handling aufgetaucht                  */
/* -2 --> Falsches Argument wurde uebergeben                    */
/* -3 --> Objekt ist noch nicht angemeldet                      */
/****************************************************************/
int ActivateEP(string epobject) {
  int tag;
  if(!epobject || !stringp(epobject))
    return -2;
  if(!secure(epobject))
    return 0;
  if(!CheckArrays()) 
    return -1;
  if(!epobject || !stringp(epobject)) 
    return -2;
  if((tag=member(explore_obj,epobject))==-1) 
    return -3;
  if(activity[tag]) 
    return 1;
  max_EP+=ep[tag];
  activity[tag]++;
  save_info();
  EPLOG(sprintf("ActivateEP: Object: %s\n  Points: %d Activity: %d  Wizard: %s",
                explore_obj[tag],ep[tag],activity[tag],geteuid(this_interactive())));
  get_ep_list();
  return 1;
}

/****************************************************************/
/* int DeactivateEP(string epobject)                            */
/*                                                              */
/* Deaktivieren eines Objekts                                   */
/* Nur aktivierte Objekte werden bei der Gesamtanzahl an        */
/* zu bekommenden Forschungspunkten mit einberechnet.           */
/* Daran orientiert sich auch die bereits erhaltene Gesamtmenge */
/* eines Spielers. (Sie veraendert sich auch nachtraeglich      */
/*                                                              */
/* epobject --> Objekt, das bereits angemeldet ist und nun      */
/*              deaktiviert werden soll                         */
/*                                                              */
/* Returnwerte:                                                 */
/*  1 --> Objekt  ist deaktiviert worden                        */
/*  0 --> Keine Berechtigung zum Deaktivieren                   */
/* -1 --> Fehler im Array-Handling aufgetaucht                  */
/* -2 --> Falsches Argument wurde uebergeben                    */
/* -3 --> Objekt ist noch nicht angemeldet                      */
/****************************************************************/
int DeactivateEP(string epobject) {
  int tag;
  if(!epobject || !stringp(epobject)) 
    return -2;
  if(!secure(epobject)) 
    return 0;
  if(!CheckArrays()) 
    return -1;
  if(!epobject || !stringp(epobject)) 
    return -2;
  if((tag=member(explore_obj,epobject))==-1) 
    return -3;
  if(!activity[tag]) 
    return 1;
  max_EP-=ep[tag];
  activity[tag]--;
  save_info();
  EPLOG(sprintf("DeactivateEP: Object: %s\n  Points: %d Activity: %d  Wizard: %s",
                explore_obj[tag],ep[tag],activity[tag],geteuid(this_interactive())));
  get_ep_list();
  return 1;
}

/**************************************************************/
/* int ChangeEPPath(string epobject_old, string epobject_new) */
/*                                                            */
/* Aendern des Filenamens eines bereits angemeldeten Objekts  */
/*                                                            */
/* epobject_old --> Alter Objektname                          */
/* epobject_new --> Neuer Objektname                          */
/*                                                            */
/* Returnwerte:                                               */
/*  1 --> Objekt wurde umbenannt                              */
/*  0 --> Keine Berechtigung zum Umbenennen                   */
/* -1 --> Fehler im Array-Handling aufgetaucht                */
/* -2 --> Falsche Argumente wurden uebergeben                 */
/* -3 --> Objekt ist nicht angemeldet                         */
/* -4 --> Neues Objekt ist bereits angemeldet                 */
/* -5 --> Neues Objekt kann nicht geladen werden              */
/**************************************************************/
int ChangeEPPath(string epobject_old, string epobject_new) {
  int i, j, tag;
  string *explore_obj_new;
  if(!epobject_old || !stringp(epobject_old) || 
     !epobject_new || !stringp(epobject_new)) 
    return -2;
  if(!secure(epobject_old) || !secure(epobject_new)) 
    return 0;
  if(!CheckArrays()) 
    return -1;
  if(!epobject_old || !stringp(epobject_old) || 
     !epobject_new || !stringp(epobject_new)) 
    return -2;
  if((tag=member(explore_obj,epobject_old))==-1) 
    return -3;
  if(member(explore_obj,epobject_new)!=-1) 
    return -4;
  if(catch(call_other(epobject_new,"???")) || !find_object(epobject_new)) 
    return -5;
  explore_obj_new=({});
  for(j=sizeof(explore_obj),i=0;i<j;i++)
    if(i==tag)
      explore_obj_new+=({ epobject_new });
    else
      explore_obj_new+=({ explore_obj[i] });
  explore_obj=explore_obj_new;
  save_info();
  EPLOG(sprintf("ChangeEPPath: Object: %s\n  Points: %d Activity: %d  Wizard: %s",
                explore_obj[tag],ep[tag],activity[tag],geteuid(this_interactive())));
  get_ep_list();
  return 1;
}

/************************************************************************/
/* int ChangeEPPoints(string epobject, int points_new)                  */
/*                                                                      */
/* Aendern der Forschungspunktanzahl eines bereits angemeldeten Objekts */
/*                                                                      */
/* epobject   --> Objekt das veraendert werden soll                     */
/* points_new --> Neue Forschungspunktanzahl                            */
/*                                                                      */ 
/* Returnwerte:                                                         */
/*  1 --> Objekt wurde veraendert                                       */
/*  0 --> Keine Berechtigung zum Umbenennen                             */
/* -1 --> Fehler im Array-Handling aufgetaucht                          */
/* -2 --> Falsche Argumente wurden uebergeben                           */
/* -3 --> Objekt ist nicht angemeldet                                   */
/* -4 --> Neue Punkte sind ausserhalb des erlaubten Bereichs            */
/************************************************************************/
int ChangeEPPoints(string epobject, int points_new) {
  int i, j, tag, *ep_new;
  if(!epobject || !stringp(epobject) || !points_new || !intp(points_new)) 
    return -2;
  if(!secure(epobject)) return 0;
  if(!CheckArrays()) 
    return -1;
  if(!epobject || !stringp(epobject) || !points_new || !intp(points_new)) 
    return -2;
  if((tag=member(explore_obj,epobject))==-1) return -3;
  if(points_new<OBJECT_MIN || points_new>OBJECT_MAX) 
    return -4;
  max_EP-=ep[tag];
  ep_new=({});
  for(j=sizeof(ep),i=0;i<j;i++)
    if (i==tag)
      ep_new+=({ points_new });
    else
      ep_new+=({ ep[i] });
  ep=ep_new;
  max_EP+=ep[tag];
  save_info();
  EPLOG(sprintf("ChangeEPPoints: Object: %s\n  Points: %d Activity: %d  Wizard: %s",
                explore_obj[tag],ep[tag],activity[tag],geteuid(this_interactive())));
  get_ep_list();
  return 1;
}

/***************************************************************/
/* int QueryNeededEP(int level)                                */
/*                                                             */
/* Gibt die benoetigten Forschungspunkte fuer einen Level aus. */
/***************************************************************/
int QueryNeededEP(int level) {
  CheckMaxEP();
  if(level<MINLEVEL || level>MAXLEVEL) return 0;
  return EP_LEVEL[level];
}

/***********************************************************/
/* mixed QueryEPObject(string epobject)                    */
/*                                                         */
/* Sucht den Filenamen eines Objekts in der Liste und gibt */
/* dessen Werte zurueck, falls vorhanden                   */
/***********************************************************/
mixed QueryEPObject(string epobject) {
  int tag;
  if(!epobject || !stringp(epobject)) 
    return 0;
  if((tag=member(explore_obj,epobject))==-1) 
    return 0;
  return ({ explore_obj[tag] })+({ ep[tag] })+({ activity[tag] })+({ tag });
}

/*****************************************************************/
/* mixed QueryEPNumber(int number)                               */
/*                                                               */
/* Sucht die Nummer eines angemeldeten Objekts aus der Liste und */
/* gibt dessen Werte zurueck, falls vorhanden                    */
/*****************************************************************/
mixed QueryEPNumber(int number) {
  if(number<0 || number>=sizeof(explore_obj)) 
    return 0;
  if(!explore_obj || !sizeof(explore_obj)) 
    return 0;
    return ({ explore_obj[number] })+({ ep[number] })+({ activity[number] })+({ number });
  return 0;
}

/****************************************************************/
/* int CheckArrays()                                            */
/*                                                              */
/* Diese Funktion ueberprueft das Zusammenspiel der drei Arrays */
/* und kontrolliert den Inhalt                                  */
/*                                                              */
/* Returnwerte:                                                 */
/*   0 --> Fehler kann in Logfile nachgesehen werden            */
/****************************************************************/
int CheckArrays() {
  int i, explore_size, value;
  if((explore_size=sizeof(explore_obj))!=sizeof(ep) && explore_size!=sizeof(activity)) 
    return 0;
  for(i=0;i<explore_size;i++)
    if((value=ep[i])<OBJECT_MIN || value>OBJECT_MAX) {
      EPLOG(sprintf("CheckArrays()-Error(wrong_ep_range): Object: %s\n  Points: %d Activity: %d  Wizard: %s",
                explore_obj[i],ep[i],activity[i],geteuid(this_interactive())));
      return 0;
    }
    else if((value=activity[i])!=0 && value!=1) {
      EPLOG(sprintf("CheckArrays()-Error(wrong_activity_tag): Object: %s\n  Points: %d Activity: %d  Wizard: %s",
                explore_obj[i],ep[i],activity[i],geteuid(this_interactive())));
      return 0;
    }
  return 1;
}

/**************************************************************/
/* int QueryMaxEP()                                           */
/*                                                            */
/* Diese Funktion gibt die momentane Anzahl aller angemeldeten*/
/* Forschungspunkte                                           */
/**************************************************************/
int QueryMaxEP() {
  return max_EP;
}

/**************************************************************/
/* int QueryQuantity()                                        */
/*                                                            */
/* Diese Funktion gibt die momentane Anzahl aller Objekte     */
/* zurueck, welche Forschungspunkte vergeben                  */
/**************************************************************/
int QueryQuantity() {
  return sizeof(explore_obj);
}

/**************************************************************/
/* void CheckMaxEP()                                          */
/*                                                            */
/* Diese Funktion prueft anhand der Summe aller eingetragenen */
/* und aktivierten Objekte, ob die Anzahl aller EP richtig ist*/
/**************************************************************/
void CheckMaxEP() {
  int i, k, summ;
  summ=0;
  for(k=sizeof(explore_obj),i=0;i<k;i++)
    if(activity[i])
      summ+=ep[i];
  max_EP=summ;
  save_info();
}

/**************************************************************/
/* int QuerySeerEP()                                          */
/*                                                            */
/* Diese Funktion berechnet die Anzahl der Punkte, die ein    */
/* beim ersten Login gesetzt bekommt, um festzulegen, wieviele*/
/* wieviele Punkte er fuer die Seherwerdung braucht           */
/**************************************************************/
int QuerySeerEP() {
  return (int)(max_EP * MIN_EP_FOR_SEER / 100);
  return MIN_EP_FOR_SEER;
}

/**************************************************************/
/* int query_npc_ep(int xp)                                   */
/*                                                            */
/* Diese Funktion berechnet zu einer gegebenen Anzahl an      */
/* Erfahrungspunkten die Forschungspunkte.                    */
/**************************************************************/
int query_npc_ep(int xp) {
  int i, from, to, points;
  if(xp<MIN_FIX) return 0;
  if(xp>=MAX_FIX)
    points=OBJECT_MAX;
  else {
    if((to=MIN_FIX+XP_STEP)>MAX_FIX) to=MAX_FIX;
    if((from=MIN_FIX)>=to) return 0;
    for(i=1;i<=OBJECT_MAX;i++) {
      if(xp>=from && xp<=to) {
        points=i;
        break;
      }
      from=to+1;
      to+=XP_STEP;
    }
  }
  return (points>OBJECT_MAX?OBJECT_MAX:points);
}

/**************************************************************/
/* void CheckNPC(int xp)                                      */
/*                                                            */
/* Diese Funktion wird von den NPC's aufgerufen und meldet    */
/* ihn gegebenenfalls als EP-Objekt an.                       */
/**************************************************************/
void CheckNPC(int xp) {
  int points;
  mixed epobject;
  
  return; // unused (Holger)
  
  if(!previous_object()) return;
  if(!(epobject=explode(file_name(previous_object()),"#")[0])) return;
  if((points=query_npc_ep(xp)))
    AddEP(epobject, points);
}
