/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: exploremaster.h,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland MUDlib
//
// SECURE/EXPLOREMASTER.H -- header file for exploremaster object
//
// Author: Bongo@Wunderland
//
/*
 * $Date: 1999/11/05 12:30:45 $
 * $Revision: 1.1.1.1 $
 * $Log: exploremaster.h,v $
 * Revision 1.1.1.1  1999/11/05 12:30:45  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:12  en
 * MUDLib CVS Preperation
 *
 * Revision 1.12  1998/07/17 13:15:30  Holger
 * paar Aenderungen an den Proto-Typen
 *
 * Revision 1.11  1997/10/29 17:55:17  Bongo
 * write_file() in write_log() geaendert
 *
 * Revision 1.10  1997/08/08 09:56:52  Bongo
 * Funktionen asy_ep_list() und query_npc_ep() deklariert
 *
 * Revision 1.9  1997/02/03 16:37:44  Bongo
 * - MIN_EP_FOR_SEER definiert
 * - Deklaration von QuerySeerEP()
 * - EP-Level veraendert
 * - Seher brauchen keine EP mehr. Spieler brauchen Prozente vom festgelegten
 *   Wert des ersten Logins
 *
 * Revision 1.7  1996/09/16 14:16:06  Bongo
 * Added Function CheckMaxEP()
 *
 * Revision 1.6  1996/09/16 08:12:33  Bongo
 * Save-File, Liste und Logfiles nach /secure/ARCH/* gelegt
 *
 */

#ifndef __EXPLOREMASTER_H__
#define __EXPLOREMASTER_H__

// the exploremaster
#define EXPLOREMASTER         "/secure/exploremaster"

// the explore save-files
#define EXPLORE       "/secure/ARCH/save/exploration"
#define FORSCHUNG     "/secure/ARCH/lists/forschung"
#define DFORSCHUNG(x) "/d/"+x+"/LORD/lists/forschung"

// log to file
#define EPLOG(x) write_log("/secure/ARCH/log/EXPLOREMASTER",dtime(time())+": "+\
                   x +"\n", 100000)

// range of points
#define OBJECT_MIN 1                  /* Minimale Punkte je Object */
#define OBJECT_MAX 5                  /* Maximale Punkte je Object */

// range of XP in NPC's
#define MIN_FIX 200000
#define MAX_FIX 1200000
#define XP_STEP 200000

// range of levels
#define MINLEVEL 1
#define MAXLEVEL 30

// needed EP of all at first login (in percent)
#define MIN_EP_FOR_SEER 45

// needed percent for increasing level
//                   level :  percent
#define EP_LEVEL ([     1  :   0  ,  \
                        2  :   0  ,  \
                        3  :   0  ,  \
                        4  :   0  ,  \
                        5  :   2  ,  \
                        6  :   4  ,  \
                        7  :   7  ,  \
                        8  :   9  ,  \
                        9  :  11  ,  \
                       10  :  16  ,  \
                       11  :  20  ,  \
                       12  :  27  ,  \
                       13  :  33  ,  \
                       14  :  40  ,  \
                       15  :  49  ,  \
                       16  :  58  ,  \
                       17  :  67  ,  \
                       18  :  76  ,  \
                       19  :  86  ,  \
                       20  : 100  ,  \
                       21  :   0  ,  \
                       22  :   0  ,  \
                       23  :   0  ,  \
                       24  :   0  ,  \
                       25  :   0  ,  \
                       26  :   0  ,  \
                       27  :   0  ,  \
                       28  :   0  ,  \
                       29  :   0  ,  \
                       30  :   0  ,  \
                       31  :   0  ,  \
                       32  :   0  ,  \
                       33  :   0  ,  \
                       34  :   0  ,  \
                       35  :   0     \
                       ])


// Funktionen
void save_info();
private static varargs int secure(mixed what);
varargs void asy_ep_list(int i, string path);
int get_ep_list();
int get_dep_list(string region);
int AddEP(string epobject, int points);
int ActivateEP(string epobject);
int DeactivateEP(string epobject);
int ChangeEPPath(string epobject_old, string epobject_new);
int ChangeEPPoints(string epobject, int points_new);
int QueryNeededEP(int level);
mixed QueryEPObject(string epobject);
mixed QueryEPNumber(int number);
int CheckArrays();
int QueryMaxEP();
int QueryQuantity();
void CheckMaxEP();
int QuerySeerEP();
int query_npc_ep(int xp);
void CheckNPC(int xp);

#endif /* __EXPLOREMASTER_H__ */
