/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: guestmaster.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
// MorgenGrauen MUDlib
//
// GUESTMASTER.C 
// $Date: 1999/11/05 12:30:45 $
// $Revision: 1.1.1.1 $
/* $Log: guestmaster.c,v $
/* Revision 1.1.1.1  1999/11/05 12:30:45  elatar
/* Preparing mudlib for cvs control
/*
/* Revision 1.1.1.1  1999/11/04 12:48:11  en
/* MUDLib CVS Preperation
/*
 * Revision 1.2  1999/05/06 05:59:45  Fiona
 * war nicht eingeloggt... aenderung irgendwas mit if (!max_guests) return 0;
 *
 * Revision 1.2  1996/02/11 18:48:52  mud
 * *** empty log message ***
 *
 * Revision 3.0  1995/11/22 14:36:52  Jof
 * Updated to rev 3.0
 *
 * Revision 1.1  1995/05/19 16:22:07  Jof
 * Initial revision
 *
 *
 */

static int max_guests; /* Max no. of guests. -1 is 'unlimited' */
static object *guests;
static int    *ltime;

nomask void create() {
  if (sizeof(explode(file_name(this_object()),"#")) != 1) {
    destruct(this_object());
    return;
  }
  guests = ltime = ({});
  max_guests = 5;
}

nomask int new_guest () {
  int ix;

  if (!max_guests) return 0;
  if (explode(file_name(previous_object()),"#")[0] != "/secure/login")
    return 0;
  for (ix = 0; ix < sizeof(guests); ix++)
  {
    if (guests[ix] && !interactive(guests[ix]))
    {
       guests[ix] = 0;
    }
  }

  if ((ix = member_array(0, guests)) == -1) {
    ix = sizeof(guests);
    if (max_guests < 0 || ix < max_guests) 
    {
      guests += ({ 0 }), ltime += ({ 0 });
    }
    else {
      int mintime, minix;
      mintime = time();
      for (ix = 0; ix < sizeof(guests); ix++) {
        if (guests[ix] && ltime[ix] < mintime) mintime=ltime[ix], minix=ix;
      }
      ix = minix;
    }
  } 
  return ix+1;
}

nomask void set_guest (int ix, object pl) {
  if (explode(file_name(previous_object()),"#")[0] != "/secure/login") return;
  guests[ix-1] = pl;
  ltime[ix-1] = time();
}

nomask int query_max_guests() { return max_guests; }
nomask int set_max_guests(int v) {
  if (this_player() && query_wiz_level(this_player()) >= 40)
    max_guests = v;
  return max_guests;
}

