/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: guildmaster.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// /SECURE/GUILDMASTER.C --- guildmaster object 
//
// Function:	verantwortlich fuer das Gilden-Handling
//
// Copyright (c)	Andara & Arachna, 1994
//
// Based on Wunderland-Mudlib
//
// $Date: 1999/11/05 12:30:45 $
// $Revision: 1.1.1.1 $
/*
 * $Log: guildmaster.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:45  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:11  en
 * MUDLib CVS Preperation
 *
 */

#include <config.h>
#include <wizlevels.h>
#include <properties.h>
#include <guilds.h>

#define NEED_PROTOTYPES

#include <guildmaster.h>

//	Definition des Gilden-Feldes

mapping guilds;
/*	Im Mapping 'guilds' werden alle Gilden gespeichert, die noch gueltig sind,
 *	d.h., die alle an sie gestellten Anforderungen  erfuellen
 *	Struktur:	([Guildenname :  ({Name, Wiz, Stats})])
 */

mapping  not_valid_guilds;
/*	Im Mapping 'not_valid_guilds' werden alle Gilde gespeichert, die
 *	einmal existiert haben, aber aus irgendeinem Grund nicht mehr
 *	gueltig sind, da mit den Mitgliedern dieser Gilden anders umgegangen
 *	werden muss.
 *	Struktur:	siehe oben
 */

void save_info() {
    save_object( GUILDS );
}

void create() {
    int i;
    mixed *mykeys, *myvalues;
    
    seteuid(getuid(this_object()));
    if (!restore_object( GUILDS )) {
        log_file(GUILDLOG, sprintf("restore object failed, last "
            "object: %O\n", previous_object()));
        guilds = ([]);
        not_valid_guilds = ([]);
    }
    else {
        mykeys = m_indices(guilds);
        myvalues = m_values(guilds);
        /* Test der Gilden auf ihre Gueltigkeit */
        for (i = sizeof(mykeys); i-- ; ) {
	    if (!CheckGuild(myvalues[i][0])) {
	        log_file("GUILDS",sprintf("guild %O not valid\n", mykeys[i])); 
	        not_valid_guilds += ([ mykeys[i] : myvalues[i]]);
	        guilds = m_delete(guilds, mykeys[i]);
	    }
	}
/*
        mykeys = m_indices(not_valid_guilds);
        myvalues = m_values(not_valid_guilds);
        for (i=0; i<sizeof(mykeys); i++) {
	    if (CheckGuild(myvalues[i][0])) {
	        guilds += ([ mykeys[i] : myvalues[i]]);
	        not_valid_guilds = m_delete(not_valid_guilds, mykeys[i]);
	    }
	    else
	       log_file("GUILDS", sprintf("guild %O not valid\n", mykeys[i]));
        }
*/
    }
    save_info();
}

private static int secure()
{
    if (!previous_object())
	return 0;
    if (geteuid(previous_object())==ROOTID)
	return 1;
    if (geteuid(previous_object()) != geteuid(this_interactive()))
	return 0;
    if (this_interactive() != this_player())
	return 0;
    if (!IS_LORD(this_interactive()))
	return 0;
  return 1;
}

/*
 *	AddGuild() 
 *	Aufgabe:	Fuegt eine Gilde den bestehenden hinzu
 *	Parameter:	name	- Name der Guilde
 *			Datei	- Datei, in welcher die Gilde programmiert ist                
 *			wiz	- Programmierer
 *	Rueckgabe:	<1 wenn Fehler
 *			1  wenn ordnungsgemaess durchgefuehrt
*/ 

int AddGuild(string name, string Datei, string wiz)
{
  int i, ret;
  object obj;
  string *guild_names;
  mixed values;
  log_file(GUILDLOG, sprintf("AddGuild: %O from %O\n", name, previous_object()));
  if (!secure())
      return 0;
  if (!stringp(name) || strlen(name)<5)
      return -1;
  if  (guilds[name] || not_valid_guilds[name])
      return -2;
  if (!stringp(Datei))
      return -3;
  /* Kann das Objekt ueberhaupt geladen werden */
  if (call_other(Datei,"???",0) != 0)
      return -4;
  /* Ist die Gilde schon unter einem anderen Namen angemeldet? */
  if (sizeof((guild_names=m_indices(guilds))))
    for (i=0;i<sizeof(guild_names);i++)
      if (Datei==guilds[guild_names[i]][0])
        return -5;
  /* Existiert der Wizard? */
  if (!stringp(wiz) || wiz=="" || 
      file_size("/players/"+(wiz=lower_case(wiz))) != -2)
      return -6;
  if ( (ret = CheckGuild(Datei))<1)
      return ret-7;
  obj = find_object(Datei);
  if (obj->QueryProp(P_GUILD_NAME)!=name)
      return -7;

  guilds += ([name:({Datei, wiz, obj->QueryProp(P_MAX_STATS)})]);
 
  save_info();

  return 1;
}

/*
 *	RemoveGuild()
 *	Aufgabe:	Entfernen der Guilde
 *	Parameter:	name - Name der Gilde
 *	Rueckgabe:	1  wenn ok
 *			<1 wenn Fehler
*/

int RemoveGuild(string name)
{
  log_file(GUILDLOG, sprintf("RemoveGuild: %O from %O\n", name, previous_object()));

  if (!secure())
      return 0;
  if (!guilds[name])
  {
      if (!not_valid_guilds[name])
	  return -1;
      not_valid_guilds = m_delete(not_valid_guilds, name);
  }
  else
      guilds = m_delete(guilds, name);

  save_info();  
  return 1;
}

/* 
 *	QueryGuild()
 *	Aufgabe:	Liefert eine Gilde zurueck
 *	Parameter:	name - Name der Gilde
 *	Rueckgabe:	({}), wenn keine solche existiert,
 *			({Gildendatei, wizname}), wenn doch
*/

mixed *QueryGuild(string name, int type)
{
  if (type == GM_TYPE_VALID)
  {
    if (guilds[name])
      return guilds[name];
  }
  else
    if (not_valid_guilds[name])
      return not_valid_guilds[name];
  return ({});
}

/*
 *	QueryGuilds()
 *	Aufgabe:	Liefert alle Gilden zurueck
 *	Parameter:	keine
 *	Rueckgabe:	Feld:	1. Index: Gildennamen
 *				2. Index: ({Gildenobject, wizname})
*/

mapping QueryGuilds(int type)
{
 if (type == GM_TYPE_VALID)
   return guilds;
 return not_valid_guilds;
}

mixed QueryProp(string name, int type) {
    mixed max;
    int i;

    if (!sizeof(guilds[name]) && !sizeof(not_valid_guilds[name])) {
        switch (type) {
            case GM_NAME:
            case GM_WIZ:  return "";
            case GM_STAT: return ({0,0,0,0});
            default: return -1;
        }
    }
    // nicht so toll, aber geht erstmal ;)
    if(sizeof(guilds[name])) {
        switch (type) { 
            case GM_NAME:
            case GM_WIZ: return guilds[name][type];
            case GM_STAT:
                 max = guilds[name][type];
                 for (i=0; i<4; i++) {
                     if ((max[i] < 10) || (max[i]>50)) {
                         log_file(GUILDLOG, sprintf("wrong stat: %O, called "
                             "from %O\n", i, previous_object()));
                         max[i] = 50;
                     }
                 }
                 return ({max[0], max[1], max[2], max[3]});
             default: return -1;
        }
    }
    switch (type) { 
        case GM_NAME:
        case GM_WIZ: return not_valid_guilds[name][type];
        case GM_STAT:
             max = not_valid_guilds[name][type];
             for (i=0; i<4; i++) {
                 if ((max[i] < 10) || (max[i]>50)) {
                     log_file(GUILDLOG, sprintf("wrong stat: %O, called "
                         "from %O\n", i, previous_object()));
                     max[i] = 50;
                 }
             }
             return ({max[0], max[1], max[2], max[3]});
         default: return -1;
    }
}
  
   
/*
 *	CheckGuild()
 *	Aufgabe:	Prueft die Integritaet einer Gilde, dabei wir das Vorhandensein
 *			folgender Properties ueberprueft:
 *			P_SHORT <> 0		- Kurzbeschreibung der Gilde
 *			P_LONG <> 0		- Langbeschreibung der Gilde
 *			P_MIN_LEVEL>0,<10	- Minimaler Eintrittslevel 
 *			P_MIN_STATS >0, <10	- Minimale Eintrittsstats
 *			P_MAX_STATS >0, <30	- Maximal erreichbare Stats
 *			P_GUILD_SKILLS<>0	- es muss wenigstens 1 Spell/Skill dasein
 *			P_GUILD_FACTOR >9000,<11000	- Gilde muss ausgewogen sein
 *			QueryTitle			- Sind aller Level-Titel definiert
 *			QueryExp			- Wieviel kostet die Erhoehung (sicher einheitlich!)
 *	Parameter	Datei - Name der Datei
 *	Resultat	1   - Gilde ok
 *			<1  - Fehler
*/

int CheckGuild(string Datei)			
{
  int i,j;
  string str, oldstr;
  object obj;

  log_file(GUILDLOG, sprintf("Check Guild: %O, from %O\n", Datei, previous_object()));  
  if (file_size(Datei)<0 || call_other(Datei,"???",0) != 0)
    return -1;
  obj = find_object(Datei);
  if (!obj || !objectp(obj))
    return -2;
  if (member(m_indices(guilds),obj->QueryProp(P_GUILD_NAME))!=-1)
    return -3;
  if (!strlen(obj->QueryProp(P_INT_SHORT)) || !strlen(obj->QueryProp(P_INT_LONG)))
    return -4; 
  if (!sizeof(obj->QueryProp(P_GUILD_SKILLS)))
    return -5;
  if (obj->QueryProp(P_JOIN_COST)<0)
    return -6;
  if ((obj->QueryProp(P_MIN_LEVEL)<1) || (obj->QueryProp(P_MIN_LEVEL)>20))
    return -7;
  for (i=0; i<4; i++)
    {
      if ((obj->QueryProp(P_MIN_STATS)[i]<1) || (obj->QueryProp(P_MIN_STATS)[i]>10))
	return -8;
      if ((obj->QueryProp(P_MAX_STATS)[i]<10) || (obj->QueryProp(P_MAX_STATS)[i]>50))
	return -9;
    }

  oldstr = "";
  for (j = 0; j < 2; j++)
    for (i = obj->QueryProp(P_MIN_LEVEL); i < 21; i++)
      {
	if (!stringp(str = obj->QueryTitle(i,j)) || strlen(str) < 5)
	  return -10;
	if (str == oldstr)
	  return -11;
	oldstr = str;
      }
  
  /* keine Erfahrungspunkte kleiner als in der Standardgilde */
  
  for (i = obj->QueryProp(P_MIN_LEVEL); i < sizeof(MIN_EP); i++)
    {
      if (obj->QueryExp(i) < MIN_EP[i - 1]) return -12;
    }
  
  /* 
   * wenn mehr Erfahrungspunkte (Level) als in der Standardgilde,
   * muessen diese streng monoton wachsend sein ;)
   * PS.: Dieser Kommentar stammt von Arachna (TM)
   */
  
  for (j = i; j < sizeof(obj->QueryProp(P_GUILD_EXP)); j++)
    {
      if (obj->QueryExp(j - 1) > obj->QueryExp(j)) return -13;
    }

  
  for (i=0,j=1; i<4; i++) j *= obj->QueryProp(P_GUILD_FACTOR)[i];
  if (j<9000 || j>11000) return -14;
  return 1;
}
