/*******************
** Eldarea MUDLib **
********************
**
** secure/login.c -  login object
**
** CVS DATA
** $Date: 2001/02/06 08:55:24 $
** $Revision: 1.11 $
**
** login.c look up the username in the secure/PASSWD file. If it is
** found, the password is checked. If the user is already logged in,
** he will be reconnected to the running object. If the other object
** is still interactive, that will be disconnected before the user is
** reconnected to that object.
**
** If the user is not in PASSWD, a new entry with level 0 is created.
** A new player will be generated. Finalizing is done in /std/player/base
** All PASSWD writing is done in secure/master.c.
**
** CVS History
**
** $Log: login.c,v $
** Revision 1.11  2001/02/06 08:55:24  elatar
** applied strong_types requirements
**
** Revision 1.10  2001/01/10 08:22:07  elatar
** user update implemented
**
** Revision 1.9  2000/12/11 13:10:04  elatar
** changes due to namedb move
**
** Revision 1.8  2000/11/30 16:08:14  elatar
** login sequence nearly completed, opened test mode
**
** Revision 1.7  2000/03/13 10:29:03  elatar
** implemented much basic functionality
**
** Revision 1.6  2000/01/31 20:59:38  elatar
** diverse bugs fixed
**
** Revision 1.5  2000/01/25 16:31:01  elatar
** new logins disabled again
**
** Revision 1.4  2000/01/06 17:55:07  elatar
** fixed bug in login
**
** Revision 1.3  2000/01/06 14:18:51  elatar
** New login procedure implemented (inactive)
**
** Revision 1.2  1999/11/08 09:36:48  elatar
** new logins disabled
**
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "/secure/telnetneg.c";
inherit "/std/more.c";

/* Variables of the secure save file */
int level;
string password, name, shell, sponsor, *apprentices, *loginfailfrom;
int loginfails;
mixed *domains;
int creation_date, wiz_date, touch, *loginfaildate;

#include <config.h>
#include <properties.h>
#include <wizlevels.h>
#include <defines.h>
#include <telnet.h>
#include <ansi.h>
#include <daemon.h>
#include <channeling.h>
#include <living/attributes.h>
#include <living/skills.h>
#include <rmaster.h>
#include <humanoid/description.h>
#include <userupdate.h>

#define GUESTMASTER "/secure/guestmaster"
#define EXPLOREMASTER "/secure/exploremaster"
#define WELCOME_DIR "/etc/welcome/"

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

#define B(x) ANSI_BOLD+x+ANSI_NORMAL
#define LFLAG_NONE      0
#define LFLAG_GUEST 	1
#define LFLAG_NEW   	2

#define TESTPHASE
//#define NOLOGIN

static int guestx;
static string loginname;
static string cap_name;
static object myself;
static string *userentry;
static string banish;
static int *stats;
static mapping props;

mixed* QueryRandomStats();
static void SendTelopts();
static void logon2(string str);
static void new_player_load();
static void new_player();
static void new_player1();
static void new_player2(string str);
static void new_player3();
static void new_player4(string str,string * valid_races);
static void new_player5();
static void new_player6(string str);
static void new_player7(string str);
static void new_player8(string str);
static void new_player9();
static void new_player10(string str);
static void new_player11(string str);
static void new_player12(string str,mapping done,string *attr, string * pprops);
static void new_player13(string str,mapping stats);
static void load_player_object(int lflag);
varargs int valid_name(string str);
static void get_aspect(string str);
static void new_player_select_weapons(string str);
static void new_player_select_spells(string str);
static void new_player_select_size(string str);
static void new_player_select_eyecolor(string str);
static void new_player_select_skincolor(string str);
static void new_player_select_haircolor(string str);
static void new_player_select_hairtexture(string str);
static void new_player_want_skills(string str);
static void auto_learn_skills();
static void new_player_learn_skills(string str);
static void load_player_ob_2(string obname, int lflag);

nomask string loginname() { return loginname ? loginname : ""; }
    
void titel_bild() {
    string *alle, file;
    int x;
    
    if((x=sizeof(alle=get_dir(WELCOME_DIR+"*.txt")))) {
        file=WELCOME_DIR+alle[random(x)];
    }
    else file="/etc/WELCOME";
    cat(file);
    write("\n>");
}


/*
 * This is the function that gets called by /secure/master for every user
 */
static nomask int logon()
{
  call_out("time_out", 240);
  loginname = "logon";
  myself=this_player();
  if (!myself) 
    return 0;
  SendTelopts();
  cat("/etc/WELCOME");
  input_to("logon2");
  return 1;
}

int check_illegal(string str)
{
  return 0;
}
   
static void logon2(string str) {
  object ob;
  int i,len,arg;
  string st1,st2,text;
  mixed txt;
  
  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);
  if (!str || str == "") 
  {
  write("\n"
        "  Bitte gebt Euren Namen ein oder waehlt eine der folgenden Moeglichkeiten:\n\n"
        "  [1]  zeigt die Lebewesen an, die momentan auf Eldarea verweilen.\n"
        "  [2]  gibt Euch die Moeglichkeit, Eldarea zu besuchen und kennen zu lernen.\n"
        "  [3]  laesst Euch einen neuen Charakter erstellen, um Eldarea zu betreten.\n"
        "  [4]  <name> zeigt Informationen ueber einen bestimmten Spieler an.\n"
        "  [5]  zeigt eine kurze Beschreibung von Eldarea an.\n"
        "  [6]  zeigt die Hintergrundgeschichte an.\n"
        "  [7]  laesst Euch eine Anfrage nach einem bestimmten Namen starten.\n\n"
        "  [0]  verlaesst Eldarea und diese Sphaere.\n\n");
  write(">");
  input_to("logon2");
  return;
  }
  if(loginname != "logon") {
    log_file("system/login",
      sprintf("%s illegal patch - loginname: %O PO: %O\n",
        dtime(time())[5..], loginname, previous_object()));
    destruct(this_object());
    raise_error(sprintf("illegal patch: loginname==%O\n", loginname));
    return;
  }
  if (str[0..3]=="GET ")
  {
    cat("/etc/HTMLREDIRECT");
    destruct(this_object());
    return;
  }
  if (1<=sscanf(str,"%1d %s",i,text))
  {
    switch (str[0..0])
    {
    case "0":
      write("Lebt wohl, Fremder!\n");
      destruct(this_object());
      return;
      break;
    case "1":
      write(call_other("/global/service/werliste","QueryShortWhoListe",0,0,0)+"\n>"); 
      input_to("logon2");
      return; 
      break;
    case "2":
      write("Entschuldigt, Eldarea kann noch nicht besucht werden.\n\n>");
      input_to("logon2");
      return;
      break;
    case "3":
#ifdef NOLOGIN
      write(break_string(
        "Entschuldigt, das Eldarea befindet sich noch im Aufbau und kann daher"
        " nicht besucht werden. Wenn Ihr Interesse habt, an der Entwicklung "
        "mitzuarbeiten oder ueber die Oeffnung des Muds informiert zu werden, "
        "wendet Euch doch per Mail an: mud@eldarea.de.")+"\>");
      log_file("TRIED_LOGIN",sprintf("%s Tried new login from %s (%s)\n"
               ,dtime()[5..]
               ,query_ip_name(this_object())
               ,query_ip_number(this_object())));
      input_to("logon2");
      return;
      break;
#endif
#ifdef TESTPHASE
      log_file("TESTED_LOGIN",sprintf("%s Tried new login from %s (%s)\n"
               ,dtime()[5..]
               ,query_ip_name(this_object())
               ,query_ip_number(this_object())));
      write(break_string(
        "Entschuldigt, das Eldarea befindet sich noch im Aufbau und kann "
        "daher nicht besucht werden. Diese Loginsequenz ist nur testweise "
        "aktiviert, der erstellt Charakter wird am Ende der Sequenz wieder "
        "geloescht. Wenn Ihr Interesse habt, an der Entwicklung "
        "mitzuarbeiten oder ueber die Oeffnung des Muds informiert zu "
        "werden, wendet Euch doch per Mail an: mud@eldarea.de."));
#endif
      new_player();
      return;
      break;
    case "4":
      if (2<strlen(str[2..<1]))
	write("/global/service/finger"->finger(text,"")+"\n");
      else
	write("Ihr solltet schon einen Namen angeben.\n");
      write(">");  
      input_to("logon2");
      return;
      break;
    case "5":
      More("/etc/welcome/concept",1,#'logon2);
      return;
      break;
    case "6":
      More("/etc/welcome/story",1,#'logon2);
      return;
      break;
    case "7":
      write("Bitte gebt den Namen an, nach dem Ihr eine Anfrage starten "
            "moechtet.\n>");
      input_to("namerequest");
      return;
    break;
      default:
      write("Entschuldigt, es gibt weder diese Option noch einen Charakter "
            "dieses Namens.\n> ");
      input_to("logon2");
      return;
    }
  }
  cap_name = capitalize(str);
  str = lower_case(str);
  loginname = str;
  // read the secure save file to see if character already exists
  if (!restore_object(__MASTER_OBJECT__->secure_savefile(str)))
  {
    object *user;
    
    write("Entschuldigt, es gibt keinen Charakter dieses Namens.\n");
    loginname = "logon";
    write(">");
    input_to("logon2");
    return;
    for(i=sizeof(user=users())-1;i>=0;i--)
    {
      if(file_name(user[i])[0..7]=="/secure/"&&user[i]!=this_object())
      {
	if(user[i]->loginname()==loginname)
	{
	  write("Eine Anmeldung fuer diesen Namen laeuft bereits.\n");
	  destruct(this_object());
	  return;
	}
      }
    }
    // new character
    if ( strlen(str) < 3 )
    {
      write("Der Name ist ein bisschen zu kurz.\n");
      write("Versucht doch einen laengeren: ");
      loginname = "logon";
      write(">");  
      input_to("logon2");
      return;
    }
    if ((txt=__MASTER_OBJECT__->QueryBanished(str)))
    {
      write(txt+"\n");
      write("Waehlt bitte einen anderen Namen: ");
      loginname = "logon";
      write(">");  
      input_to("logon2");
      return;
    }
    // Initialize the new secure savefile 
    name = str;
    password = "";
    level = 0;
    domains = ({ });
    shell = "";

    creation_date = time();
    write("Neuer Spieler.\n");
    write("Bitte gebt ein Password ein: ");
    input_to("new_password",1);
    return;
  }
  else {
    /* Oigen, da brauchma kein gastlogin
    if (str == "gast") {
      if (check_illegal(str)) return;
      load_player_object(LFLAG_GUEST);
      return; 
    }
    */
    if (txt=__MASTER_OBJECT__->QueryTBanished(str)) {
      write(txt);
      destruct(this_object());
      return;
    }
    write("Schoen, dass Ihr wieder da seid, "+capitalize(str)+"!\n");
    if (password == "" || !password) {
      write("Ihr habt KEIN PASSWORT!\n");
      write("Benutzt den 'password'-Befehl, um das zu aendern !\n");
      load_player_object(LFLAG_NONE);
      return;
    }
    write("Passwort: ");
    input_to("check_password",1);
    return;
  }
}

static void namerequest(string str)
{
  mixed * nameinfo;

  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);
  if (!str||str=="")
  {
    write("Anfrage abgebrochen.\n>");
    input_to("logon2");
    return;
  }
  if (!valid_name(str))
  {
    write(">");
    input_to("namerequest");
    return;
  }
  nameinfo=NAMEDB->name_info(str);
  if (pointerp(nameinfo)&&2<sizeof(nameinfo))
  {
    if (nameinfo[1]&FN_USED)
      write("Der Name '"+capitalize(str)+"' ist bereits besetzt.\n>");
    else if (nameinfo[1]&FN_REST)
      write("Der Name '"+capitalize(str)+"' ist gesperrt.\n>");
    else
      write(break_string(
        "Der Name '"+capitalize(str)+"' ist noch frei. Er ist zulaessig fuer "+
        ({"neutrale","maennliche","weibliche"})[nameinfo[2]]+" Charaktere der Rassen: "
        +implode(nameinfo[0],", ")+".\n>"));
    input_to("logon2");
    return;
  }
  write(break_string(
    "Der Name '"+capitalize(str)+"' ist noch nicht eingetragen. Ihr koennt nun beantragen, ihn "
    "einzutragen. Welchen Geschlechts soll der Name denn sein? (weiblich/maennlich)\n>"));
  input_to("namerequest2",0,str);
  return;
}

static void namerequest2(string str,string name)
{
  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);
  if (str=="weiblich")
    str="w";
  else if (str=="maennlich")
    str="m";
  if (str!="m"&&str!="w")
  {
    write(break_string(
      "Bitte gebt als Geschlecht nur weiblich oder maennlich an.\n>"));
    input_to("namerequest2",0,name);
    return;
  }
  write(break_string(
    "Nun gut, es wird eine Anfrage fuer den "+(["w":"weiblichen","m":"maennlichen"])[str]+" Namen "+
    capitalize(name)+" gestartet. Das kann in ein paar Minuten erledigt sein, oder auch einige Tage "
    "dauern. Ihr koennt nun noch eine Email-Adresse angeben, wenn Ihr per Email ueber die Eintragung "
    "Eures Namens benachrichtigt werden moechtet:\n>"));
  input_to("namerequest3",0,name,(["m":1,"w":2])[str]);
  return;
}

static void namerequest3(string str, string name, int gender)
{
  string a,b,c;

  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);    
  if (str=="")
  {
     write(break_string("Eure Anfrage ist vorgemerkt, schaut doch in ein "
           "paar Stunden oder Tagen noch einmal vorbei.")+"\n\n>");
     input_to("logon2");
     return;
  }
  else if (!str||2!=sscanf(str,"%s@%s",a,b)||strlen(b)<2)
  {
    write("Bitte gebt nur eine gueltige Emailadresse oder <return> fuer keine an.\n>");
    input_to("namerequest3",0,name,gender);
    return;
  }
  write("Ihr werdet per Mail benachrichtigt, sobald Eure Anfrage bearbeitet wurde.\n\n>");
  NAMEDB->NameRequest(name, gender, str);
  input_to("logon2");
  return;
}

static void new_player()
{
  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);
  write(
    "Seid nochmals herzlich willkommen auf Eldarea!\n"
    "Ihr bekommt nun die Moeglichkeit, einen neuen Charakter anzulegen.\n"+
    break_string(
    "Dabei koennt Ihr jederzeit mit 'z' einen Schritt zurueckgehen und mit "
    "'h' eine Hilfe anzeigen lassen.")+"\n"
    "Gebt zunaechst einmal ein Passwort an: ");
  input_to("new_password",1);
  return;
}

static void new_password(string str) {
  write("\n");
  if (!str||str=="")  
  {
    write("Bitte gebt ein Passwort an: ");
    input_to("new_password",1);
    return;
  }  
  if (str=="h")
  {
    write(break_string(
      "Das Passwort schuetzt Euren Charakter vor Missbrauch durch andere. "
      "Es sollte nicht zu einfach oder offensichtlich sein, also gebt etwas "
      "an, was nur Ihr wissen koennt.")+"Bitte gebt ein Passwort an: ");
    input_to("new_password",1);
    return;
  }
  password = str;
  if (lower_case(str)==lower_case(loginname))
  {
    write("Das ist zu einfach zu erraten. Nehmt bitte ein anderes.\n");
        write("Bitte gebt ein Passwort an: ");
        input_to("new_password",1);
        return;
  }
  if (strlen(str)<6)
  {
    write("Das Passwort muss wenigstens 6 Zeichen lang sein.\n");
    write("Bitte gebt ein Passwort an: ");
    input_to("new_password",1);
    return;
  }
  write("Passwort bitte nochmal eingeben: ");
  input_to("again_password",1);
  return;
}

static void again_password(string str) {
  write("\n");
  if (str != password) {
    write("Die Passwoerter stimmten nicht ueberein!\n");
    new_password("");
    return;
  }
  password = crypt(password,0);
  /*Oigen des muss spaeter...
  save_object(SECURESAVEPATH+loginname[0..0]+"/"+loginname);
  MASTER->RemoveFromCache(loginname);
  load_player_object(LFLAG_NEW);*/

  write(
     "Nun geht es richtig los...\n"
     "Seid Ihr w(eiblich) oder m(aennlich)? ");
  input_to("new_player2");
  return;
}                                                                             

static void new_player2(string str)
{
  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);
  if (    !str 
       || str=="" 
       || 
          (    !(str[0..0]=="m") 
            && !(str[0..0]=="w") 
          )
     )
  {
    if (str=="z")
      write("Beim ersten Schritt macht das wohl keinen Sinn.\n");
    if (str=="h")
      write(break_string(
        "Als Geschlecht koennt Ihr 'w' fuer weiblich oder "
        "'m' fuer maennlich angeben."));
    else 
      write("Bitte gebt als Geschlecht w(eiblich) "
            "oder m(aennlich) an: ");
    input_to("new_player2");
    return;
  }
  props=([P_GENDER:(str[0..0]=="m"?MALE:FEMALE)]);
  write("\nNun muesst Ihr eine Rasse auswaehlen.\n");
  new_player3();
  return;
}

static void new_player3()
{
  string * valid_races;
  mapping offs;
  string txt;
  int i;

  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);

  // rassen sammeln und ausgeben
  valid_races=call_other(RMASTER,"valid_races");
  offs=RMASTER->QueryOffset(P_RACE_NAME,0);
  txt="Zur Auswahl stehen:\n\n";
 
  for (i=0;i<sizeof(valid_races);i++)
  {
    txt+=sprintf("  [%:2d]  %s\n",i+1,offs[valid_races[i]][1]);
  }
  txt+="mit info <nr> oder ? <nr> koennt Ihr eine Beschreibung der jeweiligen Rasse ansehen.\n\n>";
  write(txt);
  input_to("new_player4",0,valid_races);
  return;
}

static void new_player4(string str,string * valid_races)
{
  int no;
  
  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);
  if (!str||str=="")
    new_player3();
  else if (str=="z")
  {
    new_player2("");
    return;
  }
  else if (str=="h")
  {
    write(break_string(
      "Gebt einfach 'info <nr>' ein, um die Beschreibung der jeweiligen "
      "Rasse anzusehen (zum Beispiel 'info 3' fuer eine Beschreibung der "
      "Sonnenelfen), oder gebt eine Zahl an, um eine der Rassen auszuwaehlen.")+">");
    input_to("new_player4",0, valid_races);
    return;
  }
  else if (1==sscanf(str,"%d",no))
  {
    if (1>no||sizeof(valid_races)<no)
    {
      write("Ungueltige Eingabe.\n>");
      input_to("new_player4",0,valid_races);
    }
    else
    {
      props[P_RACE]=valid_races[no-1];
      write("\nNun geht es an die Wahl eines Namen.\n");
      new_player5();
    }
  }
  else if (1==sscanf(str,"info %d",no)||1==sscanf(str,"? %d",no))
  {
    if (1>no||sizeof(valid_races)<no)
    {
      write("Ungueltige Eingabe.\n>");
      input_to("new_player4",0,valid_races);
    }
    else
    {
      // test ob file vorhanden !!!
      write("\n");
      if (file_size("/etc/races/"+valid_races[no-1])<1)
        write(break_string(
          "Die Rassenbeschreibung wurde nicht gefunden. Bitte wendet "
          "Euch an einen Avatar."));
      else
        cat("/etc/races/"+valid_races[no-1]);
      write("\n\n>");
      input_to("new_player4",0,valid_races);
    }           
  }
  else
  {
    write("Ungueltige Eingabe.\n>");
    input_to("new_player4");
  }
  return;
}

static void new_player5()
{
  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);
  write(
   "Ihr koennt einfach einen Namen ausprobieren oder Euch die Liste der fuer\n"
   "Eure Rasse und Euer Geschlecht passenden Namen anzeigen lassen. Der \n"
   "Befehl dazu ist 'liste'.\n\n>");
  input_to("new_player6");
  return;
}

static void show_namelist()
{
  int i,j;
  string *names;
  string zeile, txt;

  names=NAMEDB->QueryNames(0,props[P_RACE],props[P_GENDER]);
  txt="";
  for (i=0;i<sizeof(names)/5+1;i++)
  {
    zeile="";
    for (j=0;(j<5)&&(i*5+j<sizeof(names));j++)
      zeile+=sprintf("%11-s    ",capitalize(names[i*5+j]));
    txt+=zeile+"\n";
  }
  More(txt,0,"end_of_list");
  return;
}

static void end_of_list()
{
  write("Nun entscheidet Euch fuer einen Namen.\n>");
  input_to("new_player6");
  return;
}

static void new_player6(string str)
{
  string txt;
  mixed *nameinfo;
  object *user;
  int i;

  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);
  if (!str||str=="")
    new_player5();
  if (str=="h")
  {
    write(break_string(
      "Da Eldarea ein Mud ist, in dem sehr viel Wert auf Atmosphaere "
      "und Rollenspiel gelegt wird, werden hier auch bei der Wahl der Namen "
      "recht strenge Richtlinien angelegt, identifiziert sich doch jeder "
      "Charakter auch ueber seinen Namen. Aus diesem Grund sind im Eldarea "
      "nur bestimmte Namen erlaubt. Mit dem Befehl 'liste' laesst sich "
      "eine Liste der fuer die gewaehlte Rasse und das gewaehlte Geschlecht "
      "passenden Namen ausgeben. Sollte der gewuenschte Name nicht in der "
      "Liste auftauchen, so ist er entweder schon vergeben, oder Ihr muesst "
      "beim Startbildschirm eine Anfrage nach dem Namen starten. Wenn Ihr "
      "Euch fuer einen Namen entschieden habt, koennt Ihr ihn einfach "
      "eingeben.")+"\n>");
    input_to("new_player6");
    return;
  }
  else if (str=="z")
  {
    new_player3();
    return;
  }
  else if (str=="liste")
  {
    show_namelist();
    return;
  }
  str=lower_case(str);
  loginname=str;
  for(i=sizeof(user=users())-1;i>=0;i--)
  {
    if(file_name(user[i])[0..7]=="/secure/"&&user[i]!=this_object())
    {
      if(user[i]->loginname()==loginname)
      {
        write(break_string("Eine Anmeldung fuer diesen Namen laeuft bereits. Waehlt bitte einen "
              "anderen.")+"\n>");
        loginname="logon";
        input_to("new_player6");
        return;
      }
    }
  }       
  if (strlen(str)<3)
  {
    write("Entschuldigt, der Name '"+capitalize(str)+"' ist zu kurz. Bitte waehlt einen andren.\n\n>");
    loginname="logon";
    input_to("new_player6");
    return;
  }
  else if (strlen(str)>11)
  {
    write("Entschuldigt, der Name '"+capitalize(str)+"' ist zu lang. Bitte waehlt einen andren.\n\n>");
    loginname="logon";
    input_to("new_player6");
    return;
  }     
  else if ((txt=__MASTER_OBJECT__->QueryBanished(str)))
  {
    write(txt+".\n");
    write("Waehlt bitte einen anderen Namen: ");
    loginname="logon";
    input_to("new_player6");
    return;
  }
  else if (nameinfo=NAMEDB->name_info(str))
  {
    if (!pointerp(nameinfo)||sizeof(nameinfo)!=3)
      write(break_string(
        "Der Name "+capitalize(str)+" ist noch nicht eingetragen. Bitte startet doch eine Anfrage "
        "dannach oder waehlt einen anderen Namen."));
    else if (nameinfo[1]&FN_USED)
      write("Der Name '"+capitalize(str)+"' ist bereits besetzt.\n>");
    else if (nameinfo[1]&FN_REST)
      write("Der Name '"+capitalize(str)+"' ist gesperrt.\n>");
    else if (-1==member(nameinfo[0],props[P_RACE]))
    {
      write(break_string(
        "Der Name '"+capitalize(str)+"' ist nicht fuer die Rasse "+capitalize(props[P_RACE])+" erlaubt. " 
        "Bitte waehlt einen anderen."));
      write(">");
    }
    else if (nameinfo[2]!=props[P_GENDER])
    {
      write(capitalize(str)+" ist ein "+({"neutraler","maennlicher","weiblicher"})[nameinfo[2]]+" Name. "
      "Bitte waehlt einen anderen.\n>");
    }
    else
    {
      // Initialize the new secure savefile 
      name = str;
      level = 0;
      domains = ({ });
      shell = ""; 
      creation_date = time();
      cap_name = capitalize(str);
      new_player7("");
      return;
    }
    loginname="logon";
    input_to("new_player6");
    return;
  }
  write(break_string(
    "Der Name "+capitalize(str)+" ist noch nicht eingetragen. Bitte startet doch eine Anfrage "
    "dannach oder waehlt einen anderen Namen."));
  loginname="logon";
  input_to("new_player6");
  return;
}

static void new_player7(string str)
{
  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);

  write(break_string(
    "Der naechste Punkt der Charaktererstellung ist der Beruf. Jeder Charakter "
    "muss sich einen Berufszweig auswaehlen, dem er angehoeren moechte. Auf "
    "Eldarea kann jeder Charakter saemtliche Fertigkeiten erlernen und anwenden, "
    "der Beruf gibt jedoch an, wie schnell oder langsam er die einzelnen "
    "Fertigkeiten erlernt. Die Wahl eines Berufs will also gut ueberlegt sein, "
    "gibt es doch spaeter im Spiel keine Moeglichkeit mehr, den Beruf zu "
    "wechseln. Die Berufe koennen in drei Gruppen unterteilt werden: "
    "Magieunkundige, Teilmagierkundige und Magiekundige."));
  new_player8("");
  return;
}

static void new_player8(string str)
{
  string s,list;
  int no,pn,i,j;
  mixed * prof;
  string * professions;

  while(remove_call_out("time_out") != -1);
  call_out("time_out", 240);
  prof=PMASTER->QueryProfessions(props[P_RACE],PF_TYPE);
  professions=prof[PT_NONSPELL]+prof[PT_SEMISPELL]+prof[PT_PURESPELL];
  if (!stringp(str)||str=="")
  {

    list=
      "Folgende Berufe stehen fuer Eure Rasse momentan zur Auswahl:\n\n";
    pn=0;
    for (j=0;j<3;j++)
    {
      list+=({"Magieunkundige\n","Teilmagiekundige\n","Magiekundige\n"})[j];
      if (!sizeof(prof[j]))  
        list+="  keine\n";
      else 
        for (i=0;i<sizeof(prof[j]);i++)
        {
          pn++;
          list+=sprintf("  [%2d]  %s\n",pn,capitalize(professions[pn-1]));
        }
    }
 
    list+=break_string(
      "\nWaehlt einen dieser Berufe aus oder lasst Euch mit 'info <nr>' oder '? <nr>'  "
        "eine Beschreibung des jeweiligen Berufs anzeigen.")+"\n>";
    write(list);  
    input_to("new_player8");
    return;
  }
  if (str=="z")
  {
    loginname="logon";
    new_player5();
    return;
  }
  if (str=="h")
  {
    write(break_string(
      "Mit dem Befehl '"B("info <nr>")"' koennt Ihr Euch die Beschreibung des "
      "jeweiligen Berufes ansehen (zum Beispiel 'info 1' fuer die Beschreibung "
      "des Berufs "+professions[0]+"). Einen Beruf auswaehlen koennt Ihr, "
      "indem Ihr einfach nur "
      "seine Nummer eingebt.")+"\n>");
    input_to("new_player8");
    return;
  }
  if (2==sscanf(str,"%s %d",s,no) && (s="info" || s=="?") && no>0 && no<=sizeof(professions) )
  {
    if (file_size("/etc/professions/"+professions[no-1])<1)
    {
      write(break_string(
        "Die Beschreibung des Berufes wurde nicht gefunden. Bitte wendet Euch "
        "an einen Avatar."));
    }
    else
      cat("/etc/professions/"+professions[no-1]);
    write("\n>");
    input_to("new_player8");
    return;
  } 
  if (1==sscanf(str,"%d",no)&&no>0&&no<=sizeof(professions))
  {
    props[P_PROFESSION]=professions[no-1];
    write("Nun gut, Ihr werdet ein "+capitalize(professions[no-1])+" sein.\n");
    if (PMASTER->QueryRequireAspect(props[P_PROFESSION]))
    {
      get_aspect("");
      return;  
    }  
    write(
      "Jetzt geht es zum wichtigsten Teil der Charaktererstellung, den Attributen.\n");
    new_player9();
    new_player10("n");
    return;
  }  
  write("Entschuldigt, die Eingabe war ungueltig.\n");
  new_player8("");
  return;
}

static void get_aspect(string str)
{
  string txt, * valid_asp, s;
  int i, num;
  
  valid_asp=PMASTER->QueryAspects(props[P_PROFESSION])&VALID_ASPECTS;
  if (sizeof(valid_asp)==1)
  {
    props[P_ASPECT]=valid_asp[0];
    write(
      "Jetzt geht es zum wichtigsten Teil der Charaktererstellung, den Attributen.\n");
    new_player9();
    new_player10("n");
    return;
  }
  if (!stringp(str) || str=="")
  {
    txt=break_string(
      "Als Vertreter eines der eng mit den Aspekten verbundenen Berufe "
      "muesst Ihr nun einen der Aspekte als den auswaehlen, dem Ihr "
      "dienen moechtet.")+"\n";
    for (i=0;i<sizeof(valid_asp);i++)
    {
      txt+=sprintf("  [%2d]  %s\n",i+1,ASP_DESCR[valid_asp[i]][4]);
    }
    txt+="\n"+break_string("Waehlt bitte einen dieser Aspekte aus. Mit info "
      "'<nr>' oder '? <nr> koennt Ihr naehere Informationen zu dem "
      "jeweiligen Aspekt erhalten.")+"\n>";
    write(txt);
    input_to("get_aspect");
    return;
  }
  else if (sscanf(str,"%d",num)==1)
  {
    if (num<1 || num>sizeof(valid_asp))
    {
      write("Dieser Aspekt ist nicht angegeben.\n>");
      input_to("get_aspect");
      return;  
    }
    write("Ihr werdet also dem Aspekt "+ASP_DESCR[valid_asp[num-1]][WESSEN]+" dienen.\n"
          "Jetzt geht es zum wichtigsten Teil der Charaktererstellung, den Attributen.\n");
    new_player9();
    new_player10("n");
    return;
  }
  else if (sscanf(str,"%s %d",s,num)==2 && (s=="info" || s=="?") )
  {
    if (file_size("/etc/aspects/"+valid_asp[num-1])<1)
    {
      write(break_string(
        "Die Beschreibung des Aspekts wurde nicht gefunden. Bitte wendet Euch "
        "an einen Avatar."));
    }
    else
      cat("/etc/aspects/"+valid_asp[num-1]);
    write("\n>");
    input_to("get_aspect");
    return;
  }
  else
  {
    write("Entschuldigt, die Eingabe war ungueltig.\n>");
    input_to("get_aspect");
    return;  
  }
}

/* Attribute ermitteln. Das versteht hinterher keiner mehr, also doku :) */
int * calc_stats()
{
  int i,a,b,max;
  int *ar;
  
  /*
  ** Die ersten beiden Attribute sind zwischen 90 und 100 einschliesslich.
  ** Die naechsten drei liegen beliebig zwischen 21 und 100. Der Rest wird 
  ** mal mit 0 vorbesetzt
  */
  ar=({random(11)+90,random(11)+90,
       random(80)+21,random(80)+21,random(80)+21,
       0,0,0,0});
  /* Gesamtpunktzahl reduzieren */
  max=585-(ar[0]+ar[1]+ar[2]+ar[3]+ar[4]);
  /* Attribute 6-8 berechnen */
  for (i=5;i<8;i++)
  {
    /* Wie hoch darf das Attribut hoechstens sein, damit genug Punkte 
       fuer die restlichen bleiben? */
    a=max-(8-i)*100;
    a=a<21?21:a;
    /* Und wie hoch muss es mindestens sein, damit alle Punkte 
       verbraucht werden? */
    b=max-(8-i)*21;
    b=b>100?100:b;
    /* Einen zufaelligen Wert zwischen den Schranken ermitteln */
    ar[i]=a+random(b-a+1);
    /* Gesamtzahl reduzieren */
    max-=ar[i];
  }
  /* Das letzte Attribut bekommt die restlichen Punkte */
  ar[8]=max;

  return ar;  
}

static void new_player9()
{
  write(break_string(
    "Jeder Charakter auf Eldarea hat neun Attribute, die seine koerperlichen "
    "und geistigen Staerken und Schwaechen angeben. Diese Werte werden "
    "anfangs zufaellig ermittelt; sie liegen in einem Bereich von 20 bis "
    "100, wobei die Summe aller Attribute immer 585 betraegt. Spaeter "
    "koennen die Attribute auch ueber 100 hinaus steigen. Den einzelnen "
    "Attributen werden die Werte erst im naechsten Schritt zugeordnet."));
}

static void new_player10(string str)
{
  string * attr;

  while(remove_call_out("time_out") != -1);
  call_out("time_out", 2400);
 
  if (!stringp(str)||str=="")
  {
    new_player9();
    printf(
      "  %3d   %3d   %3d   %3d   %3d   %3d   %3d   %3d   %3d\n\n"
      "Moechtet Ihr diese Werte behalten? (j/n)\n>",
      stats[0],stats[1],stats[2],stats[3],stats[4],
      stats[5],stats[6],stats[7],stats[8]);
  }
  else if (str=="h")
  {
    write(break_string(
      "Jedes Mal, wenn Ihr 'n' eingebt, wird ein neuer Satz Zufallszahlen "
      "erzeugt. Wenn Euch ein Satz gefaellt, und Ihr ihn behalten wollt, gebt "
      "einfach 'j' ein.")+"\n>");
    input_to("new_player10");
    return;
  }
  else if  (str=="z")
  {
    new_player7("");
    return;
  }
  else if (str=="n")
  {
    stats=calc_stats();
    printf(
      "  %3d   %3d   %3d   %3d   %3d   %3d   %3d   %3d   %3d\n\n"
      "Moechtet Ihr diese Werte behalten? (j/n)\n>",
      stats[0],stats[1],stats[2],stats[3],stats[4],
      stats[5],stats[6],stats[7],stats[8]);
  }
  else if (str="j")
  {
    attr=PMASTER->QueryAttributes(props[P_PROFESSION]);
    write("\n"+break_string(
      "Es gibt auf Eldarea neun verschiedene Attribute. Jedes dieser Attribute "
      "ist wichtig und wird im Laufe des Spieles benoetigt, allerdings kann "
      "ein Charakter natuerlich eine bestimmte Gewichtung dieser Attribute "
      "haben. So wird ein Krieger beispielsweise hohe koerperliche Attribute "
      "besitzen, waehrend ein Magier eher hohe geistige Attribute hat. Jeder "
      "Beruf hat zwei Hauptattribute, die am wichtigsten fuer den jeweiligen "
      "Beruf sind. Diese muessen daher Werte von mindestens 90 erhalten. Fuer "
      "Euren Beruf ("+capitalize(props[P_PROFESSION])+") sind das "
      +ATTR_DESC[attr[0]]+" und "+ATTR_DESC[attr[1]]+". Die "
      "Attribute sind:")+"\n");  
    new_player11("");
    return;
  } 
  else
  {
    write(break_string(
      "Bitte gebt nur 'j' zum Behalten der Werte und 'n' zum zufaelligen "
      "Erzeugen neuer Werte an, oder drueckt <return>, um noch einmal die "
      "Erklaerung anzusehen.")+">");
  }  
  input_to("new_player10");
  return;
}

void show_attr_desc(int n)
{
  string txt;
  string att;

  switch (n)
  {
    case 1:
      txt=break_string(
        "Staerke gibt die rohe koerperliche Kraft eines Charakters an. Sie "
        "ist ein Mass dafuer, wie fest er zuschlagen kann und wie viel er "
        "tragen kann und ist daher besonders fuer Kaempfer jeder Art wichtig. "
        "Sie macht jedoch keine Aussage darueber, wie gut ein Charakter "
        "kaempfen kann.");
      att=A_ST;
      break;
    case 2:
      txt=break_string(
        "Geschicklichkeit umfasst sowohl die Fingerfertigkeit als auch das "
        "Koerpergefuehl eines Charakters. Geschickte Charaktere koennen "
        "Waffen praeziser fuehren, komplizierte Aufgaben wie Fallen "
        "entschaerfen besser loesen und auch besser schleichen und sich "
        "verstecken.");
      att=A_AG;
      break;
    case 3:
      txt=break_string(
        "Reaktion ist ein Mass fuer die Schnelligkeit eines Charakters. "
        "Sie gibt im Kampf Vorteile, weil man schneller reagieren kann, "
        "ist aber auch bei verschiedenen anderen Dingen nuetzlich, bei "
        "denen es auf Schnelligkeit und gute Reflexe ankommt.");
      att=A_QU;
      break;
    case 4:
      txt=break_string(
        "Konstitution ist das Mass fuer die koerperliche "
        "Wiederstandsfaehigkeit eines Charakters. Das betrifft sowohl die "
        "Faehigkeit, Schmerzen zu ertragen als auch die koerperlichen "
        "Abwehrkraefte gegen Hitze und Kaelte, Krankheiten und Gifte.");
      att=A_CO;
      break;
    case 5:
      txt=break_string(
        "Selbstdisziplin ist ein Mass fuer die Konzentrationsfaehigkeit "
        "eines Charakters. Sie gibt an, wie gut er in der Lage ist, sich "
        "trotz wiedriger Umstaende auf eine Aufgabe konzentrieren kann "
        "und wie gut er in der Lage ist, sich geistig auf etwas einzustellen.");
      att=A_SD;
      break;
    case 6:
      txt=break_string(
        "Intelligenz ist das Mass fuer die logische Denkfaehigkeit eines "
        "Charakters. Sie gibt an, wie gut er Fertigkeiten anwenden kann,  "
        "die Nachdenken erfordern.");
      att=A_RE;
      break;
    case 7:
      txt=break_string(
        "Intuition ist ein Mass fuer die intuitiven Faehigkeiten eines "
        "Charakters. Sie gibt an, wie gut sein Gefuehl ihm helfen kann, "
        "Gefahren zu erkennen und richtige Entscheidungen zu treffen, "
        "aber auch, wie gut er mit uebernatuerlichen Wesenheiten in "
        "Einklang kommen kann. Daher ist sie sehr wichtig fuer die an den "
        "uebernatuerlichen Kraeften orientierten Berufe und magisch Begabte, "
        "die Ihre Kraefte von uebernatuerlichen Lebewesen beziehen.");
      att=A_IN;
      break;
    case 8:
      txt=break_string(
        "Mana ist ein Mass fuer das emotionale Einfuehlungsvermoegen eines "
        "Charakters. Das betrifft zum einen die Faehigkeit des Charakters, "
        "sich in die Situation andere einzufuehlen, zum andren aber auch, "
        "seine Faehigkeit die Stroeme der Magie zu spueren und zu lenken. "
        "Mana ist somit sehr wichtig fuer die akademischen Magier, die ihre "
        "Macht aus der Essenz der Magie beziehen.");
      att=A_EM;
      break;
    case 9:
      txt=break_string(
        "Charisma ist das Mass fuer den Eindruck, den ein Charakter auf andere "
        "Personen macht, aber auch fuer seine innerliche charakterliche "
        "Staerke. Charaktere mit hohem Charisma sind viel leichter in der Lage, "
        "die Magie mit ihrem Geist zu beeinflussen, daher ist Charisma sehr "
        "wichtig fuer mentale Magier.");
      att=A_PR;
      break;
    default:
      txt="Fehler. Bitte Magier benachrichtigen und folgende Zahl angeben: "+n+"\n";
      break;
   }
  if (-1!=member(PMASTER->QueryAttributes(props[P_PROFESSION]),att))
    txt+=break_string(
      ATTR_DESC[att]+" ist ein Hauptattribut fuer Euren "
      "Beruf, den "+capitalize(PMASTER->QueryName(props[P_PROFESSION]))+".");
  txt+="\n>";
  write(txt);
  return;
}

static void new_player11(string str)
{
  int n;
  string * pprops;

  while(remove_call_out("time_out") != -1);
  call_out("time_out", 2400);
  if (!stringp(str)||str=="")
  {
    write(
     " Koerperliche Attribute:\n"
     "  [1]  Staerke\n"
     "  [2]  Geschicklichkeit\n"
     "  [3]  Reaktion\n"
     "  [4]  Konstitution\n"
     " Geistige Attribute:\n"
     "  [5]  Selbstdisziplin\n"
     "  [6]  Intelligenz\n"
     "  [7]  Intuition\n"
     "  [8]  Mana\n"
     "  [9]  Charisma\n\n"+break_string(
     "Gebt eine Nummer ein, um eine Beschreibung des jeweiligen Attributs "
     "anzusehen oder 'w(eiter)' , um mit der Zuweisung der bereits "
     "ermittelten Werte zu den Attributen zu beginnen."
     )+"\n>");
     input_to("new_player11");
     return;
  }
  if (str=="z")
  {
    new_player10("");
    return;
  }
  if (str=="h")
  {
    write(break_string(
      "In diesem Schritt koennt Ihr nur die Beschreibungen der einzelnen "
      "Attribute ansehen, um Euch zu entscheiden, welchen Attributen Ihr "
      "eher hohe und welchen eher niedrige Werte zuordnen moechtet. Die "
      "Zuordnung selbst erfolgt im naechsten Schritt, wenn Ihr 'w'"
      "eingegeben habt. Zum Ansehen der einzelnen Attribute gebt Ihr einfach "
      "die Nummer ein, die vor dem jeweiligen Attribut steht.")+"\n>");
    input_to("new_player11");
    return;
  }
  if (str=="w")
  {
    pprops=PMASTER->QueryAttributes(props[P_PROFESSION]);
    new_player12("",([]),ALL_ATTRIBUTES,pprops);
    return;
  }
  else if (sscanf(str,"%d",n)==1&&n>0&&n<11)
  {
    show_attr_desc(n);
    input_to("new_player11");
    return;
  }
  write("Entschuldigt, die Eingabe war ungueltig.\n>");
  input_to("new_player11");
  
  return;
}

static void new_player12(string str,mapping done,string *attr, string * pprops)
{
  int i,att,ind;
  string *inddone;

  while(remove_call_out("time_out") != -1);
  call_out("time_out", 2400);
  inddone=m_indices(done); 
  if (!stringp(str)||str=="")
  {
    if (sizeof(done))
    {
      write("\nBereits zugeteilte Attributwerte\n");
      for(i=0;i<sizeof(done);i++)
        printf("  [%2d] %20-s: %d\n",i+1,ATTR_DESC[inddone[i]],done[inddone[i]]);
      write("\n");
    }
    if (sizeof(stats))
    {
      write("   Attribute                   Werte\n");
      for (i=0;i<sizeof(stats);i++)
        printf("  [%2d] %20-s   [%2d] %3d\n",i+1,ATTR_DESC[attr[i]],i+1,stats[i]);
    }
    write(break_string(
      "Bitte gebt zuerst die Nummer eines Attributs an, dann die Nummer eines "
      "der Werte, oder 'd <nr>' um eine der Zuweisungen wieder rueckgaengig "
      "zu machen. Denkt bitte daran, die beiden Hauptattribute ("
      +ATTR_DESC[pprops[0]]+", "
      +ATTR_DESC[pprops[1]]+
      ") muessen einen "
      "Wert von 90 oder hoeher bekommen. Wenn Ihr fertig seid, tippt '"+B("w")+
      "'.")+">");
    input_to("new_player12",0,done,attr,pprops);
    return;
  }
  else if (str=="h")
  {
    write(break_string(
      "In diesem Schritt geht es darum, die bereits erzeugten Attributwerte "
      "den einzelnen Attributen zuzuordnen. Dabei solltet Ihr darauf achten, "
      "dass Magiekundige Charaktere eher geistig und Magieunkundike eher "
      "koerperlich hohe Werte haben sollten. Ausserdem muessen die "
      "Hauptattribute Eures Berufes auf jeden Fall 90 oder hoeher sein. Die "
      "Attribute zuordnen koennt Ihr ganz einfach, indem Ihr zuerst die "
      "Nummer angebt, die vor dem ensprechenden Attribut steht, und dann die "
      "Nummer, die vor dem Wert steht, den Ihr dem Attribut zuordnen "
      "moechtet. Eine bereits erfolgte Zuordnung koennt Ihr wieder "
      "rueckgaengig machen, indem Ihr '"+B("d")+"', gefolgt von der Nummer "
      "eingebt. Wenn Ihr fertig seid, gebt einfach '"+B("w")+"' ein.")+"\n>");
    input_to("new_player12",0,done,attr,pprops);
    return;
  }  
  else if (str=="z")
  {
    new_player10("j");
    return;
  }
  else if (str=="w")
  {
    //Kompletter Check ob alles OK ist.

    if (9!=sizeof(done))
    {
      write("Es sind noch nicht alle Attributwerte zugeordnet.\n>");
    }
    else if (done[pprops[0]]<90)
    {
      write("Der Wert fuer "+
        ATTR_DESC[pprops[0]]+" muss "
        "groesser als 89 sein.\n>");
      
    }
    else if (done[pprops[1]]<90)
    {
      write("Der Wert fuer "+
        ATTR_DESC[pprops[1]]+" muss "
        "groesser als 89 sein.\n>");
    }   
    else 
    {
      new_player13("",done);
      return;
    }
    input_to("new_player12",0,done,attr,pprops);
    return;
  }
  else if (2==sscanf(str,"%d %d",att,ind))
  {
    if (ind<1 || ind>sizeof(stats) || att<1 || att>sizeof(stats) )
    {
      write("Die Eingabe ist nicht im zulaessigen Bereich.\n>");
      input_to("new_player12",0,done,attr,pprops);
      return;
    }
    else if (member(pprops,attr[att-1])!=-1 && stats[ind-1]<90)
    {
      write("Der Wert fuer "+ATTR_DESC[attr[att-1]]+
            " muss groesser als 89 sein.\n");
      input_to("new_player12",0,done,attr,pprops);
      return;
    }
    done[attr[att-1]]=stats[ind-1];
    stats=stats[0..ind-2]+stats[ind..<1];
    attr-=({attr[att-1]});
    new_player12("",done,attr,pprops);
    return;        
  }
  else if (1==sscanf(str,"d %d",ind))
  {
    if (!sizeof(done))
    {
      write("Es ist doch noch kein Wert zugeordnet worden.\n>");
      input_to("new_player12",0,done,attr,pprops);
      return;
    } 
    if ( ind<1 || ind>sizeof(done) )
    {
      write("Ein bereits zugeordneter Attributwert mit der Nummer '"+ind+"' "
            "existiert nicht.\n>");
      input_to("new_player12",0,done,attr,pprops);
      return;
    }
    attr+=({inddone[ind-1]});
    stats+=({done[inddone[ind-1]]});
    done=m_delete(done,inddone[ind-1]);
    new_player12("",done,attr,pprops);
    return;    
  }
  write("Bitte gebt zwei Zahlen oder d <nr> an.\n>");
  input_to("new_player12",0,done,attr,pprops);
  return;     
}

static void new_player13(string str,mapping stats)
{
  props[P_ATTRIBUTES]=stats;
  shell="std/shells/wood_elf";
  props[P_WEAPONS]=({0,0,0});
  write("\n");
  new_player_select_weapons("");
}

static void new_player_select_weapons(string str)
{
  mixed * weap;
  int cur, i, no;
  string txt, *list, s;
  
  while(remove_call_out("time_out") != -1);
    call_out("time_out", 2400);

  weap=PMASTER->QueryWeapons(props[P_PROFESSION]);
  if (!pointerp(weap))
  {
    write(break_string(
      "Fehler. Waffenfertigkeiten konnten nicht geladen werden. Bitte "
      "benachrichtigt einen Avatar."));
    destruct(this_object());
    return;  
  }
  while( cur<3 && props[P_WEAPONS][cur] )
    cur++;
  
  if (cur==3)
  {
    props[P_FIRST_WEAPON_SKILLS]=([SK_FIRST_WEAPON:props[P_WEAPONS][0],
                                   SK_SECOND_WEAPON:props[P_WEAPONS][1],
                                   SK_THIRD_WEAPON:props[P_WEAPONS][2]]);
    new_player_select_spells("");
    return;
  }
  
  if (str=="h")
  {
    write(break_string(
      "In diesem Schritt koennt Ihr Eure primaeren Waffenfertigkeiten "
      "auswaehlen. Prinzipiell kann jeder Charakter fast jede Waffe fuehren "
      "und den Umgang mit Ihr erlernen, allerdings muesst ihr Euch jetzt "
      "festlegen, welches Eure wichtigsten Waffen werden sollen. Diese "
      "sind spaeter am leichtesten zu lernen und ihr werdet sie am besten "
      "beherrschen. Es ist daher wichtig, diese Waffen mit Bedacht zu waehlen, "
      "das es spaeter nicht mehr moeglich ist, diese Entscheidung zu aendern. "
      "Waehlt einfach der Reihe nach durch Eingabe der jeweiligen Zahl aus der "
      "Liste Eure Waffen aus.")+"\n>");
    input_to("new_player_select_weapons");
    return;  
  }
  else if (str=="z")
  {
    new_player12("",([]),ALL_ATTRIBUTES,PMASTER->QueryAttributes(props[P_PROFESSION]));
    return;      
  }
  else
  {  
    if (stringp(weap[cur]))
    {  // Fix
      props[P_WEAPONS][cur]=weap[cur];
      write(break_string(
        "Eure "+({"erste","zweite","dritte"})[cur]+" Waffenfertigkeit ist "
        +SK_GROUP_WEAPON[weap[cur],0]+"."));
      new_player_select_weapons("");
      return;
    }
    else if (pointerp(weap[cur][0]))
    { // Choose one of them
      list=weap[cur][0]-props[P_WEAPONS];
    }
    else
    {
      list=({});
      for (i=0;i<3;i++)
      {
        if ( pointerp(weap[i]) 
          && !pointerp(weap[i][0]) 
          && sizeof(weap[i])==sizeof(weap[i]-props[P_WEAPONS]))
          list+=weap[i]-list;
      }
    }
    if (str && str!="")
    {
      if (sscanf(str,"%s %d",s,no)==2 && (s=="info" || s=="?") && no>0 && no<=sizeof(list))
      {
        if (file_size("/etc/skills/"+list[no-1])<1)
        {
          write(break_string(
            "Die Beschreibung der Waffenfertigkeit wurde nicht gefunden. Bitte "
            "wendet Euch an einen Avatar."));
        }          
        else
        {
          cat("/etc/skills/"+list[no-1]);
        }
        write("\n>");
        input_to("new_player_select_weapons");
        return;
      }
      else if (sscanf(str,"%d",no)==1 && no>0 && no<=sizeof(list))
      {
        props[P_WEAPONS][cur]=list[no-1];
        write(break_string(
          "Eure "+({"erste","zweite","dritte"})[cur]+" Waffenfertigkeit ist "
          +SK_GROUP_WEAPON[list[no-1],0]+"."));
        new_player_select_weapons("");
      }
      else
      {
        write("Die Eingabe ist nicht gueltig.\n>");  
        input_to("new_player_select_weapons");
        return;
      }
    }
    else
    {
      txt=break_string(
        "Bitte waehlt Eure "+({"erste","zweite","dritte"})[cur]+
        " Waffe aus:\n\n");
      for (i=0;i<sizeof(list);i++)
      {
        txt+=sprintf("  [%2d] %s\n",i+1,SK_GROUP_WEAPON[list[i],0]);
      }
      txt+="\n"+break_string(
        "Gebt einfach die Nummer der Waffenfertigkeit an oder 'info <nr>' "
        "oder 'h <nr>', um eine Beschreibung dieser Waffenfertigkeit zu "
        "betrachten.")+"\n>";
      write(txt);
      input_to("new_player_select_weapons");
      return;
    }
  }
}

static void new_player_select_spells(string str)
{
  write(break_string(
    "An dieser Stelle fehlt noch die Auswahl der Zaubersprueche (die es "
    "noch nicht gibt)."));
  
  write(break_string(
    "In den naechsten Schritten koennt Ihr verschiedene Aspekte Eures "
    "Aussehens bestimmen."));
  new_player_select_size("");
}

// Appearance

static void new_player_select_size(string str)
{
  int no;
  int * values;
  
  values=RMASTER->QueryRange(props[P_RACE],P_SIZE)[props[P_GENDER]-1];
  
  if (!str||str=="")
  {
    write(break_string(
      "Als erstes ist Eure Koerpergroesse an der Reihe. Angehoerige Eures "
      "Geschlechtes und Volkes sind zwischen "+values[0]+" und "+values[1]+
      " Zentimetern gross. Spieltechnisch gesehen bringt Groesse keine "
      "Vorteile, sucht sie also einfach nach Eurem Geschmack zwischen "
      "diesen beiden Grenzen aus.")+">");  
  }  
  else if (str=="h")
  {
    write(break_string(
      "In diesem Schritt muesst Ihr die Koerpergroesse Eures Charakters "
      "auswaehlen. Ihr koennt einfach eine Zahl zwischen den beiden "
      "Grenzen, "+values[0]+" und "+values[1]+", angeben. Spieltechnisch "
      "hat die Groesse keine Bedeutung.")+">"); 
  }
  else if (str=="z")
  {
    new_player_select_spells("");
    return;
  }
  else if (sscanf(str,"%d",no)==1 && no>=values[0] && no<=values[1])
  {
    props[P_SIZE]=no;
    write("Ihr seid somit "+props[P_SIZE]+" cm gross.\n\n");
    new_player_select_eyecolor("");
    return;
  }
  else
  {
    write("Die Eingabe ist nicht im gueltigen Bereich.\n");
  }
  input_to("new_player_select_size");
}

static void new_player_select_eyecolor(string str)
{
  int no, i;
  string * values, txt;
  
  values=RMASTER->QueryRange(props[P_RACE],P_EYE_COLOR);
  if (!str||str=="")
  {
    txt=break_string(
      "Nun koennt Ihr Eure Augenfarbe auswaehlen.")+"\n\n";
    for (i=0;i<sizeof(values);i++)
      txt+=sprintf("[%2d]  %s\n",i+1,values[i]);
    write(txt+"\n\n>");
  }  
  else if (str=="h")
  {
    write(break_string(
      "In diesem Schritt koennt Ihr Eure Augenfarbe auswaehlen. Es werden "
      "eine Reihe Farben angeboten, welche bei Eurem Volk mehr oder weniger "
      "haeufig vertreten sind. Sucht Euch einfach eine dieser Farben aus.")); 
  }
  else if (str=="z")
  {
    new_player_select_size("");
    return;
  }
  else if (sscanf(str,"%d",no)==1 && no>0 && no<=sizeof(values))
  {
    props[P_EYE_COLOR]=values[no-1];
    write("Eure Augenfarbe ist "+props[P_EYE_COLOR]+".\n\n");
    new_player_select_skincolor("");
    return;
  }
  else
  {
    write("Die Eingabe ist nicht im gueltigen Bereich.\n");
  }
  input_to("new_player_select_eyecolor");
}

static void new_player_select_skincolor(string str)
{
  int no, i;
  string * values, txt;
  
  values=RMASTER->QueryRange(props[P_RACE],P_SKIN_COLOR);
  if (!str||str=="")
  {
    txt=break_string(
      "Nun koennt Ihr Eure Hautfarbe auswaehlen.")+"\n\n";
    for (i=0;i<sizeof(values);i++)
      txt+=sprintf("[%2d]  %s\n",i+1,values[i]);
    write(txt+"\n\n>");
  }  
  else if (str=="h")
  {
    write(break_string(
      "In diesem Schritt koennt Ihr Eure Hautfarbe auswaehlen. Es werden "
      "eine Reihe Farben angeboten, welche bei Eurem Volk mehr oder weniger "
      "haeufig vertreten sind. Sucht Euch einfach eine dieser Farben aus.")); 
  }
  else if (str=="z")
  {
    new_player_select_eyecolor("");
    return;
  }
  else if (sscanf(str,"%d",no)==1 && no>0 && no<=sizeof(values))
  {
    props[P_SKIN_COLOR]=values[no-1];
    write("Eure Hautfarbe ist "+props[P_SKIN_COLOR]+".\n\n");
    new_player_select_haircolor("");
    return;
  }
  else
  {
    write("Die Eingabe ist nicht im gueltigen Bereich.\n");
  }
  input_to("new_player_select_skincolor");
}

static void new_player_select_haircolor(string str)
{
  int no, i;
  string * values, txt;
  
  values=RMASTER->QueryRange(props[P_RACE],P_HAIR_COLOR);
  if (!str||str=="")
  {
    txt=break_string(
      "Nun koennt Ihr Eure Haarfarbe auswaehlen.")+"\n\n";
    for (i=0;i<sizeof(values);i++)
      txt+=sprintf("[%2d]  %s\n",i+1,values[i]);
    write(txt+"\n\n>");
  }  
  else if (str=="h")
  {
    write(break_string(
      "In diesem Schritt koennt Ihr Eure Haarfarbe auswaehlen. Es werden "
      "eine Reihe Farben angeboten, welche bei Eurem Volk mehr oder weniger "
      "haeufig vertreten sind. Sucht Euch einfach eine dieser Farben aus.")); 
  }
  else if (str=="z")
  {
    new_player_select_skincolor("");
    return;
  }
  else if (sscanf(str,"%d",no)==1 && no>0 && no<=sizeof(values))
  {
    props[P_HAIR_COLOR]=values[no-1];
    write("Eure Haarfarbe ist "+props[P_HAIR_COLOR]+".\n\n");
    new_player_select_hairtexture("");
    return;
  }
  else
  {
    write("Die Eingabe ist nicht im gueltigen Bereich.\n");
  }
  input_to("new_player_select_haircolor");
}

static void new_player_select_hairtexture(string str)
{
  int no, i;
  mixed * values, txt;
  
  values=RMASTER->QueryRange(props[P_RACE],P_HAIR_TEXTURE);
  if (!str||str=="")
  {
    txt=break_string(
      "Nun koennt Ihr Eure Haarstruktur auswaehlen.")+"\n\n";
    for (i=0;i<sizeof(values);i++)
      txt+=sprintf("[%2d]  %s\n",i+1,HAIR_TEXTURE_DESC[values[i]]);
    write(txt+"\n\n>");
  }  
  else if (str=="h")
  {
    write(break_string(
      "In diesem Schritt koennt Ihr Eure Haarstruktur auswaehlen. Es werden "
      "eine Reihe Vorschlaegen angeboten, welche bei Eurem Volk mehr oder "
      "weniger haeufig vertreten sind. Sucht Euch einfach eine dieser "
      "Moeglichkeiten aus.")); 
  }
  else if (str=="z")
  {
    new_player_select_haircolor("");
    return;
  }
  else if (sscanf(str,"%d",no)==1 && no>0 && no<=sizeof(values))
  {
    props[P_HAIR_TEXTURE]=values[no-1];
    write("Eure Haar ist "+HAIR_TEXTURE_DESC[props[P_HAIR_TEXTURE]]+".\n\n");
    new_player_want_skills("");
    return;
  }
  else
  {
    write("Die Eingabe ist nicht im gueltigen Bereich.\n");
  }
  input_to("new_player_select_hairtexture");
  
  // fertig mit appearance
}

static void new_player_want_skills(string str)
{	
  while(remove_call_out("time_out") != -1);
  call_out("time_out", 2400);
 
  if (!stringp(str)||str=="")
  {
    write(break_string(
      "Nun folgt der letzte Schritt der Charaktererstellung: Die "
      "Fertigkeiten. Jeder Charakter auf Eldarea verfuegt ueber die gleichen "
      "Fertigkeiten, die in verschiedene Bereiche aufgeteilt sind. "
      "Allerdings beherrscht nicht jeder Charakter jede Fertigkeit gleich "
      "gut. So wird ein Magier beispielsweise sehr gut im Zaubern sein, "
      "waehrend ein Krieger sehr gut mit einer Waffe umgehen kann. Zu Anfang "
      "sind noch alle Fertigkeiten eines Charakters sehr beschraenkt, jedoch "
      "gibt es schon einige, die er etwas besser kann. Diese Fertigkeiten "
      "muessen im naechsten Schritt festgelegt werden. Ihr koennt Euch jetzt "
      "entscheiden, ob Ihr das selbst uebernehmen moechtet, oder ob Ihr "
      "lieber die Standardfertigkeiten fuer Euren Beruf erlernen moechtet. "
      "Moechtet Ihr die Fertigkeiten selbst zuordnen? (j/n)")+"\n> ");	
    input_to("new_player_want_skills");
    return;
  }
  else if (str=="h")
  {
    write(break_string(
      "Wenn Ihr 'j' eingebt, koennt Ihr saemtliche Anfangs beherrschten "
      "Fertigkeiten selbst festlegen. Das ermoeglicht eine groessere "
      "Kontrolle ueber Euren Charakter, ist aber auch etwas aufwaendig "
      "und daher nur erfahreneren Spielern zu empfehlen. Wenn Ihr 'n' "
      "eingebt, werden die Fertigkeiten nach den Standardwerten fuer "
      "Euren Beruf festgelegt. Das sind im Regelfall die "
      "berufstypischsten und somit sinnvollsten Fertigeiten.")+"\n> ");
    input_to("new_player_want_skills");
    return;
  }
  else if  (str=="z")
  {
    //TODO TODO TODO
    new_player7("");
    return;
  }
  else if (str=="n")
  {
    auto_learn_skills();
    return;
  }
  else if (str="j")
  {
    new_player_learn_skills("");
    return;
  } 
  else
  {
    write(break_string(
      "Bitte gebt nur 'j' zum manuellen oder 'n' zum automatischen "
      "Zuordnen der Fertigkeiten an, oder drueckt <return>, um noch einmal "
      "die Erklaerung anzusehen.")+"> ");
  }  
  input_to("new_player_want_skills");
  return;  	
}

static int skill_cost(string skill, mapping skills)
{
  if (!skills[skill,SI_LEARNED])
    return skills[skill,SI_COST];
  else
    switch(skills[skill,SI_COST])
    {
      case 1:
        return 2;
        break;  
      case 2:
        return 3;
        break;  
      case 3:
        return 5;
        break;  
      case 4:
        return 7;
        break;  
      case 5:
        return 9;
        break;  
      default:
        return 2*skills[skill,SI_COST];
        break;  
    } 
}

static void auto_learn_skills()
{
  mapping skillinfo,skills;
  mixed * work_array;
  string * ind;
  int i,j,lvl,dp;
  
  dp=DP_FIRST_LEVEL;
    
  skills=ALL_SKILLS;
  skillinfo=PMASTER->QuerySkills(props[P_PROFESSION],props[P_FIRST_WEAPON_SKILLS]);
  PMASTER->SetSkillcosts(skills,props[P_PROFESSION],props[P_FIRST_WEAPON_SKILLS]);
  work_array=({({}),({}),({}),({}),({}),({}),({}),({}),({}),({}),({})});
  ind=m_indices(skillinfo);
  
  // nach prioritaet sortieren
  ind=sort_array(ind
    ,lambda(({'x,'y}),
      ({#'<
       ,({#'[,skillinfo,'x,1})
       ,({#'[,skillinfo,'y,1})})));
  
  lvl=1;
  // first run over all skills
  for (i=0;i<sizeof(ind)&&dp;i++)
  {
    if ( skills[ind[i],SI_RANKS]<to_int(skillinfo[ind[i],2]*lvl)+1 
      && dp>=skill_cost(ind[i],skills)
      && skills[ind[i],SI_LEARNED]<2)
    {
      skills[ind[i],SI_RANKS]++;
      dp-=skill_cost(ind[i],skills);
      skills[ind[i],SI_LEARNED]++;
      if (skillinfo[ind[i],3])
      {
        if ( skills[ind[i],SI_RANKS]<to_int(skillinfo[ind[i],2]*lvl)+1
          && dp>=skill_cost(ind[i],skills)
          && skills[ind[i],SI_LEARNED]<2)
        {
          skills[ind[i],SI_RANKS]++;
          dp-=skill_cost(ind[i],skills);
          skills[ind[i],SI_LEARNED]++;
          ind[i]=0;
        }
      }
      else
      {
        ind[i]=0; 
      }
    }
  }
  ind-=({0});

  // second one, all needs were already fit *shrug*
  for (i=0;i<sizeof(ind)&&dp;i++)
  {
    if ( dp>=skill_cost(ind[i],skills)
      && skills[ind[i],SI_LEARNED]<2)
    {
      skills[ind[i],SI_RANKS]++;
      dp-=skill_cost(ind[i],skills);
      skills[ind[i],SI_LEARNED]++;
      if ( dp>=skill_cost(ind[i],skills)
        && skills[ind[i],SI_LEARNED]<2)
      {
        skills[ind[i],SI_RANKS]++;
        dp-=skill_cost(ind[i],skills);
        skills[ind[i],SI_LEARNED]++;
      }
    }
  }
  
  props[P_SKILLS]=skills;
  props[P_DP]=dp;
  write(break_string(
    "In Ordnung, Eure Fertigkeiten wurden zugeteilt. Ihr koennt sie Euch "
    "im Spiel mit 'info' ansehen."));
#ifdef TESTPHASE
  write(break_string(
    "So, das war die Login-Sequenz. Moegliche Fehler, Ideen und Anregungen "
    "bitte an elatar@eldarea.de schicken. Bis bald!"));
  destruct(this_object());
  return;
#endif
  new_player_load();
}

static void new_player_learn_skills(string str)
{
  
#ifdef TESTPHASE
  write(break_string(
    "So, das war die Login-Sequenz. Moegliche Fehler, Ideen und Anregungen "
    "bitte an elatar@eldarea.de schicken. Bis bald!"));
  destruct(this_object());
  return;
#else
  write(break_string(
    "Das manuelle Zuordnen der Fertigkeiten ist noch nicht implementiert. "
    "Daher werden die Fertigkeiten jetzt automatisch zugeordnet."));
  auto_learn_skills();
#endif  
  new_player_load();	
}

static void new_player_load()
{
  if (!NAMEDB->RegisterName(loginname,props[P_GENDER]))
  {
    write(break_string(
      "Entschuldigt, es ist ein Fehler aufgetreten. Versucht einen anderen "
      "Namen oder wendet Euch an die Avatare dieses Muds."));
    destruct(this_object());      
    return;
  }
  creation_date = time();
  wiz_date = -1;
  apprentices = ({});
  touch = ACTUAL_SECURE_PATCH;
  
  save_object(SECURESAVEPATH+loginname[0..0]+"/"+loginname);
  MASTER->RemoveFromCache(loginname);
  load_player_object(LFLAG_NEW);
}

void sorry() {
  cat("/etc/SORRY");
  destruct(this_object());
}

static void check_password(string str)
{
  write("\n");
  if (touch!=ACTUAL_SECURE_PATCH)
  {
    switch(touch)
    {
      case 0:
        wiz_date = -1;
        apprentices = ({});
        if (!pointerp(loginfaildate) || !pointerp(loginfailfrom))
        {
          loginfails = 0;
          loginfaildate = ({});
          loginfailfrom = ({});
        }
    }
    touch = ACTUAL_SECURE_PATCH;
    save_object(SECURESAVEPATH+loginname[0..0]+"/"+loginname);
    MASTER->RemoveFromCache(loginname);
  }
  if (crypt(str,password) != password)
  {
    write("Falsches Passwort!\n");
    log_file("system/loginfail",sprintf("PASSWORD: %O %O %s\n",query_ip_name(this_object()),loginname,ctime(time())));
    if (!pointerp(loginfaildate) || !pointerp(loginfailfrom))
    {
      loginfails = 0;
      loginfaildate = ({});
      loginfailfrom = ({});
    }
    loginfaildate += ({time()});
    loginfailfrom += ({query_ip_name(this_object())});
    loginfails++;
    save_object(SECURESAVEPATH+loginname[0..0]+"/"+loginname);
    loginname = "logon";
    logon2("");
    return;
  }
  if (name)
  {
    
    save_object(SECURESAVEPATH+loginname[0..0]+"/"+loginname);
    MASTER->RemoveFromCache(loginname);
  }
  if (loginfails)
  {
    write(loginfails+" fehlgeschlagene"+(loginfails==1?"r":"")+" Login-Versuch"+(loginfails==1?"":"e")+" seit dem letzten erfolgreichen Login.\n");
    loginfails=0;
    loginfailfrom = ({});
    loginfaildate = ({});
    save_object(SECURESAVEPATH+loginname[0..0]+"/"+loginname);
    MASTER->RemoveFromCache(loginname);
  }
  load_player_object(LFLAG_NONE);
  return;
}

static void load_player_object(int lflag) 
{
  string obname;
  object ob;
  string err,fname;
  int was_interactive;

  if( sizeof(users()) >= 195 && !IS_WIZARD(loginname) ) 
  {
    write("Die maximale Spielerzahl wurde bereits erreicht!!!\n"+
	  "Aus technischen Gruenden duerfen sich nur noch Magier einloggen.\n"+
	  "Versucht es spaeter noch einmal ...\n");
    destruct(this_object());
    return;
  }
  else if ( sizeof(users()) >= 198 && !IS_ARCH(loginname) ) 
  {
    write("Die maximale Spieler- und Magierzahl wurde bereits erreicht!!!\n"+
	  "Aus technischen Gruenden duerfen sich nur noch Erzmagier einloggen.\n"+
	  "Versucht es spaeter noch einmal ...\n");
    destruct(this_object());
    return;
  }
  if ((fname=__MASTER_OBJECT__->secure_isavefile(loginname)) != "") 
  {
    save_object(SECURESAVEPATH+loginname[0..0]+"/"+loginname);
    MASTER->RemoveFromCache(loginname);
    // Just to be sure ...
    rm(fname+".o");
    log_file("REACTIVATE",ctime(time())+": "+capitalize(loginname)+
	     " reactivated\n");
  }
  if (lflag==LFLAG_GUEST) 
  {
    guestx = GUESTMASTER ? GUESTMASTER->new_guest() : 0;
	  if (!guestx)
	  {
	    write("Derzeit kein Gastlogin moeglich!\n");
  	  destruct(this_object());
	  }
    loginname = "gast"+guestx;
    cap_name = capitalize(loginname);
    name=cap_name;
    ob = find_player(loginname);
    if (ob)
    {
      if (interactive(ob))
	      tell_object(ob,"Ein anderer Spieler moechte diesen Gastzugang jetzt benutzen. Wenn es Dir hier\n"+
		      "gefallen hat, ueberleg Dir doch einen Charakternamen und komm unter diesem\n"+
		      "Namen wieder!\n");
      destruct(ob);
    }
  }
  else if (lflag==LFLAG_NONE)
  {
    /* Test if we are already playing */
    was_interactive=0;
    ob = find_player(loginname);
    if (!ob)
      ob=find_netdead(loginname);
    if (ob) {
      write(break_string(
        "Ihr seid bereits auf Eldarea.\nIhr findet Euren alten Koerper... \n"));
      if (interactive(ob)) 
      {
        //////////////////////////////////////////////////////////////////
	      // The other object is still interactive; reconnect that "soul" //
	      // to a dummy object and destruct that, thus disconnecting the  //
	      // other probably linkdead user. The real "body" is still       //
	      // there for reconnecting by login.c                            //
        //////////////////////////////////////////////////////////////////
	      remove_interactive(ob);
	      was_interactive=1;
      }

      // Now reconnect to the old body
      exec(ob, this_object());
      ob->Reconnect(was_interactive);
      USERUPDATE->UpdateUser(ob);
      call_out("remove",1);
      return;
    }
  }
  // read player object from passwd file
  if (stringp(shell) && shell != "") 
  {
    load_player_ob_2(shell,lflag);
  }
  else
  {
    load_player_ob_2("std/shells/human",lflag);
  }
  return;
}

static void load_player_ob_2(string obname, int lflag) 
{
  object blueprint;
  string err,ob_name;
  object ob,old_ob;

  // start player activity
  log_file("user/enter", capitalize(name) + ", " + extract(ctime(time()), 4, 15)+
	   ", "+query_ip_name(this_object())+".\n");
  seteuid(loginname);

  // load the "real" player object 
  // If some asshole has moved the blueprint 
  blueprint = find_object(obname);
  if (blueprint && environment(blueprint) != 0)
    destruct(blueprint);

  err = catch(ob = clone_object(obname));
  if (err)
  {
    log_file("SHELLS", "Failed to load shell "+obname+", "+
	     dtime(time())+", "+loginname+"\n"+err+"\n\n");
    write("Konnte das passende Spielerobjekt nicht laden. Lade stattdessen\n"+
	  "das Objekt Mensch. BITTE ERZAVATAR BENACHRICHIGEN !\n");
    err=catch(ob=clone_object("std/shells/human"));
  }
  if (!ob||err) {
    write("Error on loading "+shell+"\nError = "+err+"\n");
    destruct(this_object());
    return;
  }
  if (lflag==LFLAG_GUEST)
    catch(GUESTMASTER->set_guest(guestx,ob));
  ob_name=(explode(file_name(ob),"#")[0]);
  if (strlen(ob_name)>11 && ob_name[0..11]=="/std/shells/")
    ob_name=ob_name[11..];
  ob_name=ob_name+":"+lower_case(cap_name);
  if (lflag!=LFLAG_GUEST) 
  {
    if (old_ob=find_object(ob_name))
    {
      catch(old_ob->remove());
      if (old_ob)
	destruct(old_ob);
    }
    rename_object(ob,ob_name);
  }
  exec(ob,this_object());
  ob->start_player(cap_name, 0); 
  if (lflag==LFLAG_NEW)
  {
    /////////////////////////////////////////////////////////
    // A new playerobject will is loaded, known properties //
    // are set...and finalizing will be done in the shell  //
    /////////////////////////////////////////////////////////
    ob->SetProp(P_CREATION_DATE,creation_date);
    ob->Set(P_CREATION_DATE,SAVE|SECURED|PROTECTED|NOSETMETHOD,F_MODE_AS);
    ob->SetProp(P_ATTRIBUTES,props[P_ATTRIBUTES]);
    ob->Set(P_PROFESSION,props[P_PROFESSION]);
    ob->Set(P_PROFESSION,SAVE|SECURED|PROTECTED,F_MODE_AS);
    ob->Set(P_GENDER,props[P_GENDER]);
    ob->Set(P_GENDER,SAVE|SECURED|PROTECTED|NOSETMETHOD,F_MODE_AS);
    ob->Set(P_RACE,props[P_RACE]);
    ob->Set(P_RACE,SAVE|SECURED|PROTECTED,F_MODE_AS);
    ob->Set(P_DP,props[P_DP]);
    ob->Set(P_DP,SAVE|SECURED|PROTECTED,F_MODE_AS);
    ob->Set(P_SIZE,props[P_SIZE]);
    ob->Set(P_SIZE,SAVE,F_MODE_AS);
    ob->Set(P_HAIR_COLOR,props[P_HAIR_COLOR]);
    ob->Set(P_HAIR_COLOR,SAVE,F_MODE_AS);
    ob->Set(P_HAIR_TEXTURE,props[P_HAIR_TEXTURE]);
    ob->Set(P_HAIR_TEXTURE,SAVE,F_MODE_AS);
    ob->Set(P_HAIR_LENGTH,
      RMASTER->QueryOffset(P_HAIR_LENGTH,props[P_RACE])[props[P_GENDER]]);
    ob->Set(P_HAIR_LENGTH,SAVE,F_MODE_AS);
    ob->Set(P_SKIN_COLOR,props[P_SKIN_COLOR]);
    ob->Set(P_SKIN_COLOR,SAVE,F_MODE_AS);
    ob->Set(P_EYE_COLOR,props[P_EYE_COLOR]);
    ob->Set(P_EYE_COLOR,SAVE,F_MODE_AS);
    ob->Set(P_FIRST_WEAPON_SKILLS,props[P_FIRST_WEAPON_SKILLS]);
    ob->Set(P_FIRST_WEAPON_SKILLS,SAVE|SECURED|PROTECTED,F_MODE_AS);
    ob->SetSkills(props[P_SKILLS]);
  }
  else
    USERUPDATE->UpdateUser(ob);  
  destruct(this_object());
}

/*
 * Check that a player name is valid. Only allow
 * lowercase letters.
 * Hier die Pruefung der Namenbank vornehmen.
 * vorlaeufig mal varargs
 */
varargs int valid_name(string str) 
{
  int i, length;
  if (str == "logon") {
    write("Der Name 'logon' ist nicht erlaubt.\n");
    return 0;
  }
  length = strlen(str);
  if (length < 3)
  {
    write("Der Name ist zu kurz, bitte waehlt einen anderen.\n");
    return 0;
  }
  if (length > 11) {
    write("Der Name ist zu lang, bitte waehlt einen anderen.\n");
    return 0;
  }
  i=0;
  while(i<length) {
    if (str[i] < 'a' || str[i] > 'z') {
      write("Unerlaubtes Zeichen im Namen: " + str[i..i] + "\n");
      write("Benutzt bitte nur Buchstaben.\n");
      return 0;
    }
    i += 1;
  }
  return 1;
}

void create() 
{
  if(myself)
    return;
  loginname = "logon";
  creation_date = -1;
  catch(call_other(SERVICE,"?"));
  loginfails=0;
}

/* for debugging purpose */
int query_wiz_level() 
{ 
  return 0; 
}

int query_level() 
{ 
  return 0; 
}

string query_real_name() 
{ 
  return "<logon>"; 
}

int query_prevent_shadow() 
{ 
  return 1; 
}

void time_out() {
  if (this_player()) write("Die Zeit ist abgelaufen. Lebt wohl!\n");
  destruct(this_object());
}

int remove() {
  destruct(this_object());
  return 1;
}

void telnet_neg(mixed cmd,mixed opt,mixed args) {
  if (opt==34 && cmd==251)
    binary_message(({255,250,34,1,1,255,240}));
}

// Wir zeigen, was wir alles koennen.
// Zumindest so Telnet-technisch gesehen ;-)
static void SendTelopts() {
    efun::binary_message(({
        IAC,DO,TELOPT_LINEMODE,
            IAC,WILL,TELOPT_EOR,
            IAC,DO,TELOPT_NAWS,
            IAC,DO,TELOPT_TTYPE,
            IAC,DO,TELOPT_XDISPLOC,
            IAC,DO,TELOPT_ENVIRON,
            IAC,DO,TELOPT_NEWENV,
            IAC,DO,TELOPT_TSPEED,
            }),3);
    TN=(["sent":([
        TELOPT_LINEMODE:0;DO;0,
        TELOPT_EOR:WILL;0;0,
        TELOPT_NAWS:0;DO;0,
        TELOPT_TTYPE:0;DO;0,
        TELOPT_ENVIRON:0;DO;0,
        TELOPT_NEWENV:0;DO;0,
        TELOPT_XDISPLOC:0;DO;0,
        TELOPT_TSPEED:0;DO;0,
        ])]);
}
