/*******************
** Eldarea MUDLib **
********************
**
** /secure/mailer.c - mud mail daemon
**
** CVS DATA
** $Date: 2001/02/06 08:56:57 $
** $Revision: 1.3 $
**
** longdesc
**
** CVS History
**
** $Log: mailer.c,v $
** Revision 1.3  2001/02/06 08:56:57  elatar
** applied strong_types requirements
**
** Revision 1.2  2000/11/30 16:09:06  elatar
** local mail handling changed
**
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
 *
 *------------------------------------------------------------
 * The mail demon. Receives mail from users and delivers it into
 * the mail directory.
 *
 * Deepthought, Nightfall, 25-May-92
 * Remove-Functions : Jof, 29-June-92
 *
 * $Log: mailer.c,v $
 * Revision 1.3  2001/02/06 08:56:57  elatar
 * applied strong_types requirements
 *
 * Revision 1.2  2000/11/30 16:09:06  elatar
 * local mail handling changed
 *
 * Revision 1.1.1.1  1999/11/05 12:30:45  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:11  en
 * MUDLib CVS Preperation
 *
 *------------------------------------------------------------
 *
 *	Save file format (sort of formal notation):
 *
 *	mixed *folders = ({
 *	   ({ string name1; string name2; ... string nameN; })
 *	   ({ mixed *msgs1; mixed *msgs2; ... mixed *msgsN; })
 *	})
 *
 *	Each msgs field is an array of messages:
 *
 *	mixed *msgs = ({ mixed *message1; ... mixed *messageM })
 *
 *	A message is represented as an array with the following fields:
 *
 *	mixed *message = ({
 *	   string from;
 *	   string sender;
 *	   string recipient;
 *	   string *cc;
 *	   string *bcc;
 *	   string subject;
 *	   string date;
 *	   string id;
 *	   string body;
 *	})
 *
 *	The mailer demon (/secure/mailer, or /obj/mailer) provides
 *	the following functions:
 *
 *	string *DeliverMail(mixed *message)
 *	  Hand a mail message over to the mailer demon. The mailer
 *	  demon extracts recipients from the recipient, cc and bcc
 *	  fields and removes the bcc information. It then deposits
 *	  the message to the mail files of all recipients. A valid
 *	  message is shown above. Returns a list of successfully
 *	  delivered recipients.
 *
 *	int FingerMail(string user)
 *	  Gives the number of unread messages a user has.
 *------------------------------------------------------------
 */
#include <config.h>
#include <mail.h>

//#define DEBUG(msg) if(find_player("elatar")) tell_object(find_player("elatar"),msg)
//#undef DEBUG
#define DEBUG(x)
#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

static void save_msg(mixed * msg, string user);

mixed *folders;		/* used for save and restore of mail files */
static mapping alias;

void create()
{
  mixed tmp;
  int i;
  string s1,s2;
  
  seteuid(ROOTID);
  alias=([]);
  if (tmp=read_file("/mail/system.mailrc")+"\n"+read_file("/mail/user.mailrc"))
  {
    tmp=explode(tmp,"\n");
    for (i=sizeof(tmp)-1;i>=0;i--)
      if (sscanf(tmp[i],"%s %s",s1,s2)==2)
	alias[s1]=s2;
  }
}

string add_user_alias(string mali)
{
  string * uafile, uid, auid, amali;
  int i;
 
  if (!uid=getuid(previous_object()) || previous_object()!=find_player(uid))
    return 0;
    
  uafile=explode(read_file("/mail/user.mailrc"),"\n");
  for (i=sizeof(uafile);i-->0;)
  {
    if (sscanf(uafile[i],"%s %s",auid,amali)==2 && auid==uid)
    {
      uafile[i]=0;
    }
  }
  
  uafile-=({0});
  if (!mali || mali=="")
  {
    alias=m_delete(alias,uid);
  }
  else
  {
    alias[uid]=mali;
    uafile+=({sprintf("%s %s",uid,mali)});  
  }
  rm("/mail/user.mailrc");
  write_file("/mail/user.mailrc",implode(uafile,"\n")+"\n");
  return mali;
}

string *unify(string *str)
{
  string *new;
  
  new=({});
  while (pointerp(str) && sizeof(str))
  {
    if (str[0])
    {
      DEBUG(sprintf("%O\n",str[0]));
      if (str[0][0]=='\\') str[0]=str[0][1..];
      if (member(new,lower_case(str[0]))==-1)
	new+=({lower_case(str[0])});
    }
    str=str[1..];
  }
  return new;
}

varargs string * expand(string * addr,int expa)
{
  string s,tmp, *new, *ret;
  int i,j;

  ret=({});
  addr-=({""});
  j=sizeof(addr);
  for (i=0;i<j;i++)
  {
    s=lower_case(addr[i]);
    new=explode(s,"@");
    DEBUG(sprintf("Now we have %O\n",new));
    /*
    if (sizeof(new)==2 &&
	(new[1]==MUDHOST||new[1]==lower_case(MUDNAME)||new[1]=="mud"||
	 new[1]==MUDCOMP))
      s=new[0];
    */
    if (!expa&&tmp=alias[s])
      ret+=explode(tmp,",");
    else
      ret+=({s});
  }
  for (i=sizeof(ret)-1;i>=0;i--) if (ret[i][0]=='\\') ret[i]=ret[i][1..];
  return ret;
}

varargs string * DeliverMail(mixed * msg, int expa) {
  string sender;
  string *recipients;
  string *recok;
  mixed *tmp;
  mixed *newmsg;
  int i,ext,holger,rand;
  string footer;
  string t;
  object* obs;
  
  if (!pointerp(msg) || sizeof(msg) != 9)
    return 0;
  t=dtime(time());ext=0;
  footer=
    "\n"
    "+----------------------------------------------------------------------+\n"
    +MUDNAME+" Mailrelais  -  bearbeitet "+t[5..]+"\n"
    "telnet "+MUDCOMP+" "+MUD_PORT+"\n" 
    "Website: "+MUD_WWW+"\n"
    "+----------------------------------------------------------------------+\n"
    "Bei Problemen bitte an "+ADMIN_EMAIL+" ohne (!) Realnamensangabe wenden\n";
  
  /* determine the real sender */
  if (extern_call() &&
      (!previous_object()||file_name(previous_object())[0..7]!="/secure/"))
  {
    DEBUG(file_name(previous_object()));
    if (!this_interactive()) { // finden eines 'Schuldigen'
      obs=caller_stack();
      while (sizeof(obs) && member(({"secure","std","global","mail","obj",
        "room"}), efun::explode(load_name(obs[0]), "/")[1])!=-1)
        obs=obs[1..];
      // moeglichst nahes nicht-lib Objekt
      if (!sizeof(obs)) sender=msg[MSG_FROM]; // return -1; // Nur Libobj?!?
      else {
        sender=getuid(obs[0]);
        footer="\n(Nachricht erzeugt von "+load_name(obs[0])+")\n"+footer;
      }
    } else sender = getuid(this_interactive());
  }
  else
    sender = msg[MSG_SENDER];
  
  /* make a list of all recipients */
  recipients = ({msg[MSG_RECIPIENT]});
  if (pointerp(msg[MSG_CC])) recipients+=msg[MSG_CC];
  if (pointerp(msg[MSG_BCC])) recipients+=msg[MSG_BCC];
  recipients=unify(recipients);

  recipients=expand(recipients,expa);

  DEBUG(sprintf("NEED TO DELIVER TO %O\n",recipients));

  /* build the new message */
  newmsg = ({ msg[MSG_FROM], sender, msg[MSG_RECIPIENT],
	      msg[MSG_CC], "", msg[MSG_SUBJECT],
	      dtime(time()), MUDNAME+":"+time(),
	      msg[MSG_BODY] });
  
  /* Send it off ... */
  recok = ({ });
  for (i = 0; i < sizeof(recipients); i++) 
  {
    mixed *xtmp;

    if (member(recipients[i],'%')>0 && member(recipients[i],'@')<0)
    {
      xtmp=explode(recipients[i],"%");
      recipients[i]=implode(xtmp[0..<2],"%")+"@"+xtmp[<1];
    }
    if(member(recipients[i],'@')>0)
    {
      string mud;
      mixed rec;
      
      rec=explode(recipients[i],"@");
      mud=rec[1];
      rec=rec[0];
      if (member(mud,'.')==-1 && mud!="localhost")
      {
      	sender=implode(explode(sender,"@"),"%");
        "/secure/udp_mail"->deliver_mail(rec,mud,sender,msg[MSG_SUBJECT],
					 msg[MSG_BODY]);
      }
      else
      {
        ext=1;
        /* Obsoletes altes Format, wir verwenden sendmail
        // Achtung, das Format (Zeilenzahl etc) ist empfindlich, auf
        // Vertraeglichkeit mit ~mud/bin/delivermail achten!
        write_file(sprintf("/mail/OutBound/%s.%d-%d-%d",sender,time(),i,
          random(123456)), sprintf("RCPT TO: %s@%s\nREALNAME: %s@"+MUDNAME+"\n"
          "DATA\nReply-To: \"%s@"+MUDNAME+"\"<"+ADMIN_EMAIL+">\nSubject: %s\n\n********************"
          "** Mail aus dem "+MUDNAME+" **********************\n"
          "* von: %:-60s *\n* an : %:-60s *\n"+
          (pointerp(msg[MSG_CC])?"* CC : %:-60s *\n":"%s")+
          "****************************************************************"
          "*****\n\n", 
          rec, 
          mud,
          capitalize(sender),
          capitalize(sender),
          msg[MSG_SUBJECT],
          capitalize(sender),
          recipients[0], 
          pointerp(msg[MSG_CC])?implode(msg[MSG_CC],","):"")
          +msg[MSG_BODY]+footer);
        */
        rand=0;
        while(file_size(sprintf("/mail/OutBound/%s.%d-%d-%d",sender,time(),i,++rand))>0);
        write_file(sprintf("/mail/OutBound/%s.%d-%d-%d",sender,time(),i,rand)
          ,sprintf("To: %s@%s\n"
                   "Cc: %s \n"
                   "From: %s@"MUDNAME"\n"
                   "Sender: "MUDNAME"@"MUDCOMP"\n"
                   "Reply-To: %s.mud@"MUDCOMP"\n"
                   "Subject: %s\n"
                   "\n"
                   "%s\n"
                   "\n"
                   "%s"
                   ,rec
                   ,mud
                   ,pointerp(msg[MSG_CC])?implode(msg[MSG_CC],","):""
                   ,capitalize(sender)
                   ,capitalize(sender)
                   ,msg[MSG_SUBJECT]
                   ,msg[MSG_BODY]
                   ,"+----------------------------------------------------------------------+\n"
                    +MUDNAME+" Mailrelais  -  bearbeitet "+t[5..]+"\n"
                    "telnet 137.226.129.125 3636\n" 
                    "Website: http://137.226.129.125\n"
                    "+----------------------------------------------------------------------+\n"
                    "Bei Problemen bitte an "+ADMIN_EMAIL+" ohne (!) Realnamensangabe wenden\n"
                    ));
        write_file("/mail/OutBound/SendList"
                   ,sprintf("%s@%s %s\n"
                            ,rec
                            ,mud
                            ,sprintf("/mail/OutBound/%s.%d-%d-%d",sender,time(),i,rand)));
      }
      recok+=({recipients[i]});
    } 
    else if (file_size(SAVEPATH+recipients[i][0..0]+"/"+
		    recipients[i]+".o") >=0) 
    {
       save_msg(newmsg,recipients[i]);
       recok += ({ recipients[i] });
    } 
    else holger=1; // Nur eine Mail pro fehlerhafter Mail
  } /* ende for */
  if (holger) 
  {
      write_file(sprintf("/mail/OutBound/postmaster.%d-%d",time(),
      random(123456)),
      sprintf("RCTP TO: "+ADMIN_EMAIL+"\nREALNAME: %s@"+MUDNAME+"\n"
      "DATA\nReply-To: \"%s@"+MUDNAME+"\"<"+ADMIN_EMAIL+">\nSubject: "
      "Unzustellbare Mudmail\n\nFormat:\n"
      "0 FROM       1 SENDER     2 RECIPIENT  3 CC         4 BCC\n"
      "5 SUBJECT    6 DATE       7 ID         8 BODY\n"
      "%O\n\nErfolgreich an %s\n",capitalize(sender),capitalize(sender),
      newmsg,implode(recok,", ")));
  }
   //if (ext) send_imp(UDPSERV,4123,"DELIVERMAIL"); // bei uns via cron
  return recok;
}

int FingerMail(string user) {
  int newfolder;
  int i;
  
  if (!restore_object(MAILPATH+user[0..0]+"/"+user)) {
    return 0;
  }
  newfolder = member_array("unread",folders[0]);
  if (newfolder == -1) {
    return 0;
  }
  return sizeof(folders[1][newfolder]);
}

static void save_msg(mixed * msg, string user) {
  int newfolder;
  
  if (!restore_object(MAILPATH+user[0..0]+"/"+user)) {
    folders = ({({ }), ({ })});
  }
  
  /* if folder 'unread' doesn't exist, create it */
  newfolder = member_array("unread",folders[0]);
  if (newfolder == -1) {
    folders[0] += ({ "unread" });
    folders[1] += ({ ({ }) });
    newfolder = member_array("unread",folders[0]);
  }
  folders[1][newfolder] += ({ msg });
  save_object(MAILPATH+user[0..0]+"/"+user);
}

/* Remove a message from a folder */
int RemoveMsg(int msg, int folder, string user) {
  mixed *first, *rest;

  /* if (user != geteuid(previous_object())) return -2; /* Disallow */

  if (!restore_object(MAILPATH+user[0..0]+"/"+user)) 
    return -1; /* No such folder */

  if (!pointerp(folders) || !pointerp(folders[0]) || 
      folder>=sizeof(folders[0])) return -1;

  if (sizeof(folders[1][folder])<=msg || msg<0) return 0; /* No such msg */

  if (msg==0)
    first==({});
  else
    first=folders[1][folder][0..msg-1];
  if (msg==sizeof(folders[1][folder]))
    rest=({});
  else
    rest=folders[1][folder][msg+1..sizeof(folders[1][folder])];
  if (!rest) 
    folders[1][folder]=first;
  else 
    if (!first) 
      folders[1][folder]=rest;
    else
      folders[1][folder]=first+rest;
  save_object(MAILPATH+user[0..0]+"/"+user);
  return 1; /* Success */
}

/* Move message into another folder */
int MoveMsg(int msg, int folder, int newfolder, string user) {
  int target;

  /* if (user != geteuid(previous_object())) return -2; /* Disallow */

  if (!restore_object(MAILPATH+user[0..0]+"/"+user))
    return -1; /* Source folder not found */

  if (!pointerp(folders) || !pointerp(folders[0]) || 
      folder>=sizeof(folders[0])) return -1;
  
  if (sizeof(folders[1][folder])<=msg || msg<0) return 0; /* No such msg */

  target=member_array(newfolder, folders[0]);

  if (target==-1) return -3;

  if (target==folder) return 1;

  if (!pointerp(folders[1][target])) 
    folders[1][target]=({folders[1][folder][msg]});
  else 
    folders[1][target]+=({folders[1][folder][msg]});

  save_object(MAILPATH+user[0..0]+"/"+user);
  return RemoveMsg(msg,folder,user);
}

int MoveAllMessages(int folder, int newfolder, string user) {
  int target,i;

  /* if (user != geteuid(previous_object())) return -2; /* Disallow */

  if (!restore_object(MAILPATH+user[0..0]+"/"+user))
    return -1; /* Source folder not found */

  if (!pointerp(folders) || !pointerp(folders[0]) ||
      folder>=sizeof(folders[0])) return -1;

  target=member_array(newfolder, folders[0]);
  if (target==-1 || target==folder)
    return 0;
  if (!pointerp(folders[1][target]))
    folders[1][target]=({});

  if (pointerp(folders[1][folder]))
    folders[1][target]+=folders[1][folder];
  folders[1][folder]=({});

  save_object(MAILPATH+user[0..0]+"/"+user);
}

int RemoveFolder(int folder, string user) {
  int i;
  mixed *start, *rest, *start0, *rest0;

  if (geteuid(previous_object()) != user && geteuid(previous_object()) != MAILID) return -2; /* Disallow */

  if (!restore_object(MAILPATH+user[0..0]+"/"+user)) return -1; /* No such f */

  i=member_array(folder, folders[0]);

  if (i<0) return -1; /* No such folder */

  if (sizeof(folders[1][i])>0) return 0; /* Folder not empty */

  if (i==0) {
    start=({});
    start0=({});
  } else {
    start=folders[1][0..i-1];
    start0=folders[0][0..i-1];
  }
  if (i==sizeof(folders[0])-1){
    rest=({});
    rest0=({});
  } else {
    rest=folders[1][i+1..sizeof(folders[0])-1];
    rest0=folders[0][i+1..sizeof(folders[0])-1];
  }
  folders[0]=start0+rest0;
  folders[1]=start+rest;
  save_object(MAILPATH+user[0..0]+"/"+user);
  return 1;
}

int MakeFolder(string folder, string user)
{
  if (!folder) return -1; /* Huh ? */

  if (folder=="unread") return 0; /* Folder exists virtually :) */

  /* if (geteuid(previous_object()) != user) return -2; /* Disallow */
  
  if (!restore_object(MAILPATH+user[0..0]+"/"+user)) folders=({({}),({})});

  if (member_array(folder, folders[0])!=-1) return 0; /* Folder exists */

  folders[0]=folders[0]+({folder});
  folders[1]=folders[1]+({({})});
  save_object(MAILPATH+user[0..0]+"/"+user);
  return 1;
}

/* no shadowing */
int query_prevent_shadow() { return 1; }

int query_recipient_ok(string name)
{
  return 
  (file_size("secure/save/"+name[0..0]+"/"+name+".o")>0||
   member(name,'%')>0||member(name,'@')>0);
}

void deliver_mail(
		  string recipient,       /* the local players real name*/
		  string from,            /* A string depicting the sender */
		  string subject,         /* The mail subject/header */
		  string mail_body        /* The actual mail message */
		  )
{
  DEBUG(sprintf("DELIVER %O\n",({from,from,recipient,({}),({}),subject,time(),"EXTERNAL",mail_body})));
  DeliverMail(({from,from,recipient,({}),({}),subject,time(),"EXTERNAL",mail_body}));
}
