/*******************
** Eldarea MUDLib **
********************
**
** secure/master - mud master object
**
** CVS DATA
** $Date: 2001/02/01 14:31:16 $
** $Revision: 1.9 $
**
** CVS History
**
** $Log: master.c,v $
** Revision 1.9  2001/02/01 14:31:16  elatar
** added '#pragma strong_types' to auto_include_string
**
** Revision 1.8  2001/02/01 08:19:31  elatar
** global preload file implemented
**
** Revision 1.7  2001/01/10 08:22:49  elatar
** domain ids prefixed with d:
**
** Revision 1.6  2000/11/30 16:09:52  elatar
** some rights changes and miscellaneous
**
** Revision 1.5  2000/03/13 10:29:03  elatar
** implemented much basic functionality
**
** Revision 1.4  1999/11/23 16:24:44  elatar
** small valid_write debug
**
** Revision 1.3  1999/11/18 11:37:38  elatar
** VOICEMASTER Anpassung
**
** Revision 1.2  1999/11/08 09:37:07  elatar
** file acces rights corrected
**
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

inherit "/secure/master/misc";
inherit "/secure/master/userinfo";
inherit "/secure/master/network";
inherit "/secure/master/domain";
//inherit "/secure/master/ftpd";

#include "/secure/master.h"

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

static mapping ip_map;
static object debugger;
// last /log/ARCH/READ entry
static string last_rf_log = "";

void notify_text(string cmd, object player);
varargs int access_rights(string *p_arr, string euid,
                          int readflag, int def, string fun);

string *define_include_dirs() {
  return ({ "secure/%s" , "sys/%s", "room/%s" });
}

void flag(string str) {}

string dtime(int wann)
{
  string monat, uhrzeit, wotag, tag, jahr;

  sscanf(ctime(wann),"%s %s %d %s %d",wotag, monat, tag, uhrzeit, jahr);
  switch (monat)
  {
    case "May": monat="Mai"; break;
    case "Oct": monat="Okt"; break;
    case "Dec": monat="Dez"; break;
  }
  switch(wotag)
  {
    case "Sun": wotag="Son"; break;
    case "Tue": wotag="Die"; break;
    case "Wed": wotag="Mit"; break;
    case "Thu": wotag="Don"; break;
    case "Fri": wotag="Fre"; break;
    case "Sat": wotag="Sam"; break;
  }
  return wotag+(tag<=9 ? ",  " : ", ")+tag+". "+monat+" "+jahr+", "+uhrzeit;
}

object connect() { // Einloggende Spieler landen hier
  string err;
  object ob,bp;

  printf("Lokalzeit: %s MET\n\n"+MUDNAME+
         " LPmud, NATIVE mode, Version: %s\n\n",
         dtime(time()),__VERSION__);

  if ((bp=find_object("/secure/login"))&&environment(bp)) catch(destruct(bp));
  err = catch(ob = clone_object("secure/login"));
  if (err) write("Fehler beim Laden von /secure/login.c\n"+err+"\n");
  return ob;
}

string get_master_uid()  {return ROOTID;}

string get_wiz_name(string file) {return creator_file(file);}

string *epilog(int eflag) {
  string *files, *domains;
  int i;

  seteuid(ROOTID);
  ReloadBanishFile();

  if (eflag) {
    write("-e angegeben -> Preloading unterdrueckt ...\n");
    return 0;
  }

  printf("Preloading gestartet: %s\n\n",ctime(time()));
  files = explode_files("/std/preload_file")+
          explode_files("/"GLOBALDIR"/preload_file")+
          explode_files("/"DOMAINDIR"/preload_file");
  domains = get_domains();
  for(i=sizeof(domains);i--;)
    files+=explode_files("/"DOMAINDIR"/"+domains[i]+"/preload_file");
  files += explode_files("/"GUILDDIR"/preload_file");
  write("\n");
  return files;
}

void preload(string file) {
  string err;
  string name;
  int *res, t1;

  if(!file || !file[0] || file[0] == ';' || file_size(file+".c") < 0) return;

  printf("%-50s",file);
  if (!(name=creator_file(file))) {
    write("\nno creator found for "+file+"\n");
    return;
  }
  printf("%-15s",name);
  if (!seteuid(name)) {
    write("\ncannot set euid to "+name+"\n"+"EUID is now "+geteuid(TO)+"\n");
    return;
  }
  res = rusage();
  t1 = res[0] + res[1];
  err = catch(call_other(file, "??"));
  if (err != 0) {
    write("\nGot error " + err + " when loading " + file + "\n");
  } else {
    res=rusage();
    t1=res[0]+res[1]-t1;
    printf("(%2d.%:02d s)\n",t1/1000,t1%1000);
  }
  seteuid(ROOTID);
}

string creator_file(mixed str) {
  string *strs,tmp;
  int s;

  if(objectp(str))
    strs=full_path_array(file_name(str), 0);
  else if(stringp(str))
    strs=full_path_array(str, 0);
  else return NOBODY;

  s=sizeof(strs);
  if(s<2) return NOBODY;

  switch(strs[0]) {
    case DOMAINDIR:
      if(s==2 || !IS_LEARNER(strs[2]))
      {
        if (file_size(strs[0]+"/"+strs[1])!=-2)
          return "d";
        else
          return "d:"+strs[1];
      }
      return "d:"+strs[1]+":"+strs[2];
    case PROJECTDIR:
      if(s>2 || (s==2 && file_size(strs[0]+"/"+strs[1])==-2))
        return PROJECTDIR+":"+strs[1];
      return PROJECTDIR;
    case WIZARDDIR:
      if(s>2)
        return strs[1];
      if(s==2 && file_size(strs[0]+"/"+strs[1])==-2)
        return strs[1];
      return NOBODY;
    case "secure":
      return ROOTID;
    case "std":
    case "room":
    case "obj":
      return BACKBONEID;
    case "doc":
      return "DOC";
    case "mail":
      return MAILID;
    case "news":
      return NEWSID;
    case GLOBALDIR:
      if(s>2 || (s==2 && file_size(strs[0]+"/"+strs[1])==-2))
        return "GLOBAL:"+strs[1];
      return "GLOBAL";
    case GUILDDIR:
      if(s>2 || (s==2 && file_size(strs[0]+"/"+strs[1])==-2))
        return "GUILD:"+strs[1];
      return "GUILD";
    case SPELLBOOKDIR:
      if(s>2 || (s==2 && file_size(strs[0]+"/"+strs[1])==-2))
        return SPELLBOOKDIR+":"+strs[1];
      return SPELLBOOKDIR;
  }
  return NOBODY;
}

mixed valid_read(string path, string euid, string fun, object obj) 
{
  string *strs;
  int s, lev;

  if (member(path,' ')!=-1)
    return 0;

  if(!euid) euid="-";

  strs=full_path_array(path, euid);
  path=implode(strs, "/");

  if (!sizeof(strs) || !strlen(path) || euid == ROOTID || obj==TO)
    return path;

  //DB(sprintf("p %O u %O f %O o %O\n",path,euid,fun,obj));

  if ((s=sizeof(strs)) <= 1)
    if (strs[0]=="core" || strs[0]=="news")
      return 0;
    else
      return path;

  lev=query_wiz_level(euid);

  switch(strs[0]) 
  {
    case "core":
      return 0;
    case "news":
      return 0;
      
    case "":
    case "doc":
    case "etc":
    case "npc":
    case "obj":
    case "open":
    case "room":
    case "std":
    case "sys":
    case "tmp":
    case "var":
      return path;

    case "mail":
      //DB(sprintf("p %O u %O f %O o %O\n",path,euid,fun,obj));
      if (euid==MAILID) return path;                    // Mailer OK
      if (s==2 && file_size(path)!=-2) return path;     // 1. Verz.-Ebene OK
      return IS_ARCH(euid) && path[<2..]!=".o" && path; // Erzis nur .o nicht

    case "secure":
      if (strs[1]=="save" || strs[1]=="save_old" || strs[1]=="save_inactive") return 0;
      if (path[<2..]==".o" || path[<5..]==".dump") return 0;
      if (strs[1]=="ARCH" && lev < ELDER_LVL) return 0;
      if (strs[1]=="LORD" && lev < LORD_LVL) return 0;
      return path;

    case "log":
      if ( strs[1]=="ARCH" )
          return lev>=ELDER_LVL;
      // Als Nicht-Lehrling sonst alles erlaubt
      if ( lev>=INACTIVE_LVL )
          return path;

      // Ab hier fuer Magier < INACTIVE_LVL
      if ( strs[1]=="report" )
          return path;

      // Duerfen nichts ausser dem /log/report/ Verzeichnis einsehen
      return 0;

    case "save":
      // Lords sind trusted
      if (lev>=LORD_LVL) return path;

      // Ausnahmen
      if (euid[0..6]=="GLOBAL:") return path;        // v.a. fingerd und fwserv
      if (fun=="file_size") return path;       // Existenzpruefung

      if (s==3 && (strs[2]==euid+".o" || strs[2]==euid))
        return path;

      // Prinzipiell jedenfalls NICHT erlaubt
      return 0;

    case GLOBALDIR:
      // Lords sind trusted, ausserdem impliziert Schreibrecht Leserecht
      if (lev>=LORD_LVL || project_access(euid,strs[1]))
        return path;

      // Objekte eines Projektes haben Lesezugriff auf ihr Projekt
      if (s>2 && "GLOBAL:"+strs[1]==euid) return path;

      // Sonst entscheidet access_rights
      return access_rights(strs,euid,1,(lev>WIZARD_LVL),fun) ? path : 0;

    case GUILDDIR:
    case SPELLBOOKDIR:
      // Gilden(objekte) selbst duerfen lesen
      if (euid[0..4]=="GUILD")
        return path;
      // Lords sind trusted
      if (lev>=LORD_LVL)
        return path;
      // Kleine Magier sind untrusted
      if (lev<WIZARD_LVL)
        return 0;
      // doc/ Verzeichnis ist OK
      if (strs[1]=="doc")
        return path;
      // Vollmagier je nach access_read(), default: OK, sonst default: 0
      return access_rights(strs,euid,1,(lev>=WIZARD_LVL),fun) ? path : 0;

    case WIZARDDIR:
      if (s==2) return path;
      // das eigene Verzeichniss darf man natuerlich immer lesen...
      if (strs[1]==euid) return lev>=LEARNER_LVL ? path : 0;

      // Pruefen ob ein File existiert darf jeder...
      if (fun=="file_size") return path;

      // fremde Verzeichnisse mit < Level 15 noch nicht
      if (lev<INACTIVE_LVL) return 0;

      // Lords sind trusted
      if (lev>=LORD_LVL) return path;

      // Legt access_rights() Veto ein?
      if (!access_rights(strs,euid,1,1,fun)) return 0;

      // folgende Funktionen sind natuerlich voellig uninteressant
      if (member(({"get_dir","restore_object","read_file_test"}),fun)!=-1)
        return path;

      // Nur Nicht-Daemons und Dateien mit Inhalt sind relevant
      if (euid=="p:daemon" || file_size(path) <= 0) return path;

      // wenn Zugriff erlaubt, mitloggen
      if (last_rf_log != sprintf("%O %s %s", fun, euid, path)) {
        last_rf_log = sprintf("%O %s %s", fun, euid, path);
        log_file("ARCH/READFILE",
            sprintf("%O %s %s: %s\n", fun, ctime()[4..], euid, path));
      }
      return path;

    case DOMAINDIR:
      // den Verzeichnisbaum von /d/ darf man natuerlich lesen
      if (s<=2) return path;

      // eigenen Code darf man natuerlich lesen
      if (euid==strs[2] ||
          euid==sprintf("d:%s", strs[1]) ||
          euid==sprintf("d:%s:%s", strs[1], strs[2]))
         return path;

      // Daemons+death_room duerfen auch lesen (insbesondere der libmaster)
      if (euid=="p:daemon" || euid=="room") return path;

      // Existenztests und .readme sind immer erlaubt...
      if (strs[<1]==".readme" || fun=="file_size" || fun=="get_dir")
        return path;

      // Als Mitarbeiter darf man ueberall lesen
      if (domain_member(euid, strs[1]))
        return path;

      // Mit Level <4 darf man noch keinen fremden Code lesen!
      if (lev<WIZARD_LVL) return 0;

      // Lords sind trusted
      if (lev>=LORD_LVL) return path;

      // Legt access_rights() Veto ein?
      if (!access_rights(strs,euid,1,
            (file_size(sprintf("/d/%s/%s",strs[1],euid))==-2),fun))
        return 0;

      // folgende Funktionen sind natuerlich voellig uninteressant
      if (member(({"get_dir","restore_object","read_file_test"}),fun)!=-1)
        return path;

      // Nur Dateien mit Inhalt sind relevant
      if (file_size(path) <= 0) return path;

      // wenn Zugriff erlaubt, mitloggen
      if (last_rf_log != sprintf("%O %s %s", fun, euid, path)) {
        last_rf_log = sprintf("%O %s %s", fun, euid, path);
        log_file("ARCH/READFILE",
            sprintf("%O %s %s: %s\n", fun, ctime()[4..], euid, path));
      }
      return path;
    case "www":
      if (objectp(obj) && load_name(obj)==WWWD)
        return 1;
      else if (member(strs,".htpasswd")>-1)
        return 0;
      else if (sizeof(strs)>2 && strs[2]=="ARCH")
        return IS_ELDER(euid);
      else if (sizeof(strs)>2 && strs[2]=="LORD")
        return IS_LORD(euid);
    
  }
  if (lev<ELDER_LVL) return 0;
  return path;
}

// access_rights - klappert den Pfad Richtung root nach access_rights.c ab
// readflag sagt, dass nach Leserechten gefragt wird.
// def legt den Defaultwert fest.
varargs int access_rights(string *p_arr, string euid,
                          int readflag, int def, string fun)
{
  int i;

  i=sizeof(p_arr)-2;
  while (i>=0 && file_size(implode(p_arr[0..i],"/")+"/access_rights.c") < 0)
    i--;
  if (i<0) return def;
  if (catch(i=call_other(
          implode(p_arr[0..i],"/")+"/access_rights", "access_rights",
          euid, implode(p_arr[i+1..],"/"), readflag, def, fun)))
    return def;
  return i;
}

mixed valid_write(string path, string euid, string fun, object obj) {
  string *strs;
  int s;
  int x;
  string *pn;

  if (IS_GOD(euid)) return 1;

  if (member(path,' ')!=-1)
    return 0;

  //DB(sprintf("p %O u %O f %O o %O\n",path,euid,fun,obj));
  if (fun=="log_file")
  {
    strs=full_path_array(path, 0);
    if (sizeof(strs)>1 && strs[0]=="log") return implode(strs,"/");
  }
  if(!euid || euid=="NOBODY" || euid=="ftp" || euid=="anonymous") return 0;

  switch(fun)
  {
    case "save_object":
      if(!path) return 0;
      if(objectp(obj) && path==file_name(obj)) // Holger
        return path;
      strs=full_path_array(path, 0);
      break;
    case "ed_start":
      if(path && path[0])
        strs=full_path_array(path, euid);
      else
        strs=({"players",euid,".err"});
      break;
    default:
      strs=full_path_array(path, euid);
  }

  path=implode(strs, "/");

  if(euid == ROOTID || obj==TO)
    return path;

  s=sizeof(strs);

  if(s>1) 
  {
    switch(strs[0]) 
    {
      case "wahl":
      case "secure":
      case "news":
      case "quests":
        return 0;

      case "www":
        if (objectp(obj) && load_name(obj)==WWWD)
          return path;
        else if (member(strs,".htpasswd")>-1)
          return 0;
        else if (sizeof(strs)>2 && strs[2]=="LORD")
          return IS_LORD(euid);
        else if (sizeof(strs)>2 && strs[2]=="ARCH")
          return IS_ELDER(euid);
        else
          return 0;
        break;
      case "ftp":
      case "open":
        if(obj &&
          (fun=="write_file" || fun=="write_bytes" || fun=="write_log"))
          write_file("/log/ARCH/WRITE_OPEN",
            efun::ctime()+": "+path+" - "+euid+"\n");
      case "tmp":
        return path;

      case "sys":
      case "std":
      case "obj":
        if (IS_ELDER(euid) || access_rights(strs,euid))
          return path;
        return 0;
      case GLOBALDIR:
        if ("GLOBAL:"+strs[1]==euid && fun=="save_object") break;
        if (IS_ELDER(euid)) break;
        if ( s>3
          && strs[1]=="daemon"
          && strs[2]=="crontabs"
          && objectp(obj) && load_name(obj)==CRON)
          break;
        if (access_rights(strs,euid)) break;
        return 0;

      case GUILDDIR:
	      if("GUILD:"+strs[1]==euid) break;
      case SPELLBOOKDIR:
        if(IS_GOD(euid)) break;
	      if(s<3) return 0;
	      if(implode(strs[0..1],":")==euid) break;
        if(access_rights(strs,euid)) break;
        return 0;

      case "doc":
        return IS_SPECIAL(euid) || access_rights(strs,euid);

      case "mail":
        if (euid==MAILID || strs[1]=="spool")
          break;

      case "save":
        if(IS_GOD(euid)) return 1;
        if(s != 3) return 0;
        if(extern_call() &&
	  ((!TP || PO != TP) &&
	    (geteuid(PO)!=getuid(PO) || geteuid(PO)!=euid)))
	      return 0;
        if(strs[1] == euid[0..0] && (strs[2] == euid || strs[2]==euid+".o"))
	  break;
        return 0;

      case PROJECTDIR:
        if(s<3&&!IS_ARCH(euid)) return 0;
        if(IS_ELDER(euid)) break;
        if (objectp(obj))
	  pn=explode(file_name(obj),"/");
        else
	  pn=({});
        if (sizeof(pn)>2 && s>3 && implode(strs[0..1],":")==euid)
          return 1;
        if(s==3&&strs[2]=="ACCESS_RIGHTS")
	  if(project_access(euid,strs[1])>1)
	    break;
          else
	    return 0;
        if(s>3&&euid==strs[2])
	  break;
        if(project_access(euid,strs[1]))
	  break;
        return 0;

      case DOMAINDIR:
        if(IS_ARCH(euid) || (s>2 && IS_ELDER(euid))) break;
        if(s<2) return 0;
        // if(s>2&&IS_ARCH(strs[2])) return 0;
        // if(s>2&&IS_ELDER(strs[2])) return 0; // Bugfix fuer Ulo's Bug
	  // 2 zeilen auskommentiert  Fini
        if(domain_master(euid,strs[1])) break;
        if(euid==strs[1]) break;
        if(s<=3 && (fun=="mkdir"||fun=="rmdir")) return 0;
        if(s==2) return domain_master(euid,strs[1]);
	if((strs[2]=="common" || strs[2]=="alle") &&
	    domain_member(euid, strs[1]))
	      break;
        if((euid==strs[2]) || (euid==(DOMAINDIR+":"+strs[2]))) break;
        if(access_rights(strs,euid)) break;
        return 0;

      case "log":
        if (sizeof(strs)==2 && (strs[1][0]<='Z' && strs[1][0]>='A'))
        {
          if (!IS_ARCH(euid) &&
            fun != "write_file" && fun != "log_file" && fun != "write_log")
              return 0;
        } else break;

      case WIZARDDIR:
        if (IS_ARCH(euid)) break;
        if (s>2 && IS_ELDER(euid)) break;
        if ( /* IS_WIZARD(euid) && */ euid==strs[1]) break;
        return access_rights(strs,euid);

      default:
        return IS_ARCH(euid);
    }
    return path;
  }
  return IS_ARCH(euid);
}

int valid_seteuid(object ob, string neweuid) {
  if (ob==this_object() ||
      getuid(ob) == ROOTID || getuid(ob) == neweuid ||
      creator_file(file_name(ob)) == neweuid)
    return 1;
  return 0;
}

string get_simul_efun() {
  if(!catch(call_other(SIMUL_EFUN_FILE, "start_simul_efun")))
    return SIMUL_EFUN_FILE;
  write("Failed to load " + SIMUL_EFUN_FILE + "\n");
  if(!catch(call_other(SPARE_SIMUL_EFUN_FILE, "start_simul_efun")))
    return SPARE_SIMUL_EFUN_FILE;
  write("Failed to load " + SPARE_SIMUL_EFUN_FILE + "\n");
  efun::shutdown();
  return 0;
}

int valid_trace(object player, int trace_lvl) {
  return IS_WIZARD(player);
}

string make_path_absolute(string str) {
  return _get_path(str, getuid(TP));
}

int query_allow_shadow(object ob) {
	string f;

  if (ob==TO)
    return 0;
  if(getuid(ob) == ROOTID)
    return 0;
	f=explode(file_name(ob),"#")[0];
	if (f[-14..]=="/access_rights") return 0;
  return !(int)ob->query_prevent_shadow(PO);
}

string get_ed_buffer_save_file_name(string file) {
  string *file_ar;

  file_ar=efun::explode(file, "/");
  file=file_ar[sizeof(file_ar)-1];
  return "/players/"+getuid(TP)+"/.dead_ed_files/"+file;
}

int query_player_level(string what) {
  if(!TP) return 0;
  switch(what) {
    case "wizard":
    case "trace":
    return IS_ELDER(TP);
    case "error messages":
    return (TP->QueryProp(P_DEBUGGER) || IS_LEARNER(TP));
  }
  return 0;
}

int log_error(string file,string message) {
  string lfile, cr, *tmp;

  cr=creator_file(file);
  if(!cr)
    cr="NOBODY";
  if(cr==ROOTID)
    lfile="/log/err/ROOT";
  else if(member(cr,' ')!=-1)
    lfile="/log/err/STD";
  if(!lfile)
  {
    if(!cr)
      lfile="/log/err/SYSERROR";
    else if(file_size("/players/"+cr) == -2)
      lfile="/players/"+cr+"/.err";
    else if(file_size("/d/"+cr) == -2)
      lfile="/d/"+cr+"/.err";

    else if(sizeof(tmp=explode(cr,":"))>=2)
    {
      if((tmp[0]==DOMAINDIR || -1!=member(get_domains(),tmp[0]) ) &&
        file_size("/players/"+tmp[1])==-2)
          lfile="/players/"+tmp[1]+"/.err";
      else if((tmp[0]==PROJECTDIR   ||
             tmp[0]==GUILDDIR      ||
             tmp[0]==SPELLBOOKDIR) &&
             (file_size("/"+tmp[0]+"/"+tmp[1]) == -2))
               lfile="/"+tmp[0]+"/"+tmp[1]+"/.err";
      else
        lfile="/log/err/"+cr;
    }
    else
      lfile="/log/err/"+cr;
  }
  write_file(lfile,efun::ctime()+": "+message);
  if(IS_LEARNER(TI))
    write(message);
  return 1;
}

object __redirect_internal_errors(object ob) {
  if(objectp(ob))
    return debugger=ob;
  return debugger=(object)0;
}

void runtime_error(string err ,string prg, string curobj, int line) {
  string code;
  int flag;
  string mkzmsg;
  object ob;

  if(TI) mkzmsg=getuid(TI);
  else mkzmsg="noone";
  if (!curobj) curobj="";
  if (!prg) {
    prg="<driver internal>";
    if(objectp(debugger)) {
      tell_object(debugger,
        sprintf("!<%s>::%s::%s::%d::%s\n",mkzmsg,prg,curobj,line,err));
      return;
    }
  }
  mkzmsg=sprintf("Fehler: %O, Objekt: %s, Programm: %O, Zeile %O (%s)",
                 err[0..<2], curobj, (prg[0]!='<'?"/":"")+prg, line,
                 capitalize(mkzmsg||"<Unbekannt>"));
  DEBUG_MSG(mkzmsg);
  if(!TI)
    return;
  if(flag=query_player_level("error messages")) {
    write("------------------------------------------------------------------------------\n"+
          "file: "+prg+" line: "+line+" object: "+curobj+"\n");
    if(prg && code=read_file("/"+prg, line, 1))
      write("\n"+code+"\n");
    write("error: "+err+
          "-----------------------------------------------------------------------------\n");
  }
  else
    write("Du siehst einen Fehler im Raum-Zeit-Gefuege.\n");
  if (err=="Object the closure was bound to has been destructed\n")
  {
    ob=find_object(curobj);
    if (ob && IS_LEARNER(ob) && query_once_interactive(ob))
    {
      ob->quit();
      if (ob)
	ob->remove();
      if (ob)
	destruct(ob);
    }
  }
}

int valid_exec(string name) {return 1;}

int save_ed_setup(object who, int code) {
  string file;

  if (!intp(code))
    return 0;
  file = "/players/" + geteuid(who) + "/.edrc";
  rm(file);
  return write_file(file, code + "");
}

int retrieve_ed_setup(object who) {
  string file;
  int code;

  file = "/players/" + getuid(who) + "/.edrc";
  if (file_size(file) <= 0)
    return 0;
  sscanf(read_file(file), "%d", code);
  return code;
}

void destruct_environment_of(object ob) {
  if (!query_once_interactive(ob) && file_name(ob)[0..10]!="/std/shells")
    return;
  tell_object(ob, "Ploetzlich loest sich deine Welt in ihre Bestandteile auf. Zum Glueck wirst\ndu irgendwo hin geschleudert ...\n");
  if(catch(ob->move("/room/void",M_TPORT|M_NOCHECK,0,"faellt")) && ob)
    destruct(ob);
}

void move_or_destruct(object what, object to) {
  object old_env;

  old_env=environment(what);
  if(catch(what->move(to, M_NOCHECK)))
    destruct(what);
  else if (what && environment(what)==old_env)
    destruct(what);
}

mixed prepare_destruct(object ob) {
  object super;
  mixed *errors;
  int i;

  if (!ob)
    return 1;
  super = environment(ob);
  if (!super) {
    object item;

    while ( item = first_inventory(ob) ) {
      destruct_environment_of(item);
      if (item && environment(item) == ob) destruct(item);
    }
  } else
    while ( first_inventory(ob) )
      move_or_destruct(first_inventory(ob), super);
  return 0; /* success */
}

int valid_snoop(object me, object you) {
  return getuid(PO) == ROOTID;
}

int valid_query_snoop(object wiz) {
  return getuid(PO) == ROOTID;
}

/*
 is called when objects try to do illegal things,
 * or files being compiled request a privileged efun.
 *
 * return values:
 *   1: The caller/file is allowed to use the privilege.
 *   0: The caller was probably misleaded; try to fix the error.
 *  -1: A real privilege violation. Handle it as error.
 */
int privilege_violation(string what, mixed who, mixed where, mixed special)
{
  if(objectp(who) && (geteuid(who)==ROOTID || who==this_object())) return  1;

  switch(what)
  {
    case "update_htpassword":
    case "update_htaccess":
      if (load_name(who)==WWWD)
        return 1;
      break;
    case "send_imp":      // yet
    case "call_out_info": // yet
      return 1;
    case "input_to":
      if(load_name(who)[0..7]=="/secure/") return 1;
      break;
    case "nomask simul_efun":
      if(who == SIMUL_EFUN_FILE || who == SPARE_SIMUL_EFUN_FILE) return 1;
      break;
    case "set_extra_wizinfo":
    case "get_extra_wizinfo":
      switch(load_name(who)) {
        case SIMUL_EFUN_FILE:
        case SPARE_SIMUL_EFUN_FILE:
        case "/secure/memory":
          return 1;
      }
      break;
    case "rename_object":
      switch (load_name(who))
      {
        case "/secure/login":
          return 1;
      }
      break;
    case "erq":
      switch (load_name(who))
      {
        case "/global/daemon/intermud3":
        case "/obj/tools/vk":
          return 1;
      }
      break;
  }
  return -1;
}

void receive_imp(string host, string message, int port)
{
  mixed *tmp;

  if (message[0..4]=="NFTPD")
  {
#if 0
#if __HOST_NAME__==MUDHOST
    if (host!=FTPD_IP)
    {
      DEBUG("INVALID HOST\n");
      return;
    }
#endif
#endif
    FtpAccess(host,message,port);
    return;
  }
  if (message[0..9]=="udp_query:")
    return udp_query(message[10..],host,port);
  if (message[0..5]=="IPNAME")
  {
    tmp=explode(message,"|");
    if (sizeof(tmp)<3) return;
    if (!ip_map) ip_map=get_extra_wizinfo(0)[IP_NAMES];
    ip_map[tmp[1]]=tmp[2];
    ip_map[tmp[1],1]=time();
    return;
  }
  if (message[0..3]=="AUTH")
  {
    object pl;
    mixed *data;

    data=explode(message,"|");
    if (pl=funcall(symbol_function('find_player),data[1])) //'))
	{
	  while (strlen(data[2]) && data[2][<1]<=' ') data[2]=data[2][0..<2];
      pl->SetProp("auth_info",data[2]);
	}
    return;
  }
  "secure/inetd"->receive_udp(host, message);
}


void slow_shut_down(int minutes)
{
  filter_array(users(),#'tell_object,
  ROOTNPC" ruft: Der Arbeitsspeicher wird knapp! Bereitet euch auf das Ende "
  "vor!\n");
  "/obj/shut"->shut(minutes*30);
}

void external_master_reload()
{
  int i;
  mixed *CALL_OUTS;

//  "/secure/simul_efun"->StopCallOut(1);
}

int heart_beat_error( object heart_beat, string error, string program,
		     string current_object, int line)
{
  if (!heart_beat)
    return 0;
  if ( interactive(heart_beat) ) {
    tell_object( heart_beat,
		"Der GameDriver teilt Dir mit: Dein Herzschlag hat ausgesetzt!\n");
    if (IS_LEARNER(heart_beat))
      tell_object(heart_beat, "Fehler: "+error+"Progamm: "+program+", CurrObj: "+current_object+", Zeile: "+line+"\n");
  }
  if (query_once_interactive(heart_beat))
    call_out("restart_heart_beat", 5, heart_beat);
  return 0; /* Don't restart */
}

void disconnect(object who)
{
  who->NetDead();
}

object compile_object(string st)
{
  int l;
  object ret;
  string *str;
  string compiler;

  if (!st || st=="")
    return 0;
  str=explode(st,"/")-({""});
  l=sizeof(str);
  if (l<2) return 0;
  compiler=implode(str[0..l-2],"/")+"/virtual_compiler";
  if (file_size(compiler+".c")>0)
  {
    if (catch(ret=(object)call_other(compiler,"compile_object",str[l-1])))
      return 0;
  }
  return ret;
}

void dangling_lfun_closure() {
  raise_error("dangling lfun closure\n");
}

void remove_player(object victim) {
  catch(victim->quit());
  if (victim)
    destruct(victim);
}

mixed give_uid_to_object(mixed what,object po, int clone)
{
  string creator,pouid;

  if ((!objectp(what) && !stringp(what)) || !objectp(po))
    return 1; // invalid parameters
  if (!(creator=creator_file(what)))
    return 1; // No creator, disallow
  if (creator==ROOTID && po==TO)
    return ROOTID; // Special hack for first load of simul_efun - ARGHH
  if (!(pouid=geteuid(po)))
    return 1; // Disallow if no euid in po
//  if (pouid==NOBODY)
//    log_file("NOBODY_CLONES",sprintf("%O (euid %O) cloned %O\n",po,pouid,what));
  if (creator==pouid || creator==BACKBONEID)
    return pouid;
  return ({creator,NOBODY});
}

void inaugurate_master(int arg) {
  userinfo::create();
  set_auto_include_string("#pragma combine_strings\n#pragma verbose_errors\n#pragma strong_types\n");
  ReloadBanishFile();
  if (!arg)
    set_extra_wizinfo(0, allocate(BACKBONE_WIZINFO_SIZE));
  if (find_call_out("wiz_decay") < 0)
    call_out("wiz_decay", 3600);
    set_driver_hook(
		    H_MOVE_OBJECT0,
		    unbound_lambda( ({'item, 'dest}), ({#',,
		      ({#'?, ({#'!=, 'item, ({#'this_object})}),
			({#'raise_error,
			  "Illegal to move other object than this_object()\n"}) }),
		      ({#'efun::efun308, 'item, 'dest}),
		      ({#'?, ({#'living, 'item}), ({#',,
			({#'efun::set_this_player, 'item}),
			({#'call_other, 'dest, "init"}),
			({#'?, ({#'!=, ({#'environment, 'item}), 'dest}), ({#'return})}),
		      }) }),
		      ({#'=, 'others, ({#'all_inventory, 'dest}) }),
		      ({#'=, ({#'[, 'others, ({#'member, 'others, 'item}) }), 0}),
		       ({#'filter_array, 'others,
			 ({#'bind_lambda,
			   unbound_lambda( ({'ob, 'item}),
					  ({#'?, ({#'living, 'ob}), ({#',,
					    ({#'efun::set_this_player, 'ob}),
					    ({#'call_other, 'item, "init"}),
					  }) })
					  )
			   }),
			 'item,
		       }),
		       ({#'?, ({#'living, 'item}), ({#',,
			 ({#'efun::set_this_player, 'item}),
			 ({#'filter_objects, 'others, "init"}),
		       }) }),
		       ({#'?, ({#'living, 'dest}), ({#',,
			 ({#'efun::set_this_player, 'dest}),
			 ({#'call_other, 'item, "init"}),
		       }) }),
		     }) )
				   );
        set_driver_hook(
             H_LOAD_UIDS,
             unbound_lambda( ({'printf_obj_name}), ({
	       #'give_uid_to_object,'printf_obj_name,({#'previous_object}),0
             }) )
            );
       set_driver_hook(
            H_CLONE_UIDS,
            unbound_lambda( ({'blueprint, 'new_name}), ({
	      #'give_uid_to_object,'new_name,({#'previous_object}),1
           }) )
        );
#if 1
      set_driver_hook(H_CREATE_OB,          "create");
#else
      set_driver_hook(H_CREATE_OB,
      unbound_lambda(({'ob}), ({#',,
          ({#'&&,
            ({#'>, ({#'sizeof, ({#'=, 'list, ({#'inherit_list, 'ob})})}), 1}),
            ({#'find_object, ({#'=, 'first, ({#'[, 'list, 1})})}),
            ({#'==,
              ({#'sizeof, 'list}),
              ({#'+, 1,
                ({#'sizeof, ({#'inherit_list, ({#'find_object, 'first})})})})}),
            ({#'==, 1, ({#'sizeof, ({#'=, 'list,
                ({#'functionlist, 'ob,
                  RETURN_FUNCTION_NAME|NAME_INHERITED})})})}),
            ({#'==, ({#'[, 'list, 0}), "create"}),
#if 1
            ({#',, ({#'printf, "replacing %O\n", 'ob}), 1}),
#endif
            ({#'funcall,
              ({#'funcall, #'bind_lambda, #'replace_program, 'ob}),
              'first})
          }),
          ({#'call_other, 'ob, "create"})
        })
      ));
#endif
      set_driver_hook(H_INCLUDE_DIRS, map_array(
				define_include_dirs(),
				#'[..<],
				0, 3
			));
      set_driver_hook(H_CREATE_CLONE,       "create");
      set_driver_hook(H_RESET,              "reset");
      set_driver_hook(H_CLEAN_UP,           "clean_up");
      set_driver_hook(H_MODIFY_COMMAND,     "modify_command");
      set_driver_hook(H_NOTIFY_FAIL,        #'notify_text);
      set_driver_hook(H_TELNET_NEG,"telnet_neg");
      set_driver_hook(H_MODIFY_COMMAND_FNAME, "modify_command");
#ifdef __EMACS__NERV__
		    ]
#endif
		      call_out("_cleanup_uinfo",3600);
			call_out("start_simul_efun",0);
}

// WIZLIST
static void wiz_decay() {
  mixed *wl;
  int i;

  wl = wizlist_info();
  for (i=sizeof(wl); i--; ) {
    set_extra_wizinfo(wl[i][WL_NAME], wl[i][WL_EXTRA] * 99 / 100);
  }
  call_out("wiz_decay", 3600);
}

void save_wiz_file() {
  rm("/WIZLIST");
  write_file(
	     "/WIZLIST",
	     implode(
		     map_array(wizlist_info(),
			       lambda(({'a}),
				      ({#'sprintf, "%s %d %d\n",
					({#'[, 'a, WL_NAME}),
					 ({#'[/*]*/, 'a, WL_COMMANDS}),
					  ({#'[/*]*/, 'a, WL_EXTRA})
#ifdef __EMACS__NERV__
					   ]]]
#endif
					   })
				      )
			       ), ""
		     )
	     );
}

void notify_shutdown() {
  if (PO && PO != TO)
    return;
  filter_array(users(), #'tell_object,
       ROOTNPC" ruft: Das "MUDNAME" wird jetzt neu gestartet!\n");
  save_wiz_file();
}

int remove()
{
  write("The master object doesn't want to be removed!\n");
  return 0;
}

void telnet_neg(mixed cmd,mixed opt,mixed args)
{
  if (opt==34 && cmd==251)
        binary_message(({255,250,34,1,1,255,240}));
}

void notify_text(string cmd, object player)
{
  string text;

  if (!objectp(player) || !query_once_interactive(player)) return;

  text = player->QueryProp(P_NOTIFY_MSG);
  if (!stringp(text) || !strlen(text)) text = "Wie bitte?";
  tell_object(player, "/secure/simul_efun"->break_string(text));
}
