/*******************
** Eldarea MUDLib **
********************
**
** secure/master/misc.c - miscellaneous master functions
**
** CVS DATA
** $Date: 2001/06/18 16:14:48 $
** $Revision: 1.7 $
**
** CVS History
**
** $Log: misc.c,v $
** Revision 1.7  2001/06/18 16:14:48  elatar
** renewing player objects now updates players patchlevel
**
** Revision 1.6  2001/02/01 08:23:32  elatar
** advance_wizlevel updated
** create_home updated
**
** Revision 1.5  2001/01/10 08:23:52  elatar
** group ids in show_dir() removed
**
** Revision 1.4  2000/12/19 22:14:18  elatar
** fixed crasher :/ (do not call sfun directly from master)
**
** Revision 1.3  2000/12/19 18:32:23  elatar
** security fixes with secure_level()
**
** Revision 1.2  2000/11/30 16:16:08  elatar
** armours changed from array to mapping
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#include "/secure/master.h"
#include "/secure/wizlevels.h"
#include "/sys/userupdate.h"

static mapping projects=([]);
static mixed *banished;
static mapping tbanished;

static string *explode_files(string file) {
  string data;
  mixed *exploded;
  int i;

  data=read_file(file);
  if (!data || !stringp(data) || data == "") return ({});
  exploded = efun::explode(data,"\n");
  for (i=sizeof(exploded);i--;)
    if (!stringp(exploded[i]) || exploded[i]=="" || exploded[i][0]=='#')
      exploded[i]=0;
  exploded-=({0});
  printf("%-30s: %3d Objekt%s\n",file,i=sizeof(exploded),(i==1?"":"e"));
  return exploded;
}

string *full_path_array(string path, string user) {
  string *strs;
  int p;

  if(!path)
    path="/";
  switch(path[0]) {
    case '/':
    if(!path[1]) return ({""});
    strs=PATH_ARRAY(path);
    break;
    case '+':
    if(!path[1]) return ({"d"});
    strs=({"d"})+PATH_ARRAY(path[1..<1]);
    break;
    case '~':
    if(user && !path[1])
      return ({"players",user});
    if(user && path[1]=='/')
      strs=({"players",user})+PATH_ARRAY(path[2..<1]);
    else
      strs=({"players"})+PATH_ARRAY(path[1..<1]);
    break;
    default:
    if(user && TP && getuid(TP) == user && TP->QueryProp(P_CURRENTDIR))
      strs=PATH_ARRAY(TP->QueryProp(P_CURRENTDIR)+"/"+path);
    else
      strs=PATH_ARRAY(path);
  }
  while((p=member_array("..", strs)) != -1)
    strs = strs[0..p-2]+strs[p+1..];
  return strs;
}

string _get_path(string path, string user) {
  return "/"+implode(full_path_array(path, user),"/");
}

static void _cleanup_projects()
{
  int i;
  mixed *users;

  for (users=m_indices(projects),i=sizeof(users)-1;i>=0;i--)
    if((time()-projects[users[i]][1])>1800)
      projects=m_delete(projects,users[i]);
}

static int project_access(string user, string project)
{
  mixed *lines;
  string s;
  mapping tmp;

  if (!member(projects,project))
  {
    s=read_file(PROJECTDIR+"/"+project+"/ACCESS_RIGHTS");
    if(!s||s=="")
      return 0;
    tmp=([]);
    for (lines=explode(s,"\n")-({""});sizeof(lines);lines=lines[1..])
    {
      if (lines[0][0]=='*')
	tmp[lines[0][1..]]=2;
      else
	tmp[lines[0]]=1;
    }
    projects[project]=({tmp,time()});
    return tmp[user];
  }
  projects[project][1]=time();
  return projects[project][0][user];
}

void OudateProjectCache(string project)
{
  projects=m_delete(projects,project);
}

void UpdateTBanish();

mixed QueryBanished(string str){
  int i;

  if (!str) return 0;
  if (!pointerp(banished)) return 0;
  for (i=sizeof(banished)-1;i>=0;i--)
    if (sizeof(regexp(({str}),"^"+banished[i][0]+"$")))
    {
      if (!banished[i][1] || banished[i][1]=="")
	return "Dieser Name ist gesperrt.";
      else
	return banished[i][1];
    }
  return 0;
}

varargs mixed QueryTBanished(string str, int raw) {
  int i;

  if (!str || !mappingp(tbanished) || !(i=tbanished[str]))
    return 0;

  if (i == -1 || i > time()) {
    if (raw) return i;
    return sprintf("Es gibt schon einen Spieler diesen Namens.\n"
	+"Allerdings kann er/sie erst am %s wieder ins Mud kommen.\n",
	  (i == -1 ? "St. Nimmerleinstag" :
	   funcall(symbol_function('dtime),i)[0..16]));
  }

  // Ansonsten: die Zeit ist abgelaufen, Spieler darf wieder...
  efun::m_delete(tbanished, str);
  UpdateTBanish();
  return 0;
}

void ReloadBanishFile(){
  int i,t;
  string s1,s2,*s;

  banished=efun::explode(read_file("/secure/BANISH"),"\n");
  banished=banished-({""});
  for (i=sizeof(banished)-1;i>=0;i--)
  {
    s=efun::explode(banished[i]," ");
    s1=s[0];
    s2=implode(s[1..]," ");
    banished[i]=({s1,s2});
  }
  if (!mappingp(tbanished)) {
    tbanished = ([]);

    if (file_size("/secure/TBANISH")>0) {
      s = efun::explode(read_file("/secure/TBANISH"),"\n");
      s-= ({""});
    }
    else
      s = ({});

    for (i=sizeof(s)-1; i>=0; i--) {
      sscanf(s[i],"%s:%d",s1,t);
      tbanished += ([ s1 : t ]);
    }
  }
}

void BanishName(string name, string reason)
{
  string *names;
  int i;

  if ( (i=extern_call()) 
    && LORD_LVL > (funcall(symbol_function('secure_level))) ) 
    return 0;
  if (QueryBanished(name)){
    if (i) write("Der Name ist schon gebannt.\n");
    return;
  }
  if (i && file_size(SAVEPATH+name[0..0]+"/"+name+".o")>0){
    write("Es existiert bereits ein Spieler dieses Namens.\n");
    return;
  }
/*  if (!("/secure/login"->valid_name(name))) return;*/
  if (!reason) reason="";
  names=({name+" "+reason});
  for (i=sizeof(banished)-1;i>=0;i--)
    names+=({banished[i][0]+" "+banished[i][1]});
  names=sort_array(names,#'>);
  rm("/secure/BANISH");
  write_file("/secure/BANISH",implode(names,"\n"));
  ReloadBanishFile();
}

void UpdateTBanish()
{
  int i;
  string *names;

  for (i=sizeof(names = sort_array(m_indices(tbanished), #'<))-1;i>=0;i--)
    names[i] = sprintf("%s:%d", names[i], tbanished[names[i]]);

  rm("/secure/TBANISH");
  write_file("/secure/TBANISH", implode(names, "\n"));
}

void TBanishName(string name, int days)
{
  int t;

  if ( ARCH_LVL > (funcall(symbol_function('secure_level))) 
    && (getuid(TI) != name) )
    return;
  if (QueryBanished(name)){
    write("Der Name ist schon gebannt.\n");
    return;
  }
  if (file_size(SAVEPATH+name[0..0]+"/"+name+".o")<=0){
    write("Es existiert kein Spieler dieses Namens!\n");
    return;
  }

  if (!days && member(tbanished, name))
    efun::m_delete(tbanished, name);
  else {
    if (!mappingp(tbanished))
      tbanished = ([]);
    if (days <= -1)
      t = -1;
    else
      t = (time()/86400)*86400 + days*86400;
    tbanished += ([ name : t ]);
  }
  UpdateTBanish();
}

static int create_home(string owner, int level)
{
  string def_castle;
  string castle, wizard;
  
  wizard = "/players/" + owner;
  castle = "/players/" + owner + "/workroom.c";
  if (file_size(wizard) == -1) 
    mkdir(wizard);
    
  def_castle = read_file("/std/def_workroom.c");
  if (file_size(castle) > 0) 
    return 1;
  else 
  {
    if (write_file(castle, def_castle))
      return 1;
    else
      return 0;
  }
}

int allowed_advance_wizlevel(mixed ob)
{
  string what;

  if (objectp(ob) && geteuid(ob)==ROOTID) return 1;

  if (!stringp(ob))
    what=explode(file_name(ob),"#")[0];
  else
    what=ob;

  if (what==SERVICE) 
    return 1;

  return 0;
}

varargs int advance_wizlevel(string name, int level, int check)
{
  int answer;
  mixed *user;

  if (!allowed_advance_wizlevel(PO))
    return -1;

  if (level>ARCH_LVL) return -2;

  if (!find_userinfo(name)) return -3;

  user=get_full_userinfo(name);

  if (user[USER_LEVEL+1]>level) return -4;

  if (user[USER_LEVEL+1]==level) return 1;

  if (!check)
  {
    create_home(name, level);
    update_wiz_level(name, level);
  }

  return 1;
}

void redo_preload()
{
  mixed *to_preload;
  int i;

  to_preload=epilog(0);
  for (i=0;i<sizeof(to_preload);i++)
    catch(preload(to_preload[i]));
  to_preload=0;
}

void restart_heart_beat(object heart_beat)
{
  if (heart_beat) heart_beat->_restart_beat();
}

int renew_player_object(mixed who)
{
  object newob;
  object *obs;
  mixed err;
  string ob_name;
  object *weapons;
  mapping armours;
  object tp;
  int i,active;

  if (stringp(who))
  {
    who=funcall(symbol_function('find_player),who);//'))
    if (!who)
    {
      who=funcall(symbol_function('find_netdead),who);//'))
      if (!who)
	return -1;
    }
  }
  if (!objectp(who))
    return -2;
  if (!query_once_interactive(who))
    return -3;
  active=interactive(who);
  printf("OK, renewing %O\n",who);
  seteuid(geteuid(who));
  err=catch(newob=clone_object(query_player_object(getuid(who))));
  seteuid(getuid(TO));
  if (err)
  {
    printf("%O\n",err);
    return -4;
  }
  if (!newob)
    return -5;
  /* Ok, the object is here now ... lets go for it ... */
  USERUPDATE->UpdateUser(newob);
  who->save_me(0);
  disable_commands();
  armours=who->QueryProp(P_ARMOURS);
  weapons=who->QueryProp(P_WEAPONS);
  DEBUG_MSG(sprintf("RENEWING: %O %O\n",newob,who));
  ob_name=explode(file_name(newob),"#")[0];
  if (strlen(ob_name)>11 && ob_name[0..11]=="/std/shells/")
    ob_name=ob_name[11..];
  ob_name=ob_name+":"+getuid((object)who);
  if (active)
    exec(newob,who);
  if (active && (interactive(who)||!interactive(newob)))
  {
    DEBUG_MSG("ERROR: still active!\n");
    newob->remove();
    return 0;
  }
  funcall(bind_lambda(unbound_lambda(0,
    ({ #'call_other, newob, "start_player", capitalize(getuid(who)), 1 })),
    who));
  newob->move(environment(who),M_TPORT|M_NOCHECK|M_NO_SHOW|M_SILENT
	      |M_NO_ATTACK);
  obs=all_inventory(who);
  for (err=0;err<sizeof(obs);err++)
    if (!obs[err]->QueryProp(P_AUTOLOADOBJ))
      catch(obs[err]->move(newob,M_NOCHECK));
    else if (obs[err]->remove(), obs[err])
      destruct(obs[err]);
  who->remove();
  rename_object(newob,ob_name);
  tp=this_player();
  efun::set_this_player(newob);

  if (pointerp(weapons)) map_objects(weapons, "wield_me");
  if (pointerp(armours)) map_objects(armours, "do_wear", "alles");

  efun::set_this_player(tp);
}

mixed __query_variable(object ob, string var)
{
  if ( ELDER_LVL > (funcall(symbol_function('secure_level))))
  {
    write("ILLEGAL\n");
    return;
  }
  return
    funcall(bind_lambda(
			unbound_lambda(
				       ({}),
				       ({#'funcall,({#'symbol_variable,var})})),
			ob));
}

void RestartBeats()
{
  int i,size,counter;
  object ob;
  mixed *list;
  string file,obname,fun;

  "/secure/simul_efun"->StopCallOut(0);
  write("CALL_OUT-Restart in progress !\n");
  filter_array(users(),#'tell_object,"CALL_OUT-Restart in progress !\n");
  size=file_size("log/call_out_stop");
  if (size<=0)
    return;
  file="";
  counter=0;
  while (counter<size)
  {
    file+=read_bytes("log/call_out_stop",counter,
		     (size-(counter+=40000)>0?counter:size));
  }
  list=explode(file,"__(CUT HERE)__\n");
  list=list[<1..];
  list=explode(list[0],"\n")-({""});
  for (i=sizeof(list)-1;i>=0;i--)
    if (sscanf(list[i],"%s \"%s\"",obname,fun)==2 && ob=find_object(obname))
    {
      write(sprintf("%O -> %s\n",ob,fun));
      catch(ob->__restart(fun));
    }
  write("CALL_OUT-Restart completed !\n");
  filter_array(users(),#'tell_object,"CALL_OUT-Restart completed !\n");
  rename("log/call_out_stop","log/call_out_stop.old");
}

string show_dir(string wo,string user)
{
  string ret;
  mixed *dir;
  int isdir,r,w,x;
  string tmp;
  object pl;
  int tim;
  string date;

  if (!user) 
    user=geteuid(TI);
  if (!wo && pl=funcall(symbol_function('find_player),user))
    wo=pl->QueryProp(P_CURRENTDIR);
  tim=time();
  isdir=(file_size(wo)==-2);
  ret="";
  for (dir=get_dir(isdir?wo+"/*":wo,7);sizeof(dir)>2;dir=dir[3..])
  {
    if (member_array(dir[0],({".","..",".ftp"}))==-1)
    {
      if (dir[0][<2..<1]!=".c")
	      x='-';
      else
	      x=(find_object(wo+"/"+(string)dir[0]))?'x':'-';
      w=(valid_write(wo+"/"+dir[0],user,"write_file",0))?'w':'-';
      r=(valid_read(wo+"/"+dir[0],user,"read_file",0))?'r':'-';
      date=funcall(symbol_function('dtime),dir[2]);
      if ((tim-dir[2])<31536000)
	      date=date[5..11]+", "+date[19..<4];
      else
	      date=date[5..16]+"  ";
      isdir=(dir[1]==-2);
      tmp=creator_file(wo+"/"+dir[0]);
      if (tmp==ROOTID)
      {
	      tmp="root";
	    }
      else
      {
	      if (tmp==BACKBONEID)
	        tmp="daemon";
	      else
	        if (!tmp)
	          tmp="none";
	    }
      ret+=sprintf("%c%c%c%c %-19s %8s %s %s%s\n"
                  ,isdir?'d':'-',r,w,x,tmp,
		               isdir?"-":sprintf("%d",dir[1]), date,dir[0],isdir?"/":"");
    }
  }
  if (ret=="")
    ret="No files found.\n";
  return ret;
}
