/*******************
** Eldarea MUDLib **
********************
**
** secure/master/network.c  - UDP-Handling
**
** CVS DATA
** $Date: 2001/08/20 14:19:19 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: network.c,v $
** Revision 1.3  2001/08/20 14:19:19  eldarea
** changed log path for loginfail
** made variable ip_map static due to inheritance redefinition
**
** Revision 1.2  2000/01/10 16:00:33  elatar
** FTPAccess adapted to proftpd
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#include "/secure/master.h"
#include "/sys/erq.h"

static private mapping ip_map; // Wird via extra_wizinfo mit simul_efun verbunden

// uncomment and ___updmaster() if you ever want a new erq startet
void new_erq() {attach_erq_demon("",0);}

string *mk_rec_list(string str)
{
  DEBUG("\n"+str+"\n");
  return explode(lower_case(implode(explode(str," "),"")),",");
}

static int CheckPasswd(string name, string passwd)
{
  mixed *uinf;

  uinf=get_full_userinfo(name);
  if (sizeof(uinf)<2) return 0;
  return (crypt(passwd,uinf[USER_PASSWORD+1])==uinf[USER_PASSWORD+1]);
}

static void FtpAccess( string host, string message, int port )
{
    string *comp, reply, head;

#if __EFUN_DEFINED__(send_imp)
    comp = efun::explode( message, "\t" );
#define FTP_ID   0
#define FTP_SEQ  1
#define FTP_TAG  2
#define FTP_CMD  3
#define FTP_ARG1 4
#define FTP_ARG2 5
#define FTP_ARG3 6

    // unknown requests are logged
    if ( sizeof(comp) <= FTP_CMD || lower_case(comp[FTP_TAG]) != "req" ){
        log_file( "IMP_MSGS", "Host: " + host + ":" + port + " - '" +
                  message + "'\n" );
        return;
    }

    // prepare the answer; default is 'not allowed'
    reply = "INVALID";
    head = sprintf( "%s\t%s\tRPLY\t%s\t",
                    comp[FTP_ID], comp[FTP_SEQ], comp[FTP_CMD] );


    // now let's see what is requested:
    switch ( lower_case(comp[FTP_CMD]) ){
    // a user wants to log in; test if it is a valid account
    case "user":
        if ( sizeof(comp) <= FTP_ARG1 )
            break;

        // only wizards have ftp-accounts
        // anonymous accounts are handled by ProFtpd
        if ( IS_LEARNER(lower_case(comp[FTP_ARG1])) )
            reply = "/players/" + lower_case(comp[FTP_ARG1]);
        else
            reply = "NONE";
        break;

    // authenticate user; does password match username?
    case "pass":
        if ( sizeof(comp) <= FTP_ARG2 )
            break;

        comp[FTP_ARG1] = lower_case(comp[FTP_ARG1]); 

        // only wizards have ftp-accounts
        // anonymous accounts are handled by ProFtpd
        if ( IS_LEARNER(comp[FTP_ARG1]) ){
            if ( CheckPasswd( comp[FTP_ARG1], comp[FTP_ARG2] ) )
                reply = "OK";
            else
                // failed logins are logged
                log_file( "system/loginfail",
                          sprintf( "BAD PASSWORD:      (FTP)     %s %s\n",
                                   comp[FTP_ARG1],
                                   ctime(time()) ) );
        }
        else
            reply = "FAIL";
        break;

    // user wants to read files; is he allowed to?
    case "read":
        if ( sizeof(comp) <= FTP_ARG2 )
            break;

        if ( comp[FTP_ARG2][0] == '/' &&
             // check if read-access is valid
             // access-rights for anonymous accounts are handled by ProtFpd
             valid_read( comp[FTP_ARG2], lower_case(comp[FTP_ARG1]),
                         "read_file", 0 ) )
            reply = "OK";
        else
            reply = "FAIL";
        break;

    // is user allowed to write the given file?
    case "writ":
        if ( sizeof(comp) <= FTP_ARG2 )
            break;

        if ( comp[FTP_ARG2][0] == '/' &&
             // the same as above
             valid_write( comp[FTP_ARG2], lower_case(comp[FTP_ARG1]),
                          "write_file", 0 ) )
            reply = "OK";
        else
            reply = "FAIL";
        break;
    // is user allowed to list contents of directory?
    // NOTE: you need permissions to list the contents of a directory
    // to 'cd' into it with ProFtpd
    case "list":
        if ( sizeof(comp) <= FTP_ARG2 )
            break;

        if ( comp[FTP_ARG2][0] == '/' &&
             // In contrast to NaseFtp, the mud-module for ProFtpd
             // only expects "OK" or "FAIL" as an answer to the list-command.
             // The directory listing is built by ProFtpd itself.
             // Thus it is possible that a user can see a file but isn't
             // allowed to read it`s contents.
             // This solution isn't as flexible as the way NaseFtp handles
             // directory listings, but it is _way_ faster.
             valid_read( comp[FTP_ARG2], lower_case(comp[FTP_ARG1]),
                         "read_file", 0 ) )
            reply = "OK";
        else
            reply = "FAIL";
        break;

    default:
        // unknown requests are logged
        log_file( "IMP_MSGS", "Host: " + host + ":" + port + " - '" +
                  message + "'\n" );
        break;
    }

    // send the answer
    send_imp( host, port, head+reply );
#endif
}                                                                            

void doReadMail(string file)
{
  mixed *lines, *message;
  string rest,what,*line;
  int i;
  int to_read,pos,now;
  
  DEBUG("READING "+file+"\n");
  to_read=file_size(file);
  if (to_read>250000||to_read<5)
  {
    (void)rm(file);
    return;
  }
  rest="";
  pos=0;
  while (to_read>0)
  {
    now=to_read;
    if (now>20000) now=20000;
    rest+=read_bytes(file,pos,pos+now-1);
    pos+=now;
    to_read-=now;
  }
  DEBUG("GOT "+rest+"\n");
  lines=explode(rest,"\n");
  if (!sizeof(lines))
    return;
  i=0;
  while (i<sizeof(lines) && lines[i]!="")
  {
    i++;
  }
  if (i==sizeof(lines))
    return;
  rest=implode(lines[i..],"\n");
  message=allocate(9);
  for (;i>=0;i--)
  {
    line=explode(lines[i],":");
    if (sizeof(line)>1)
    {
      what=lower_case(line[0]);
      line[0]=implode(line[1..],":");
      switch (what)
      {
	case "subject": 
	message[MSG_SUBJECT]=line[0];
	break;
	case "from":
	message[MSG_FROM]=line[0];
	message[MSG_SENDER]=line[0];
	break;
	case "cc":
	message[MSG_CC]=mk_rec_list(line[0]);
	break;
	case "bcc":
	message[MSG_BCC]=mk_rec_list(line[0]);
	break;
	case "to":
	message[MSG_RECIPIENT]=mk_rec_list(line[0])[0];
	break;
      }
    }
  }
  message[MSG_BODY]=rest;
  if (!message[MSG_FROM]||!message[MSG_RECIPIENT])
    return;
  "/secure/mailer"->DeliverMail(message);
  rm(file);
}

void mailread()
{
  string *files;
  
  files=get_dir("/mail/InBound/*")-({"..","."});
  while (sizeof(files))
  {
    doReadMail("/mail/InBound/"+files[0]);
    files=files[1..];
  }
}

void udp_query(string query,string host,int port)
{
  string *mess,tmp,*tmp2;
  mixed *data;
  int i;
  
  mess=explode(query," ");
  switch ("" /*Fi, mess[1]*/)
  {
    case "wholist":
    case "who":
    data="/global/service/werliste"->QueryWhoListe();
    break;
    case "uptime":
	  data=({funcall(symbol_function("uptime"))});
	  break;
    case "finger":
    if (sizeof(mess)<3)
      data=({"Error: Wen soll ich fingern ?"});
    else
      data=explode("/global/service/finger"->finger(lower_case(mess[2])),"\n");
    break;
    case "mailread":
    data=({"Okay"});
    mailread();
    break;
    default:
    data=({"Error: unknown request "+mess[1]+"\n"});
  }
  send_imp(host,port,sprintf("%s 0 %d",mess[0],sizeof(data)));
  for (i=0;i<sizeof(data);i++)
    send_imp(host,port,sprintf("%s %d %s",mess[0],i+1,data[i]));
}

// Funktion wird als Antwort auf ERQ_RLOOKUP aufgerufen vom driver
// data bestehen die ersten 4 Chars die ip_num, dann der Namenstring
void _got_ip_name(int* data, int len) {
  int* x;
  string ip_num, ip_nam;
  if (previous_object()) return; // nur vom driver aufrufbar
  x=allocate(4); // Daten muessen kopiert werden, sonst kann man nicht addieren
  if (!pointerp(data) || len<5) return;
  if ((x[0]=data[0])<0) x[0]+=256;
  if ((x[1]=data[1])<0) x[1]+=256;
  if ((x[2]=data[2])<0) x[2]+=256;
  if ((x[3]=data[3])<0) x[3]+=256;
  ip_num=sprintf("%d.%d.%d.%d", x[0], x[1], x[2], x[3]);
  ip_nam=to_string(data[4..]);
  if (!ip_map) ip_map=get_extra_wizinfo(0)[IP_NAMES];
  ip_map[ip_num, 0]=ip_nam;
  ip_map[ip_num, 1]=time();
}

// Hier wird das Namens-Lookup angestossen
void get_ip_name(string ip_num) {
  int* num;
  num=allocate(4);
  if (!stringp(ip_num)) return;
  if (sscanf(ip_num, "%d.%d.%d.%d", num[0], num[1], num[2], num[3])!=4) return;
  send_erq(ERQ_RLOOKUP, num, #'_got_ip_name);
}

#if __EFUN_DEFINED__(query_ip_port)
void get_auth_user(object pl)
{
  string s;
  
//  send_imp(UDPSERV,4123,sprintf("AUTH|%s|%s|%d|%d",getuid(pl),query_ip_number(pl),query_ip_port(pl),query_mud_port(pl)));
  s=sprintf("AUTH|%s|%s|%d|%d",getuid(pl),query_ip_number(pl),query_ip_port(pl),query_mud_port(pl));
  send_imp(UDPSERV,4246/*4123*/,s);
}
#endif
