/*******************
** Eldarea MUDLib **
********************
**
** secure/master/userinfo.c - player data saving
**
** CVS DATA
** $Date: 2001/05/03 21:01:10 $
** $Revision: 1.11 $
**
** CVS History
**
** $Log: userinfo.c,v $
** Revision 1.11  2001/05/03 21:01:10  elatar
** log file locations changed
**
** Revision 1.10  2001/02/24 13:12:24  elatar
** fixed dumb bug in query_wiz_level()
**
** Revision 1.9  2001/02/23 17:11:21  elatar
** adapted query_wiz_level() to new uids
**
** Revision 1.8  2001/02/09 12:37:33  elatar
** bug in find_userinfo() removed
**
** Revision 1.7  2001/02/01 08:24:09  elatar
** additional info and sponsorships implemented
**
** Revision 1.6  2000/12/19 22:14:27  elatar
** fixed crasher :/ (do not call sfun directly from master)
**
** Revision 1.5  2000/12/19 18:27:13  elatar
** security fix in arch_delete_player() (with secure_level())
**
** Revision 1.4  2000/12/11 13:06:39  elatar
** changes due to namehandler move to namedb
**
** Revision 1.3  2000/11/30 16:15:30  elatar
** webseite access file handling implemented
**
** Revision 1.2  2000/01/06 13:29:56  elatar
** no passwd bug in delete_player() fixed
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strong_types

#include "/secure/master.h"
#include "/global/daemon/wwwd.h"
#include "/sys/daemon/namedb.h"
#include "/secure/wizlevels.h"
#include "/sys/userupdate.h"

static mapping userlist;
string name, password, sponsor;
int level, *loginfaildate;
string *domains, *apprentices, *loginfailfrom, shell;
int creation_date, wiz_date, touch, loginfails;


int clear_cache() // Vergiss ALLE infos im Cache
{
  userlist=allocate_mapping(0,10);
  return 1;
}

void create()
{
  clear_cache();
}

string secure_isavefile(string name)
{
  if (file_size("secure/save_inactive/"+name[0..0]+"/"+name+".o")>=0)
    return "secure/save_inactive/"+name[0..0]+"/"+name;
  return "";
}

string secure_savefile(string name)
{
  if (file_size(SECURESAVEPATH+name[0..0]+"/"+name+".o")>=0)
    return SECURESAVEPATH+name[0..0]+"/"+name;
  return secure_isavefile(name);
}

mixed *show_cache()
{
  return m_indices(userlist);
}

int find_userinfo(string user) 
{
  string file;
  
  if (member(user,' ')!=-1||member(user,':')!=-1)
    return 0;
  if (!member(userlist,user)) 
  {
    if ((file=secure_savefile(user))=="")
    {
      userlist+=([user: "NP"; -1; ({}); "LOCKED"; -1; time(); 0; -1; ({})
                 ;ACTUAL_SECURE_PATCH; 0; ({}); ({}) ]);
      return 0;
    }  
    password="";
    sponsor = 0;
    wiz_date = -1;
    apprentices = ({});
    loginfails = 0;
    loginfailfrom = ({});
    loginfaildate = ({});
    
    if (!restore_object(file)) 
      return 0;
    userlist+=([user: password; level; domains; shell; time(); creation_date;
                sponsor; wiz_date; apprentices; touch; loginfails;
                loginfailfrom; loginfaildate]);
  }
  else
    userlist[user,USER_TOUCH]=time();
  if (userlist[user,USER_LEVEL]==-1) 
    return 0;
  return 1;
}

void RemoveFromCache(string user)
{
  efun::m_delete(userlist,user);
}

mixed *get_userinfo(string user) 
{
  if (!member(userlist,user) && !find_userinfo(user))
    return 0;
  level=userlist[user,USER_LEVEL];
  if (level==-1) 
    return 0;
  domains=userlist[user,USER_DOMAIN];
  shell=userlist[user,USER_OBJECT];
  creation_date = userlist[user, USER_CREATION_DATE];
  sponsor = userlist[user, USER_SPONSOR];
  wiz_date = userlist[user, USER_WIZ_DATE];
  apprentices = userlist[user, USER_APPRENTICES];
  touch = userlist[user, USER_SAVEFILE];
  loginfails = userlist[user, USER_LOGINFAILS];
  loginfaildate = userlist[user, USER_FAIL_DATE];
  loginfailfrom = userlist[user, USER_FAIL_FROM];

  return ({user,"##"+user,level,domains,shell,creation_date,sponsor
          ,wiz_date,apprentices,touch,loginfails,loginfaildate
          ,loginfailfrom});
}

static mixed *get_full_userinfo(string user) 
{
  if (!member(userlist,user) && !find_userinfo(user))
    return 0;
  password=userlist[user,USER_PASSWORD];
  level=userlist[user,USER_LEVEL];
  domains=userlist[user,USER_DOMAIN];
  shell=userlist[user,USER_OBJECT];
  creation_date = userlist[user, USER_CREATION_DATE];
  sponsor = userlist[user, USER_SPONSOR];
  wiz_date = userlist[user, USER_WIZ_DATE];
  apprentices = userlist[user, USER_APPRENTICES];
  touch = userlist[user, USER_SAVEFILE];
  loginfails = userlist[user, USER_LOGINFAILS];
  loginfaildate = userlist[user, USER_FAIL_DATE];
  loginfailfrom = userlist[user, USER_FAIL_FROM];

  return ({user,password,level,domains,shell,creation_date,sponsor
          ,wiz_date,apprentices,touch,loginfails,loginfaildate
          ,loginfailfrom});
}

static void save_userinfo(string user) 
{
  if (!member(userlist,user)) 
    return;
  name = user;
  level = userlist[name,USER_LEVEL];
  domains = userlist[name,USER_DOMAIN];
  shell = userlist[name,USER_OBJECT];
  password = userlist[name,USER_PASSWORD];
  creation_date = userlist[user, USER_CREATION_DATE];
  sponsor = userlist[user, USER_SPONSOR];
  wiz_date = userlist[user, USER_WIZ_DATE];
  apprentices = userlist[user, USER_APPRENTICES];
  touch = userlist[user, USER_SAVEFILE];
  loginfails = userlist[user, USER_LOGINFAILS];
  loginfaildate = userlist[user, USER_FAIL_DATE];
  loginfailfrom = userlist[user, USER_FAIL_FROM];

  save_object(SECURESAVEPATH+name[0..0]+"/"+name);
}

int update_wiz_level(string user,int lev) 
{
  int seclvl;
  
  if ( !extern_call() 
    || getuid(previous_object())==ROOTID)
    seclvl=GOD_LVL;
  else
    seclvl = (funcall(symbol_function('secure_level)));
  if (seclvl<QUEST_LVL)
    return 0;
  else if (lev>3 && seclvl<LORD_LVL)
    return 0;
  else if (lev>4 && seclvl<ELDER_LVL)
    return 0;
  else if (lev>6 && seclvl<GOD_LVL)
    return 0;
  if (!find_userinfo(user)) 
    return 0;
  if (userlist[user,USER_LEVEL] > ARCH_LVL) 
    return 0;
  userlist[user,USER_LEVEL] = lev;
  save_userinfo(user);
  return 1;
}

int set_player_object(string user, string objectname)
{
  mixed *path;
  string prev;
  
  if (objectname=="") objectname=0;
  if (!stringp(user) || user=="") return -6;
  if (!stringp(objectname))
  {
    if (!find_userinfo(user)) return -4;
    userlist[user,USER_OBJECT]=0;
    save_userinfo(user);
    return 1;
  }
  if (catch(call_other(objectname,"??")))
  {
    write("Fehler in "+objectname+"!\n");
    return -2;
  }
  objectname=_get_path(objectname,0);
  path=(explode(objectname,"/")-({""}))-({0});
  if (sizeof(path)<3 || path[0]!="std" || path[1]!="shells") return -3;
  if (!find_userinfo(user)) return -4;
  userlist[user,USER_OBJECT]=objectname;
  save_userinfo(user);
  return 1;
}

string query_player_object( string name )
{
  if( !find_userinfo(name) ) return "";
  return userlist[name,USER_OBJECT];
}

int update_password(string old,string new) 
{
  string user;
  
  if (!find_userinfo(user=getuid(PO))) 
    return 0;
  password = userlist[user,USER_PASSWORD];
  if (password && password != "" && crypt(old,password) != password)
    return 0;
  userlist[user,USER_PASSWORD] = crypt(new,0);
  WWWD->update_htpassword(user,new);
  save_userinfo(user);
  return 1;
}

string get_wiz_name(string file) {return creator_file(file);}

int get_wiz_level(string user) 
{
  if (user == ROOTID)
    return GOD_LVL;
  if (user && find_userinfo(user)) 
    return userlist[user,USER_LEVEL];
}

int query_wiz_level(mixed player) 
{
  if (objectp(player) && query_once_interactive(player))
    return get_wiz_level(getuid(player));
  else
    if (stringp(player))
    {
      if( player=="d" || player[0..1]=="d:" ) return 4;
      if( player=="GUILD" || player[0..5]=="GUILD:") return 5;
      if( player=="p" || player[0..1]=="p:" ) return 4;
      if( player=="GLOBAL" || player[0..6]=="GLOBAL:") return 4;
      return get_wiz_level(player);
    }
  return 0;
}

int add_sponsorship(string sponsor, string apprentice)
{
  if (extern_call() && load_name(previous_object())!=SERVICE)
    return 0;
  if (!find_userinfo(sponsor) || !find_userinfo(apprentice))
    return -1;
  if (-1!=member(userlist[sponsor, USER_APPRENTICES],apprentice))
    return -2;
  if (userlist[apprentice, USER_SPONSOR])
    return -3;
    
  userlist[sponsor, USER_APPRENTICES]+=({apprentice});
  save_userinfo(sponsor);
  userlist[apprentice, USER_SPONSOR]=sponsor;
  userlist[apprentice, USER_WIZ_DATE]=time();
  save_userinfo(apprentice);
  
  return 1;
}

static void set_domains(string player, mixed *domains)
{
  userlist[player, USER_DOMAIN]=domains;
  save_userinfo(player);
}

void _cleanup_uinfo() {
  mixed users;
  int i;

  remove_call_out ("_cleanup_uinfo");
  call_out("_cleanup_uinfo", 3600);
  for (users=m_indices(userlist),i=sizeof(users)-1; i>=0;i--)
    if ((time()-userlist[users[i],USER_TOUCH]) > 1800
	&& !funcall(symbol_function('find_player),users[i]))
      userlist=m_delete(userlist,users[i]);
  _cleanup_projects();
}

static void _delete_player(string real_name, int lvl)
{
  string part_filename;
  
  part_filename="/"+real_name[0..0]+"/"+real_name+".o";
  (void)rm("secure/save"+part_filename);
  (void)rm("save"+part_filename);
  (void)rm("mail"+part_filename);
  userlist=m_delete(userlist,real_name);
  if (lvl>1)
    BanishName(real_name, "Das war einmal ein Avatar.");
  else
    NAMEDB->FreeName(real_name);
  
  log_file("user/delete",sprintf("%s: %s\n",ctime(time()),real_name));  
}

int delete_player(string passwd, string real_name)
{
  int lvl;
 
  if (!PO || PO!=TP || PO!=TI || real_name != getuid(PO) ||
      !find_userinfo(real_name))
    return 0;
  lvl=query_wiz_level(real_name);
  password = userlist[real_name,USER_PASSWORD];
  if (password!=0 && password!="" && crypt(passwd, password) != password) 
    return 0;
  
  _delete_player(real_name,lvl);
  log_file("user/delete.self",sprintf("%s: %s\n",ctime(time()),real_name));
  
  return 1;
}

int arch_delete_player(string real_name, string reason)
{
  int lvl;
  
  if ( ARCH_LVL > (funcall(symbol_function('secure_level))) 
    || !find_userinfo(real_name) )
  return 0;

  lvl=query_wiz_level(real_name);
  
  _delete_player(real_name,lvl);
  log_file("user/delete.arch",sprintf("%s: %s (by %s, reason: %s)\n",ctime(time()),real_name,getuid(PO),reason));
  
  return 1;  
}
