/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2001/02/01 08:20:31 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: memory.c,v $
** Revision 1.2  2001/02/01 08:20:31  elatar
** clock path adjusted
**
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// SECURE/MEMORY.C -- unloeschbarer Speicher
//
// Das Memory bietet die Moeglichkeit sensible Daten sicher auzubewahren,
// ohne dass jemand anders dranrumpfuschen oder es gar loeschen kann. Das
// MEmory behaelt ueber die extra-wizinfo alle Daten bis zum Reboot
//
// Autor: Holger@Wunderland
// 
// $Revision: 1.2 $
//
// $Log: memory.c,v $
// Revision 1.2  2001/02/01 08:20:31  elatar
// clock path adjusted
//
// Revision 1.1.1.1  1999/11/05 12:30:45  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:12  en
// MUDLib CVS Preperation
//
// Revision 1.2  1999/05/17 19:54:55  Fiona
// Erlaubnis fuer lib_sensor und uhr
//
// Revision 1.1  1999/04/29 08:42:54  Holger
// Initial revision
//

#include <config.h>

#pragma strict_types

// Wer darf das Memory benutzen?
private mixed allowed(object who) {
  string f;
  f=file_name(who);
  switch( f ) {
    case "/secure/eventd":
    case "/secure/combat":
    case "/global/service/clock":
    case "/global/service/lib_sensor":
      return f;
  }
  return 0;
}

// Memory neu erzeugen oder die Infos wiederherstellen.
void create() {
  mixed info;
  seteuid(getuid(this_object()));
  if(clonep(this_object())) {
    destruct(this_object());
    return;
  }
  if(!pointerp(info=get_extra_wizinfo(0)))
    raise_error("WIZINFO ZERSTOERT. SIMUL-EFUN NEU STARTEN!\n");
  if(!mappingp(info[MEMORY_BUFF]))
    info[MEMORY_BUFF]=([]);
}

// Daten eintragen
int put(string key, mixed var) {
  string who;
  mixed info;
  if(!stringp(who=allowed(previous_object())))
    return 0;
  if(!stringp(key))
    return 0;
  if(!pointerp(info=get_extra_wizinfo(0)))
    raise_error("WIZINFO ZERSTOERT. SIMUL-EFUN NEU STARTEN!\n");
  if(!mappingp(info[MEMORY_BUFF]))
    raise_error("I'M DEAD! PLEASE HELP!\n");
  if(!member(info[MEMORY_BUFF],who))
    info[MEMORY_BUFF][who]=([]);
  info[MEMORY_BUFF][who][key]=var;
  return 1;
}

// Daten ausgeben/referenzieren
mixed get(string key) {
  string who;
  mixed info;
  if(!stringp(who=allowed(previous_object())))
    return 0;
  if(!stringp(key))
    return 0;
  if(!pointerp(info=get_extra_wizinfo(0)))
    raise_error("WIZINFO ZERSTOERT. SIMUL-EFUN NEU STARTEN!\n");
  if(!mappingp(info[MEMORY_BUFF]))
    raise_error("I'M DEAD! PLEASE HELP!\n");
  if(!member(info[MEMORY_BUFF],who))
    return 0;
  if(!member(info[MEMORY_BUFF][who],key))
    return 0;
  return info[MEMORY_BUFF][who][key];
}

// Eintrag testen
int test(string key) {
  mixed info;
  string who;
  who=allowed(previous_object());
  if(!pointerp(info=get_extra_wizinfo(0)))
    raise_error("WIZINFO ZERSTOERT. SIMUL-EFUN NEU STARTEN!\n");
  if(!mappingp(info[MEMORY_BUFF]))
    raise_error("I'M DEAD! PLEASE HELP!\n");
  if(!member(info[MEMORY_BUFF],who))
    return 0;
  return member(info[MEMORY_BUFF][who],key);
}

// Ein Eintrag oder alle Eintraege werden geloescht
varargs int wash(string key) {
  string who;
  mixed info;
  if(!stringp(who=allowed(previous_object())))
    return 0;
  if(!pointerp(info=get_extra_wizinfo(0)))
    raise_error("WIZINFO ZERSTOERT. SIMUL-EFUN NEU STARTEN!\n");
  if(!mappingp(info[MEMORY_BUFF]))
    raise_error("I'M DEAD! PLEASE HELP!\n");
  if(!member(info[MEMORY_BUFF],who))
    return 0;
  if(stringp(key)) {
    if(!member(info[MEMORY_BUFF][who],key))
      return 0;
    info[MEMORY_BUFF][who]=m_delete(info[MEMORY_BUFF][who], key);
    return 1;
  }
  info[MEMORY_BUFF]=m_delete(info[MEMORY_BUFF], who);
  return 1;
}

// DEBUG-Fun

void printf_entries() {
  printf("%O\n",get_extra_wizinfo(0)[MEMORY_BUFF]);
}

