/*******************
** Eldarea MUDLib **
********************
**
** secure/pmaster - profession master
**
** CVS DATA
** $Date: 2000/11/30 16:11:22 $
** $Revision: 1.3 $
**
** The profession master provides the mudlib profession handling
**
** CVS History
**
** $Log: pmaster.c,v $
** Revision 1.3  2000/11/30 16:11:22  elatar
** news data fields implemented
**
** Revision 1.2  2000/03/13 10:29:03  elatar
** implemented much basic functionality
**
** Revision 1.1  2000/01/06 14:38:33  elatar
** Initial revision for basic login functionality
**
**
*/

#define PMASTER_NEED_PROTO
#include <daemon.h>
#include <wizlevels.h>
#include <living/skills.h>
#include <living/attributes.h>
#include <daemon/pmaster.h>

#pragma strict_types

/** professions mapping ******************************************
**
** ([P_PROFESSION:PM_ATTR;PM_RACE;PM;PM_NAME;PM_TYPE;PM_ASPC;PM_WEAP:PM_SPEL])
** ([profession:attr;races;name;type;aspect;weapons;spells])
**
** P_PROFESSION	String
** PM_ATTR      Array mit den beiden hauptattributen (A_**)
** PM_RACE      Array mit den erlaubten rassen
** PM_NAME      string mit dem langnamen
** PM_TYPE      integer fuer den typ (spelluser etc.) 
** PM_ASPC      Array mit den erlaubten Aspekten (0 wenn nicht
**              vorgeschrieben)
** PM_WEAP      3 Arrays mit den erlaubten/notwendigen Waffentypen
** PM_SPEL      Array mit den Punkten fuer die Spells der 6 Kategorien
**
*/
#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x)

mapping professions;

void create()
{
  seteuid(getuid());
  if (!restore_object(PMASTER) || !mappingp(professions))
    professions=([]);
  
  //uncomment and modify _add_value() to add a value to the mapping
  //_add_value();  
}

// function to extend the professions mapping
static void _add_value()
{
  int i,j;
  string * ind;
  mapping new;
  
  ind=m_indices(professions);
  new=([]);
  
  for (i=sizeof(professions);i-->0;)
  {
    new+=([ind[i]:professions[ind[i],PM_ATTR];
                  professions[ind[i],PM_RACE];
                  professions[ind[i],PM_NAME];
                  professions[ind[i],PM_TYPE];
                  professions[ind[i],PM_ASPC];
                  professions[ind[i],PM_WEAP];
                  ({0,0,0,0,0,0})]);    
  }  
  professions=copy_mapping(new);
  save_object(PMASTER);
}

// check if profession is valid
int valid_profession(string profession)
{
  return member(professions,profession);  
}

// return an array of the professions given in ind, filtered in subarrays 
// through flag
static mixed * filter_professions(string * ind, int flag)
{
  mixed *ret;
  int i;

  switch (flag)
  {
    case PF_TYPE:
      ret=({({}),({}),({})});
      for (i=sizeof(ind);i-->0;)
      {
        ret[professions[ind[i],PM_TYPE]]+=({ind[i]});
      }
      break;
    default:
      ret=ind;
      break;
  }
  return ret;
}

// query all professions for given race (or all races), filtered by flag
varargs mixed * QueryProfessions(string race,int flag)
{
  mapping map;
  string *ind;
  int i;

  ind=m_indices(professions);

  if (!stringp(race)&&race="")
    return filter_professions(ind,flag);
 
  race=lower_case(race);
  for (i=sizeof(ind);i-->0;)
    if (!member(professions[ind[i],PM_RACE],race))
      ind-=({ind[i]});
  return filter_professions(ind,flag);
}

// return an array of the main attributes of one profession
string * QueryAttributes(string profession)
{
  profession=lower_case(profession);

  if (member(professions,profession))
    return professions[profession,PM_ATTR];
  else
    return 0;
}

// return all valid races of one profession
string * QueryRaces(string profession)
{
  profession=lower_case(profession);

  if (member(professions,profession))
    return professions[profession,PM_RACE];
  else
    return 0;  
}

// return the valid aspects for one profession
string * QueryAspects(string profession)
{
  mixed * asp;
  
  profession=lower_case(profession);

  if (!member(professions,profession))
    return 0;
  asp=professions[profession,PM_ASPC];
  if (!pointerp(asp) || sizeof(asp)<1)
    return 0;
    
  return asp[1..];
}

// does profession require aspect?
int QueryRequireAspect(string profession)
{
  mixed * asp;
  
  profession=lower_case(profession);

  if (!member(professions,profession))
    return 0;
  asp=professions[profession,PM_ASPC];
  if (!pointerp(asp) || sizeof(asp)<1)
    return 0;
    
  return asp[0];
}

// return the skill data array of one profession
// format:
//
// 0 = Development Points
// 1 = Prioritaet
// 2 = Haeufigkeit pro Stufe
// 3 = Flag zweimal lernen?

mapping QuerySkills(string profession, mapping fws)
{
  string * file, skill, * ind;
  int i,dp,flag;
  float prio1,prio2,vals1,vals2;
  mapping ret;
  
  profession=lower_case(profession);

  if (member(professions,profession) && file_size(PMASTER_CONFIG_DIR"/"+profession))
  {
    file=explode(read_file(PMASTER_CONFIG_DIR"/"+profession),"\n");
    ret=([]);
    for (i=0;i<sizeof(file);i++)
    {
      if (file[i][0]!='#' && file[i][0]!=' ')
        if (sscanf(file[i],"%s %d %1d.%1d %1d.%1d %d"
                  ,skill,dp,prio1,prio2,vals1,vals2,flag)==7)
          ret+=([skill:dp;
                       to_float(prio1)+prio2/10.0;
                       to_float(vals1)+vals2/10.0;
                       flag]);
    }
    // weapon skills adden
    ind=m_indices(SK_GROUP_WEAPON);
    for (i=sizeof(ind);i-->0;)
    {
      if (ind[i]==fws[SK_FIRST_WEAPON])
        ret+=([ind[i]:ret[SK_FIRST_WEAPON,0];
                      ret[SK_FIRST_WEAPON,1];
                      ret[SK_FIRST_WEAPON,2];
                      ret[SK_FIRST_WEAPON,3]]);
      else if (ind[i]==fws[SK_SECOND_WEAPON])
        ret+=([ind[i]:ret[SK_SECOND_WEAPON,0];
                      ret[SK_SECOND_WEAPON,1];
                      ret[SK_SECOND_WEAPON,2];
                      ret[SK_SECOND_WEAPON,3]]);
      else if (ind[i]==fws[SK_THIRD_WEAPON])
        ret+=([ind[i]:ret[SK_THIRD_WEAPON,0];
                      ret[SK_THIRD_WEAPON,1];
                      ret[SK_THIRD_WEAPON,2];
                      ret[SK_THIRD_WEAPON,3]]);
      else
        ret+=([ind[i]:ret[SK_OTHER_WEAPONS,0];
                      ret[SK_OTHER_WEAPONS,1];
                      ret[SK_OTHER_WEAPONS,2];
                      ret[SK_OTHER_WEAPONS,3]]);
    }
    ret=m_delete(ret,SK_FIRST_WEAPON);
    ret=m_delete(ret,SK_SECOND_WEAPON);
    ret=m_delete(ret,SK_THIRD_WEAPON);
    ret=m_delete(ret,SK_OTHER_WEAPONS);
    
    return ret;
  }
  else
    return 0;
}

void SetSkillcosts(mapping skills, string profession, mapping fws)
{
  string * ind;
  mapping skillinfo;
  int i;
  
  if (!valid_profession(profession))
    return;
  
  skillinfo=QuerySkills(profession,fws);
  
  for (i=sizeof(ind=m_indices(skills));i-->0;)
  {
/*    if (member(SK_GROUP_WEAPON,ind[i]))
    {
      if (ind[i]==fws[SK_FIRST_WEAPON])
        skills[ind[i],SI_COST]=skillinfo[SK_FIRST_WEAPON,0];
      else if (ind[i]==fws[SK_SECOND_WEAPON])
        skills[ind[i],SI_COST]=skillinfo[SK_SECOND_WEAPON,0];
      else if (ind[i]==fws[SK_THIRD_WEAPON])
        skills[ind[i],SI_COST]=skillinfo[SK_THIRD_WEAPON,0];
      else
        skills[ind[i],SI_COST]=skillinfo[SK_OTHER_WEAPONS,0];
    }
    else*/
      skills[ind[i],SI_COST]=skillinfo[ind[i],0];
  }
}

// return the full name of one profession
string * QueryName(string profession)
{
  profession=lower_case(profession);

  if (member(professions,profession))
    return professions[profession,PM_NAME];
  else
    return 0;
}

// return the type of one profession
int QueryType(string profession)
{
  profession=lower_case(profession);

  if (member(professions,profession))
    return professions[profession,PM_TYPE];
  else
    return 0;
}
          
// add one profession. skill costs and priorities will be defaulted          
int AddProfession(mapping profession)
{
  if ( !previous_object()
    || !IS_ARCH(getuid(previous_object())) 
    || !mappingp(profession))
    return 0;
  professions+=profession;
  save_object(PMASTER);
  return 1;
}

mixed ChangeValue(string profession, int val, mixed value)
{
  profession=lower_case(profession);
  
  if (!member(professions,profession))
    return 0;
    
  return professions[profession,val]=value;
}

mixed QueryWeapons(string profession)
{
  profession=lower_case(profession);
  
  if (!member(professions,profession))
    return 0;
    
  return professions[profession,PM_WEAP];    
}

int * QuerySpellpoints(string profession)
{
  profession=lower_case(profession);
  
  if (!member(professions,profession))
    return 0;
    
  return professions[profession,PM_SPEL];
}
