/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2001/02/06 08:57:05 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: potionmaster.c,v $
** Revision 1.2  2001/02/06 08:57:05  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
// $Date: 2001/02/06 08:57:05 $
// $Revision: 1.2 $
/* $Log: potionmaster.c,v $
/* Revision 1.2  2001/02/06 08:57:05  elatar
/* applied strong_types requirements
/*
/* Revision 1.1.1.1  1999/11/05 12:30:45  elatar
/* Preparing mudlib for cvs control
/*
/* Revision 1.1.1.1  1999/11/04 12:48:11  en
/* MUDLib CVS Preperation
/*
 * Revision 1.1  1999/08/05 00:17:13  Largo
 * Initial revision
 *
 *
 */
/* Das "Potion-Handling" laeuft ueber eine AList. Die Raeume, die Potions ent-
   halten koennen, bekommen eine Zahl zugeordnet. Eine AList hat die Raumnamen
   als Schluessel, die Raumnummern als  Elemente.
   Es existieren 8 weitere AListen, die die "aktiven" Raeume enthalten.
   Einem Spieler wird beim ersten Einloggen eine Liste von 76 Raeumen (ueber
   ihre Nummerns spezifiziert) gegeben. Dabei werden ihm je RoomsPerList Raeume aus der
   ersten bis siebten Liste und 6 Raeume aus der achten Liste zugeordnet.
   Die Raeume sollten nach Schwierigkeit sortiert sein (die einfachsten in
   der ersten, die schwersten in der achten Liste). So ist gewaehrleistet, das
   der Spieler die ersten Advances relativ einfach, die letzten dafuer umso
   schwerer erreicht.
*/

#include "/secure/config.h"
#include "/secure/wizlevels.h"
#include "/std/sys_debug.h"

#define RoomsPerList 10 

#define POTIONDUMP "/secure/ARCH/lists/traenke"
#define POTIONLOG "/secure/ARCH/log/POTIONS"
#define DUMP(str) write_file(POTIONDUMP,str)

mixed *all_rooms;
mixed *active_rooms;
int nextroom;

void save_info()
{
    save_object("/secure/ARCH/save/potions");
}

int secure()
{
  if (!previous_object()) return 0;
  if (geteuid(previous_object())==ROOTID) return 1;
  if (geteuid(previous_object()) != geteuid(this_interactive())) return 0;
  if (this_interactive() != this_player()) return 0;
  if (!IS_ARCH(this_interactive())) return 0;
  return 1;
}

void create()
{
    int i;

    seteuid(getuid(this_object()));
    if (!restore_object("/secure/ARCH/save/potions"))
    {
        all_rooms=({({}),({})});
        active_rooms=allocate(8);
        for (i=0;i<8;i++) active_rooms[i]=({});
    }
    all_rooms=order_alist(all_rooms);
}

int AddPotionroom(string roomname)
{
    if (!secure()) return 0;
    if (!stringp(roomname) || roomname=="") return -1;
    roomname=MASTER->_get_path(roomname,0);
    if (catch(call_other(roomname,"???"))) return -2;
    //if (roomname[0..12]!="/room/potion/") return -4;
    if (assoc(roomname, all_rooms, -1)!=-1) return -3;
    all_rooms=insert_alist(roomname, nextroom, all_rooms);
    nextroom++;
    save_info();
    return nextroom;
}

int ChangeRoomPath(string oldpath, string newpath)
{
  int num;

  if (!secure()) return 0;
  if (!stringp(oldpath) || oldpath=="") return -1;
  if (!stringp(newpath) || newpath=="") return -2;
  oldpath=MASTER->_get_path(oldpath,0);
  newpath=MASTER->_get_path(newpath,0);
  if (assoc(oldpath,all_rooms,-1)==-1) return -3;
  if (assoc(newpath,all_rooms,-1)!=-1) return -4;
  if (catch(call_other(newpath,"???"))) return -5;
  num=assoc(oldpath, all_rooms);
  all_rooms=remove_alist(oldpath,all_rooms);
  all_rooms=insert_alist(newpath, num, all_rooms);
  save_info();
  return num;
}

int ActivateRoom(string roomname, int listno)
{
    int nummer;
    int i;

    if (!secure()) return 0;
    if (listno<0 || listno>7) return -1;
    nummer=assoc(roomname, all_rooms, -1);
    if (nummer==-1) return -2;
    for (i=0;i<8;i++)
        if (member_array(nummer,active_rooms[i])!=-1) return -3;
    active_rooms[listno]+=({nummer});
    save_info();
    return 1;
}

int DeactivateRoom(string roomname)
{
    int nummer, i, pos;

    if (!secure()) return 0;
    nummer=assoc(roomname, all_rooms,-1);
    if (nummer==-1) return -1;
    i=0;
    while (i<8 && (pos=member_array(nummer, active_rooms[i]))==-1) i++;
    if (pos==-1) return -2;
    //if (sizeof(active_rooms[i])<11) return -3;
    active_rooms[i]=active_rooms[i][0..pos-1]+active_rooms[i][pos+1..<1];
    return 1;
}

mixed _create_list(int listno, int anz)
{
    mixed *list, tmp;
    int i, j;

    list=({});
    tmp=active_rooms[listno][0..<1]; 
    
    while (anz>0)
    {
        anz--;
        if (sizeof(tmp)==0)
        {
//        	write("Fehler ! Liste konnte nicht erzeugt werden ! PANIC !\n");
        	return list;
        }
        if (sizeof(tmp)==1)
        {
          list+=tmp;
          tmp=({});
        }
        else
        {
          j=random(sizeof(tmp));
          list+=({tmp[j]});
          tmp=tmp[0..j-1]+tmp[j+1..<1];
        }
    }
    return list;
}

mixed * InitialList()
{
    mixed *list;
    int i;
    list=({});

    list+=_create_list(0, RoomsPerList);
    list+=_create_list(1, RoomsPerList);
    list+=_create_list(2, RoomsPerList);
    list+=_create_list(3, RoomsPerList);
    list+=_create_list(4, RoomsPerList);
    list+=_create_list(5, RoomsPerList);
    list+=_create_list(6, RoomsPerList);
    list+=_create_list(7, RoomsPerList);
    /* Code for 80 potions */
    /* nur wenn Liste nicht leer ist...*/
    if (sizeof(list) > 0) {
      while (2*sizeof(list) < 80)
        list += list;
      for (i=sizeof(list); i<80; i++)
        list += ({list[random(i)]});
    }
    return list;
}

mixed HasPotion(mixed room)
{
  return assoc(explode(file_name(room),"#")[0], all_rooms, -1);
}

int InList(mixed room, mixed list)
{
	room=assoc(explode(file_name(room),"#")[0], all_rooms, -1);
	if (room==-1) return 0;
	if (member_array(room, list)==-1) return 0;
	return 1;
}

mixed RemoveList(mixed room, mixed list)
{
	room=assoc(explode(file_name(room),"#")[0], all_rooms, -1);
	if (room==-1) return list;
	if ((room=member_array(room, list))==-1) return list;
	return list[0..room-1]+list[room+1..<1];
}

int DumpList()
{
  int i,j,k,s;
	int *LIST;

  rm(POTIONDUMP);
	LIST=all_rooms[1];
  for (i=0;i<8;i++)
  {
		LIST-=active_rooms[i];
    s = sizeof(active_rooms[i]);
    DUMP(sprintf("################## Liste %d ################## (%d)\n\n",
		 i,s));
    for (j=0;j<s;j++)
    {
      DUMP(sprintf("%3d. ",active_rooms[i][j]));
      k=member_array(active_rooms[i][j],all_rooms[1]);
      if (k==-1)
        DUMP("KEIN ZUGEORDNETER RAUM !!\n");
      else
        DUMP(all_rooms[0][k]+"\n");
    }
    DUMP("\n\n");  
  }
	s=sizeof(LIST);
	DUMP(sprintf("################## Inaktiv ################## (%d)\n\n",s));
	for (j=0;j<s;j++)
	{
		DUMP(sprintf("%3d. ",LIST[j]));
		k=member_array(LIST[j],all_rooms[1]);
		if (k==-1)
		  DUMP("KEIN ZUGEORDNETER RAUM !!\n");
		else
		   DUMP(all_rooms[0][k]+"\n");
	}
	DUMP("\n\n");
  return 1;
}


void log_potion(string text)
{
  if (!text || !stringp(text)) return;
  write_log(POTIONLOG, text);
}
