/*******************
** Eldarea MUDLib **
********************
**
** secure/questmaster.c - questmaster object
**
** CVS DATA
** $Date: 2000/03/13 10:29:03 $
** $Revision: 1.2 $
**
** This questmaster is obsolet, it will be replaced as soon as possible
**
** CVS History
**
** $Log: questmaster.c,v $
** Revision 1.2  2000/03/13 10:29:03  elatar
** implemented much basic functionality
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

/* Die Quests werden in einem Mapping gespeichert. Der Schluessel ist dabei der
   Quest-Name, die Eintraege sind Arrays der folgenden Form:

   1. Element ist die Zahl der durch diese Quest zu erwerbenden Questpunkte.
   2. Element ist die Zahl der Erfahrungspunkte, die der Spieler bekommt,
      wenn er diese Quest loest.
   3. Element ist ein Array mit den Filenamen der Objekte, denen es gestattet
      ist, diese Quest beim Player als geloest zu markieren (Erzmagier duerfen
      das aber sowieso immer).
   4. Element ist ein String, der die Quest kurz beschreibt. Dieser String wird
      dem Spieler vom Orakel als Hinweis gegeben.
   5. Element ist eine Zahl zwischen 0 und 35, die den Schwierigkeitsgrad der
      Quest angibt, nach Einschaetzung des EM fuer Quests. Das Orakel kann dann
      evtl. sinnige Saetze wie "Diese Quest erscheint mir aber noch recht
      schwer fuer Dich.", oder "Hm, die haettest Du ja schon viel eher loesen
      koennen." absondern. :)
   6. Element ist ein Integer, 0, 1 oder 2. 
      0: Questpunkte zaehlen zur Berechnung der maximalen Questpunkte.
         Die Quest ist freiwillig.
      1: Questpunkte zaehlen zur Berechnung der maximalen Questpunkte.
         Die Quest muss geloest werden (unabhaengig von der 80%-Regel).
      2: Questpunkte zaehlen nicht zur Berechnung der maximalen Questpunkte.
         Die Quest ist freiwillig.
   7. Element ist ein Integer, 0 oder 1.
      0: Quest voruebergehend deaktiviert (suspendiert)
      1: Quest aktiviert
   8. Element ist ein String und enthaelt den Namen des Magiers, der die
      Quest "verbrochen" hat.
   9. Element ist ein Integer:
      0: wenn allgemeine Quest,
      1: wenn Gildenquest
*/

#include <wizlevels.h>
#include <properties.h>
#include <daemon.h>
#include <config.h>

#define NEED_PROTOTYPES
#include <questmaster.h>

#pragma strong_types

int max_QP;
mapping quests;

void save_info() {
  save_object( QUESTS );
}

void create() {
  seteuid(getuid(this_object()));
  if (!restore_object( QUESTS )) {
    quests=([]);
    max_QP=0;
  }
}

private static int secure() {
  object po, ti;
  po=previous_object();
  ti=this_interactive();
  if(geteuid(po)==ROOTID)
      return 1;
  if(ti && ti==this_player() && IS_ARCH(ti))
    return 1;
  return 0;
}

int AddQuest(string name, int questpoints, int experience,
	     string *allowedobj, string hint, int difficulty, int need,
	     int active, string wiz, int gildenquest) {
  mixed *quest;
  int i;

#if 0
  printf("Name        : %s\n"
         "Questpoints : %d\n"
         "Erfahrung   : %d\n"
         "Questobjekte: %O\n"
         "Info        : %s\n"
         "Mindestlevel: %d\n"
         "Typ         : %d\n"
         "Aktiviert   : %d\n"
         "Magier      : %s\n"
         "Gildenquest : %d\n",
         name, questpoints, experience, allowedobj, hint, difficulty, need,
         active, wiz, gildenquest);
#endif

  if (!secure()) return 0;
  if (!stringp(name) || strlen(name)<5) return -1;
  if (questpoints<0) return -2;
  if (!intp(experience)) return -3;
  if (stringp(allowedobj)) allowedobj=({allowedobj});
  if (!pointerp(allowedobj)) return -4;
  for (i=sizeof(allowedobj)-1;i>=0;i--)
  {
    if (!stringp(allowedobj[i]) || allowedobj[i]=="") return -4;
    allowedobj[i]=MASTER->_get_path(allowedobj[i],0);
  }
  if (!stringp(hint) || hint=="") return -5;
  if (difficulty<0 || difficulty>35) return -6;
  if (active<0 || active>1) return -7;
  if (!stringp(wiz) || wiz=="" || 
      file_size("/players/"+(wiz=lower_case(wiz))) != -2) return -8;
  if(quests[name]&&(quests[name][QM_NEED]==0||quests[name][QM_NEED]==1)&&quests[name][QM_ACTIVE])
    max_QP-=quests[name][QM_QP];

  if (gildenquest) // falls gildenquest anderen Wert als 1 hat, einfach setzen
    {
      gildenquest = 1;
      need = 2;    // need darf dann nur 2 sein
    }

  quests+=([name:({questpoints,experience,allowedobj,hint,difficulty,need,active,wiz,gildenquest})]);
  if ((need == 0 || need ==1) && active )
    max_QP+=questpoints;
  save_info();
  QMLOG(sprintf("add: %s %O (%s)",name,quests[name],
		getuid(this_interactive())));
  return 1;
}

int RemoveQuest(string name) {
  mixed *quest;
    
  if (!secure()) return 0;
  if (!quests[name]) return -1;
  QMLOG(sprintf("remove: %s %O (%s)",name,quests[name],
		getuid(this_interactive())));
  if ((quests[name][QM_NEED] == 0 || quests[name][QM_NEED] == 1) && quests[name][QM_ACTIVE])
    max_QP-=quests[name][QM_QP];
  quests=m_delete(quests,name);
  save_info();
  return 1;
}

int QueryNeededQP() {
  return max_QP * QP_PERCENT / 100;
}

int QueryMaxQP() {
  return max_QP;
}

int QueryReadyForWiz(object player) {
  int i;
  string *indices;
  mixed *notsolved;
  int *groups,*dontneed;
  int bonus;
  
  groups = ({0,0,0,0});
  dontneed = QDONTNEED;

  if (player->QueryProp(P_QP)<QueryNeededQP()) return -1;
  notsolved=({});
  indices=m_indices(quests);
  for (i=sizeof(indices)-1;i>=0;i--)
  {
    if (!quests[indices[i]][QM_ACTIVE])
      continue;
    if (quests[indices[i]][QM_QP] < QGROUP_1 &&
	!player->QueryQuest(indices[i]))
      groups[0]++;
    else if (quests[indices[i]][QM_QP] < QGROUP_2 &&
	     !player->QueryQuest(indices[i]))
      groups[1]++;
    else if (quests[indices[i]][QM_QP] < QGROUP_3 && 
	     !player->QueryQuest(indices[i]))
      groups[2]++;
    else if (!player->QueryQuest(indices[i]))
      groups[3]++;
    if (quests[indices[i]][QM_NEED]==1 && !player->QueryQuest(indices[i]))
      notsolved+=({indices[i]});
  }
  for(i=3,bonus=0;i>=0;i--)
    if((bonus += dontneed[i]-groups[i])<0)
      break;
      
  if (!sizeof(notsolved) && bonus >= 0)
    return 1;
  return 0;
}

mixed *QueryQuest(string name) {
  if(!quests[name])
    return ({});
  return quests[name];
}

varargs mixed QueryQuests (int mapflag)
{
  if (mapflag)
    return quests;
  else
    return ({m_indices(quests),m_values(quests)});
}

//alt:
//mixed *QueryQuests() {
//  return ({m_indices(quests),m_values(quests)});
//}

string *QueryAllKeys() {
  return m_indices(quests);
}

int SetActive(string name, int flag) {
  mixed *quest;
    
  if (!secure()) return 0;
  if (!(quest=quests[name])) return -1;
  switch(flag)
  {
    case 0:
      if (quest[QM_ACTIVE] == flag)
        return -2;
      quest[QM_ACTIVE] = flag;
      if (quest[QM_NEED] == 0 || quest[QM_NEED] == 1)
	max_QP-=quest[QM_QP];
      break;
    case 1:
      if (quest[QM_NEED] == flag)
        return -2;
      quest[QM_ACTIVE] = flag;
      if (quest[QM_NEED] == 0 || quest[QM_NEED] == 1)
	max_QP+=quest[QM_QP];
      break;
    default:
      return -3;
  }
  quests[name]=quest;
  save_info();
  QMLOG(sprintf("%s: %s (%s)",(flag?"activate":"deactivate"),name,
		getuid(this_interactive())));
  return 1;
}

void Channel(string msg) {
  catch(VOICEMASTER->SendToChannel("Abenteuer",this_object(),MSG_SAY,msg));
}

/*      Query...()
 *      Funktion:       Liefert die Werte der Quests aus den Feldern des Mappings zurueck
 *      Parameter:      unterschiedlich
 *      Rueckgabe:      die Werte, falls eine solche Quest existiert
 */
int QueryQP(string name) {
  if (!quests[name])
    return -1;
  return quests[name][QM_QP];
}

int QueryLevel(string name) {
  if (!quests[name])
    return -1;
  return quests[name][QM_LEVEL];
}

int QueryActive(string name) {
  if (!quests[name])
    return -1;
  return quests[name][QM_ACTIVE];
}

string  QueryWizard(string name) {
  if (!quests[name])
    return "";
  return quests[name][QM_WIZ];
}

int IsGuildQuest(string name) {
  if (!quests[name])
    return -1;
  return quests[name][QM_GUILD];
}

