/*******************
** Eldarea MUDLib **
********************
**
** secure/rmaster.c - race information master
**
** CVS DATA
** $Date: 2000/11/30 16:11:43 $
** $Revision: 1.3 $
**
** the race master provides race information for 
** various issues
**
** CVS History
**
** $Log: rmaster.c,v $
** Revision 1.3  2000/11/30 16:11:43  elatar
** news data fields implemented
**
** Revision 1.1  2000/01/25 19:13:05  elatar
** initial revision
**
**
*/

#pragma strict_types

#define _RACEMASTER_NEED_PROTO_
#include <rmaster.h>

#include <wizlevels.h>
#include <properties.h>

static mapping data;
mapping ranges;

void create()
{
  seteuid(getuid());
  Update();  
}

void Update()
{
  object po;
  string *ndata;
  int line,inter;

  // savefile data variables
  string name,race_name_m, race_name_f;
  int st, ag, qu, co, sd, re, em, in, pr, esse, chan, ment, dise,
      pois, psio, fear, powe, elem, hp, psp, esp, msp, csp, 
      civ, ali, hl_m, hl_f, rvm1, rvm2;

  po=previous_object();

  if (interactive(po)||po=find_player(geteuid(po)))
  {
    inter=1;
    tell_object(po,"\nUpdating race master...\n");
  }
  
  if (file_size(SAVEFILE)>0)
  { // use this savefile
    if (file_size(SAVEBACK)<1)
    {
      if (inter)
        tell_object(po,"Backup savefile missing, created new one.\n");
    }
    else
    {
      rm(SAVEBACK);
      if (inter)
        tell_object(po,"Updating backup savefile.\n");
    }  
    write_file(SAVEBACK,read_file(SAVEFILE));
  } 
  else if (file_size(SAVEBACK)>0)
  { // use this instead and create new SAVEFILE
    write_file(SAVEFILE,read_file(SAVEBACK));
    if (inter)
      tell_object(po,"Savefile missing, using backup file to create new one.\n");
  }
  else
  { // use defaults and create new savefiles
    write_file(SAVEFILE,RDEFAULTS);
    write_file(SAVEBACK,RDEFAULTS);
    if (inter)
      tell_object(po,"NO SAVEFILES FOUND. Using defaults to create new one.\n");
  }

  data=([]);

  // now read the savefile, whatever it is now

  ndata=explode(read_file(SAVEFILE),"\n");

  if (inter)
    tell_object(po,"Reading race data ");
  for (line=0;line<sizeof(ndata);line++)
  { // parse line after line
    if ( strlen(ndata[line])>0 
      && ndata[line][0]!='#' 
      && ndata[line][0]!=' ')
    { // # leads a comment in savefile, such lines will not be parsed
      // lines leaded by a space will also not be parsed (clear lines)
      sscanf(ndata[line],
        "%15s%t%15s%t%15s %4d %4d %4d %4d %4d %4d %4d %4d %4d %4d %4d"
        " %4d %4d %4d %4d %4d %4d %4d %4d %4d %4d %4d %4d %6d %6d %4d"
        " %4d %1d.%2d",
        name, race_name_m, race_name_f ,st, ag, qu, co, sd, re, em, in, pr, 
        esse, chan, ment, dise,
        pois, psio, fear, powe, elem, hp, psp, esp, msp, csp,
        civ, ali, hl_m, hl_f, rvm1, rvm2);
      race_name_m=implode(explode(race_name_m,"_")," ");
      race_name_f=implode(explode(race_name_f,"_")," ");
      data+=([name:([P_RACE_NAME        : ({race_name_m,race_name_m,race_name_f}),
                     A_ST               : st,
                     A_AG               : ag,
                     A_QU               : qu,
                     A_CO               : co,
                     A_SD               : sd,
                     A_RE               : re,
                     A_EM               : em,
                     A_IN               : in,
                     A_PR               : pr,
                     RR_ESSENCE         : esse, 
                     RR_CHANNELING      : chan,
                     RR_MENTALISM       : ment,
                     RR_DISEASE         : dise,
                     RR_POISON          : pois,
                     RR_PSIONS          : psio,
                     RR_FEAR            : fear,
                     RR_POWERDRAIN      : powe,
                     RR_ELEMENTAL       : elem,
                     P_HP               : hp,
                     P_PSP              : psp,
                     P_ESP              : esp,
                     P_MSP              : msp,
                     P_CSP              : csp,
                     P_CIVILIZATION     : civ,
                     P_ALIGN            : ali,
                     P_HAIR_LENGTH      : ({hl_m,hl_m,hl_f}),
                     P_VOLUME_MULTIPLIER: rvm1+to_float(rvm2)/100.0])]);
      if (inter)
        tell_object(po,".");
    }
  }
  if (inter)
    tell_object(po," done.\nReading race default ranges.\n");
  ranges=([]);
  restore_object(RANGES_SAVEFILE);    
  if (inter)
    tell_object(po,"Updated successfully.\n");
  
  return;
}

mixed QueryPropDefaults(string property,string race)
{
  if (!property||!stringp(property)||property=="")
    return 0;
  if (!member(DATA,race)&&!member(DATA,race=lower_case(race)))
    race=DEFAULTRACE;

  if (member(DATA[race],property))
    return DATA[race][property];
  else
    return 0;
}

static mixed getraceoff(string key, string offset)
{
  return data[key][offset];
}

mapping QueryAllOffsets(string offset)
{
  mapping map;

  if (!offset || offset=="")
    return 0;

  map=mkmapping(VALID_RACES,map_array(VALID_RACES,#'getraceoff,offset));

  return map;
}

mixed QueryOffset(string offset,string race)
{
  if (!race)
  {
    return QueryAllOffsets(offset);
  }

  if (!race || (!member(data,race)&&!member(data,race=lower_case(race))))
    race=DEFAULTRACE;

  if (!offset||!stringp(offset))
    return copy_mapping(data[race]);

  if (offset=="")
    return 0;

  if (member(data[race],offset))
    return data[race][offset];
  else
    return 0;
}

string * valid_races()
{
  return VALID_RACES;
}

mixed QueryRange(string race, string property)
{
  if (!race || (!member(data,race)&&!member(data,race=lower_case(race))))
    race=DEFAULTRACE;

  return ranges[race][property];
}

void AddRange(string property, mixed defval)
{
  string * ind;
  int i;
  
  ind=m_indices(data);
  for (i=sizeof(ind);i-->0;)
  {
    if (!member(ranges,ind[i]))
      ranges[ind[i]]=([]);
    if (mappingp(defval))
      ranges[ind[i]][property]=copy_mapping(defval);
    else if (pointerp(defval))
      ranges[ind[i]][property]=defval+({});
    else 
      ranges[ind[i]][property]=defval;
  }
  save_object(RANGES_SAVEFILE);
}