/*******************
** Eldarea MUDLib **
********************
**
** secure/rmaster.h - rmaster header
**
** CVS DATA
** $Date: 2000/11/30 16:11:45 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: rmaster.h,v $
** Revision 1.3  2000/11/30 16:11:45  elatar
** news data fields implemented
**
** Revision 1.2  2000/03/13 10:29:03  elatar
** implemented much basic functionality
**
** Revision 1.1  2000/01/25 19:13:10  elatar
** initial revision
**
**
*/

#include <humanoid/description.h>

#define RMASTER         "/secure/rmaster"

// Das WICHTIGSTE define, nur die Rassen, die hier stehen, sind legal
#define VALID_RACES\
  ({HIGH_HUMAN,WOOD_HUMAN,DESERT_HUMAN,HIGH_ELF,WOOD_ELF,SUN_ELF,MOON_ELF\
   ,STAR_ELF,NORTH_HUMAN,STONE_DWARF,SNOW_DWARF})

#define DEFAULTRACE     "DEFAULT"
#define HIGH_HUMAN 	"high_human"
#define WOOD_HUMAN 	"wood_human"
#define DESERT_HUMAN	"desert_human"
#define HIGH_ELF	"high_elf"
#define WOOD_ELF	"wood_elf"
#define SUN_ELF		"sun_elf"
#define MOON_ELF	"moon_elf"
#define STAR_ELF	"star_elf"
#define NORTH_HUMAN	"north_human"
#define STONE_DWARF	"stone_dwarf"
#define SNOW_DWARF	"snow_dwarf"

#ifdef _RACEMASTER_NEED_PROTO_
#undef _RACEMASTER_NEED_PROTO_

#define SAVEFILE "/secure/ARCH/config/racedata"
#define SAVEBACK "/secure/ARCH/config/.racedata.bak"
#define RANGES_SAVEFILE "/secure/ARCH/config/race_ranges"

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),"DEBUG: "+x)

#define RDEFAULTS\
  "# Race Master savefile\n"\
  "#\n"\
  "# This file will be parsed by the racemaster to restore its data.\n"\
  "# \n"\
  "# Call Update() in racemaster to parse it again.\n"\
  "#\n"\
  "\n"\
  "#P_RACE         A_ST A_AG A_QU A_CO A_SD A_RE A_EM A_IN A_PR "\
  "ESSE CHAN MENT DISE POIS PSIO FEAR POWE ELEM "\
  "HP_O PSP_ ESP_ MSP_ CSP_\n"\
  "DEFAULT            0    0    0    0    0    0    0    0    0 "\
  "   0    0    0    0    0    0    0    0    0 "\
  " 200   50   50   50   50\n"\


#define DATA \
([\
   DEFAULTRACE:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
  ,HIGH_HUMAN:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
  ,WOOD_HUMAN:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
  ,DESERT_HUMAN:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
  ,HIGH_ELF:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
  ,WOOD_ELF:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
  ,SUN_ELF:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
  ,MOON_ELF:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
  ,STAR_ELF:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
  ,NORTH_HUMAN:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
  ,STONE_DWARF:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
  ,SNOW_DWARF:([\
   P_STATUE:\
    ({({"hager","sehr schlank","schlank","durchschnittlich","kraeftig","muskuloes","athletisch"})\
     ,({"zerbrechlich","sehr schlank","schlank","durchschnittlich","feminin","trainiert","athletisch"})})])\
])
/*
RACE:([mapping])
:([P_STATUE:({,})])\
*/

mixed QueryPropDefaults(string property,string race);
mixed QueryOffset(string offset,string race);
mapping QueryAllOffsets(string offset);
void AddRange(string property, mixed defval);
mixed QueryRange(string race, string property);

static mixed getraceoff(string key, string offset);
void Update();

string * valid_races();

#endif // _RACEMASTER_NEED_PROTO_