/*******************
** Eldarea MUDLib **
********************
**
** secure/service.c - master service object
**
** CVS DATA
** $Date: 2001/02/01 08:21:35 $
** $Revision: 1.8 $
**
** CVS History
**
** $Log: service.c,v $
** Revision 1.8  2001/02/01 08:21:35  elatar
** create_wizard updated and test run implemented
**
** Revision 1.7  2000/12/21 11:12:35  elatar
** secured with secure_level()
**
** Revision 1.5  2000/12/18 14:22:54  elatar
** MBanishQuery implemented and small security bugfix
**
** Revision 1.4  2000/11/30 16:12:10  elatar
** rudimentary user statistics implemented
**
** Revision 1.3  2000/01/31 00:27:00  elatar
** maxusers handling debugged
**
** Revision 1.2  2000/01/17 14:57:33  elatar
** maxuser handling fixed
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <properties.h>
#include <defines.h>
#include <homes.h>
#include <news.h>
#include <wizlevels.h>
#include <config.h>
#include <questmaster.h>
#include <clock.h>
#include <daemon/channel.h>

#pragma strong_types

#define DB(x) if(find_player("elatar")) tell_object(find_player("elatar"), sprintf("%O\n", x))

#define SAVEFILE    "/secure/ARCH/save/service"
#define ONLINESTATS "/log/statistics"
#define MAXUSERS    ONLINESTATS"/maxusers"
#define MAXTODAY    ONLINESTATS"/maxusers.today"
#define UPTIME      ONLINESTATS"/uptime"

#define P_RUBRIK  "bekanntmachungen" // Spielerrubrik fuer Bekanntmachungen 
#define S_RUBRIK  "seher.seher"      // Seherrubrik
#define M_RUBRIK  "avatar"           // Magierrubrik
#define S_LEVEL     1                // Seher
#define L_LEVEL     3                // Learner
#define M_LEVEL     4                // Vollmagier

static void write_article(mixed stuff);
private int str2time(string t);
void update_maxuptime();
void update_maxusers();
void update_userload();
void UpdateStatistics();
mixed * QueryStatistics();

static int max,today,umax;

mapping MBanishListe;
mapping sponsors;
mapping userload;
mapping userstats;
int lasttime, ausers, udate;

void create() 
{
  string s;
  
  seteuid(ROOTID);
  if(file_size(MAXUSERS)<=0) 
  {
    max=sizeof(users());
    rm(MAXUSERS);
    write_file(MAXUSERS,
      sprintf("%d user: %s load: %s\n",max,dtime(time()),query_load_average()));
  }
  else 
  {
    s=read_file(MAXUSERS,0,1);
    sscanf(s,"%d",max);
  }
  if ( file_size(MAXTODAY)<=0 || dtime(file_time(MAXTODAY))[6..16] != dtime()[6..16] )
  {
    today=sizeof(users());
    rm(MAXTODAY);
    write_file(MAXTODAY,sprintf("%d user\n",today));
  }
  else 
  {
    s=read_file(MAXTODAY,0,1);
    sscanf(s,"%d",today);
  }
  update_maxuptime();
  restore_object(SAVEFILE);
  if (!mappingp(MBanishListe)) 
    MBanishListe=([]);
  if (!mappingp(sponsors)) 
    sponsors=([]);
  update_userload();
  if (!mappingp(userstats))
    userstats=([]);
  if (!udate)
    udate=time();
}

/** For Channeld
 */

string name()
{
  return "";  
}

/*************** Onlinestats ***************/

void update_maxuptime()
{
  int u, t;
  
  if ( file_size(UPTIME)<=0) 
  {
    u=umax=time()-last_reboot_time();
    rm(UPTIME);
    write_file(UPTIME,sprintf("uptime: %d\nuptime record %d at %d\n",u,umax,time()));
  }
  else if (dtime(file_time(UPTIME))[6..16] != dtime()[6..16] )
  {
    if (sscanf(read_file(UPTIME),
        "uptime: %d\nuptime record %d at %d\n",u,umax,t)==3)
    {
      u=time()-last_reboot_time();
      if (u>umax)
      {
        umax = u;
        t = time();
      }
      rm(UPTIME);
    }
    else
    {
      u=umax=time()-last_reboot_time();
      rm(UPTIME);
    }
    write_file(UPTIME,sprintf("uptime: %d\nuptime record %d at %d\n",u,umax,time()));
  }
}

/*************** Max-User Liste ***************/

void update_maxusers()
{
  int u;

  if ( file_size(MAXUSERS) <= 0 )
    max=0;
  if ( file_size(MAXTODAY) <= 0 || dtime(file_time(MAXTODAY))[6..16] != dtime()[6..16]  )
    today=0;
  if (( u = sizeof(users())) > today )
  {
    today = u;
    rm(MAXTODAY);
    write_file(MAXTODAY,sprintf("%d user\n",today));
  }
  if (u > max )
  {
    max=u;
    rm(MAXUSERS);
    write_file(MAXUSERS,
      sprintf("%d user: %s load: %s\n",max,dtime(time()),query_load_average()));
  }
  return;
}

/*************** User-Statistik ***************/

void update_userload()
{
  int dticks, avuser, i, * ind;
  
  if (!mappingp(userload))
    userload=([]);

  if (dtime()[6..16]!=dtime(lasttime)[6..16])
  { // new day, calc stats and write file
    if (file_size("/log/statistics/"+dtime(lasttime)[13..16])!=-2)
      mkdir("/log/statistics/"+dtime(lasttime)[13..16]);
    if (file_size("/log/statistics/"+dtime(lasttime)[13..16]+"/"+
                                     dtime(lasttime)[9..11])!=-2)
      mkdir("/log/statistics/"+dtime(lasttime)[13..16]+"/"+
                               dtime(lasttime)[9..11]);
    
    dticks=CLOCK->get_day_ticks(time());
    userload[ausers]+=time()-lasttime-dticks;
    ind=sort_array(m_indices(userload),#'>);
    for (i=sizeof(ind);i-->0;)
    {
      avuser+=userload[ind[i]]*ind[i];  
    }
    write_file("/log/statistics/"+dtime(lasttime)[13..16]+"/"+
                                  dtime(lasttime)[9..11]+"/average",
      sprintf("%2s - minusers: %:3d; maxusers: %:3d; average users: % 6.2f\n",
        dtime(lasttime)[5..6],ind[0],ind[<1],avuser/86400.0));
    lasttime=time()-dticks;
    userload=([]);
  }
  userload[ausers]+=time()-lasttime;
  ausers=sizeof(users());
  lasttime=time();
  save_object(SAVEFILE);
}

void UpdateStatistics()
{
  if (extern_call() && load_name(previous_object())!=CRON)
    return;
  if (dtime()[6..16]!=dtime(udate)[6..16])
  {
    string filestat, * ind;
    int i;
    
    if (file_size("/log/statistics/"+dtime(lasttime)[13..16])!=-2)
      mkdir("/log/statistics/"+dtime(lasttime)[13..16]);
    if (file_size("/log/statistics/"+dtime(lasttime)[13..16]+"/"+
                                     dtime(lasttime)[9..11])!=-2)
      mkdir("/log/statistics/"+dtime(lasttime)[13..16]+"/"+
                               dtime(lasttime)[9..11]);
    
    ind = sort_array(m_indices(userstats),#'>);
    
    filestat = "";
    for(i=0;i<sizeof(ind);i++)
      filestat += sprintf("[%s] %3d %3d\n",
                          ind[i],userstats[ind[i]][0],userstats[ind[i]][1]);
    
    write_file(sprintf("/log/statistics/%s/%s/%s",
                       dtime(lasttime)[13..16],
                       dtime(lasttime)[9..11],
                       regreplace(dtime(lasttime)[5..6]," ","0",0)),
               filestat);
    
    userstats = ([]);
    udate = time();
  }
  userstats[dtime()[19..23]] = 
    ({sizeof(users()),
      sizeof(filter(users(),#'query_wiz_level))});
  save_object(SAVEFILE);
  update_maxuptime();
}

mixed * QueryStatistics()
{
  int u, t;
  
  update_maxuptime();
  update_maxusers();
  sscanf(read_file(UPTIME),"uptime: %d\nuptime record %d at %d\n",u,umax,t);
  
  return ({u,umax,t,today,max});  
}

void notify_player_change(string who, int rein) 
{
  int i;
  object *u, ob;
  string wer, adverb;

  if(!stringp(who))
    return;
  wer=capitalize(who);
  i=0;
  update_maxusers();
  update_userload();
  if((ob = find_player(who)) && !(ob->QueryProp(P_INVIS))) 
  {
    if(lower_case(wer)==lower_case(ob->name()))
      wer=ob->name();
    u=users()-({ob});
    adverb=ob->QueryProp("my_inform_text");
    ob->SetProp("my_inform_text", 0); // immer nur 1x verwenden
    for(i = sizeof(u); i;)
      catch(u[--i]->notify_player_change(wer,rein,adverb));
  }
}

void notify_player_remove(string who) 
{
  notify_player_change(who, 2);
}

void notify_player_enter(string who) 
{
  notify_player_change(who, 1);
}

void notify_player_leave(string who) 
{
  notify_player_change(who, 0);
}



/*************** Wiz&Seer Creation *****************/

// Returnwerte:
//   1  Ok
// -15  Zuwenig XP
// -16  Zuwenig AP
// -17  Pflichtquest fehlt
static int QueryBedingungen(object pl, string was) {
  int ret,i;

  if (IS_SEER(pl)) return 1;
  if (pl->QueryProp(P_XP)<XP_NEEDED_FOR_WIZ) return -15;
  ret="secure/questmaster"->QueryReadyForWiz(pl);
  if (ret==-1) return -16;
  if (ret!=1) return -17;
  return 1;
}

// Returnwerte:
//   2  Ok, wird Vollmagier
//   1  Ok, wird Magier
//  -1  Parameter ist kein Objectp oder nicht interaktiv
//  -2  Parameter sind identisch
//  -3  Magier-Bann besteht
//  -5  Nachfahre ist noch regionslos
//  -6  advance_wizlevel() schlug fehl
//  -7  Sponsor hat zu niedrige Stufe
//  -8  Vertrag fehlt
//  -9  Vertrag nicht von Sponsor
// -10  Magiershell nicht ladbar
// -15 bis -17 siehe QueryBedingungen()
// ist check gesetzt, so werden nur die bedingungen ueberprueft
public varargs int create_wizard(mixed who, mixed promoter, int check) 
{
  mixed *domains;
  object vertrag;
  int ret;
  string gen;

  who=find_player(who);
  promoter=find_player(promoter);
  if ( !objectp(who) || !objectp(promoter) 
    || !interactive(who) || !interactive(promoter)) 
    return -1;
  if (who==promoter) 
    return -2;
  if (member(MBanishListe,getuid(who))) 
    return -3;
  if (IS_WIZARD(who)) 
    return -4;
  if (!IS_QUEST(promoter))
    return -7;
  if ( secure_level() < QUEST_LVL 
    && load_name(previous_object())!="/d/avatar/tower/room/dome")
    return -7;
  if (IS_LEARNER(who)) 
  {
    ret="secure/master"->advance_wizlevel(geteuid(who), M_LEVEL, check);
    if(ret<=0) 
      return -6;
    if (!check)
    {
      VOICEMASTER->send("Info", this_object(), sprintf(
        "%s wurde soeben von %s in den %d. Kreis der Avatare erhoben."
        ,who->Name(), this_player()->name(WEM), 11-M_LEVEL));
      "secure/master"->renew_player_object(who);
    }
    return 2;
  }
  if (!(vertrag=present("unterschriebenvertrag",who))) 
    return -8;
  if(geteuid(vertrag)!=geteuid(promoter)) 
    return -9;
  if(1!=(ret=QueryBedingungen(who,"Magier"))) 
    return ret;
  if (!check)
    vertrag->remove();
  ret="secure/master"->advance_wizlevel(geteuid(who),L_LEVEL, check);
  if (ret>0) 
  {
    if (!check)
    {
      if ("secure/master"->set_player_object(geteuid(who),
          "/std/shells/avatar")<=0)
        return -10;
      // Achtung, Logfile wird vom Finger ausgelesen, Format nicht aendern!
      log_file("SPONSOR",dtime(time())+": "+promoter->name(WER)+" macht "+
        who->name(WER)+" zum Learner.\n");
      write_article(({"wiz", L_LEVEL, who, promoter}));
      MASTER->add_sponsorship(getuid(promoter),getuid(who));
      VOICEMASTER->send("Info", this_object(), 0, sprintf(
        "%s wurde in den Kreis der Avatare aufgenommen und ist damit %s "
        "Schlueler%s.",who->Name(),this_player()->name(WESSEN),
                       (who->QueryProp(P_GENDER)==2)?"in":""));
      "secure/master"->renew_player_object(who);
    }
    return 1;
  }
  return -6;
}

// Returnwerte:
//   2  Spieler ist schon seher
//   1  Spieler ist nun Seher
//  -1  Spieler ist kein Objektp
//  -2  advance_wizlevel() lieferte Fehlerwert
// -15 bis -17 siehe QueryBedingungen()
//TODO: obsolet, remove
public int create_seer(mixed player) 
{
  string playername;
  int ret;
  
  if (!objectp(player)) 
    return -1;
  if (IS_SEER(player)) 
    return 2;
  if (1!=(ret=QueryBedingungen(player,"Seher")))
    return ret;
  if ((ret="secure/master"->advance_wizlevel(geteuid(player),S_LEVEL))<=0) 
    return -2;
  playername = geteuid(player);
  write_article(({"seer", S_LEVEL, player}));
  "secure/master"->renew_player_object(player);
  player = find_player(playername);
  return 1;
}


/*********** PK-Meldungen erzeugen **********/
void pk_done() 
{
  //TODO: remove
}


/*********** Hm. Someone are not allowed... *********/

public int MBanishInsert(string name, string grund) 
{
  if ( !stringp(name) || !strlen(name)
    || !stringp(grund) || !strlen(grund))
    return 0;
  if ( secure_level() < ELDER_LVL )
    return 0;
  MBanishListe += ([name:grund;getuid(this_interactive())]);
  save_object(SAVEFILE);
  return 1;
}

public int MBanishDelete(string name) 
{
  if (!name || name=="")
    return 0;
  if ( secure_level() < ARCH_LVL)
    return 0;
  MBanishListe = m_delete(MBanishListe,name);
  save_object(SAVEFILE);
  return 1;
}

public string MBanishQuery()
{
  string str, * names;
  int i;
  
  str = 
    "+-------------------------------------------------------------------+\n"
    "|  MBanish-Liste                                                    |\n"
    "+-------------+-------------+---------------------------------------+\n"
    "| Name        | gebannt von | Grund                                 |\n"
    "+-------------+-------------+---------------------------------------+\n";
  for (i=sizeof(names=m_indices(MBanishListe));i-->0;)
  {
    str += sprintf(
    "| %:11-s | %:11-s | %:37-s |\n",
    names[i],MBanishListe[names[i],1],MBanishListe[names[i],0]);
  }
  str += "+-------------+-------------+---------------------------------------+\n";
  
  return str;
}

/*************** Artikel schreiben ******************/

/*
 * write_article(mixed stuff)
 *   Stellt Artikel fuer Zeitung zusammen
 *   stuff - array
 *   1. Element: Schluesselwort
 *   Rest        vom Schluesselwort abhaengig
 */
static void write_article(mixed stuff) 
{
  string text, tmp, tmp2, tmp3;
  mixed message, doms;
  object newsd;
  int i, g2, g3;
  
  if(!pointerp(stuff) || !sizeof(stuff) || !stringp(stuff[0]))
    return;

  switch(stuff[0]) 
  {
    case "wiz":
      if(sizeof(stuff)<4 || !intp(stuff[1]) || !objectp(stuff[2]) ||
        !objectp(stuff[2])) return;
      if(stuff[1]==L_LEVEL) 
      {
        g2=stuff[2]->QueryProp(P_GENDER)==2;
        g3=stuff[3]->QueryProp(P_GENDER)==2;
        message=allocate(7);
        message[M_BOARD]=P_RUBRIK;
        message[M_REFERENCE]="";
        message[M_TITLE]=stuff[2]->name(WER)+" wurde in den Kreis der "
                         "Avatare aufgenommen.";
        message[M_WRITER]="Der grosse Rat";
        message[M_MESSAGE]=break_string(sprintf(
          "Seid gegruesst, Bewohner "MUDNAME"s!\n\n"
          "%s hat soeben %s zu seine%s Schueler%s berufen und %s somit in den "
          "Kreis der Avatare aufgenommen. Wir freuen uns, dass %s sich in "
          "den Dienst "MUDNAME"s stellt und wuenschen %s viel Spass und "
          "Erfolg mit %s Taetigkeit als Avatar%s.\n"
          "Herzlichen Dank auch Dir, %s, fuer Deine Anstrengungen als "
          "Meister%s.\n\n"
          "Der grosse Rat",
          capitalize(getuid(stuff[3])),
          capitalize(getuid(stuff[2])),
          g2?"r":"m",
          g2?"in":"",
          stuff[2]->QueryPronoun(WEN),
          stuff[2]->QueryPronoun(WER),
          stuff[2]->QueryPronoun(WEM),
          stuff[2]->QueryPossPronoun(FEMALE,WESSEN),
          g2?"in":"",
          capitalize(getuid(stuff[3])),
          g3?"in":""));
      }/* 
      //TODO: brauchen wir den Artikel?
      if(stuff[1]==D_LEVEL) 
      {
	doms="secure/master"->get_domain_homes(getuid(stuff[2]));
        for(i=sizeof(doms);i--;) doms[i]="+"+capitalize(doms[i]);
	tmp2=(stuff[2]->QueryProp(P_GENDER)>MALE?" ist Mitarbeiterin":" ist Mitarbeiter");
        message=allocate(7);
        message[M_BOARD]=M_RUBRIK;
        message[M_REFERENCE]="";
        message[M_TITLE]=stuff[2]->name(WER)+" ist jetzt Regionsmitglied";
        message[M_WRITER]="Hurrikap";
        message[M_MESSAGE]=break_string(
          "Seid gegruesst, Magier des "+MUDNAME+"!\n\n"
          "Hiermit verkuende ich feierlich, dass ich heute in "+
          stuff[3]->name(WESSEN)+" Auftrag "+stuff[2]->name(WEN)+
          " zum Regionsmitglied (L"+to_string(D_LEVEL)+") ernannt habe!\n"+
          stuff[2]->name(WER)+tmp2+" in Region "+stuff[2]->CountUp(doms)+
          ".\nHurrikap - der Urvater aller Magier\n");
      }*/
      break;
    default:
      return;
  }
  newsd=find_object("/secure/news");
  if (newsd) newsd->WriteNote(message);
  return;
}

public mixed QuerySponsor(string uid) 
{
  mixed arr;
  arr=sponsors[uid];
  if (!arr) return -1;
  return copy(arr);
}

int query_prevent_shadow(object ob) { return 1; }
