/*******************
** Eldarea MUDLib **
********************
**
** secure/simul_efun - simulierte Efuns
**
** CVS DATA
** $Date: 2001/03/13 12:16:49 $
** $Revision: 1.13 $
**
** Basierend auf Wunderland Mudlib
**
** Bedeutung von simul_efun.c <-> spare_simul_efun.c
** =================================================
**
** Wenn man an simul_efun.c etwas aendert, und das File buggt beim
** Neuladen, kann das ganze Mud abstuerzen. Um gefahrlos Aenderungen
** durchzufuehren, gibt es spare_simul_efun.c. Laesst sich simul_efun
** naemlich nicht laden, so wird es mit der spare-Version versucht.
** Wird die spare_simul_efun destructet wird wieder erstmal die simul_efun
** probiert, dann die spare_simul_efun.
** Bevor man etwas an simul_efun aendert, sollte man das File also einfach
** einmal nach spare_simul_efun.c umkopieren. Dann kann man gefahrlos
** alle Sachen ausprobieren. Nicht vergessen, auch die Spare immer
** upzudaten!
** Und natuerlich ist es zwecklos, die spare_simul_efun.c ins RCS
** aufzunehmen! Das ist wirklich nur ein Hilfsfile, meistens eine Kopie
** der letzten lauffaehigen Version von simul_efun.c.
**
** CVS History
**
** $Log: simul_efun.c,v $
** Revision 1.13  2001/03/13 12:16:49  eldarea
** secure_level now has a flag to ignore the current object
**
** Revision 1.12  2001/02/22 11:50:40  elatar
** list_words() now returns  for empty arrays (for programmers convenience)
**
** Revision 1.11  2001/02/08 17:17:06  elatar
** small bug in country determination removed
**
** Revision 1.10  2001/02/02 14:27:51  elatar
** new ip resolution
**
** Revision 1.9  2001/02/01 08:22:34  elatar
** small bugfix with VOICEMASTER call
**
** Revision 1.8  2001/01/24 16:06:36  elatar
** ipnets displaced to /global/service/ipnets.c
** country() determination changed
** dtime() prototype changed to accept no or 1 argumente, taking time() as default
** security improved by use of secure_level()
** ___updsimul() implemented
** ip_owner() implemented
** set_next_reset() updatet from Wunderland
** process_string() removed / blocked
** call_out prototype changed
** debug_info() prototype changed
** general cleanup of obsolete stuff and reformatting
**
** Revision 1.7  2000/12/19 18:00:01  elatar
** implemented deep_destruct()
** implemented secure_level(), process_call() and slightly changed process_string()
** (credits and thanks to Woody@Silberland)
**
** Revision 1.6  2000/12/12 11:32:20  elatar
** unique_id() implemented
**
** Revision 1.5  2000/11/30 16:13:26  elatar
** list_words() implemented
**
** Revision 1.4  2000/03/13 10:29:03  elatar
** implemented much basic functionality
**
** Revision 1.2  1999/11/18 11:52:09  elatar
** new due to VOICEMASTER adaption
**
*/

#pragma strong_types

#define SNOOPLOGFILE  "SNOOP"
#define SHADOWLOGFILE "ARCH/SHADOWS"
#define RMILOGFILE    "ARCH/REMOVE_INTERACTIVE"
#define COMMANDLOGFILE "ARCH/COMMAND"

// Absolute Pfade erforderlich - zum Zeitpunkt, wo der Master geladen
// wird, sind noch keine Include-Pfade da ...

#include "/secure/config.h"
#include "/secure/wizlevels.h"
#include "/sys/snooping.h"
#include "/sys/language.h"
#include "/sys/thing/properties.h"
#include "/sys/wizlist.h"
#include "/sys/erq.h"
#include "/sys/lpctypes.h"
#include "/sys/daemon.h"
#include "/sys/properties.h"
#include "/sys/events.h"
#include "/sys/defines.h"
#include "/sys/telnet.h"
#include "/sys/rpgsys.h"
#include "/sys/service/ipnets.h"

#define FILE_NAME 1
#define FILE_SIZE 2
#define FILE_DATE 4

#define IP_VALID_CACHE 86400 // Eintraege im IP-Name-Cache nach 24h erneuern
#define IP_RETRY 28800       // Retry after 8 hours if name not found

#define TO       efun::this_object()
#define TI       efun::this_interactive()
#define TP       efun::this_player()
#define PO       efun::previous_object(0)
#define LEVEL(x) query_wiz_level(x)
#define NAME(x)  capitalize(getuid(x))

#define DEBUG(x) if (find_player("elatar")) tell_object(find_player("elatar"),x)

// prototypes
varargs string dtime(varargs int * wann);
int file_date(string file);
varargs int log_file(string file, string txt, int size_to_break);
int query_wiz_level(mixed player);
mixed *remove_alist(mixed key, mixed *alist);
nomask int snoop(object me, object you);
nomask object query_snoop(object who);
string *get_dir_ext(string path);
string *new_explode(string str, string del);
varargs mapping ipinfo(mixed dnsname, string ipnum);
varargs string country(mixed ip, string num);
varargs string ip_owner(mixed ip, string num);
void localcmd();
int query_wiz_grp(mixed wiz);
void set_living_name(string name);
object find_living(string name);
object find_player(string name);
varargs object deep_present(mixed what, object ob);
string unique_id(string filename);
nomask varargs int secure_level(int exto);
nomask int process_call();
nomask string process_string(mixed str);

int d100();
int d100low();
int d100high();
int _d100low(int last);
int _d100high(int last);
int EvalCheck(int roll);
int EvalCheckResult(int roll);

nomask void destruct(object ob)
{
  string fname;
  object* tmp;

  if ( (fname=file_name(ob))==MASTER
    || fname=="/obj/shut"
    || fname=="/room/void")
  {
    if ( previous_object()!=ob
      && (!this_interactive() || !IS_ARCH(this_interactive()) ))
    {
      write("Das waere sicherlich keine sehr gute Idee!!!\n");
      return;
    }
  }
  if ( query_once_interactive(ob) && IS_ARCH(ob)
    && previous_object()!=ob && secure_level()<ARCH_LVL )
    return;
  tmp=all_environment(ob);
  efun::destruct(ob);
  if(pointerp(tmp)) map_objects(tmp, "ContentChanged");
}

nomask varargs void deep_destruct(object ob)
{
  object * inv;

  if (objectp(ob))
  {
    for (inv = all_inventory(ob);sizeof(inv);inv = inv[1..])
    {
      deep_destruct(inv[0]);
    }
  }
  destruct(ob);
}

void ___updmaster()
{
  write("Removing old master ... ");
  efun::destruct(efun::find_object(MASTER));
  write("done.\nLoading again ... ");
  call_other(MASTER,"???");
  write("done.\n");
}

void ___updsimul() {
  object ob;
  write("Removing old simul ...\n");
  ob = find_object(SIMUL_EFUN_FILE);
  if (ob) destruct(ob);
  ob = find_object(SPARE_SIMUL_EFUN_FILE);
  if (ob) destruct(ob);
  write("Done. - Loading again ...\n");
  MASTER->get_simul_efun();
  write("Done.\n");
}

// * Caching fuer IP-Info-Abfragen nach alter Methode
string last_ipnum;
string last_dnsname;
mapping last_info;

// * Herkunfts-Ermittlung
mapping ip_map;

varargs string query_ip_number(object ob)
{
  ob=ob||this_player();
  if (!interactive(ob)) return 0;
  return ob->_query_my_ip()||efun::query_ip_number(ob);
}

string query_ip_name(mixed ob)
{
  string ipnum;
  mixed ipname;

  if (stringp(ob)) ipnum=ob;
  else ipnum=query_ip_number(ob);
  ipname=ip_map[ipnum,0];
  if (stringp(ipname))
  {
    if ((time()-ip_map[ipnum,1])>IP_VALID_CACHE)
    {
      ip_map[ipnum,1]=time();
      MASTER->get_ip_name(ipnum);
    }
    return ipname;
  }
  if (++ipname>3)
  {
    ip_map[ipnum,1]=time()-IP_VALID_CACHE+IP_RETRY;
    return ip_map[ipnum]=ipnum;
  }
  MASTER->get_ip_name(ipnum);
  ip_map[ipnum,0]=ipname;
  return ipnum;
}

varargs mapping ipinfo(mixed dnsname, string ipnum)
{
  int * a_ip;
  string * strs;
  mapping result;
  
  if (objectp(dnsname))
  {
    ipnum=query_ip_number(dnsname);
    dnsname=query_ip_name(ipnum);
  }
  else if (stringp(dnsname))
  {
    dnsname=lower_case(dnsname);
    if (!ipnum)
    {
      ipnum=dnsname;
      if ( sizeof(regexplode(dnsname,"[a-zA-Z]"))<=1
        || member(dnsname, ':')!=-1)
        dnsname=lower_case(query_ip_name(dnsname));
    }
    else if (!stringp(ipnum))
      return ([]);
  }
  else
    return ([]);

  strs=efun::explode(ipnum, ":");
  if (sizeof(strs)>1)
  { // v6
    strs=efun::explode(strs[<1], ".");
    if (sizeof(strs)<2)
    { // Kein v4 via v6
      a_ip = ({-1,-1,-1,-1});
      result = ([IPDATA_V6:1]);
    }
    else
    { // v4 Teil der v6 Adresse extrahieren
      a_ip = map(strs,#'to_int);
      result = ([]);
    }
  }
  else
  {
    a_ip = map(efun::explode(strs[<1], "."), #'to_int);
    result = ([]);
  }

  if (ipnum == last_ipnum || dnsname == last_dnsname)
    return (last_info+result);

  result += IPNETS->resolve(a_ip, dnsname);
  
  last_ipnum = ipnum;
  last_dnsname = dnsname;
  last_info = result;
  
  return result;
}

varargs string country(mixed ip, string num)
{
  mapping info;
  string result;
  
  info = ipinfo(ip, num);

  if (result = info[IPDATA_TOWN])
  {
    if (info[IPDATA_COUNTRY] && info[IPDATA_COUNTRY]!=IPCOUNTRY)
    {
      result += " (" + upper_case(info[IPDATA_COUNTRY]) + ")";
    }
  }
  else if (result = info[IPDATA_COUNTRY])
  {
    result = IPNETS->CountryName(result);  
  }
  else
  {
    result = "Unbekannt";  
  }
  if (info[IPDATA_V6])
  {
    result += " [v6]";
  }

  return result;
}

varargs string ip_owner(mixed ip, string num)
{
  return ipinfo(ip, num)[IPDATA_OWNER];  
}


// * Snoopen und was dazugehoert

static object find_snooped(object who)
{
  object *u;
  int i;

  for (i=sizeof(u=users())-1;i>=0;i--)
    if (who==efun::query_snoop(u[i]))
      return u[i];
  return 0;
}

private static string Lcut(string str)
{
  return str[5..11]+str[18..];
}


varargs nomask int snoop(object me, object you)
{
  int ret;
  object snooper0,snooper,snooper2,snooper3;


  if(me == you)
    return 0;
  if(me && PO)
  {
    snooper0=find_snooped(me);
    if(you)
    {
      if (PO != me && query_wiz_grp(me)>=query_wiz_grp(geteuid(PO)))
	return 0;
      if (query_wiz_grp(me)<=query_wiz_grp(you) && !(you->QueryAllowSnoop(me)))
	return 0;
      if ((snooper=efun::query_snoop(you)) &&
	  query_wiz_grp(snooper)>=query_wiz_grp(me))
      {
	if (snooper->QueryProp(P_SNOOPFLAGS && SF_LOCKED))
	  return 0;
	tell_object(snooper,sprintf("%s snooped jetzt %s.\n",
				    me->name(WER),you->name(WER)));
	snooper2=me;
	while ((snooper3=query_snoop(snooper2)))
	{
	  tell_object(snooper,sprintf("%s wird seinerseits von %s gesnooped.\n",snooper2->name(WER),snooper3->name(WEM)));
	  snooper2=snooper3;
	}
	efun::snoop(snooper,snooper2);
	if (efun::query_snoop(snooper2)!=snooper)
	  tell_object(snooper,sprintf("Du kannst %s nicht snoopen.\n",
				      snooper2->name(WEN)));
	else
	{
	  tell_object(snooper,sprintf("Du snoopst jetzt %s.\n",
				      snooper2->name(WEN)));
	  if (!IS_ARCH(snooper))
	  {
	    log_file(SNOOPLOGFILE,sprintf("%s: %O %O %O\n",
					  dtime(time()),snooper,snooper2,environment(snooper2)),100000);
	    if (snooper0)
	      VOICEMASTER->send("Snoop",this_object(),sprintf("%s *OFF* %s (%O)",capitalize(getuid(snooper)),capitalize(getuid(snooper0)),environment(snooper0)), MSG_SAY);
	    VOICEMASTER->send("Snoop",this_object(),sprintf("%s -> %s (%O)",capitalize(getuid(snooper)),capitalize(getuid(snooper2)),environment(snooper2)), MSG_SAY);
          }
	}
      }
      else
      {
	if (snooper)
	  if (!me->QueryProp(P_SNOOPFLAGS) & SF_LOCKED)
	  {
	    printf("%s wird bereits von %s gesnooped. Benutze das \"f\"-Flag, wenn du dennoch snoopen willst.\n",you->name(WER),snooper->name(WEM));
	    return 0;
	  }
      }
      ret=efun::snoop(me, you);
      if (!IS_ARCH(me) && efun::query_snoop(you)==me)
      {
	log_file(SNOOPLOGFILE,sprintf("%s: %O %O %O\n",Lcut(dtime(time())),me,you,environment(you)),100000);
	if (snooper0)
	  VOICEMASTER->send("Snoop",this_object(),sprintf("%s *OFF* %s (%O).",capitalize(getuid(me)),capitalize(getuid(snooper0)),environment(snooper0)), MSG_SAY);
	VOICEMASTER->send("Snoop",this_object(),sprintf("%s -> %s (%O).",capitalize(getuid(me)),capitalize(getuid(you)),environment(you)), MSG_SAY);
      }
      if(ret && query_wiz_grp(me) <= query_wiz_grp(you))
	tell_object(you, "*** "+NAME(me)+" snoopt Dich!\n");
      return ret;
    }
    else
    {
      if((me == PO ||
	  query_wiz_grp(geteuid(PO)) > query_wiz_grp(me) ||
	  (query_wiz_grp(geteuid(PO)) == query_wiz_grp(me) &&
	   query_snoop(PO)==me))&&snooper0)
      {
	if (!IS_ARCH(me))
	{
	  log_file(SNOOPLOGFILE,sprintf("%s: %O %O %O *OFF*\n",Lcut(dtime(time())),me,snooper0,environment(snooper0)),100000);
	  VOICEMASTER->send("Snoop",this_object(),sprintf("%s *OFF* %s (%O).",capitalize(getuid(me)),capitalize(getuid(snooper0)),environment(snooper0)), MSG_SAY);
	}
	return efun::snoop(me);
      }
    }
  }
  return 0;
}

nomask object query_snoop(object who) {
  object snooper;

  snooper=efun::query_snoop(who);
  if (!snooper) return 0;
  if (query_wiz_grp(snooper)>query_wiz_grp(getuid(previous_object())) &&
    IS_ARCH(snooper) && strstr(file_name(previous_object()), "/", 1)!=-1)
    return 0;
  return snooper;
}

// * Emulation des 'alten' explode durch das neue

string *explode(string str, string del) {
  int s, t;
  string *strs;

  if(del == "")
    return ({str});
  strs=efun::explode(str, del);
  t=sizeof(strs)-1;
  while(s<=t && strs[s++] == "");s--;
  while(t>=0 && strs[t--] == "");t++;
  if(s<=t)
    return strs[s..t];
  return ({});
}

string *old_explode(string str, string del) {return explode(str,del);}

string *new_explode(string str, string del) {
  return efun::explode(str, del);
}

// * get_dir_ext: an directories einen /, an geladene Files einen * anhaengen

string *get_dir_ext(string path) {
  string *strs, file;
  mixed *finfo;
  int i, s, t;

  set_this_object(previous_object());
  if(s=sizeof(finfo=get_dir(path, FILE_NAME|FILE_SIZE))) {
    strs=(string*)MASTER->full_path_array(path, TP ? getuid(TP) : 0);
    if(t=sizeof(strs))
      path="/"+(implode(strs[0..t-2], "/")+"/");
    else
      path="/";
    strs=({});
    while(s--,s-->0) {
      file=finfo[i++];
      switch(finfo[i++]) {
	case -2:
	file+="/";
	break;
	case -1:
	file+=" -?-";
	break;
	default:
	if(find_object(path+file))
	  file+="*";
      }
      strs+=({file});
    }
  }
  return strs;
}

// * Modifikations-Datum eines Files

int file_date(string file) {
  mixed *data;

  if(sizeof(data=get_dir(file, FILE_DATE)))
    return data[0];
  else
    return 0;
}

int file_time(string path)
{
  mixed *v;

  set_this_object(previous_object());
  if (sizeof(v=get_dir(path,4))) return v[0];
}

// * Bei 50k Groesse Log-File rotieren

varargs int log_file(string file, string txt, int size_to_break) {
  mixed *st;
  int logroot;

  if (member(file, '/')==-1) logroot=1;
  file="/log/"+file;
  file=implode((efun::explode(file,"/")-({".."})),"/");
  if (!funcall(bind_lambda(#'efun::call_other,PO),"secure/master",//')
	       "valid_write",file,geteuid(PO),"log_file",PO))
      return 0;
  if ( size_to_break >= 0 & (
      sizeof(st = get_dir(file,2) ) && st[0] >= (size_to_break||MAX_LOG_SIZE)))
      catch(rename(file, ( logroot ? "/log/old/"+file[5..] : file+".old") ));
      /* No panic if failure */
  write_file(file,txt);
}


varargs int write_log(string file, string txt, int size_to_break) {
  int max_size, j;
  mixed fsize;
  if (!file || !stringp(file) || !txt || !stringp(txt))
    return 0;
  if (!funcall(bind_lambda(#'efun::call_other,PO),"secure/master",//')
      "valid_write",file,geteuid(PO),"write_log",PO))
    return 0;
  max_size = 10*MAX_LOG_SIZE;
  size_to_break = (size_to_break<=0 ? MAX_LOG_SIZE : (size_to_break>max_size ? max_size : size_to_break));
  fsize = get_dir(file,2);
  if ((j=sizeof(fsize)) && fsize[0]<0)
    return 0;
  if (j && fsize[0]>=size_to_break && catch(rename(file, file + ".old")))
    return 0;
  return write_file(file, txt);
}


// Fuer this_player() definierte Kommandos anzeigen

void localcmd() {
  string *verbs;
  int i, s;

  if(!TP) return;
  s=sizeof(verbs=query_actions(TP));
  write("Local commands:\n");
  while(s--)
    write("'"+verbs[i++]+"' ");
  write("\n");
}

// * Magier-Level abfragen

int query_wiz_level(mixed player) {
  return (int)MASTER->query_wiz_level(player);
}

nomask varargs int secure_level(int exto)
{
  int i, l;
  object po;
  if (!this_interactive()) // kein Interactive
    return 0;
  l=query_wiz_level(this_interactive());
  i=exto?1:0;
  //DEBUG(sprintf("%O",previous_object(0)));
  while (po=previous_object(i))
  {
    i++;                                  // Den niedrigsten Wizlevel
    if (query_wiz_level(geteuid(po))<l)   // in den Previous_objects
      l=query_wiz_level(geteuid(po));     // bestimmen...
  }
  if (i<caller_stack_depth()) return 0;   // Selbstzerstoerer abfangen
  return l;
}

// * Teile aus einem Array entfernen *** OBSOLETE

mixed *exclude_array(mixed *arr,int from,int to)
{
  if (to<from)
    to = from;
  return arr[0..from-1]+arr[to+1..];
}

// * Element aus Alist loeschen (by key)

mixed *remove_alist(mixed key,mixed *alist)
{
  int i,j;

  if (!pointerp(alist) || !sizeof(alist))
    return alist;
  if (!pointerp(alist[0]))
  {
    if ((i=assoc(key,alist))<0)
      return alist;
    return alist[0..i-1]+alist[i+1..];
  }
  i = assoc(key,alist[0]);
  if ((i=assoc(key,alist[0]))<0)
    return alist;
  alist=alist[0..];
  for (j=sizeof(alist)-1;j>=0;j--)
    alist[j]=alist[j][0..i-1]+alist[j][i+1..];
  return alist;
}

// * Element aus Alist loeschen (by pos)

mixed *exclude_alist(int i,mixed *alist)
{
  int j;
  if (!pointerp(alist) || !sizeof(alist) || i<0)
    return alist;
  if (!pointerp(alist[0]))
    return alist[0..i-1]+alist[i+1..];
  alist=alist[0..]; /* Create PHYSICAL copy of alist */
  for (j=sizeof(alist)-1;j>=0;j--)
    alist[j]=alist[j][0..i-1]+alist[j][i+1..];
  return alist; /* order_alist is NOT necessary - see /doc/LPC/alist */
}

// * creator *** OBSOLETE

string creator(object ob)
{
  return (string)MASTER->creator_file(ob);
}

// *** Notloesung fuer Sommerzeitkorrektur

private static int correktur;

void create() {
  string str;
  if (file_size("/etc/SOMMER")<=0) return;
  str=read_file("/etc/SOMMER");
  correktur=to_int(str);
}

int time() {
  return efun::time()+3600*correktur;
}

// * German version of ctime()

string dtime(varargs int * wann)
{
  string monat, uhrzeit, wotag, tag, jahr;
  int t;

  if (!pointerp(wann) || sizeof(wann)<1)
    t=time();
  else
    t=wann[0];
  sscanf(ctime(t),"%s %s %d %s %d",wotag, monat, tag, uhrzeit, jahr);
  switch (monat)
  {
    case "May": monat="Mai"; break;
    case "Oct": monat="Okt"; break;
    case "Dec": monat="Dez"; break;
  }
  switch(wotag)
  {
    case "Sun": wotag="Son"; break;
    case "Tue": wotag="Die"; break;
    case "Wed": wotag="Mit"; break;
    case "Thu": wotag="Don"; break;
    case "Fri": wotag="Fre"; break;
    case "Sat": wotag="Sam"; break;
  }
  return wotag+(tag<=9 ? ",  " : ", ")+tag+". "+monat+" "+jahr+", "+uhrzeit;
}

// * Shutdown mit zusaetzlichem logging

nomask int shutdown(string reason)
{
  string name;
  string obname;
  string output;

  if (!reason)
    return 0;
  if ( secure_level() < ARCH_LVL
    && file_name(previous_object())!="/obj/shut")
  {
    write("You have no permission to shut down the gamedriver!\n");
    return 0;
  }
  if ((this_interactive())&&(name=getuid(this_interactive())))
  {
    name=capitalize(name);
    filter_array(users(),#'tell_object,//'
		 capitalize(name)+" faehrt das Spiel herunter!\n");
  }
  else
    name="ANONYMOUS";
  if (previous_object()) obname=capitalize(getuid(previous_object()));
  output=name;
  if (obname && name!=obname) output=output+" ("+obname+")";
  if (previous_object()&&file_name(previous_object())=="/obj/shut"){
    output+=" faehrt das Spiel via Armageddon herunter.\n";
    output=dtime(time())+": "+output;
    log_file("system/run",output+"\n",-1);
    efun::shutdown();
    return 1;
  }
  output=ctime(time())+": "+output+" faehrt das Spiel herunter.\n";
  output+="    Grund: "+reason;
  log_file("system/run",output+"\n",-1);
  efun::shutdown();
  return 1;
}

// * Interactive-Struct uebertragen - zus. checks

nomask int exec(object to, object from)
{
  if (!objectp(to) || !objectp(from)) return 0;
  if (explode(file_name(from),"#")[0]=="/secure/login" ||
      file_name(previous_object())==__MASTER_OBJECT__)
    return efun::exec(to,from);
  if (this_interactive() != from || previous_object() != from ||
      getuid(from) != getuid(to) || geteuid(from) != geteuid(to)) return 0;
  return efun::exec(to, from);
}

// * GD version

string version()
{
  return __VERSION__;
}

// * break_string

static int width,gCol,lfsig;
static string indstr;

private static string bnlfs(string word)  {
  int zz;

  zz=lfsig;
  lfsig=0;
  if ((gCol+strlen(word))>width) {
    gCol=strlen(indstr)+strlen(word)+1;
    return "\n"+indstr+word;
  }
  else  {
    gCol+=strlen(word)+1;
    return (zz ? "" : " ")+word;
  }
}

#define __LFS "                                                          "
#define LFS (__LFS __LFS)

// Altes break_string() nur noch intern fuer BS_BLOCK
private varargs string
_break_string(string str, int _width, mixed indent, int flags)
{
  string *tmp,*a,*b;
  int i,j,k,l;

  if (!str || str=="")
    return str;             /* Ein Scherzbold war am Werk... */

  if (flags&BS_LEAVE_MY_LFS)
  {
    flags&=~BS_LEAVE_MY_LFS;
    a=efun::explode(str,"\n");
    i = sizeof(a);
    if (a[<1]=="" && i>1)
    {
      a=a[0..<2];
      i--;
    }
    for (i--;i>=0;i--)
    {
      a[i]=_break_string(a[i],_width,indent,flags);
      if (a[i]=="") a[i]="\n";
    }
    return implode(a,"");
  }
  width=_width;
  lfsig=2;
  if (indent)  {
    if (intp(indent))       /* Soviel spaces sollten reichen! */
      indstr=LFS[1..indent];
    else if (stringp(indent))  {
      indstr=indent;
      indent=strlen(indstr);
    }
    else  {          /* Sicher ist sicher. Koennte ja auch ein obj sein */
      log_file(explode(file_name(previous_object()), "/")[1]+".rep",
	       "BUG GAME: Illegal argument indent to break_string in file "+
	       file_name(previous_object())+"\n");
      return "";
    }
  }
  else
    indstr="";
  gCol=indent;
  for (i=strlen(str)-1;i>=0;i--)
    if (str[i]=='\n') str[i]=' ';
  while (str!="" && str[<1]==32)
    str=str[0..<2];
  if ((flags & BS_BLOCK) && !(flags & BS_NO_PARINDENT))
    if (strlen(str))
      if (str[0]==' ')
	str[0]='x';
      else
	str="x"+str;
  if (sizeof(tmp=map_array(efun::explode(str, " "),#'bnlfs))) //#')))
    tmp[0]=indstr+tmp[0];
	str=implode(efun::explode(implode(tmp,""),"\n")-({indstr}),"\n")+"\n";
  if (!(flags&BS_BLOCK))
    return str;
  if (!(flags & BS_NO_PARINDENT))
    str=str[1..];
  a=efun::explode(str,"\n"); // Einzelne Zeilen
  if (strlen(a[0])<_width && a[0][0..0]!=" " &&
      !(flags&BS_NO_PARINDENT))
    a[0]=" "+a[0];
  for (i=sizeof(a)-2;i>=0;i--) // der Reihe nach bearbeiten
  {
    l=strlen(a[i]);           // Laenge der akt. Zeile
    if (l<_width && member(a[i][1..],' ')>=0) // Kein Leerzeichen? Nichts tun
    {
      b=efun::explode(a[i]," "); // Fragmente erzeugen
      for (j=sizeof(b)-1;j>0;j--)
        if (l<_width && ((b[j]!="" && member(",.-()[]{}!?",b[j][0])>=0) ||
		    (j>0&&b[j-1]!="" &&
		     member(",.-()[]{}!?",b[j-1][<1])>=0)))
	  b[j]=" "+b[j],l++;
      if (l<_width)
        for (j=sizeof(b)-1;j>0;j--)
          if (l<_width &&
              ((b[j]=="" || b[j][0]!=' ') && (b[j-1]=="" || b[j-1][<1]!=' ')))
            b[j]=" "+b[j], l++;
      while (l<_width)
	for (j=sizeof(b)-1;j>0;j--)
	{
	  if (l<_width)
	    b[j]=" "+b[j], l++;
	  if (l<_width)
	    b[sizeof(b)-j]=" "+b[sizeof(b)-j], l++;
	}
      a[i]=implode(b," ");
    }
  }
  return implode(a,"\n")+"\n";
}

public varargs string
break_string(string str, int width, mixed indent, int flags) {
	int a, b, indlen;
	if (width<=0) width=BS_STDLEN;
	if (flags&BS_BLOCK) return _break_string(str, width, indent, flags);
	if (strlen(str)==0) return str;
	if (flags&BS_FOR_COMM) { // Migrationshack
		if (stringp(indent)) str=indent+str;
		indent=BS_STDINDLEN;
		width=BS_STDLEN;
		flags=0;
	}
	if (flags&BS_ERASE_LFS) str=implode(efun::explode(str, "\n"), " ");
	if (intp(indent)) {
		indlen=indent;
		indent=sprintf("%*s", indent, "");
	} else {
		indlen=strlen(indent);
		flags|=BS_IND_FIRST;
	}
	if (str[<1]=='\n') str=str[0..<2];
	if (indlen && !(flags&BS_IND_FIRST)) {
		if (strlen(str)<=width) return str+"\n";
		for (;;) {
			a=strstr(str, " ", b);
			if (a<0 || a>width) break;
			b=a+1;
		}
		if (a==-1 && b==0) b=width, a=-2;
		else b--;
		return str[0..b-1]+"\n"+
			sprintf("%s%=-*s", indent, width-indlen,
				str[(a==-2?b:b+1)..])+"\n";
	}
	else return sprintf("%s%=-*s", indent, width-indlen, str)+"\n";
}


// * times
static int last_reboot;

int last_reboot_time() {
  return last_reboot;
}

int first_boot_time() {
  return 941700647;
}

int exist_days() {
  return (((time()-first_boot_time())/8640)+5)/10;
}

// * uptime :)

string uptime() {
  int t;
  int tmp;
  string s;

  t=time()-last_reboot_time();
  s="";
  if (t>=86400)
    s+=sprintf("%d Tag%s, ",tmp=t/86400,(tmp==1?"":"e"));
  if (t>=3600)
    s+=sprintf("%d Stunde%s, ",tmp=(t=t%86400)/3600,(tmp==1?"":"n"));
  if (t>60)
    s+=sprintf("%d Minute%s und ",tmp=(t=t%3600)/60,(tmp==1?"":"n"));
  return s+sprintf("%d Sekunde%s",t=t%60,(t==1?"":"n"));
}

// * Was tun bei 'dangling' lfun-closures ?

void dangling_lfun_closure() {
  raise_error("dangling lfun closure\n");
}

// * Sperren ausser fuer master/simul_efun

nomask void set_environment(object o1, object o2) {raise_error("Available only for root\n");}
nomask void efun308(object o1, object o2) {raise_error("Available only for root\n");}
nomask void set_this_player() {raise_error("Available only for root\n");}

// * Bisschen sperren
nomask varargs int set_next_reset(int x)
{
  int alt;

  set_this_object(previous_object());
  alt=efun::set_next_reset(0);
  if (x<1 || x>alt)
    return efun::set_next_reset(x);
  return alt;
}

// * Sperren, wenn was anderes als this_object() benutzt werden soll
nomask varargs int command(string str, object ob)
{
  if (objectp(ob) && query_once_interactive(ob) && (ob != previous_object()))
  {
    log_file(COMMANDLOGFILE, sprintf("%s: PO:%O ob:%O str:%s\n",
      dtime(time()), previous_object(), ob, str));
    return 0;
  }

  return funcall(bind_lambda(#'efun::command,
    previous_object()), str, objectp(ob) ? ob : previous_object());
}

// * actions auf den neusten Stand bringen

public void update_actions()
{
  int objs;

  if (environment(previous_object()))
    previous_object()->move(environment(previous_object()),1);
  filter_array(all_inventory(previous_object()),"move_inv",previous_object());
}

static void move_inv(object ob)
{
  if (living(ob)) ob->move(previous_object(),1);
}

#if __EFUN_DEFINED__(process_string)
nomask string process_string(mixed str) {
  raise_error(sprintf("Illegal use of process_string() (%O)",
    previous_object()));
}
#endif

// * Properties ggfs. mitspeichern

void save_object(string name)
{
  mapping properties;
  mapping save;
  mixed index;
  int i;

  save = allocate_mapping(0, 2);
  properties = previous_object()->QueryProperties();

  if(mappingp(properties))
  {
    // delete all entries in mapping properties without SAVE flag!
    index = m_indices(properties);
    for(i = sizeof(index)-1; i>=0;i--)
    {
      if(properties[index[i], F_MODE] & SAVE)
      {
        save[index[i]] = properties[index[i]];
        save[index[i], F_MODE] =
	  properties[index[i], F_MODE] &
	    (~(SETMNOTFOUND|QUERYMNOTFOUND|QUERYCACHED|SETCACHED));
      }
    }
  }
  else save = ([]);

  // save object!
  previous_object()->_set_save_data(save);
  funcall(bind_lambda(#'efun::save_object, previous_object()), name);
  previous_object()->_set_save_data(0);
}

// * Auch Properties laden

int restore_object(string name)
{
  int result;
  mixed index;
  mapping save;
  mapping properties;
  int i;
  closure cl;

  // get actual property settings (by create())
  properties = previous_object()->QueryProperties();

//  DEBUG(sprintf("RESTORE %O\n",name));
  // restore object
  result=funcall(bind_lambda(#'efun::restore_object, previous_object()), name);
  //'))
  save = previous_object()->_get_save_data();
  if(mappingp(save))
  {
    index = m_indices(save);
    for(i = sizeof(index)-1; i>=0; i--)
    {
      properties[index[i]] = save[index[i]];
      properties[index[i], F_MODE] = save[index[i], F_MODE]
	&~(SETCACHED|QUERYCACHED);
    }
  }
  else properties = ([]);

  // restore properties
  cl=unbound_lambda(({'arg}),
	                  ({#'call_other,({#'this_object}), //'
			    "SetProperties",'arg})); //'})}))
  (void)funcall(
		bind_lambda(
			    unbound_lambda(({'arg}), //'})
					   ({#'call_other,({#'this_object}),
					   "SetProperties",'arg})),//')
			    previous_object()),properties);
  previous_object()->_set_save_data(0);
  return result;
}

// * HB eines Objektes ein/ausschalten

int set_object_heart_beat(object ob, int flag)
{
  if (objectp(ob))
    return funcall(bind_lambda(#'efun::set_heart_beat,ob),flag);
}

// * Magierlevelgruppen ermitteln

int query_wiz_grp(mixed wiz)
{
  int lev;

  lev=query_wiz_level(wiz);
  if (lev<SEER_LVL) return 0;
  if (lev>=GOD_LVL) return lev;
  if (lev>=ARCH_LVL) return ARCH_GRP;
  if (lev>=ELDER_LVL) return ELDER_GRP;
  if (lev>=LORD_LVL) return LORD_GRP;
  if (lev>=SPECIAL_LVL) return SPECIAL_GRP;
  if (lev>=DOMAINMEMBER_LVL) return DOMAINMEMBER_GRP;
  if (lev>=WIZARD_LVL) return WIZARD_GRP;
  if (lev>=LEARNER_LVL) return LEARNER_GRP;
  return SEER_LVL;
}

// * wizlist ausgeben

varargs void wizlist(string name)
{
  int i, pos, total_cmd;
  int *cmds;
  mixed *a;
  mixed *b;

  if (!name) {
    if (this_player())
			name = getuid(this_player());
    if (!name)
      return;
  }
  a = transpose_array(wizlist_info());
  cmds = a[WL_COMMANDS];
  a[WL_COMMANDS] = a[0];
  a[0] = cmds;
  a = order_alist(a);
  cmds = a[0];
  a[0] = a[WL_COMMANDS];
  a[WL_COMMANDS] = cmds;
  if ((pos = member(a[WL_NAME], name)) < 0 && name != "ALL")
    return;
  b = allocate(sizeof(cmds));
  for (i = sizeof(cmds); i;) {
    b[<i] = i;
    total_cmd += cmds[--i];
  }
  a = transpose_array(a + ({b}) );
  if (name != "ALL") {
    if (pos + 18 < sizeof(cmds)) {
      a = a[pos-2..pos+2]+a[<15..];
    } else if (pos < sizeof(cmds) - 13) {
      a = a[pos-2..];
    } else {
      a = a[<15..];
    }
  }
  write("\nWizard top score list\n\n");
  if (total_cmd == 0)
    total_cmd = 1;
  for (i = sizeof(a); i; ) {
    b = a[<i--];
    printf("%-15s %5d %2d%% (%d)\t[%4dk,%5d] %6d %d\n",
	   b[WL_NAME], b[WL_COMMANDS], b[WL_COMMANDS] * 100 / total_cmd, b[<1],
	   b[WL_EVAL_COST] / 1000,
	   b[WL_HEART_BEATS], b[WL_EXTRA], b[WL_ARRAY_TOTAL]
	   );
  }
  printf("\nTotal         %7d     (%d)\n\n", total_cmd, sizeof(cmds));
}

#ifndef TESTMUD
varargs void call_out(mixed what, int delay, varargs mixed* args)
{
  mixed tmp;
  mixed *call_outs;
  int i;

  call_outs=call_out_info();
  i=sizeof(call_outs);
  if (geteuid(previous_object())!=ROOTID && i+1>600)
  {
    for (tmp=0;i--;)
    {
      if (call_outs[i][0]==previous_object() && call_outs[i][1]==what)
        tmp++;
    }
    if (tmp>=30)
    {
      VOICEMASTER->send("Debug",this_object(),
        sprintf("CALL_OUT overflow by object %O (%O)\n"
                ,previous_object(),what),MSG_SAY);
      destruct(previous_object());
      return;
    }
  }
  tmp=this_object();
  set_this_object(previous_object());
  apply(#'efun::call_out, what ,delay, args);
  set_this_object(tmp);
  return;
}
#endif

// * Zu einer closure das Objekt, an das sie gebunden ist, suchen

mixed query_closure_object(closure c) {
  return
    CLOSURE_IS_UNBOUND_LAMBDA(get_type_info(c, 1)) ?
      0 :
  (to_object(c) || -1);
}

// * Wir wollen nur EIN Argument ... ausserdem checks fuer den Netztotenraum

varargs void move_object(mixed what, mixed where) {
  object po,*oldenv,*newenv;

  po=previous_object();
  if (!where) {
    where=what;
    what=po;
  }
  if (((stringp(where) && where==NETDEAD_ROOM ) ||
       (objectp(where) && where==find_object(NETDEAD_ROOM))) &&
       objectp(what)) {
    if (!query_once_interactive(what)) {
      what->remove();
      if (what) destruct(what);
      return;
    }
    if (living(what) || interactive(what)) {
      log_file("NDEAD2",sprintf("TRIED TO MOVE TO NETDEAD: %O\n",what));
      return;
    }
    set_object_heart_beat(what,0);
  }
  oldenv=all_environment(what)||({});
  (void)funcall(bind_lambda(#'efun::move_object,po),what,where);
  newenv=(what && all_environment(what))||({});
  map_objects((oldenv-newenv)+newenv, "ContentChanged");
}

// * additional message handling

private int living_or_interactive(object o)
{
  return (living(o) || query_once_interactive(o));
}

void shout(string s) {
  filter_array(users(), lambda(({'u}),({#'&&,
				 ({#'environment, 'u}),
				 ({#'!=, 'u, ({#'this_player})}), //'
				   ({#'tell_object, 'u, s})
				   })));
}

mapping living_name_m, name_living_m, netdead;

// Wizinfo Bearbeitung

int ___query_actual_wizinfo_size() {
  mixed info;
  info=get_extra_wizinfo(0);
  if(pointerp(info))
    return sizeof(info);
  return -1;
}

void start_simul_efun() {
  mixed *info;

  if ( !(info = get_extra_wizinfo(0)) )
    set_extra_wizinfo(0, info = allocate(BACKBONE_WIZINFO_SIZE));
  if (!(living_name_m = info[LIVING_NAME]))
    living_name_m = info[LIVING_NAME] = allocate_mapping(0, 1);
  if (!(name_living_m = info[NAME_LIVING]))
    name_living_m = info[NAME_LIVING] = allocate_mapping(0, 1);
  if (!(last_reboot = info[LAST_REBOOT]))
    last_reboot = info[LAST_REBOOT] = time();
  if (!(netdead = info[NETDEAD_MAP]))
    netdead = info[NETDEAD_MAP] = ([]);
  if (!(ip_map = info[IP_NAMES]))
    ip_map = info[IP_NAMES] = allocate_mapping(0,2);
  if (find_call_out("clean_simul_efun") < 0)
    efun::call_out("clean_simul_efun", 10);
}

varargs void __clear_ip_map(int flag)
{
  mixed *info;

  info = get_extra_wizinfo(0);
  ip_map=info[IP_NAMES]=allocate_mapping(0,2);
}

mapping dump_ip_mapping()
{
  return copy_mapping(ip_map);
}

// * regelmaessig Listen von Ballast befreien

#define clean_log(s)

//#define clean_log(s) log_file("CLEAN_SIM",ctime(time())[4..18]+": "+(s));

static void clean_name_living_m(string *keys, int left, int num)
{
  int i, j;
  mixed a;

  while (left && num--)
  {
    if (pointerp(a = name_living_m[keys[--left]]) && member(a, 0)>=0)
    {
      a-=({0});
      name_living_m[keys[left]] = a;
    }
    if (!a || (pointerp(a) && !sizeof(a)))
    {
      clean_log("Toasting "+keys[left]+"\n");
      efun::m_delete(name_living_m, keys[left]);
    } else clean_log(sprintf("KEEPING %s (%O)\n",keys[left],pointerp(a)?sizeof(a):a));
  }
  if (left)
    efun::call_out("clean_name_living_m", 1, keys, left, 80);
  else
    clean_log("Clean process finished\n");
}

static void clean_netdead()
{
  int i;
  string *s;
  object ob;

  s=m_indices(netdead);
  for (i=sizeof(s)-1;i>=0;i--)
    if (!objectp(ob=netdead[s[i]]) || interactive(ob))
      efun::m_delete(netdead,s[i]);
}

static void clean_simul_efun() {
  /* There might be destructed objects as keys. */
  m_indices(living_name_m);
  remove_call_out("clean_simul_efun");
  if (find_call_out("clean_name_living_m") < 0) {
    clean_log("Starting clean process\n");
    efun::call_out(
		   "clean_name_living_m",
		   1,
		   m_indices(name_living_m),
		   sizeof(name_living_m),
		   80
		   );
  }
  efun::call_out("clean_simul_efun", 7200);
  efun::call_out("clean_netdead",2);
}

void set_object_living_name(string name, object obj)
{
  string old;
  mixed a;
  int i;

  if (previous_object()==obj || previous_object()==this_object() ||
      file_name(previous_object())==__MASTER_OBJECT__)
  {
    if (old = living_name_m[obj]) {
      if (pointerp(a = name_living_m[old])) {
	a[member(a, obj)] = 0;
      } else {
	efun::m_delete(name_living_m, old);
      }
    }
    living_name_m[obj] = name;
    if (a = name_living_m[name]) {
      if (!pointerp(a)) {
	name_living_m[name] = ({a, obj});
	return;
      }
      /* Try to reallocate entry from destructed object */
      if ((i = member(a, 0)) >= 0) {
	a[i] = obj;
	return;
      }
      name_living_m[name] = a + ({obj});
      return;
    }
    name_living_m[name] = obj;
  }
}

void set_living_name(string name)
{
  set_object_living_name(name,previous_object());
}

void remove_living_name()
{
  string name;

  if (!previous_object())
    return;
  if (name=living_name_m[previous_object()])
  {
    efun::m_delete(living_name_m,previous_object());
    if (objectp(name_living_m[name]))
    {
      if (name_living_m[name]==previous_object())
	efun::m_delete(name_living_m,name);
      return;
    }
    if (pointerp(name_living_m[name]))
    {
      name_living_m[name]-=({previous_object()});
      if (!sizeof(name_living_m[name]))
	efun::m_delete(name_living_m,name);
    }
  }
}

void _set_netdead()
{
  if (query_once_interactive(previous_object()))
    netdead[getuid(previous_object())]=previous_object();
}

void _remove_netdead()
{
  efun::m_delete(netdead,getuid(previous_object()));
}

object find_netdead(string name)
{
  return netdead[name];
}

string *dump_netdead()
{
  return m_indices(netdead);
}

object find_living(string name) {
  mixed *a, r;
  int i;

  if (pointerp(r = name_living_m[name])) {
    if (member(r,0)>=0)
      r-=({0});
    if (!sizeof(r)){
      efun::m_delete(name_living_m,name);
      clean_log(sprintf("find_living loescht %s\n",name));
      return 0;
    }
    if ( !living(r = (a = r)[0])) {
      for (i = sizeof(a); --i;) {
	if (living(a[<i])) {
	  r = a[<i];
	  a[<i] = a[0];
	  return a[0] = r;
	}
      }
    }
    return r;
  }
  return living(r) && r;
}

object *find_livings(string name)
{
  mixed r;

  if (pointerp(r=name_living_m[name]))
    r-=({0});
  else
    if (objectp(r))
      r=({r});
  if (!pointerp(r)||!sizeof(r))
    return 0;
  return r;
}

object find_player(string name) {
  mixed *a, r;
  int i;

  if (pointerp(r = name_living_m[name])) {
    if (member(r,0)>=0)
      r-=({0});
    if (!sizeof(r)){
      efun::m_delete(name_living_m,name);
      clean_log(sprintf("find_player loescht %s\n",name));
      return 0;
    }
    if ( !(r = (a = r)[0]) || !query_once_interactive(r)) {
      for (i = sizeof(a); --i;) {
	if (a[<i] && query_once_interactive(a[<i])) {
	  r = a[<i];
	  a[<i] = a[0];
	  return a[0] = r;
	}
      }
    }
    return r && query_once_interactive(r) && r;
  }
  return r && query_once_interactive(r) && r;
}

int check_match(string str)
{
  mixed *match;

  if (!(match=name_living_m[str]))
    return 0;
  if (!pointerp(match) || member(match,0)<0)
    return 1;
  if (sizeof(match))
    return 1;
  efun::m_delete(name_living_m,str);
  clean_log(sprintf("check_match loescht %s\n",str));
  return 0;
}

varargs mixed match_living(string str, int players_only)
{
  int i, s;
  mixed match,names,*a,r,*user;

  if (!str||str=="")
    return 0;
  if (check_match(str))
    return str;
  if (players_only) user=map_array(users(), #'getuid);
  else user=m_indices(name_living_m);
  s=strlen(str);
  match=0;
  for (i=sizeof(user)-1;i>=0;i--)
    if (str==user[i][0..s-1])
      if (match)
	return -1;
      else
      	if (check_match(user[i]))
	  match=user[i];
  if (!match)
    return -2;
  return match;
}

mixed *dump_livings()
{
  return sort_array(m_indices(name_living_m),#'>);
}

int send_imp(string host, int port, string message)
{
  return efun::send_imp(host,port,message);
}

#if __EFUN_DEFINED__(send_erq)
void cindent(string name)
{
    string valid;

    valid = funcall(
      bind_lambda(#'call_other, previous_object()),
      __MASTER_OBJECT__,
      "valid_write",
      name,
#if __EFUN_DEFINED__(geteuid)
      geteuid(previous_object()),
#else
      0,
#endif
      "cindent", previous_object()
    );
    if (valid)
      send_erq(ERQ_FORK, "indent_wrapper " + (stringp(valid) ? valid : name));
}
#else
void cindent(string name)
{
  raise_error("Sorry, no CINDENT today.\n");
}
#endif

#if !__EFUN_DEFINED__(query_comm_stat)
mixed *query_comm_stat()
{
  return ({0,0});
}
#endif

#if !__EFUN_DEFINED__(absolute_hb_count)
int absolute_hb_count()
{
  return (time() - last_reboot_time()) / 2;
}
#endif

void __set_environment(object ob, mixed target)
{
  string path;
  object obj;

  if (!objectp(ob))
    return;
  if (secure_level() < ARCH_LVL)
    return;
  if (objectp(target))
  {
    efun::set_environment(ob,target);
    return;
  }
  path=MASTER->_get_path(target,this_interactive());
  if (stringp(path) && file_size(path+".c")>=0 &&
      !catch(path->TU_GAR_NIX()))
  {
    obj=find_object(path);
    efun::set_environment(ob,obj);
    return;
  }
}

void _dump_wizlist(string file, int sortby) {
  int i;
  mixed *a;

  if (!(IS_LORD(this_interactive()) || IS_LORD(previous_object())))
    return;
  if (!__MASTER_OBJECT__->valid_write(file,geteuid(previous_object()),"write_file"))
  {
    write("NO WRITE PERMISSION\n");
    return;
  }
  a = wizlist_info();
  a = sort_array(a, lambda( ({'a,'b}),
			   ({#'<,
                             ({#'[,'a,sortby}),
                             ({#'[,'b,sortby})
                            })));
  rm(file);
  for (i=sizeof(a)-1;i>=0;i--)
    write_file(file,sprintf("%-11s: eval=%-8d cmds=%-6d HBs=%-5d array=%-5d mapping=%-7d\n",a[i][WL_NAME],a[i][WL_EVAL_COST],a[i][WL_COMMANDS],a[i][WL_HEART_BEATS],a[i][WL_ARRAY_TOTAL],a[i][WL_CALL_OUT]));
}

varargs object present_living(mixed what, object where, int flag) {
  object* inv;
  int i, j;
  if (!objectp(where)) {
    where=previous_object();
    inv=all_inventory(where);
    where=environment(where);
    if (where) inv+=all_inventory(where);
  } else inv=all_inventory(where);
  if (flag) inv=filter_array(inv, #'interactive);
  else inv=filter_array(inv, #'living);
  if (objectp(what)) {
    if (member(inv, what)) return what;
    return 0;
  }
  for (i=sizeof(inv); j<i; j++) if (inv[j]->id(what)) return inv[j];
  return 0;
}

varargs object deep_present(mixed what, object ob)
{
  object *inv;
  int cnt,i,size;
  string newwhat;

  if(!ob || !objectp(ob))
    ob=previous_object();
  if(objectp(what))
  {
    for(i=sizeof(inv=deep_inventory(ob))-1;i>=0;i--)
      if(inv[i]==what)
	return what;
  }
  else
  {
    if(stringp(what))
    {
      if(sscanf(what,"%s %d",newwhat,cnt)!=2)
        cnt=1;
      else
	what=newwhat;
      for(i=0,size=sizeof(inv=deep_inventory(ob));i<size;i++)
      {
	if(inv[i]->id(what))
	  if(!--cnt)
	    return inv[i];
      }
    }
  }
  return 0;
}

string unique_id(string filename)
{
  if (!stringp(filename))
    raise_error("bad argument type to simul_efun unique_id()\n");
  return "\nUNIQUE\t"+filename;
}

varargs int binary_message(mixed *message, int flags)
{
  return 0;
}

varargs int query_mud_port(object pl)
{
  // if (!pl) pl=users()[0];
  return efun::query_mud_port();
}

nomask void swap(object obj)
{
  write("Your are not allowed to swap objects by hand!\n");
  return;
}

nomask void garbage_collection()
{
  write("Call GC now and the mud will crash in 5-6 hours. DONT DO IT!\n");
  return;
}

int notify_fail(string str)
{
  if (!TP) return 0;
  TP->SetProp(P_ACTUAL_NOTIFY_FAIL,previous_object());
  return efun::notify_fail(str);
}

object shadow(object ob, int flag) {
  if(flag && objectp(ob) && query_once_interactive(ob))
    log_file(SHADOWLOGFILE, sprintf("%s: %O -> %O TI: %O\n",
      dtime(time())[5..], ob, previous_object(), this_interactive()));
  set_this_object(previous_object());
  return efun::shadow(ob, flag);
}

// Da wollte sich jemand einen Spass machen...
void remove_interactive(object ob) {
  if(ob && query_once_interactive(ob) && this_interactive() &&
    ob!=this_interactive() && getuid(this_interactive())!=ROOTID)
      log_file(RMILOGFILE,
       sprintf("%s: %s removed from: %O\n",
        dtime(time())[5..], capitalize(getuid(ob)), this_interactive()));
  efun::remove_interactive(ob);
}

string time2string( string format, int time )
{
  int days,hours,mins,secs,i,ch,max,abbr,dummy;
  string *parts, fmt;

  secs = time;
  mins = (time/60);
  hours = (time/3600);
  days = (time/86400);
  abbr = 0;

  parts = regexplode( format, "\(%\(-|\)[0-9]*[dhmsxDHMSX]\)|\(%%\)" );

  max = 0;
  for( i=1; i<sizeof(parts); i+=2 )
  {
    ch = parts[i][<1];
    switch( parts[i][<1] )
    {
    case 'x': case 'X':
        abbr = sscanf( parts[i], "%%%d", dummy ) && dummy==0;
        // NO break !
    case 'd': case 'D':
        max |= 7;
        break;
    case 'h': case 'H':
        max |= 3;
        break;
    case 'm': case 'M':
        max |= 1;
        break;
    }
  }
  if( max & 4 ) hours %= 24;
  if( max & 2 ) mins %= 60;
  if( max ) secs %= 60;

  for( i=1; i<sizeof(parts); i+=2 )
  {
    fmt = parts[i][0..<2];
    ch = parts[i][<1];
    if( ch=='x' )
    {
      if( days>0 ) ch='d';
      else if( hours>0 ) ch='h'; else ch = (mins>0) ? 'm' : 's';
    } else if( ch=='X' )
    {
      if( days>0 ) ch='D';
      else if( hours>0 ) ch='H'; else ch = (mins>0) ? 'M' : 'S';
    }
    switch( ch )
    {
      case 'd': parts[i] = sprintf( fmt+"d", days ); break;
      case 'h': parts[i] = sprintf( fmt+"d", hours ); break;
      case 'm': parts[i] = sprintf( fmt+"d", mins ); break;
      case 's': parts[i] = sprintf( fmt+"d", secs ); break;
      case 'D':
        if(abbr) parts[i] = "d"; else
        parts[i] = sprintf( fmt+"s", (days==1) ? "Tag" : "Tage" );
        break;
      case 'H':
        if(abbr) parts[i] = "h"; else
        parts[i] = sprintf( fmt+"s", (hours==1) ? "Stunde" : "Stunden" );
        break;
      case 'M':
        if(abbr) parts[i] = "m"; else
        parts[i] = sprintf( fmt+"s", (mins==1) ? "Minute" : "Minuten" );
        break;
      case 'S':
        if(abbr) parts[i] = "s"; else
        parts[i] = sprintf( fmt+"s", (secs==1) ? "Sekunde" : "Sekunden" );
        break;
      case '%':
        parts[i] = "%";
        break;
      }
    }
    return implode( parts, "" );
}

nomask varargs mixed debug_info(varargs mixed* args)
{
  return apply(#'efun::debug_info, args);
}

varargs string parse_mess(string str, object obj)
{
  if (!str || !stringp(str) || str=="" || strstr(str,"&",0)==-1)
    return str;

  if (!obj || !objectp(obj))
    obj = this_player();

  if (!obj || !objectp(obj))
    return str;

  str = efun::implode(efun::explode(str, "&&WER&&"),
        obj->name(WER,2));
  str = efun::implode(efun::explode(str, "&&WESSEN&&"),
        obj->name(WESSEN,2));
  str = efun::implode(efun::explode(str, "&&WEM&&"),
        obj->name(WEM,2));
  str = efun::implode(efun::explode(str, "&&WEN&&"),
        obj->name(WEN,2));
  str = efun::implode(efun::explode(str, "&&"),
        obj->name(WER,2));
  str = efun::implode(efun::explode(str, "&!WER!&"),
        obj->QueryPronoun(WER));
  str = efun::implode(efun::explode(str, "&!WESSEN!&"),
        obj->QueryPronoun(WESSEN));
  str = efun::implode(efun::explode(str, "&!WEM!&"),
        obj->QueryPronoun(WEM));
  str = efun::implode(efun::explode(str, "&!WEN!&"),
        obj->QueryPronoun(WEN));
  str = efun::implode(efun::explode(str, "&!"),
        obj->QueryPronoun(WER));
  str = efun::implode(efun::explode(str, "&%WER%&"),
        obj->QueryPossPronoun(MALE,WER));
  str = efun::implode(efun::explode(str, "&%WESSEN%&"),
        obj->QueryPossPronoun(MALE,WESSEN));
  str = efun::implode(efun::explode(str, "&%WEM%&"),
        obj->QueryPossPronoun(MALE,WEM));
  str = efun::implode(efun::explode(str, "&%WEN%&"),
        obj->QueryPossPronoun(MALE,WEN));
  str = efun::implode(efun::explode(str, "&%FWER%&"),
        obj->QueryPossPronoun(FEMALE,WER));
  str = efun::implode(efun::explode(str, "&%FWESSEN%&"),
        obj->QueryPossPronoun(FEMALE,WESSEN));
  str = efun::implode(efun::explode(str, "&%FWEM%&"),
        obj->QueryPossPronoun(FEMALE,WEM));
  str = efun::implode(efun::explode(str, "&%FWEN%&"),
        obj->QueryPossPronoun(FEMALE,WEN));
  str = efun::implode(efun::explode(str, "&%NWER%&"),
        obj->QueryPossPronoun(NEUTER,WER));
  str = efun::implode(efun::explode(str, "&%NWESSEN%&"),
        obj->QueryPossPronoun(NEUTER,WESSEN));
  str = efun::implode(efun::explode(str, "&%NWEM%&"),
        obj->QueryPossPronoun(NEUTER,WEM));
  str = efun::implode(efun::explode(str, "&%NWEN%&"),
        obj->QueryPossPronoun(NEUTER,WEN));
  str = efun::implode(efun::explode(str, "&%"),
        obj->QueryPossPronoun(MALE,WER));

  return capitalize(str);
}


//////////////// Event sefuns ///////////////////


int
listen_event(string type, int prio, mixed callback) {
  if(!callback)
    callback="receive_event";
  if(stringp(callback))
    callback=funcall(bind_lambda(#'symbol_function,previous_object()),
                     callback,previous_object());
  if(!closurep(callback))
    return 0;
  return funcall(bind_lambda(#'call_other,previous_object()),
    EVENTD, "listen", type, prio, callback);
}

int
unlisten_event(string type, int prio, mixed callback) {
  if(!callback)
    callback="receive_event";
  if(stringp(callback))
    callback=funcall(bind_lambda(#'symbol_function,previous_object()),
                     callback,previous_object());
  if(!closurep(callback))
    return 0;
  return funcall(bind_lambda(#'call_other,previous_object()),
    EVENTD, "unlisten", type, prio, callback);
}

void
set_global_listener(string type, status listening) {
  funcall(bind_lambda(#'call_other,previous_object()),
    EVENTD, "set_global", type, listening);
}

varargs mixed
send_event(string type, mapping data, mixed dest, int mode) {
  dest=map_array((pointerp(dest)?dest:({dest})), lambda( ({'a}),
         ({#'?, ({#'objectp, 'a}), 'a, ({#'load_object, 'a}) }) ));
  return funcall(bind_lambda(#'call_other,previous_object()),
    EVENTD, "send", type, data, dest, mode);
}

varargs void
cancel_event(mixed info) {
  funcall(bind_lambda(#'call_other,previous_object()),
    EVENTD, "cancel_event", info);
}

varargs void
handle_event(mixed info) {
  funcall(bind_lambda(#'call_other,previous_object()),
    EVENTD, "handle_event", info);

}

varargs void input_to(mixed fun, int onoff, varargs mixed *args) {
    mixed *arr;
    mapping TN;
    int i;

    if (!this_player() || !previous_object()) return;

    arr = ({ fun, onoff }) + args;

    for (i = sizeof(arr) - 1; i > 1; i--) {
        if ( pointerp(arr[i]) )
            arr[i] = quote(arr[i]);
    }

    TN = (mapping) this_player()->query_telnet_neg();
    if (mappingp(TN) && mappingp(TN["received"]) &&
         (TN["received"][TELOPT_EOR,1] == DO)) {
        funcall(bind_lambda(#'efun::binary_message, this_player()),
            ({ IAC, EOR }));
    }

    funcall( bind_lambda(unbound_lambda(({}),
        ({ #'efun::input_to }) + arr), previous_object()));
}

// Lesbare Liste von Woertern erstellen
string list_words(string *words)
{
  switch (sizeof(words))
  {
    case 0:
      return "";
    case 1:
      return words[0];
  }
  return implode(words[0..<2], ", ")+" und "+words[<1];
}

/******************************************************************
**                                                               **
** functions for rpg system                                      **
**                                                               **
** they are needed anywhere, so we use simul_efun                **
**                                                               **
******************************************************************/

// d100 open ended low/high, terminated at -300/+500
int d100()
{
  int roll;

  roll=random(100)+1;

  if (roll<6)
    return _d100low(roll);
  if (roll>95)
    return _d100high(roll);
  return roll;
}

// d100 open ended low, terminated at -300
int d100low()
{
  int roll;

  roll=random(100)+1;

  if (roll<6)
    return _d100low(roll);
  return roll;
}

// d100 open ended high, terminated at +500
int d100high()
{
  int roll;

  roll=random(100)+1;

  if (roll>95)
    return _d100high(roll);
  return roll;
}

// internal d100low
int _d100low(int last)
{
  int roll;

  roll=random(100)+1;

  if (roll<96 || last-roll<-300)
    return last-roll;
  return _d100low(last-roll);
}

// internal d100high
int _d100high(int last)
{
  int roll;

  roll=random(100)+1;

  if (roll<96 || last+roll>500)
    return last+roll;
  return _d100high(last+roll);
}

// what kind of success/failure do we have?
// defines found in /sys/rpgsys.h
int EvalCheckResult(int roll)
{
  switch(roll)
  {
    case CHRT_BLUNDER:
      return CH_BLUNDER;
      break;
    case CHRT_SPECTACULAR_FAILURE:
      return CH_SPECTACULAR_FAILURE;
      break;
    case CHRT_ABSOLUTE_FAILURE:
      return CH_ABSOLUTE_FAILURE;
      break;
    case CHRT_FAILURE:
      return CH_FAILURE;
      break;
    case CHRT_SUCCESS:
      return CH_SUCCESS;
      break;
    case CHRT_ABSOLUTE_SUCCESS:
      return CH_ABSOLUTE_SUCCESS;
      break;
    case CHRT_SPECTACULAR_SUCCESS:
      return CH_SPECTACULAR_SUCCESS;
      break;
    case CHRT_LEGENDARY_SUCCESS:
      return CH_LEGENDARY_SUCCESS;
      break;
    default:
      return 0;
      break;
  }
}

// just check success
int EvalCheck(int roll)
{
  if (roll<CHRT_SUCCESS_THRESHOLD)
    return CH_FAILURE;
  return CH_SUCCESS;
}
