/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: skillmaster.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// SECURE/SKILLMASTER.C - SkillMaster Verwaltung der Fertigkeiten
// 
// Inspired by Wunderland Mudlib
//
// Autoren: Andara & Arachna 1994
//          Holger 1998
//
// $Log: skillmaster.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:46  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:11  en
// MUDLib CVS Preperation
//

#include <mud.h>
#include <wizlevels.h>
#include <combat.h>
#include <defines.h>
#include <properties.h>
#include <living/skills.h>

#define NEED_PROTOTYPES

#include <skillmaster.h>

#define DEBUG(x) if(find_player("largo")) \
                   tell_object(find_player("largo"),sprintf("%O\n",x))

static mixed polls;
private mapping skills;

void save_info() {
  save_object(SKILLS);
}

void create() {
  if(clonep()) {
    destruct(ME);
    return;
  }
  seteuid(getuid(ME));
  if(!restore_object(SKILLS))
    skills = ([]);
  polls=({});
}

private int secure() {
  if(!previous_object())
    return 0;
  if(geteuid(previous_object()) == ROOTID)
    return 1;
  if(this_interactive() != PL)
    return 0;
  if(!IS_LORD(this_interactive()))
    return 0;
  return 1;
}

/*
 * AddAbility()
 *   Fuegt eine Fertigkeit (Skill, Spell oder Combat-Skill) dem Mapping 
 *   'skills' hinzu. (Manpage)
 */
int AddAbility(string SkillName, string Description, int BeginValue, int BeginLevel,
               int Costs, int Factor, string Stat, int Delay, mixed Magic, int Type,
               string File, string Item, mixed Verben, int Flags) {
  int i, j;
  if(!secure())
    return 0;
  if(!stringp(SkillName) || strlen(SkillName) < 3)
    return -1;
  if(skills[SkillName])
    return -2;
  if(!stringp(Description) || strlen(Description) < 10)
    return -3;
  if(BeginValue < 0 || BeginValue > SM_MAX_BEGINVALUE)
    return -4;
  if(BeginLevel < 0 || BeginLevel > MUD_MAX_LEVEL)
    return -5;
  if(Costs < 0 || Costs > SM_MAX_COSTS)
    return -6;
  if((Stat!=A_INT) && (Stat!=A_DEX) && (Stat!=A_CON) && (Stat!=A_STR))
    return -7;
  if(Delay < 0 || Delay > SM_MAX_DELAY)
    return -8;
  if(!VALID_SM_TYPE(Type))
    return -11;
  if(Flags<0)
    return -12;

  if(Type==SM_SPELL || Type==SM_SKILL) {
    if(!stringp(File) || !strlen(File))
      return -13;
    call_other(File,"???",0);
    if(!find_object(File))
      return -14;
    if(!function_exists("_cast_"+SkillName, find_object(File)))
      return -15;
    if(Factor < 0 || Factor > SM_MAX_FACTOR1)
      return -16;
    Magic="";
    if(!pointerp(Verben) && !stringp(Verben))
      return -25;
    if(pointerp(Verben) && sizeof(Verben))
      for(i=sizeof(Verben);i--;) {
        if(!stringp(Verben[i]))
	  return -26;
      }
    if(stringp(Verben))
      Verben=({Verben});
    Verben-=({""});
    }

  if(Type==SM_ATTACK || Type==SM_DEFEND) {
    if(!stringp(Magic))
      return -9;
    if(strlen(Magic) && !VALID_MAGIC_TYPE(Magic))
      return -10;

    // Arrays not supported yet by living/combat.c
    // if(!stringp(Magic) && !pointerp(Magic))
    //   return -9;
    // if(pointerp(Magic))
    //   for(i=sizeof(Magic);i--;) {
    //     if(strlen(Magic[i]) && !VALID_MAGIC_TYPE(Magic[i]))
    //       return -10;
    //   }
    // else
    //   if(strlen(Magic) && !VALID_MAGIC_TYPE(Magic))
    //     return -10;

    if(pointerp(File) && strlen(File)) {
      call_other(File,"???",0);
      if(!find_object(File))
        return -17;
      if(!function_exists("_cast_"+SkillName, find_object(File)))
        return -18;
    }
    if(BeginValue > 0)
      return -19;
    if(Costs > 0)
      return -20;
    if(Factor < 1 || Factor > SM_MAX_FACTOR2)
      return -21;
    if(Delay > 0)
      return -22;
    if(Type==SM_ATTACK) {
      if(!stringp(Item) || (strlen(Item) && !VALID_WEAPON_TYPE(Item)))
        return -23;
    }
    if(Type==SM_DEFEND) {
      if(!stringp(Item) || (strlen(Item) && !VALID_ARMOUR_TYPE(Item)))
        return -24;
    }
    Verben=({});
  }
  
  skills+=([ SkillName : ({
             Description, BeginValue, BeginLevel, Costs, Factor, 
             Stat, Delay, Magic, Type, File, Item, Verben, Flags }) ]);

  save_info();
  return 1;
}

/*
 * RemoveAbility()
 *    Entfernen einer Fertigkeit aus dem Skillmaster.
 *    (Spell, Skill oder Combat-Skill) (Manpage)
 */
int RemoveAbility(string ability) {
  if(!secure()) 
    return 0;
  if(skills[ability]) {
    skills=m_delete(skills, ability);
    save_info();
    return 1;
  }
  return -1;
}

/*
 * Execute()
 *  Funktion:
 *    Wird vom Spieler immer aufgerufen, wenn er eine Fertigkeit ausfuehrt.
 *    Es werden alle moeglichen Dinge getestet.
 *  Parameter:
 *    SkillName - Name des Skills
 *    Player    - vom wem dieser Aufruf stammt
 *    Argument  - Kommandozeilen-Argumente als Array aus Strings
 *  Rueckgabe:
 *       1      - wenn der Spell/Skill ordnungsgemaess ausgefuehrt wurde
 *       0      - wenn nicht
 */
int Execute(string SkillName, object Player, mixed Argument) {
  object obj;
  int  res, cost, wert, del, Art, co;
  string file, delay_msg;

  if((Art = SM->QueryProp(SkillName, P_SM_TYPE))<0 || Art>=SM_ATTACK)
    return 0;
  
  if(!strlen(file=QueryProp(SkillName, P_SM_FILE)))
    return 0;

  if(!(QueryProp(SkillName, P_SM_FLAGS)&SM_F_GHOST))
    if(Player->QueryProp(P_GHOST)) {
      tell_object(Player, "Das kannst Du als Geist doch nicht!\n");
      return 1;
    }
  
  if(Player->QueryDelay(SkillName)) {
    if(delay_msg=call_other(file, "get_delay_msg", SkillName, Player))
      tell_object(Player, to_string(delay_msg)+"\n");
    else
      tell_object(Player, "Du bist mental noch zu erschoepft von Deinem "
        "anderen Spruch.\n");
     return 1;
  }

  if(Player->QueryProp(P_DISABLE_ATTACK)) {
    if(QueryProp(SkillName, P_SM_TYPE)==SM_SKILL)
      tell_object(Player, "Du bist gelaehmt und kannst diese Faehigkeit "
        "nicht anwenden.\n");
    else
      tell_object(Player, "Du bist gelaehmt und kannst diesen Zauberspruch "+
       "nicht sprechen.\n");
    return 1;
  }

  if(Player->QueryProp(P_SP)<(cost=QueryProp(SkillName, P_SM_COST))) {
    if(QueryProp(SkillName, P_SM_TYPE)==SM_SKILL)
      tell_object(Player, "Du hast nicht genuegend Magiepunkte, um diese "
        "Faehigkeit anzuwenden.\n");
      else 
        tell_object(Player, "Du hast nicht genuegend Magiepunkte, um diesen "
          "Zauberspruch anzuwenden.\n");
    return 1;
  }

  if(extern_call()) {
    if(sizeof(FindPoll(SkillName, Player))) {
      tell_object(Player, "Jaja, das machst Du doch schon!\n");
      return 1;
    }
    if(sizeof(CountPolls(Player))==Player->QueryProp(P_MAX_SKILLS)) {
      tell_object(Player, "Du verhaspelst Dich bei dem Versuch mehrere Dinge "
        "gleichzeitig zu tun.\n");
      RemovePolls(Player);
      return 1;
    }
  }
  
  if((QueryProp(SkillName, P_SM_TYPE)!=SM_SKILL) && 
    (random(100) < environment(Player)->QueryProp(P_NOMAGIC))) {
      tell_object(Player, "Deine Magie scheint hier nicht zu wirken.\n");
      res = ERFOLG;
  }
  else {
    if(extern_call() && QueryProp(SkillName, P_SM_FLAGS)&SM_F_POLL) {
      if(register_poll(SkillName, Player, Argument)>0)
        res=ERFOLG2;
      else
        res=FEHLER;
    }
    else
      res=call_other(file, "_cast_"+SkillName, Player, Argument);
  }
  
  if(!Player) return res;

  if(res==ERFOLG || res==MISSERFOLG) {
    if(!(del=call_other(file, "get_delay", SkillName, Player))) {
      del=QueryProp(SkillName, P_SM_DELAY);
    }
    Player->SetDelayTime(SkillName, del);
    Player->restore_spell_points(-cost);
  }
  
  if(res == MISSERFOLG) { 
    wert=Player->GetProbability(SkillName) +
      (int)random(((Player->QueryAttribute(QueryProp(SkillName, P_SM_STAT)) *
      QueryProp(SkillName, P_SM_FACTOR))/40)+1);
    wert=(wert>1000?1000:wert);
    Player->GiveAbility(SkillName, wert);
    if(QueryProp(SkillName, P_SM_TYPE)==SM_SKILL)
      tell_object(Player, "Du versucht vergeblich, Deine Faehigkeit "
        "anzuwenden.\n");
    else
      tell_object(Player, "Der Zauberspruch ist missglueckt.\n");
    tell_object(Player, "Du lernst aus Deinem Fehler.\n");
    res=-3;
  }

  return res;
}

/*
 * Valid()
 * Funktion: Gibt den Typ der Fertigkeit zurueck oder -1
 * Argumente:
 *  ability - name der Fertigkeit die ueberprueft werden soll
 * Rueckgabe:
 *      0     - Es liegt ein normaler Spell vor
 *      1     - Es liegt ein normaler Skill vor
 *      2     - Es liegt ein Combat-Spell vor
 *      3     - Es liegt ein Attack-Skill vor
 *      4     - Es liegt ein Defend-Skill vor
 *     -1     - Diese Fertigkeit ist nicht im Skillmaster angemeldet
 */
int Valid(string ability) {
  int ret;
  if(!skills[ability])
    return -1;
  return QueryProp(ability, P_SM_TYPE);
}

mixed QueryProp(string SkillName, mixed prop) {
  if(skills[SkillName]) {
    if(prop==P_SM_ALL)
      return skills[SkillName];
    if(sizeof(skills[SkillName])>prop)
      return skills[SkillName][prop];
  }
  switch(prop) {
    case P_SM_ALL:
      return ({});
    case P_SM_DESCRIPTION :
    case P_SM_STAT :
    case P_SM_MAGIC:
    case P_SM_FILE:
    case P_SM_ITEM:
      return "";
    case P_SM_BEGIN :
    case P_SM_LEVEL :
    case P_SM_COST :
    case P_SM_FACTOR :
    case P_SM_DELAY :
    case P_SM_TYPE:
      return -1;
    case P_SM_VERBS:
      return ({});
    case P_SM_FLAGS:
      return 0;
  }
  return -1;
}

/* polling funs */

/*
 * register_poll()
 *  Funktion:
 *    checkt _poll_<ability> und fuegt es ggf. an die polls-liste an
 *  Returnwert:
 *    0 - nicht angenommen (z.B. keine pollfunc)
 *    1 - zu Liste hinzugefuegt
 *   -1 - (FEHLER) nicht angenommen
 */
static int register_poll(string ability, object player, mixed args) {
  int res, count;
  if((res=call_other(QueryProp(ability, P_SM_FILE),
    "_poll_"+ability, player, args, 0))==0)
    return 0;
  if(res<0)
    return -1;
  polls+=({ ({ time()+res, ability, player, args, 1 }) });
  player->AddMoveHook(ME);
  poll_loop();
  return 1;
}

static int greater(mixed p1, mixed p2) {
  return p1[0]>p2[0];
}

static int findpl(mixed arr, object pl) {
  return (arr[2]==pl);
}

static int notpl(mixed arr, object pl) {
  return !findpl(arr, pl);
}

/* zaehlt alle aktiven Polls des Spielers */
mixed CountPolls(object player) {
  return filter_array(polls, #'findpl, player);
}

static int findabil(mixed arr, string ab) {
  return (arr[1]==ab);
}

/* sucht, ob schon genau so ein Poll des Spielers laeuft */
mixed FindPoll(string ability, object player) {
  mixed tpolls;
  tpolls=filter_array(polls, #'findpl, player);
  return filter_array(tpolls, #'findabil, ability);
}

/* fuehrt den Poll durch */
static mixed do_poll(mixed entry) {
  int res;
  if(sizeof(entry) && entry[0]<=time() && living(entry[2])) {
    if(query_once_interactive(entry[2]) && !interactive(entry[2]))
      return ({});
    if((res=call_other(QueryProp(entry[1], P_SM_FILE), 
      "_poll_"+entry[1], entry[2], entry[3], entry[4]))>0)
        return ({ time()+res, entry[1], entry[2], entry[3], entry[4]+1 });
    else {
      entry[2]->RemoveMoveHook(ME);
      if(res==0) // res<0 Abbruch -> Kein execute!
        Execute(entry[1],entry[2],entry[3]);
      return ({});
    }
  }
  return entry;
}

/* hauptschleife */
static void poll_loop() {
  int i, res;
  while(remove_call_out("poll_loop")!=-1);
  if(!sizeof(polls))
    return;
  polls=map_array(polls, #'do_poll);
  polls-=({({})});
  polls=sort_array(polls, #'greater);
  if(sizeof(polls))
    call_out("poll_loop",polls[i][0]-time());
}
		   
/* Entfernt alle Polls des players */
void RemovePolls(object player) {
  player->RemoveMoveHook(ME);
  polls=filter_array(polls, #'notpl, player);
}

void NotifyLivingMove(object living, object old_env) {
  if(sizeof(CountPolls(living))) {
    tell_object(living, "Durch Deine Bewegung kommst Du voellig aus dem "
      "Konzept und verhaspelst Dich.\n");
    RemovePolls(living);
  }
}


/* stupid helpfuns - DO NOT USE */

/*
 * find_argument()
 *  Aufgabe:    versucht, im Spieler oder in seiner Umgebung ein Objekt zu finden, auf welches der
 *              Name str passt
 *  Parameter:  str     - Name des zu suchenden Objektes
 *              Player  - Wer sucht denn?
 *  Rueckgabewert:  Feld, das Objekt(e) enthaelt, wenn erfolgreich,
 *                  leeres Feld sonst
 */
mixed find_argument(mixed Argument, object Player, int option) {
  if (!sizeof(Argument))
    if (option == SM_ARG_ENEMY)
      Argument = all_inventory(environment(Player));
    else
      return ({});

   return map_array(Argument, #'Get_Skill_Arguments, Player, option) - ({ 0 });
}

mixed Get_Skill_Arguments(mixed obj, object Player, int option) {
  mixed tmp;
  object ob;

  if (((ob=present(obj, environment(Player))) ||  (ob=present(obj, Player))) &&
        ob != Player)
   switch (option)
   {
   case SM_ARG_ALL: return ob;
   case SM_ARG_LIVING: return living(ob) ? ob:0;
   case SM_ARG_NOLIVING: return living(ob) ? 0:ob;
   case SM_ARG_ENEMY:
    if (sizeof(tmp=ob->QueryEnemies()) && (member(tmp[0], Player)!=-1))
      return obj;
    else
      return 0;
    default: return 0;
   }
  return 0;
}

/* debugging funs */

void DumpAbilities() {
  string text;
  mixed names, value;
  int i;

  names = sort_array(m_indices(skills), #'>);
  text ="("+dtime(time())+")\n";
  text+="Normale Spells und Skills\n";
  text+="=========================\n";
  for(i=0; i<sizeof(names); i++) {
    value=skills[names[i]];
    if(value[P_SM_TYPE]==SM_SPELL || value[P_SM_TYPE]==SM_SKILL) {
      if(value[P_SM_TYPE]==SM_SPELL)
	text+="SPELL (Type 0) ";
      else
	text+="SKILL (Type 1) ";
      text+=sprintf("'%s' :\n  Description  : %s\n"
		            "  Beginvalue   : %d\n"
		            "  BeginLevel   : %d\n"
		            "  Kosten       : %d\n"
		            "  Faktor       : %d\n"
		            "  Stat         : %s\n"
                            "  Delay        : %d\n"
		            "  File         : %s\n"
		            "  Spez. Verben : %s\n"
		            "  Flags        : %d\n",
        names[i], value[P_SM_DESCRIPTION], value[P_SM_BEGIN], 
        value[P_SM_LEVEL], value[P_SM_COST], value[P_SM_FACTOR], 
        value[P_SM_STAT], value[P_SM_DELAY], value[P_SM_FILE], 
        (sizeof(value)>P_SM_VERBS ?
        "({"+implode(value[P_SM_VERBS],", ")+"})":"keine"),
        (sizeof(value)>P_SM_FLAGS ? value[P_SM_FLAGS] : 0));
    }
  }
  text+="\nCombat-Skills\n";
  text+="=============\n";
  for (i=0; i<sizeof(names); i++) {
    value = skills[names[i]];
    if(value[P_SM_TYPE]==SM_ATTACK || value[P_SM_TYPE]==SM_DEFEND) {
      if(value[P_SM_TYPE]==SM_ATTACK)
        text+="ATTACK-SKILL (Type 3) ";
      else
        text+="DEFEND_SKILL (Type 4) ";
      text+=sprintf("'%s' :\n  Description  : %s\n"
                            "  Beginvalue   : %d\n"
                            "  BeginLevel   : %d\n"
                            "  Kosten       : %d\n"
                            "  Faktor       : %d\n"
                            "  Stat         : %s\n"
                            "  Magic        : %s\n"
                            "  File         : %s\n"
                            "  Item         : %s\n"
                            "  Flags        : %d\n",
        names[i], value[P_SM_DESCRIPTION], value[P_SM_BEGIN], 
        value[P_SM_LEVEL], value[P_SM_COST], value[P_SM_FACTOR], 
        value[P_SM_STAT],
        (pointerp(value[P_SM_MAGIC]) ? 
         "({"+implode(value[P_SM_MAGIC],", ")+"})" : 
         value[P_SM_MAGIC]), 
        value[P_SM_FILE], 
        value[P_SM_ITEM],
        (sizeof(value)>P_SM_FLAGS ? value[P_SM_FLAGS] : 0));
    }
  }
  rm(DUMPFILE);
  write_file(DUMPFILE,text);
  return;
} 

mapping QueryAbilities() { 
  return skills; 
}

mixed QueryPolls() { 
  return polls;
}
