/*******************
** Eldarea MUDLib **
********************
**
** secure/skillmaster.h - skillmaster header file
**
** CVS DATA
** $Date: 2001/08/21 11:13:07 $
** $Revision: 1.3 $
**
** longdesc
**
** CVS History
**
** $Log: skillmaster.h,v $
** Revision 1.3  2001/08/21 11:13:07  eldarea
** corrected #endif (inserted comment)
**
** Revision 1.2  2001/08/21 11:11:56  eldarea
** correcte RemoveAbility() prototype
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

#ifndef __SKILLMASTER_H__
#define __SKILLMASTER_H__

#define SKILLS 	        "/etc/skills"
#define LOGFILE	        "SKILLMASTER"
#define DUMPFILE        "/log/ABILITYDUMP"

#define SM_MAX_COSTS        200
#define SM_MAX_BEGINVALUE   500
#define SM_MAX_FACTOR1       50
#define SM_MAX_FACTOR2      200
#define SM_MAX_DELAY        900

#endif // __SKILLMASTER_H__

#ifdef NEED_PROTOTYPES

#ifndef __SKILLMASTER_H_PROTO__
#define __SKILLMASTER_H_PROTO__

private void save_info();
private int secure();

void create();

/* abilities */
int AddAbility(string SkillName, string Description, int BeginValue, int BeginLevel,
               int Costs, int Factor, string Stat, int Delay, mixed Magic, int Type,
               string File, string Item, mixed Verben, int Flags); 
int RemoveAbility(string ability);
int Execute2(string SkillName, object Player, mixed Argument);
int Execute(string SkillName, object Player, mixed Argument);
int Valid(string ability);
mixed QueryProp(string SkillName, mixed prop);  

/* polling funs */
static int register_poll(string ability, object player, mixed args);
static mixed do_poll(mixed entry);
static int greater(mixed p1, mixed p2);
static int findpl(mixed arr, object pl);
static int notpl(mixed arr, object pl);
mixed CountPolls(object player);
static int findabil(mixed arr, string ab);
mixed FindPoll(string ability, object player);
static void poll_loop();
void RemovePolls(object player);
void NotifyLivingMove(object living, object old_env);

/* some stupid help-funs */
mixed find_argument(mixed Argument, object Player, int option);
private mixed Get_Skill_Arguments(mixed obj, object Player, int option);

/* debugging */
void DumpAbilities();
mapping QueryAbilities();
mixed QueryPolls();

#endif /* __SKILLMASTER_H_PROTO__ */

#endif // NEED_PROTOYPES
