/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: _telnet.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
inherit "/std/thing";

#define TELNET_OB     "secure/sockets/telnet_ob"
#include <wizlevels.h>
#include <properties.h>

void create() {
	if (!clonep()) return ;
	::create();
	SetProp(P_LONG, "Das Telnet Object. Versuch mal 'thilfe'.");
	SetProp(P_NAME, "Telnet");
	SetProp(P_PLURAL, "");
	SetProp(P_GENDER, NEUTER);
	AddId("telnet");
	
	AddCmd("thilfe","help");
	AddCmd("telnet","main");
}

mapping sessions = ([ ]);

status main(string str) {
  string host;
  int port;
  if (!IS_ELDER(this_player()))
   return 0;
  if (!str) {
    if (sessions[this_player()] == 0)
     return
      notify_fail("telnet: Could not find detatched session.\n"),0;
    (void)sessions[this_player()]->reattach();
    return 1;
    }
  if (str == "-q") {
    if (sessions[this_player()] == 0)
     return
      notify_fail("telnet: Could not find session.\n"),0;
    destruct(sessions[this_player()]);
    return 1;
    }
  if (sessions[this_player()])
   return
    notify_fail("telnet: You have a detatched session.\n"
                "Type 'telnet' to reattach to it.\n"),0;
  if (sscanf(str, "%s %d", host, port) != 2)
   host = str, port = 23;
  sessions[this_player()] = clone_object(TELNET_OB);
  (void)sessions[this_player()]->start(host, port);
  return 1;
  }

int help() {
  write("telnet [<address> [<port>] | -q]\n"
        "Telnet to the address given, or reactivate a dormant session.\n"
        "You may only have one session at any given time.\n"
        "Several telnet commands are available, a telnet\n"
        "command starts with the escape character (^[).\n"
        "Use \"^[?\" to get a list of available telnet commands.\n"
        "The \"-q\" option allows you to close a telnet session\n"
        "from the commandline.\n");
  return 1;
  }

mapping query_sessions() { return copy_mapping(sessions); }
