/*******************
** Eldarea MUDLib **
********************
**
** /secure/syslogd.c - mud log facility
**
** CVS DATA
** $Date$
** $Revision$
**
** CVS History
**
** $Log$
**
*/

#include <wizlevels.h>
#include <syslog.h>

#define SYSLOG_SAVE "/secure/ARCH/save/syslog"

static void AddPriv(string * filearr, int valid_types, mapping files);

static mapping privileges;

nomask void create() 
{
  if( clonep(this_object()) ) 
  {
    destruct( this_object() );
    return;
  }
  seteuid( getuid() );
  //restore_object(SYSLOG_SAVE);

  privileges = allocate_mapping(0,3);
  // build basic privileges
  AddPriv(({"secure"}),0,([]));
  AddPriv(({"players"}),0,([]));
  AddPriv(({"global"}),0,([]));
  //AddPriv(({""}),0,0);
  //AddPriv(({""}),0,0);
  //AddPriv(({""}),0,0);
  //AddPriv(({""}),0,0);
  //AddPriv(({""}),0,0);
  //AddPriv(({""}),0,0);
  //AddPriv(({""}),0,0);
    
  }
}

nomask int log_message(object caller, string message, mixed file, int type, int severity)
{
  string * filearr;
  string * files;
  string pre;
  
  if (!extern_call())
  {
    filearr = explode(load_name(this_object()),"/");
  }
  else if ( load_name(previous_object())!="/secure/simul_efun" 
         && load_name(previous_object())!="/secure/spare_simul_efun")
  {
    return 0;
  }
  else
  {
    filearr = explode(load_name(caller),"/");
    filearr[<1] = explode(filearr[<1],"#")[0];
  }

  if (type&LOG_ARCH)
  {
    pre = "/log/ARCH";
  }
  else if (type&LOG_LORD)
  {
    pre = "/log/LORD";  
  }
  else
  {
    pre = "/log  
  }

#define LOG_SYSTEM        1
#define LOG_ERROR         2
#define LOG_REPORT        4
#define LOG_PLAYER        8
#define LOG_SECURITY     16
#define LOG_STATISTIC    32
#define LOG_QUEST        64
#define LOG_GAME        128
}

static void AddPriv(string * filearr, int valid_types, mapping files)
{
  mapping priv;
  int i;
  
  priv = privileges;
  printf("%O",privileges);
  while(i<sizeof(filearr)-1)
  {    
    priv = priv[filearr[i++]];
  }
  priv[filearr[<1],PRIV_FILE] = allocate_mapping(0,3);
  priv[filearr[<1],PRIV_TYPE] = valid_types;
  priv[filearr[<1],PRIV_SEVERITY] = max_severity;
  priv[filearr[<1],PRIV_FILES] = files;
}

void PrintPriv()
{
  printf("%O",privileges);
}