/*******************
** Eldarea MUDLib **
********************
**
** secure/udp/channel 
**
** CVS DATA
** $Date: 1999/11/18 11:38:16 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: channel.c,v $
** Revision 1.2  1999/11/18 11:38:16  elatar
** VOICEMASTER Anpassung
**
**
*/

#include <udp.h>

#include <properties.h>
#include <daemon.h>
#include <defines.h>

#define COMMAND		"cmd"
#define CHANNEL		"channel"

int filter_listeners(object ob, string channel) {
    return 0;
//     return ob->QueryProp(P_INTERMUD);
}

int udp_channel(mapping data) {
  object *list, pl;
  string msg, sender;
  int i;
  
  /* Compatability with older systems. */
  if(!data[CHANNEL])
    data[CHANNEL] = data["CHANNEL"];
  if(!data[COMMAND])
    data[COMMAND] = data["CMD"];

  if(data[DATA]) {
    data[DATA]=implode(filter_array(
      efun::explode(data[DATA], ""), #'>=, " "), "");
  }
  if(!data[NAME])
    return 0;
  data[NAME]=implode(filter_array(
    efun::explode(data[NAME], ""), #'>=, " "), "");

  sender = data[SENDER];
  if (stringp(sender) && (pl = find_player(lower_case(sender))) &&
      pl->QueryProp(P_INVIS))
    sender = "jemand";

  switch(data[COMMAND]) {
    case "emote": /* A channel emote. */
	msg = break_string(data[DATA]+"]", 0,
		"["+capitalize(data[CHANNEL])+":"+capitalize(sender)+
		(data[NAME] != MUDNAME ? "@"+capitalize(data[NAME]) : "")+
		" ", BS_FOR_COMM);
      break;
    case "list": /* list of people listening to a channel. */
      list=filter_array(users(), "filter_listeners", 
        this_object(), data[CHANNEL]);
      if(i=sizeof(list)) {
        msg="["+capitalize(data[CHANNEL])+"@"+LOCAL_NAME+"] Listening:\n";
        while(i--)
          msg+="    "+capitalize(getuid(list[i]))+"\n";
      }
      else {
        msg="["+capitalize(data[CHANNEL])+"@"+LOCAL_NAME+
          "] Nobody Listening.\n";
      }
      INETD->send_udp(data[NAME], ([
        REQUEST: REPLY,
        RECIPIENT: sender,
        ID: data[ID],
        DATA: msg  ]) );
      return 1;
    default: /* A regular channel message. */
	msg = break_string(data[DATA], 0,
		"["+capitalize(data[CHANNEL])+":"+
		capitalize(sender)+
		(data[NAME] != MUDNAME ? "@"+capitalize(data[NAME]) : "")+
		"] ", BS_FOR_COMM);
        break;
  }

  if (msg[<1..<1] == "\n") msg = msg[0..<2];
  VOICEMASTER->send(capitalize(data[CHANNEL]),this_object(),msg,MSG_EMPTY);
  return 1;
}

string name() { return "<Intermud>"; }

private void _send(string mud, mixed data, mapping request)
{
  if(member(data[HOST_COMMANDS], "channel") != -1 ||
     member(data[HOST_COMMANDS], "*") != -1)
    INETD->send_udp(data[HOST_NAME], request);
}


void ChannelMessage(mixed m)
{
  mapping request;
  if(m[1] == this_object()) return;
  request = ([
              REQUEST : "channel",
              SENDER  : m[1]->name() || capitalize(getuid(m[1])),
              "CHANNEL": lower_case(m[0]),
              DATA    : implode(explode(m[2], "\n"), " ")]);
  if(m[3] == MSG_GEMOTE || m[3] == MSG_EMOTE)
  {
    request["EMOTE"] = 1;
    request["CMD"] = "emote";
  }
  walk_mapping(INETD->query("hosts") - (["md"]), #'_send/*'*/,
               request);
}
