/*******************
** Eldarea MUDLib **
********************
**
** secure/udp/reply.c - udp reply handling
**
** CVS DATA
** $Date: 2000/11/30 16:19:55 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: reply.c,v $
** Revision 1.2  2000/11/30 16:19:55  elatar
** header changed
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <udp.h>

#ifndef DATE
#define DATE	ctime(time())[4..15]
#endif

void udp_reply(mapping data) {
    string err;
    object ob;

    if(data[SYSTEM]) 
    {
      if(member_array(TIME_OUT, data[SYSTEM])>-1) 
      {
        if(stringp(data[SENDER]) && (ob = find_player(data[SENDER])))
          tell_object(ob, "Deine Anfrage ("+data[REQUEST]+") an "+
            (data[RECIPIENT]?capitalize(data[RECIPIENT])+"@"+data[NAME]:
            data[NAME])+" blieb unbeantwortet...\n");
        else if(objectp(ob = data[SENDER]) || (stringp(data[SENDER]) &&
          (ob = find_object(data[SENDER]))))
            ob->udp_reply(data);
      }
      return;
    }
    if(data[RECIPIENT]) {
	/* If recipient is a player name, pass the message to them. */
	if (stringp(data[RECIPIENT]) && (ob = find_player(data[RECIPIENT])))
	    tell_object(ob, (stringp(data[DATA]) && data[DATA][0]=='\n'?"":"\n") + data[DATA]);
	/* Otherwise send it to udp_reply() in the recipient. */
	else if (objectp(ob) || (ob = find_object(data[RECIPIENT])))
	{
//	    DEBUG(sprintf(" --- SENDING TO %O %O %d\n",ob,data,objectp(ob)));
	    ob->udp_reply(data);
//			DEBUG("DONE");
	}
	return;
    }
    switch(data[REQUEST]) {
	case "ping":
	    /* Ignore system ping replies. */
	    return;
	default:
	    /* Log replies to the system. (ie. No RECIPIENT) */
	    if (data[DATA])
		log_file(INETD_LOG_FILE, DATE + ": Reply from " + data[NAME] +
		"\n" + data[DATA] + "\n");
	    return;
    }
}

