// Hier werden alle Kommunikations-Efuns ueberlagert

#pragma save_types
#pragma strict_types

#include <message.h>

#ifdef MESSAGE_SYSTEM
nomask void tell_object(object ob, string str)
{
    ob->receive_message(MT_UNKNOWN,MA_UNKNOWN,previous_object(),str);
}

nomask varargs void tell_room(object ob, string str, object *exclude)
{
    filter_objects(exclude ? all_inventory(ob) - exclude : all_inventory(ob),
    	"receive_message",MT_UNKNOWN,MA_UNKNOWN,previous_object(),str);
    ob->receive_message(MT_UNKNOWN,MA_UNKNOWN,previous_object(),str);
}

nomask varargs void say(string str, mixed exclude)
{
    object ob;

    if (living(previous_object()) || !this_player())
    	ob = previous_object();
    else
    	ob = this_player();
    if (environment(ob))
    {
    	if (objectp(exclude))
	    exclude = ({ exclude, ob });
	else if (exclude)
	    exclude += ({ ob });
	else
	    exclude = ({ ob });
	tell_room(environment(ob),str,exclude);
    }
}
#endif

nomask void write(string str)
{
    if (this_player())
	this_player()->receive_message(MT_NOTIFY,MA_UNKNOWN,
	    	previous_object(),str);
}

nomask varargs void printf(varargs mixed *args)
{
    write(apply(#'sprintf,args));
}
