// This file is part of UNItopia Mudlib.
// ----------------------------------------------------------------
// File:	/secure/simul_efun/convert.inc
// Description:	Beliebige Variablentypen in Strings umwandeln
// Author:	Freaky

#pragma strict_types
#pragma save_types

private string get_closure(mixed vari)
{
    int tmp;

    if (typeof(vari) != T_CLOSURE)
	return "*KEINE CLOSURE*";

    tmp = get_type_info(vari,1);
    if (CLOSURE_IS_LFUN(tmp))
	return sprintf("LFUN(%O)",vari);
    if (CLOSURE_IS_IDENTIFIER(tmp))
	return sprintf("IDENTIFIER(%O)",vari);
    if (CLOSURE_IS_BOUND_LAMBDA(tmp))
	return sprintf("BOUND-LAMBDA(%O)",vari);
    if (CLOSURE_IS_LAMBDA(tmp))
	return sprintf("LAMBDA(%O)",vari);
    if (CLOSURE_IS_UNBOUND_LAMBDA(tmp))
	return sprintf("UNBOUND-LAMBDA(%O)",vari);
    if (CLOSURE_IS_SIMUL_EFUN(tmp))
	return sprintf("SIMUL-EFUN(%O)",vari);
    if (CLOSURE_IS_EFUN(tmp))
	return sprintf("EFUN(%O)",vari);
    if (CLOSURE_IS_OPERATOR(tmp))
	return sprintf("OPERATOR(%O)",vari);
    return sprintf("*UNBEKANNTE CLOSURE:%O*",vari);
}

/*
FUNKTION: mixed2str
DEKLARATION: string mixed2str(mixed arr)
BESCHREIBUNG:
Wandelt einen beliebigen Datentyp in einen String um.
Gut fuer Debuggingzwecke.
GRUPPEN: simul_efun, array, mixed
VERWEISE: to_string, to_int, to_float
*/
string mixed2str(mixed arr)
{
    switch(typeof(arr))
    {
      case T_INVALID:
	return sprintf("*FEHLER:%O*",arr);
      case T_LVALUE:
	return sprintf("LVALUE(%O)",arr);
      case T_STRING:
	arr = implode(explode(arr,"\\"),"\\\\");
	arr = implode(explode(arr,"\a"),"\\a");
	arr = implode(explode(arr,"\b"),"\\b");
	arr = implode(explode(arr,"\e"),"\\e");
	arr = implode(explode(arr,"\f"),"\\f");
	arr = implode(explode(arr,"\n"),"\\n");
	arr = implode(explode(arr,"\r"),"\\r");
	arr = implode(explode(arr,"\t"),"\\t");
	arr = implode(explode(arr,"\""),"\\\"");
	return "\"" + arr + "\"";
      case T_NUMBER:
      case T_FLOAT:
	return to_string(arr);
      case T_POINTER:
      {
	int i;
	string st;
	if (sizeof(arr) <= 0)
	    return "({})";
	st = "({";
	for (i = 0; i < sizeof(arr) - 1; i++)
	    st += mixed2str(arr[i]) + ",";
	return st + mixed2str(arr[i]) + "})";
      }
      case T_OBJECT:
	return "OBJ(" + file_name(arr) + ")";
      case T_MAPPING:
      {
	mixed *ind;
	string stm;
	int a, end;
	if (sizeof(arr) <= 0)
	    return "([])";
	stm = "([";
	ind = m_indices(arr);
	end = get_type_info(arr,1)-1;
	for(i = 0; i < sizeof(ind); i++)
	{
	    stm += mixed2str(ind[i]);
	    if (end >= 0)
	    {
		stm += ":";
		for (a = 0; a < end; a++)
		    stm += mixed2str(arr[ind[i],a]) + ";";
		stm += mixed2str(arr[ind[i],end]);
	    }
	    stm += ",";
	}
	return stm[0..<2] + "])";
      }
      case T_CLOSURE:
	return get_closure(arr);
      case T_SYMBOL:
	return sprintf("SYMBOL(%O)",arr);
      case T_QUOTED_ARRAY:
	return sprintf("QUOTED-ARRAY(%O)",arr);
      default:
	return sprintf("*UNBEKANNT:%O:*",arr);
    }
}
