// This file is part of UNItopia Mudlib.
// ----------------------------------------------------------------
// File:	/secure/simul_efun/map.inc
// Description:	Map-Handling Funktionen
// Author:	Freaky, Francis
// Modified by:	Freaky (16.06.1998) rename_allowed eingebaut

#pragma strict_types
#pragma save_types

/*
FUNKTION: domain2map
DEKLARATION: string domain2map(string file_name)
BESCHREIBUNG:
Ein Map-Raum innerhalb einer Domain ist durch seine lokalen
Koordinaten gekennzeichnet:

/d/Domain/mx_y
/d/Domain/mitglied/mx_y
/d/Domain/mitglied/bereich/mx_y

Sobald sie in der Map geladen werden, bekommen sie einen File-Namen mit
absoluten Koordinaten:

/map/mx_y

Mit dieser Routine kann der Map-File-Name eines Domain-Files erfragt werden.

Beispiel:
    domain2map("/d/Arktis/uluji/schelfweg/m0_4") --> "/map/m3_1024"

GRUPPEN: simul_efun, map
VERWEISE: map2domain
*/
string domain2map(string name)
{
    if (name && name[0..2]=="/d/")
	return ({string})MAP_OB->get_map_file_name(name);
}

/*
FUNKTION: map2domain
DEKLARATION: string map2domain(string file_name, int flag)
BESCHREIBUNG:
Ein Map-Raum innerhalb einer Domain ist durch seine lokalen
Koordinaten gekennzeichnet:

/d/Domain/mx_y
/d/Domain/mitglied/mx_y
/d/Domain/mitglied/bereich/mx_y

Sobald sie in der Map geladen werden, bekommen sie einen File-Namen mit
absoluten Koordinaten:

/map/mx_y

Mit dieser Routine kann der Domain-File-Name eines Map-Files erfragt werden.
Gibt es diesen nicht, so wird ein leerer String zurueckgegeben,
es sei denn flag==1.

Beginnt der Dateiname nicht mit einem /, so wird das Ergebnis auch nicht
micht einem ebensolchen beginnen.

Beispiel:
    map2domain("/map/m3_1024")   --> "/d/Arktis/uluji/schelfweg/m0_4.c"
    map2domain("map/m3_1024")    --> "d/Arktis/uluji/schelfweg/m0_4.c"
    map2domain("/map/m3_1025")   --> 0
    map2domain("/map/m3_1025",1) --> "/d/Arktis/m503_25.c"

GRUPPEN: simul_efun, map
VERWEISE: domain2map
*/
varargs string map2domain(string name, int flag)
{
    int x, y, noslash;
    string file;

    if (sscanf(name,"/map/m%d_%d",x,y) != 2)
        if (sscanf(name,"map/m%d_%d",x,y) != 2)
	    return 0;
        else noslash = 1;
    file = ({string})MAP_OB->query_map_file_name(x,y);
    if (flag || file && file_size(file) > 0)
	return (noslash && file) ? file [1..] : file;
}

/*
FUNKTION: map_object
DEKLARATION: int map_object(string file_name)
BESCHREIBUNG:
Liefert 1, wenn es sich bei dem Raum 'file_name' um einen Map-Raum handelt.
(z.B. bei /map/m1_1 oder auch bei /d/Doerrland/m0_0)
GRUPPEN: simul_efun, map
VERWEISE: 
*/
int map_object(string str)
{
    string *path;
    int x,y;

    path = explode(str,"/")-({""});
    return ((path[0] == "d" || path[0] == "map") &&
	    sscanf(path[<1],"m%d_%d",x,y) == 2);
}

/*
FUNKTION: touch
DEKLARATION: object touch(string|object ob [,int flag] )
BESCHREIBUNG:
Laedt einen File und gibt bei Erfolg einen Pointer darauf zurueck.

Im Prinzip macht   load_object(file)   dasselbe, jedoch kann
damit im Gegensatz zum touch() kein Map-Raum geladen werden !

Die Flags sind in /sys/touch.h definiert.

Beispiel:
        touch("/d/Vaniorh/uluji/jetty");
        touch("/map/m24_644");

GRUPPEN: simul_efun, objekt
VERWEISE: clone_object
*/
varargs object touch(mixed ob, int flag)
{
    object ret, to;
    string *path;
    int x, y;

    // Wird vom Move meist uebergeben
    if (objectp(ob))
	return ob;
    // Wird wohl auch oft mit '0' aufgerufen :(
    if (!stringp(ob))
	return 0;

    path = explode(ob,"/")-({""});

    /* Map-Raum */
    if ((path[0] == "d" || path[0] == "map") &&
	    sscanf(path[<1],"m%d_%d",x,y) == 2)
	if (path[0] == "map" && (ret=find_object(ob)))
	    return ret;
	else
	    return ({object})MAP_OB->create_map_object(ob);

    if (ret=find_object(ob))
	return ret;

    if (ob[<2..]!=".c")
	ob+=".c";

#if 0
    if (find_player("freaky"))
	tell_object(find_player("freaky"),sprintf("@@ Touch:ob:%O:\n",ob));
#endif

    if (file_size(ob)>0)		/* Normales Objekt */
    {
	to = this_object();
	set_this_object(previous_object());
#if __EFUN_DEFINED__(load_object)
	ob = load_object(ob);
#else
	call_other(ob,"???");
	ob = find_object(ob);
#endif
	set_this_object(to);
	return ob;
    }
    else if (sizeof(path)>1)		/* Virtual-Compiler starten */
    {
	string tmp, vc, name;
	object vc_ob;

	tmp="/"+implode(path[0..<2],"/")+"/";
	vc=tmp+"virtual_compiler.c";
	name=path[<1];
	if (name[<2..]==".c")
	    name=name[0..<3];

	if (vc_ob=find_object(vc))
	    ret=({object})vc_ob->virtual_compiler(name,tmp);
	else if (file_size(vc)>0)
	    ret=({object})vc->virtual_compiler(name,tmp);
	if (ret)
	{
	    // Freaky: damit es keinen Aerger gibt :(
	    if (file_name(ret) != tmp+name)
		// Check, ob das Objekt ueberhaupt umbenannt werden darf.
		if (MASTER_OB->rename_allowed(ret,1))
		    rename_object(ret,tmp+name);
	    return ret;
	}
    }

    /* Objekt wurde nicht geladen */

    if (!(flag & NO_LOG) && !wizp(this_player()))
    {
	if (this_player() && environment(this_player()))
	    MASTER_OB->do_log_error("touch: "+ob+" nicht gefunden in "+
		file_name(environment(this_player()))+".\n",
		__FILE__,
		file_name(environment(this_player())),__LINE__);
	else if (previous_object())
	    MASTER_OB->do_log_error("touch: "+ob+" nicht gefunden. caller: "+
		file_name(previous_object())+".\n",
		__FILE__,
		file_name(previous_object()),__LINE__);
	else
	    MASTER_OB->do_log_error("touch: "+ob+" nicht gefunden. Kein "
		"this_player() und kein previous_object().\n",
		__FILE__,__FILE__,__LINE__);
    }

    if (!(flag & NO_WRITE))
	if (this_player())
	    if (wizp(this_player()))
		write("touch: "+ob+" nicht gefunden.\n"); 
	    else
		write("Da hat sich wohl ein Loch im Raum-Zeit-Gefuege "
		      "aufgetan.\n");
}
