/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: parse_com.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
// This file is part of UNItopia Mudlib.
// ----------------------------------------------------------------
// File:	/secure/simul_efun/parse_com.c
// Description: Parse_com um Objekte zu finden
// Author:	Francis
// Modified by: Freaky : Einfuehren von virtuellen Objekten (23.12.93)
//			 Dadurch komplette Umstellung von parse_com
// Modified by: Freaky : Fixed Bug mit Objekten und v-Items gleicher ID
//			 (08.02.94)
// Modified by: Freaky : Casting jetzt mit ({type})ob->fun() anstatt (type)
//			 (29.06.94)
// Modified by: Monty  : Man kann jetzt v_items an v_items mit betrachte <ding>
//                       am oder im <ding> angucken
// Modified by:	Freaky : sscanf durch strstr ersetzt, da sscanf Fehler macht
//			 (14.09.95)
// Modified by: Monty (08.05 1996) parse_com_error() modernisiert,
//			 Bei PARSE_NOT_SEARCHED wird jetzt 1 returnt und die
//			 default-Fehlermeldung gesetzt.
// Modified by: Kurdel (19.02.97) neben "alle","alles" auch "jedes" u.ae.
// Modified by: Parsec (15.05.98) parse_com() und quick_search() nehmen jetzt
//                       auch Objektlisten in denen gesucht werden soll


#pragma save_types
#pragma strict_types

#include "/sys/invis.h"
#include "/sys/parse_com.h"

#undef DEBUG
#define NO_INVIS_OBS
#ifdef TestMUD
#define NO_INVIS_OBS
#endif

#ifdef DEBUG
#include "/sys/level.h"
#define D(x) if (this_interactive() && \
		 (({int})this_interactive()->query_wiz_level()==LVL_ADMIN)) \
		 printf("x:%O:\n",x)
#else
#define D(x)
#endif

#define PARSE_ERROR(x) return ({ 0,({}),command,x,pc_id_string,pc_trenner,\
				  pc_beyond_trenner});

string strip(string str);

/******************************************************************************
 * Alles zu parse_com:
 */
static string *meinesgleichen = ({ "mein","meine","meiner",
			    "meines","meinen","meinem" });
static string *artikel = ({ "ein","eine","einen","einem","einer","eines",
		"der","die","das","den","dem","des",
		"dieser","diese","dieses","diesen","diesem",
		"sein","seine","seinen","seinem","seiner","seines",
		"ihr","ihre","ihren","ihrem","ihrer","ihres","ihn","ihm",
		"dein","deine","deinen","deinem","deiner","deines" });
static string *dinge = ({"dinge", "sachen", "gegenstaende", "zeug", "zeugs" });
static string *alles = ALLES;


static string  pc_present_string;
static string  pc_id_string;
static int     pc_present_number;
static object *pc_obs;
static string *pc_adjs;
static int     pc_all;
static int     pc_all_matches;
static object *pc_ret;
static string  pc_trenner;
static string  pc_rest;
static string  pc_beyond_trenner;
static mixed  *pc_v_path;

private object *vv_present(mixed *what, object where) {
    int a;
    object *inv;

    if (pc_all) // || pc_present_number)
	return 0;

    inv = all_inventory(where);
    for (a=0; a<sizeof(inv); a++)
	if (inv[a]->query_v_item(what))
	    return ({inv[a]});
    return 0;
}

private object ppresent(string what, object where) {
	int a;
	object *inv;


    inv = all_inventory(where);
    if (pc_all) {
	for (a=0; a<sizeof(inv); a++)
#ifdef NO_INVIS_OBS
	    if (!(({int})inv[a]->query_invis() & V_ATOM_NOSHIMMER) &&
		 (inv[a]->id(what) || inv[a]->plural_id(what)))
		return inv[a];
#else
	    if (inv[a]->id(what) || inv[a]->plural_id(what))
		return inv[a];
#endif
	}
    else
	for (a=0; a<sizeof(inv); a++)
#ifdef NO_INVIS_OBS
	    if (!(({int})inv[a]->query_invis() & V_ATOM_NOSHIMMER) &&
		 inv[a]->id(what))
		return inv[a];
#else
	    if (inv[a]->id(what))
		return inv[a];
#endif
    return 0;
}

/*
 * Sucht 'schnell' nach einem Objekt, das auf die id 'what' hoert.
 * Wenn where angegeben ist (darf objekt oder Objektliste sein),
 * dann dort, ansonsten erst im
 * Environment von this_player(), dann in this_player()
 * Erst wird direkt nach dem Objekt gesucht, dann wird bei where
 * nach einem Virtuellen Objekt gesucht.
 * Als letztes wird noch die Objektliste nach einem Virtuellen Objekt,
 * das passt durchsucht.
 *
 * Es wird ein Objekt returned, wenn es durch die id gefunden wurde,
 * ein Mapping, wenn es in where gefunden wurde,
 * oder ein Array mit dem Objekt, an dem das Virtuelle an einem Objekt
 * gefunden wurde.
 */
private mixed quick_search(string what, mixed where) {
	object env;
	mixed  ret;
        int    i, imax;

    if (!where) {
	env = environment(this_player());
	if ((env && (ret=ppresent(what,env) ||
		     ret=({mapping})env->query_v_item(({what})) )) ||
		     ret=ppresent(what,this_player()) ||
		     ret=({mapping})this_player()->query_v_item(({what})) ||
		     (env && ret=vv_present(({what}),env)) ||
		     ret=vv_present(({what}),this_player()) )
	    return ret;
	}
    else if ( pointerp( where) )
    {
        for ( i = 0 , imax = sizeof( where) ; i < imax ; i++ )
            if ( where[i] &&
                (ret=ppresent( what, where[i]) ||
                 ret=({mapping})where[i]->query_v_item(({what})) ||
                 ret=vv_present(({what}),where[i])) )
                return ret;
    }
    else if (ret=ppresent(what,where) ||
	     ret=({mapping})where->query_v_item(({what})) ||
	     ret=vv_present(({what}),where) )
	return ret;
    return 0;
}

private int c_a(object ob) {
	int a;

    for (a=0; a<sizeof(pc_adjs); a++)
	if (!ob->adjektiv(pc_adjs[a]))
	    return 0;
    return 1;
}

private void search_all() {
	int a;
	object *fobs;

    pc_obs -= ({this_player()});
    if (sizeof(pc_adjs)) {
	fobs = ({});
	for (a=0; a<sizeof(pc_obs); a++)
	    if (!(({int})pc_obs[a]->query_invis() & V_ATOM_NOLIST) &&
		(pc_present_string == "" ||
		 pc_obs[a]->id(pc_present_string) ||
		 pc_obs[a]->plural_id(pc_present_string)) &&
		c_a(pc_obs[a]))
		    fobs += ({ pc_obs[a] });
	pc_ret = fobs;
	}
    else {
	fobs = ({});
	if (pc_present_string == "") {
	    for (a=0; a<sizeof(pc_obs); a++)
		if (!(({int})pc_obs[a]->query_invis() & V_ATOM_NOLIST))
		    fobs += ({ pc_obs[a] });
	    }
	else
	    for (a=0; a<sizeof(pc_obs); a++) {
		if (!(({int})pc_obs[a]->query_invis() & V_ATOM_NOLIST) &&
		    (pc_obs[a]->id(pc_present_string) ||
		    pc_obs[a]->plural_id(pc_present_string)))
		    fobs += ({ pc_obs[a] });
		}
	pc_ret = fobs;
	}
}

private void search_ob() {
	int a, b, not_found;;

    if (member_array(this_player(),pc_obs) > -1) {
	pc_obs -= ({ this_player() });
	pc_obs += ({ this_player() });
	}
    if (sizeof(pc_adjs)) {		// Mit Adjektiven
	if (pc_present_number > 0) {	// Mit Nummer
	    for (a=0; a<sizeof(pc_obs); a++)
#ifdef NO_INVIS_OBS
	    {
		if (({int})pc_obs[a]->query_invis() & V_ATOM_NOSHIMMER)
		    continue;
#endif
		if (pc_obs[a]->id(pc_present_string)) {
		    for (b=0; b<sizeof(pc_adjs); b++)
			if (!pc_obs[a]->adjektiv(pc_adjs[b])) {
			    not_found = 1;
			    break;
			    }
		    if (not_found)
			not_found = 0;
		    else {
			pc_present_number--;
			if (pc_present_number == 0) {
			    pc_ret = ({ pc_obs[a] });
			    return;
			    }
			}
		    }
#ifdef NO_INVIS_OBS
	    }
#endif
	    }
	else {				// Ohne Nummer
	    for (a=0; a<sizeof(pc_obs); a++)
#ifdef NO_INVIS_OBS
	    {
		if (({int})pc_obs[a]->query_invis() & V_ATOM_NOSHIMMER)
		    continue;
#endif
		if (pc_obs[a]->id(pc_present_string)) {
		    for (b=0; b<sizeof(pc_adjs); b++)
			if (!pc_obs[a]->adjektiv(pc_adjs[b])) {
			    not_found = 1;
			    break;
			    }
		    if (not_found)
			not_found = 0;
		    else {
			pc_ret += ({ pc_obs[a] });
			if (!pc_all_matches)
			    return;
			}
		    }
#ifdef NO_INVIS_OBS
	    }
#endif
	    }
	}
    else {				// Ohne Adjektive
	if (pc_present_number > 0) {	// Mit Nummer
	    for (a=0; a<sizeof(pc_obs); a++)
#ifdef NO_INVIS_OBS
	    {
		if (({int})pc_obs[a]->query_invis() & V_ATOM_NOSHIMMER)
		    continue;
#endif
		if (pc_obs[a]->id(pc_present_string)) {
		    pc_present_number--;
		    if (pc_present_number == 0) {
			pc_ret = ({ pc_obs[a] });
			return;
			}
		    }
#ifdef NO_INVIS_OBS
	    }
#endif
	    }
	else {				// Ohne Nummer
	    for (a=0; a<sizeof(pc_obs); a++)
#ifdef NO_INVIS_OBS
	    {
		if (({int})pc_obs[a]->query_invis() & V_ATOM_NOSHIMMER)
		    continue;
#endif
		if (pc_obs[a]->id(pc_present_string)) {
		    pc_ret += ({ pc_obs[a] });
		    if (!pc_all_matches)
			return;
		    }
#ifdef NO_INVIS_OBS
	    }
#endif
	    }
	}
}

/*
 * Sucht nach einem 'normalen' Objekt (oder nach einer Liste von Objekten)
 * Wenn nur ein Objekt angegeben wurde, dann evtl. auch noch nach
 * eine Virtuellen Objekt, das daranhaengt.
 */
private void search_normal_ob(object wo) {
    mapping ret;

    pc_obs=all_inventory(wo);
    if (pc_all)
	search_all();
    else {
	search_ob();
	if (sizeof(pc_v_path) && sizeof(pc_ret))
	    if (ret=({mapping})pc_ret[0]->query_v_item(pc_v_path))
		pc_ret=({ret});
	    else
		pc_ret=({});
	}
}

#if 0
/*
 * Hier wird ein Virtuelles Objekt gesucht.
 * Wenn ob ein Objekt-Pointer ist, dann wird an ob nach dem virtuellen
 * Objekt gesucht. (und zwar mit dem pc_v_path)
 * Es wurde also das Start-Objekt gefunden.
 *
 * Wenn ob ein Array mit einem Objekt ist, dann wird an ob[0] dach dem
 * virtuellen Objekt gesucht mit dem Present-String.
 * d.h. es wurde ein Objekt gefunden, das ein Virtuelles Objekt hat,
 * das als Start-Objekt angegeben wurde.
 *
 * Wenn ob ein Mapping oder 0 ist, wird am Objekt wo gesucht, ob dort
 * das Objekt ist.
 */
private void search_v_objects(object wo, mixed ob) {
    mapping v_item, ret;

    D(ob);
    D(wo);

    if (pointerp(ob)) {
	if (ret=({mapping})ob[0]->query_v_item(({pc_present_string})))
	    pc_ret=({ret});
	}
    else {
	v_item=([]);
	v_item["name"]=pc_present_string;
	v_item["nummer"]=pc_present_number;
	v_item["adjektiv"]=pc_adjs;

	D(v_item);

	if (ret=({mapping})wo->query_v_item(({v_item})+pc_v_path))
	    pc_ret=({ret});
	}

    D(pc_ret);
}
#endif

private mixed make_v_path(string str, string prep) {
    int i, present_number, nr, got_artikel;
    string *words, word, *adjs, id_str;
    mapping map;

    words=explode(implode(explode(str,",")," ")," ")-({""});
    adjs=({});
    id_str="";

    for (i=0; i<sizeof(words); i++) {
	word=lower_case(words[i]);
	if (word=="mich" || word=="mir" || member(alles,word)>=0 ||
		member(meinesgleichen,word)>=0 || member(dinge,word)>=0)
	    return PARSE_WRONG_ID;
	else if (member(artikel,word)>=0) { }
	else if (word[<1]=='.' && sscanf(word[0..<2],"%d",nr)) {
	    if (nr>0)
		present_number=nr;
	    }
	else
	    adjs+=({word});
	id_str+=words[i]+" ";
	}
    if (!sizeof(adjs))
	return PARSE_WRONG_ID;
    pc_id_string=id_str[0..<2]+prep+pc_id_string;
    map=([]);
    map["nummer"]=present_number;
    sizeof(adjs)>1?map["adjektiv"]=adjs[0..<2]:0;
    map["name"]=adjs[<1];
    D(map);
    D(prep);

    return map;
}

/*
FUNKTION: parse_com
DEKLARATION: varargs mixed *parse_com(string command, mixed where, string *trenner, int flag)
BESCHREIBUNG:
parse_com analysiert den String command nach Objekt-Ids und sucht in der
Umgebung von this_player() und in this_player() selbst bzw in where, falls
angegeben, nach ihnen. Where darf dabei ein Objekt oder eine Liste von
Objekten sein.

Artikel, Adjektive, Zahl-Angaben (1. 2. ....), Worte wie 'alle',
'meine', 'mich' etc werden dabei beruecksichtigt.

Ist ein String-Feld trenner mit moeglichen Trennworten angegeben, wird die
Analyse beim ersten Auftreten eines dieser Worte abgebrochen.

Es wird ein mixed-Feld mit folgendem Inhalt zurueckgegeben:

      PARSE_NUM_OBS:	Anzahl der gefundenen Objekte.

      PARSE_OBS:	Feld mit den gefundenen Objekten.

      PARSE_REST:       Rest-String des Kommandos.

      PARSE_RET_CODE:   Return-Code:
		PARSE_OK		Alles klar
		PARSE_NO_ARG		Es wurde nichts uebergeben
		PARSE_NO_OB		Objekt nicht gefunden
		PARSE_NO_MY_OB		Objekt nicht gefunden,
						"mein" war angegeben
		PARSE_NO_ALL_OB		Objekt nicht gefunden,
						"alles" war angegeben
		PARSE_NO_ALL_MY_OB	Objekt nicht gefunden,
						"mein" und "alles" war angegeben
		PARSE_WRONG_ID		Unvollstaendige oder falsche
						Objekt-Id angegeben
                PARSE_NOT_SEARCHED      Es sollte nach dem Trenner geparst
                                                werden, dieser war allerdings
                                                nicht vorhanden

      PARSE_ID: nach der gesucht wurde.

      PARSE_TRENNER: Trennwort, welches gefunden wurde.

      PARSE_BEYOND_TRENNER: Alles, was nach dem Trenner im String steht.

Beispiel 1:

	#include <parse_com.h>
	mixed *parsed;

	parsed = parse_com(
            "meine gruene tasche ist gruen und noch mehr", 0, ({"und"}));

	if (parsed[PARSE_RET_CODE] != PARSE_OK) {
	    if (parsed[PARSE_RET_CODE] == PARSE_NO_ARG ||
		parsed[PARSE_RET_CODE] == PARSE_WRONG_ID)
		notify_fail("Nimm was ?\n");

	    else if (parsed[PARSE_RET_CODE] == PARSE_NO_OB)
		notify_fail(capitalize(parsed[PARSE_ID])+" nicht gefunden.\n");

	    else if (parsed[PARSE_RET_CODE] == PARSE_NO_MY_OB)
		notify_fail(capitalize(parsed[PARSE_ID])+
			    " hast Du nicht bei dir.\n");

	    else if (parsed[PARSE_RET_CODE] == PARSE_NO_ALL_OB)
		notify_fail("Da gibt es nichts.\n");

	    else if (parsed[PARSE_RET_CODE] == PARSE_NO_ALL_MY_OB)
		notify_fail("Du hast nichts bei dir.\n");

	    else
		notify_fail("Das duerfte nie auftreten.\n");

	    return 0;
	    }

	for (a=0; a<parsed[PARSE_NUM_OBS]; a++)
	    nimm(parsed[PARSE_OBS[a]);
	if (parsed[PARSE_REST] != "")
	    write("Was meintest Du mit: '"+parsed[PARSE_REST]+"' ?\n");

Falls in obigem Beispiel eine "gruene tasche" gefunden wurde erhaelt man 
folgendes zurueck:

	parsed[PARSE_NUM_OBS]		1
	parsed[PARSE_OBS]		({ ob_pointer })
	parsed[PARSE_REST]		"ist gruen"
	parsed[PARSE_RET_CODE]		PARSE_OK
	parsed[PARSE_ID]		"gruene tasche"
	parsed[PARSE_TRENNER]           "und"
	parsed[PARSE_BEYOND_TRENNER]	"noch mehr"


Mit der Routine  parse_com_error(..)  kann man sich die Fehlerbehandlung
wesentlich vereinfachen. Unser obiges Beispiel sieht dann folgendermassen aus:


Beispiel 2:

	#include <parse_com.h>
	mixed *parsed;

	parsed = parse_com("meine gruene tasche und noch mehr",0,({"und"}));

	if (parse_com_error(parsed,"Was willst Du nehmen ?\n"))
	    return 0;

	for (a=0; a<parsed[PARSE_NUM_OBS]; a++)
	    nimm(parsed[PARSE_OBS][a]);
	if (parsed[PARSE_REST] != "")
	    write("Was meintest Du mit: '"+parsed[PARSE_REST]+"' ?\n");

Zu parse_com_error gibt es einen separaten Hilfe-Text.


Der 4. Parameter ist ein Steuerflag; moegliche Settings sind:

	PARSE_ALL_MATCHES

		Ist im Kommando KEIN Zahlwort (1. 2. ...) angegeben,
		werden statt nur dem ERSTEN Objekt ALLE darauf passenden
		Objekte zurueckgeliefert.

        PARSE_NO_V_ITEMS

                Verhindert, dass V_Items mitgeparsed werden, und somit
                in parsed[PARSE_OBS] erscheinen.

        PARSE_AFTER_TRENNER

                Hiermit beginnt der Parser erst nach einem der gegebenen
                Trenner zu parsen.

        PARSE_NOT_WITHOUT_TRENNER

                Das Parsing wird abgebrochen, falls keiner der angegeben
                Trenner im String command zu finden ist.
                Ist dies der Fall, wird PARSE_NOT_SEARCHED zurueckgegeben.


ACHTUNG: Falls nicht mit PARSE_NO_V_ITEMS explizit angegeben, werden auch
virtuelle Objekte im Feld PARSED_OBJECTS zurueckgegeben. Deshalb muss das
Programm in diesem Falle in der Lage sein, Mappings zu verarbeiten!

Weitere Beispiele zu parsed_com() findet man z.Bsp. in /i/living/hands.c


VERWEISE: parse_com_error, present, deep_present
GRUPPEN: simul_efun, string, player
*/
varargs mixed *parse_com(string command, mixed rwo, string *trenn, int flag)
{
    string junk,		/* Temporaere Variable */
	   number,		/* Es wurde eine Zahl angegeben: '100 Taler' */
    	   word,		/* Das Aktuelle Wort, das untersucht wird LOW*/
	   *words,		/* Alle Worte, die untersucht werden */
	   *satz		/* Die Satzteile des virtuellen Objektes */
	   ;
    int i,			/* Zaehler-Variable fuer Schleifen */
	completed,		/* Wenn die Suche fertig ist */
	got_meins,		/* Es soll in this_player() gesucht werden */
	mich,			/* 'mich' oder 'mir' wurde angegeben */
	do_not_add,		/* ob das Wort zu pc_id_string addiert wird */
	do_search		/* ob an 'ob' nach dem virtuellen Objekt
				   gesucht werden darf */
	;
    mixed tmp, ob;
    object  *inv;		/* Objekt-Liste */
    mixed   wo;			/* Wo soll letztendlich gesucht werden ? */
    mapping ret;		/* Virtuelles Objekt */

    D(command);

    if (!strlen(command))
	return ({ 0, ({}), "", PARSE_NO_ARG, "", "", "" });

    pc_present_number=pc_all=0;
    pc_adjs=({});
    pc_id_string="";
    pc_trenner="";
    pc_beyond_trenner = "";
    pc_present_string="";
    number="";
    pc_all_matches=flag & PARSE_ALL_MATCHES;
    wo = ( rwo && (objectp( rwo) || pointerp( rwo)) ) ?
        rwo : ({ environment( this_player()), this_player() }) ; //***


    /* Erstmal den String auf Trenner untersuchen */
    tmp=command;
    for (i=0; i<sizeof(trenn); i++)
	if (sscanf(tmp,"%s "+trenn[i]+" %s",tmp,junk)) {
	    pc_trenner = trenn[i];
	    break;
	    }

    if (pc_trenner!="") {
	/* Soll VOR oder NACH dem Trenner gesucht werden ? */

	if (flag & PARSE_AFTER_TRENNER) {
	    pc_beyond_trenner = tmp;
	    tmp = junk == 0 ? "" : junk;
	    }
	else
	    pc_beyond_trenner = junk == 0 ? "" : junk;
        }
    else	// Soll ueberhaupt gesucht werden ?
	if (flag & PARSE_NOT_WITHOUT_TRENNER)
	    return ({ 0, ({}), "", PARSE_NOT_SEARCHED, "", "", "" });


    if (flag & PARSE_NO_V_ITEMS)
	satz=({tmp});
    else
	/* Jetzt den String auf virtual-Trenner untersuchen */
	satz=regexplode(tmp,
	   "( auf )|( an )|( von )|( in )|( am )|( im )|( vom )");

    /* Der Letzte Satzteil wird untersucht */
    /* Alle Kommas in Spaces verwandeln und dann die Worte auseinadernehmen */
    pc_rest=satz[<1];
    words=explode(implode(explode(pc_rest,",")," ")," ")-({""});

    /* Ok. jetzt geht die Suche des Start-Objektes los */

    for (i=0; i<sizeof(words); i++) {
	word=lower_case(words[i]);
	if (word=="mich" || word=="mir")
	    mich=completed=1;
	else if (member(alles,word)>=0)
	    pc_all=do_not_add=1;
	else if (member(artikel,word)>=0)
	    do_not_add=1;
	else if (member(meinesgleichen,word)>=0)
        {
	    got_meins=do_not_add=1;
	    if ( wo &&
                 (objectp( wo) && wo != this_player() ||
                  pointerp( wo) && member( wo, this_player()) == -1) )
                PARSE_ERROR(PARSE_NO_OB) 
            wo=this_player();
        }
	else if (member(dinge,word)>=0)
	    completed=do_not_add=1;
	else if (word[<1]=='.' && sscanf(word[0..<2],"%d",tmp))
	    pc_present_number=tmp;
	else if (sscanf(word,"%d%s",tmp,junk) && junk=="")
	    number+=word+" ";
	else if (ob=quick_search(word,wo)) {
	    pc_present_string=word;
	    completed=1;
	    }
	else
	    pc_adjs+=({word});

	/* Wort addieren zum ID-String */
	do_not_add?do_not_add=0:pc_id_string+=" "+words[i];
	if (completed)
	    break;
	}

    /************* Jetzt auswerten **********/
    pc_id_string=pc_id_string[1..];

    if (i<sizeof(words)-1)		// Es sind noch Woerter uebrig
	pc_rest=pc_rest[strstr(pc_rest,words[i])+strlen(words[i])+1..];
    else
	pc_rest="";

    D(words);
    D(i);
    D(pc_trenner);
    D(pc_beyond_trenner);
    D(pc_all);
    D(pc_present_string);
    D(completed);
    D(pc_id_string);
    D(pc_rest);
    D(pc_adjs);
    D(pc_present_number);
    D(number);
    D(wo);
    D(ob);

    if (mich)
	return ({1,({this_player()}),pc_rest,PARSE_OK,strip(pc_id_string),
			pc_trenner,pc_beyond_trenner });

    /* Virtual-Object-Suchpfad machen */
    pc_v_path=({});
    for (i=sizeof(satz)-3; i>=0; i-=2)
	if (intp(tmp=make_v_path(satz[i],satz[i+1])))
	    PARSE_ERROR(tmp)
	else
	    pc_v_path+=({tmp});
    D(pc_v_path);

    pc_present_string=number+pc_present_string;
    pc_ret=({});

    /* Wenn 'alles' angegeben wurde, dann darf kein virtuelles Objekt
       gesucht werden und kein virtuelles Objekt das Start-Objekt sein. */
    if (pc_all && (sizeof(pc_v_path) || mappingp(ob) || pointerp(ob)))
	PARSE_ERROR(PARSE_WRONG_ID)

    /* Hier kommt die letztendliche Suche */

    /* tmp auf 1 setzen, da ich noch nach virtuellen Objekten im Raum
       oder in mir suchen muss, wenn ich so nichts gefunden habe. */
    tmp=1;

    if (!ob || objectp(ob))
    {
	/* Suche von einem normalen Start-Objekt oder einer Liste */
        if ( objectp( wo) )
	    search_normal_ob(wo);
        else
        {
            for ( i = 0 ; i < sizeof( wo) && !sizeof(pc_ret) ; i++ )
                if ( wo[i] )
                    search_normal_ob( wo[i]) ;
            tmp=sizeof(pc_ret);
	}
    }
    if (mappingp(ob) || !tmp)
    {
	/* Suche nach einem virtuellen Objekt im Raum oder am Spieler */
	tmp=({(["name":		pc_present_string,
		"nummer":	pc_present_number,
		"adjektiv":	pc_adjs
	    ])})+pc_v_path;

        if ( objectp( wo) )
	{
	    if (ret=({mapping})wo->query_v_item(tmp))
		pc_ret=({ret});
        }
	else
        {
            for ( i = 0 ; i < sizeof( wo) && !sizeof(pc_ret) ; i++ )
                if ( wo[i] && (ret=({mapping})wo[i]->query_v_item(tmp)) )
                    pc_ret=({ret});
	}
    }
    else if (pointerp(ob)) {
	/* Suche nach einem virtuellen Objekt OHNE Start-Objekt */
	/* Hier muss man nochmals die ganze Liste durchgehen, wenn
	   das 1. Objekt nicht anspricht */
	tmp=({(["name":		pc_present_string,
		"nummer":	pc_present_number,
		"adjektiv":	pc_adjs
	    ])})+pc_v_path;

	if (ret=({mapping})ob[0]->query_v_item(tmp))
	    pc_ret=({ret});
	else {
	    /* *seufz* Jetzt geht die Suche von vorne los */
            if ( objectp( wo) )
		inv=all_inventory(wo);
	    else
            {
                for ( inv = ({}) , i = 0 ; i < sizeof( wo) ; i++ )
                    if ( wo[i] )
                        inv += all_inventory( wo[i]) ;
            }
		
	    for (i=0; i<sizeof(inv); i++)
		if (ret=({mapping})inv[i]->query_v_item(tmp)) {
		    pc_ret=({ret});
		    break;
		    }
	    }
	}


    if (tmp=sizeof(pc_ret)) {
	if ((flag & PARSE_NO_V_ITEMS) && mappingp(pc_ret[0]))
	    PARSE_ERROR(PARSE_WRONG_ID)
	return ({ tmp, pc_ret, pc_rest, PARSE_OK, strip(pc_id_string),
				pc_trenner, pc_beyond_trenner });
	}

    if (!flag && sizeof(pc_v_path)) {
	// if (find_player("freaky"))
	//    tell_object(find_player("freaky"),sprintf("!! PC: V:"+query_verb()+": C:"+command+": %O\n",this_player()));
	return parse_com(command,rwo,trenn,PARSE_NO_V_ITEMS);
	}

    // Freaky: Vielleicht wuerde hier auch reichen: if (wo==this_player()) ?
    if (got_meins || rwo==this_player()) {
	if (pc_all)
	    PARSE_ERROR(PARSE_NO_ALL_MY_OB)
	PARSE_ERROR(PARSE_NO_MY_OB)
	}

    if (pc_all)
	PARSE_ERROR(PARSE_NO_ALL_OB)
    PARSE_ERROR(PARSE_NO_OB)
}

/*
FUNKTION: parse_com_error
DEKLARATION: int parse_com_error(mixed *parsed, string errormsg [, string only_one] )
BESCHREIBUNG:
parse_com_error dient der einfachen Behandlung von Fehlermeldungen.
Liefert parse_com einen Fehler zurueck, kreiert parse_com_error eine
entsprechende Fehlermeldung dazu. Nach dem parse_com_error(..) - Aufruf
sollte ein return 0 erfolgen, da es intern notify_fail(..) verwendet.

Parameter:

parsed		ist das Resultat eines vorhergehenden parse_com-Aufrufs.

errormsg	ist ein String, der dann ausgegeben wird (d.h. mit notify_fail()
                gesetzt wird), wenn kein Objekt gefunden wurde (zB ein Tippfehler
                im Kommando) und keine passendere Fehlermeldung generiert werden
                kann (z.B. trete xy ->  X nicht gefunden).

Optional:
only_one	Findet parse_com mehr als nur ein Objekt, auf dass die Be-
		schreibung passt, funktioniert aber das eigene Programm nur
		mit EINEM Objekt, so wird Nur_eins als Fehlermeldung ausge-
		geben.

Beispiel:
	mixed *parsed;

    parsed = parse_com(command);
    if (parse_com_error(parsed,"Nimm was ?\n","Immer nur eines nehmen.\n"))
	return 0;
    nimm(parsed[PARSE_OBS][0]);


oder:
	mixed *parsed;

    parsed = parse_com(command);
    if (parse_com_error(parsed,"Nimm was ?\n"))
	return 0;
    if (parsed[PARSE_NUM_OBS] > 1)
	nimm_mehrere(parsed[PARSE_OBS]);
    else
	nimm_einzelnes(parsed[PARSE_OBS][0]);


VERWEISE: parse_com
GRUPPEN: simul_efun, player
*/

#define NOTIFY_FAIL(x) this_object()->notify_fail(x)

varargs int parse_com_error(mixed *pa, string str, mixed only_one)
{
    switch (pa[PARSE_RET_CODE])
    {
	case PARSE_OK:
	    if (only_one && pa[PARSE_NUM_OBS]>1)
	    {
		NOTIFY_FAIL(stringp(only_one) ? only_one :
			"Immer eines nach dem anderen.\n");
		return 1;
	    }
	    return 0;
	case PARSE_NO_ARG:
	case PARSE_WRONG_ID:
	case PARSE_NOT_SEARCHED:
	    NOTIFY_FAIL(str);
	    return 1;
	case PARSE_NO_OB:
	    NOTIFY_FAIL(pa[PARSE_ID] == "" ?
		"Das gibt es da nicht.\n" :
	    	capitalize(pa[PARSE_ID])+" nicht gefunden.\n");
	    return 1;
	case PARSE_NO_MY_OB:
	    NOTIFY_FAIL(pa[PARSE_ID] == "" ?
		"Du hast das nicht bei dir.\n" :
	    	capitalize(pa[PARSE_ID])+" hast Du nicht bei dir.\n");
	    return 1;
	case PARSE_NO_ALL_OB:
	    NOTIFY_FAIL(pa[PARSE_ID] == "" ?
		"Da gibt es nichts.\n" : "Da gibt es nichts derartiges.\n");
	    return 1;
	case PARSE_NO_ALL_MY_OB:
	     NOTIFY_FAIL(pa[PARSE_ID] == "" ?
		"Du hast nichts bei dir.\n" :
		"Du hast nichts derartiges bei dir.\n");
	    return 1;
	default:
	    NOTIFY_FAIL("Da hat Monty wohl sagenhaften Mist programmiert.\n");
	    return 1;
    }

    return 0;
}

/******************************************************************************
 * parse_com ENDE !!!!
 *****************************************************************************/

#define DEBUG_ME 0
#define DEBUG_HERE 0

string its_me(string command, object ob)
{
    string *words, word, number, junk;
    object wo;
    mixed tmp;
    int i;

    pc_present_number=pc_all=0;
    pc_rest="";
    pc_adjs=({});
    pc_present_string="";
    number="";

    if (!ob || !strlen(command))
	return 0;
    wo=environment(ob);
    //if (!wo)     Wegen Garthans Magierladen :((((
    //	return 0;

    /* Alle Kommas in Spaces verwandeln und dann die Worte auseinadernehmen */
    words=explode(implode(explode(command,",")," ")," ")-({""});

    /* Ok. jetzt geht die Suche des Start-Objektes los */

    for (i=0; i<sizeof(words); i++)
    {
	word=lower_case(words[i]);
	if (word=="mich" || word=="mir")
	    return 0;
	else if (member(alles,word)>=0)
	    pc_all=1;
	else if (member(artikel,word)>=0)
	{
	}
	else if (member(meinesgleichen,word)>=0)
	{
	    if (!wo || wo != this_player())
		return 0;
	}
	else if (member(dinge,word)>=0)
	    break;
	else if (word[<1]=='.' && sscanf(word[0..<2],"%d",tmp))
	    pc_present_number=tmp;
	else if (sscanf(word,"%d%s",tmp,junk) && junk=="")
	    number+=word+" ";
	else if (ob->id(word) || (pc_all && ob->plural_id(word)))
	{
	    pc_present_string=word;
	    break;
	}
	else
	{
	    if (!ob->adjektiv(word))
		return 0;
	    pc_adjs+=({word});
	}
    }

    /************* Jetzt auswerten **********/

    if (i<sizeof(words)-1)		/* Es sind noch Woerter uebrig */
	pc_rest=command[strstr(command,words[i])+strlen(words[i])+1..];


#if DEBUG_ME
    D(words);
    D(i);
    D(pc_trenner);
    D(pc_beyond_trenner);
    D(pc_all);
    D(pc_present_string);
    D(pc_id_string);
    D(pc_rest);
    D(pc_adjs);
    D(pc_present_number);
    D(number);
    D(wo);
    D(ob);
#endif

    if (pc_all || pc_present_number < 2)
	return pc_rest;

    if (!wo)		// Wegen Garthans Magierladen :(((
	return 0;

    pc_present_string=number+pc_present_string;
    pc_ret=({});

    pc_obs = all_inventory(wo);
    if (pc_all)
	search_all();
    else
	search_ob();
    return member(pc_ret,ob)>=0?pc_rest:0;
}

varargs string its_here(string command, object ob, mixed name, mapping ret)
{
    string *satz, *words, word, *ids;
    mixed tmp;
    int i;

    pc_present_number=pc_all=0;
    pc_rest="";
    pc_adjs=({});
    pc_present_string="";
    ret=0;

    if (!ob || !strlen(command))
	return 0;

    satz=regexplode(command,
	    "( auf )|( an )|( von )|( in )|( am )|( im )|( vom )");

    /* Der Letzte Satzteil wird untersucht */
    /* Alle Kommas in Spaces verwandeln und dann die Worte auseinadernehmen */
    words=explode(implode(explode(satz[<1],",")," ")," ")-({""});

    /* Ok. jetzt geht die Suche des Start-Objektes los */

    for (i=0; i<sizeof(words); i++) {
	word=lower_case(words[i]);
	if (word=="mich" || word=="mir" || member(alles,word)>=0)
	    return 0;
	else if (member(artikel,word)>=0) {}
	else if (member(meinesgleichen,word)>=0) {
	    if (ob != this_player())
		return 0;
	    }
	else if (member(dinge,word)>=0)
	    return 0;
	else if (word[<1]=='.' && sscanf(word[0..<2],"%d",tmp))
	    pc_present_number=tmp;
	else if (ret=({mapping})ob->query_v_item(({word}))) {
	    pc_present_string=word;
	    break;
	    }
	else
	    pc_adjs+=({word});
	}

    /************* Jetzt auswerten **********/


    if (i<sizeof(words)-1)		/* Es sind noch Woerter uebrig */
	pc_rest=command[strstr(command,words[i])+strlen(words[i])+1..];
    else if (!ret)
	return 0;


#if DEBUG_HERE
    D(words);
    D(i);
    D(pc_trenner);
    D(pc_beyond_trenner);
    D(pc_all);
    D(pc_present_string);
    D(pc_id_string);
    D(pc_rest);
    D(pc_adjs);
    D(pc_present_number);
    D(ob);
#endif

    pc_v_path=({});
    for (i=sizeof(satz)-3; i>=0; i-=2)
	if (intp(tmp=make_v_path(satz[i],satz[i+1])))
	    return 0;
	else
	    pc_v_path+=({tmp});
#if DEBUG_HERE
    D(pc_v_path);
#endif

    tmp=([]);
    tmp["name"]=pc_present_string;
    tmp["adjektiv"]=pc_adjs;
    tmp["nummer"]=pc_present_number;

    ret=({mapping})ob->query_v_item(({tmp})+pc_v_path);
#if DEBUG_HERE
    D(ret);
#endif
    if (!name)
	return ret?pc_rest:0;
    if (!ret)
	return 0;
    ids = ret["id"];
    if (ids)
    	return (member(ids,name) >= 0) && pc_rest;
    return (ret["name"] == name) && pc_rest;
}
