// This file is part of UNItopia Mudlib.
// ----------------------------------------------------------------
// File:	/secure/simul_efun/paths.inc
// Description: Path-Handling routinen
// Author:	Monty
// Modified by: Freaky (16.09.94) Optimierung von abs_path

#pragma strict_types
#pragma save_types

/*
FUNKTION: file_path
DEKLARATION: string file_path([object file])
BESCHREIBUNG:
file_path liefert das Directory zurueck, in dem das File von ob steht. Wenn
ob nicht angegeben wird, dann wird this_object() genommen. Sollte ob ein 
Raum einer Subdomain sein, wird der richtige Pfad der Subdomain errechnet.
VERWEISE: file_name, abs_path, expand_path
GRUPPEN: simul_efun, file
*/
varargs string file_path(object ob)
{
    string dir;
    if (!ob)
	ob = previous_object();
    dir = (dir = map2domain(file_name(ob))) ? dir : file_name(ob);
    return implode(explode(dir, "/")[0..<2], "/");
}

/*
FUNKTION: abs_path
DEKLARATION: string abs_path(string path, [string absolute_path])
BESCHREIBUNG:
abs_path leifert den absoluten Pfad zu dem relativen Pfad path, bezogen auf 
den absoluten Pfad absolute_path zurueck. Hmmm, kompiziert ausgedrueckt...
Wenn abselute_path nicht mit angegeben ist, wird der Pfad genommen, in dem
this_object() steht.

Beispiel: 
    abs_path("../../obj") 
	liefert "/d/Vaniorh/obj", wenn es von einem Objekt in 
	/d/Vaniorh/monty/obj aufgerufen wird.
    abs_path("../../obj","/w/monty/zeug/krempel")
	liefert /w/monty/obj. Vorsicht, der relative Pfad darf nicht 
	mit einem "/" anfangen, wenn rel_path etwas machen soll,
    abs_path("/room/rathaus", "scheiss/egal/was")
	liefert /room/rathaus!

Es wird keinerlei Pruefung auf das Vorhandensein des Pfades gemacht!

VERWEISE: file_path, expand_path, file_name
GRUPPEN: simul_efun, file
*/
varargs string abs_path(string path, string absolute)
{
    string *abs, *rel;
    int i;

    if (!path || (absolute && absolute[0]!='/'))
	return 0;
    if (path[0]=='/') 
	return path;
    abs = explode(absolute ? absolute : file_path(), "/")-({".",""});
    rel = explode(path,"/")-({".",""});
    while(sizeof(rel) > i && rel[i] == "..")
	i++;
    return "/"+implode(abs[0..<i+1]+rel[i..],"/");
}
