// This file is part of UNItopia Mudlib.
// ----------------------------------------------------------------
// File:	/secure/simul_efun/time.inc
// Description: Funktionen zum Zeithandling
// Author:	Freaky, Francis
// Modified:    Monty (01.08 96): spiel_kurz_datum
//              Sissi (15.05.99): Ueberlaufproblem geloest, alles in
//                                ein konsistentes Schema gepresst.
//		Freaky (16.05.1999) short(v)timestr: Jahr wird mit fuehrender
//			0 angegeben (statt 01.01. 0: 01.01.00)
//

#pragma strict_types
#pragma save_types

private static mapping wtage=([ "Sun":"Sonntag", "Mon":"Montag",
	    "Tue":"Dienstag", "Wed":"Mittwoch", "Thu":"Donnerstag",
	    "Fri":"Freitag", "Sat":"Samstag" ]);
private static mapping monate=([ "Jan":"Januar", "Feb":"Februar",
	    "Mar":"Maerz", "Apr":"April", "May":"Mai", "Jun":"Juni",
	    "Jul":"Juli", "Aug":"August", "Sep":"September", "Oct":"Oktober",
	    "Nov":"November", "Dec":"Dezember" ]);
private static string* months = ({ "Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec" });


/*
FUNKTION: time_to_vtime
DEKLARATION: int time_to_vtime(int time)
BESCHREIBUNG:
Rechnet Realzeit (time(), sec seit 1970) in Spielzeit (vtime(), sec seit 0) um.
VERWEISE: vtime_to_time, time, vtime
GRUPPEN: simul_efun, zeit
*/
int time_to_vtime(int t)
{
    return t-BIRTHDAY;
}

/*
FUNKTION: vtime_to_time
DEKLARATION: int vtime_to_time(int vtime)
BESCHREIBUNG:
Rechnet Spielzeit (vtime(), sec seit 0) in Realzeit (time(), sec seit 1970) um.
VERWEISE: time_to_vtime, time, vtime
GRUPPEN: simul_efun, zeit
*/
int vtime_to_time(int z)
{
    return z+BIRTHDAY;
}

/*
FUNKTION: vtime
DEKLARATION: int vtime()
BESCHREIBUNG:
Liefert die Anzahl der Sekunden seit dem UNItopia besteht.
GRUPPEN: simul_efun, zeit
VERWEISE: datum, time, zeit_to_time, time_to_zeit
*/
int vtime()
{
    return time_to_vtime(time());
}

/*
FUNKTION: vtimestr
DEKLARATION: string vtimestr(int vtime)
BESCHREIBUNG:
Liefert einen String der Form Mittwoch 31. Maerz 12 18:47:15
in Spielzeit, das Analogon fuer Realzeit heisst timestr().
GRUPPEN: simul_efun, zeit
VERWEISE: zeit, dtime, ctime, time
*/
string vtimestr(int clock)
{
    string wtag, monat, uhr;
    int tag, jahr, vier_jahre;

    vier_jahre = clock / SEC_IN_28_YEARS;
    clock = clock % SEC_IN_28_YEARS;
    sscanf(ctime(clock*TIMEWARP),"%s %s %d %s %d",wtag,monat,tag,uhr,jahr);
    jahr += 28 * vier_jahre;
    return wtage[wtag]+" "+tag+". "+monate[monat]+" "+(jahr-1970)+" "+uhr;
}

/*
FUNKTION: shortvtimestr
DEKLARATION: string shortvtimestr(int spiel_zeit)
BESCHREIBUNG:
Liefert einen String mit dem Datum in der Form: TT.MM.JJ hh.mm.ss,
spiel_zeit ist dabei die Anzahl der Sekunden seit 0, in Spielzeit (vtime()).
Das Analogon fuer Realzeit ist shorttimestr().
GRUPPEN: simul_efun, zeit
VERWEISE: time, vtime, vtimestr, timestr
*/
string shortvtimestr(int clock)
{
    string wtag, monat, uhr;
    int tag, jahr, vier_jahre;

    vier_jahre = clock / SEC_IN_28_YEARS;
    clock = clock % SEC_IN_28_YEARS;
    sscanf(ctime(clock*TIMEWARP),"%s %s %d %s %d",wtag,monat,tag,uhr,jahr);
    jahr += 28 * vier_jahre;
    return ("00"+tag)[<2..]+"."+("00"+(member_array(monat,months)+1))[<2..]+
	   "."+("00"+(jahr-1970))[<2..]+" "+uhr;
}

/*
FUNKTION: vclock
DEKLARATION: int vclock()
BESCHREIBUNG:
Liefert einen Integer im Format: hhmmss mit der Spieluhrzeit
GRUPPEN: simul_efun, zeit
VERWEISE: clock, time, timestr, vtime, vtimestr
*/
int vclock()
{
    string ti;
    int clock;
    clock = (vtime()%REAL_SECONDS_PER_DAY) * TIMEWARP;
    ti=ctime(clock);
    return to_int(ti[11..12])*10000+
	   to_int(ti[14..15])*100+
	   to_int(ti[17..18]);
}

/*
FUNKTION: format_vseconds
DEKLARATION: string format_vseconds(int seconds)
BESCHREIBUNG:
Liefert fuer seconds einen String der Form:
'x Tage x Stunden x Minuten x Sekunden'
wobei die Ausgabe in Spielzeit ist.
GRUPPEN: simul_efun, zeit
VERWEISE: time
*/
string format_seconds (int seconds);
string format_vseconds (int seconds)
{
    return format_seconds (seconds * TIMEWARP);
}

/*
FUNKTION: timestr
DEKLARATION: string timestr(int clock)
BESCHREIBUNG:
Gibt einen deutschsprachigen String mit dem aktuellen Datum und der aktuellen
Uhrzeit zurueck. Das Argument clock sollte die Anzahl an Sekunden seit dem
1. Januar 1970 00:00:00 sein (wird von time() geliefert). Das Analogon fuer
Spielzeit ist vtimestr().
GRUPPEN: simul_efun, zeit
VERWEISE: time, ctime, vtimestr
*/
string timestr(int clock)
{
    string wtag, monat, uhr;
    int tag, jahr;

    sscanf(ctime(clock),"%s %s %d %s %d",wtag,monat,tag,uhr,jahr);

    return wtage[wtag]+" "+tag+". "+monate[monat]+" "+jahr+" "+uhr;
}

/*
FUNKTION: shorttimestr
DEKLARATION: string shorttimestr(int clock)
BESCHREIBUNG:
Liefert einen String mit dem Datum in der Form: TT.MM.JJ hh.mm.ss
clock ist dabei die Anzahl der Sekunden seit 1970 (time()).
Das Analogon fuer Spielzeit ist shortvtimestr().
GRUPPEN: simul_efun, zeit
VERWEISE: time, timestr, vtime, vtimestr, shortvtimestr
*/
string shorttimestr(int clock)
{
    string wtag, monat, uhr;
    int jahr, tag;

    sscanf(ctime(clock),"%s %s %d %s %d",wtag,monat,tag,uhr,jahr);

    return ("00"+tag)[<2..]+"."+("00"+(member_array(monat,months)+1))[<2..]+
	   "."+("00"+jahr)[<2..]+" "+uhr;
}

/*
FUNKTION: clock
DEKLARATION: int clock()
BESCHREIBUNG:
Liefert einen Integer im Format: hhmmss mit der Realuhrzeit
GRUPPEN: simul_efun, zeit
VERWEISE: vclock, time, timestr, vtime, vtimestr
*/
int clock()
{
    string ti;

    ti=ctime(time());
    return to_int(ti[11..12])*10000+
	   to_int(ti[14..15])*100+
	   to_int(ti[17..18]);
}

/*
FUNKTION: format_seconds
DEKLARATION: string format_seconds(int seconds)
BESCHREIBUNG:
Liefert einen String der Form:
'x Tage x Stunden x Minuten x Sekunden'
GRUPPEN: simul_efun, zeit
VERWEISE: time
*/
string format_seconds(int rest) {
	int tmp;
	string format;

    format = "";
    tmp = rest/86400;
    if(tmp) {
	if (tmp == 1)
	    format += "1 Tag ";
	else
	    format += tmp+" Tage ";
	rest -= tmp*86400;
	}
    tmp = rest/3600;
    if (tmp) {
	if (tmp == 1)
	    format += "1 Stunde ";
	else
	    format += ""+tmp+" Stunden ";
	rest -= tmp*3600;
	}
    tmp = rest/60;
    if (tmp) {
	if (tmp == 1)
	    format += "1 Minute ";
	else
	    format += ""+tmp+" Minuten ";
	rest -= tmp*60;
	}
    if (rest) {
	if (rest == 1)
	    format += "1 Sekunde";
	else
	    format += ""+rest+" Sekunden";
	}
    // Wenn die Sekunden genau aufgehen, steht ein Space am Ende!
    if (format[<1..<1]==" ")
	format = format[0..<2];
    return format;
}

/*
FUNKTION: real_time_diff
DEKLARATION: int real_time_diff(int zeit_von, int zeit_bis)
BESCHREIBUNG:
Liefert aus zwei Spielzeiten (Format: hhmmss wie es uhrzeit() liefert)
die Differenz in realen Sekunden zurueck.
Ist der zweite Parameter kleiner als der erste, so wird
ein Spieltag (!) hinzuaddiert.
Anwendung zB bei call_outs.

Beispiel:
       real_time_diff(011259,020011)  -->  314

VERWEISE: zeit,uhrzeit,datum
GRUPPEN: simul_efun, zeit
*/
int real_time_diff(int t1, int t2) {
	int vd;

    vd = ((t2 % 100) + ((t2/100) % 100)*60 + (t2/10000)*3600) -
	 ((t1 % 100) + ((t1/100) % 100)*60 + (t1/10000)*3600);
    if (vd < 0)
	vd += 86400;
    return vd/TIMEWARP;
}

/*
FUNKTION: file_time
DEKLARATION: int file_time(string file)
BESCHREIBUNG:
Liefert das File-Datum des Files <file>
VERWEISE: file_size, dtime, ctime
GRUPPEN: simul_efun, zeit, file
*/
int file_time(string file) {
    int *dir;
    if (!geteuid(previous_object()))
	return -1;
    dir=get_dir(file,4);
    if (sizeof(dir)==1)
	return dir[0];
    return -1;
}

/*
FUNKTION: query_up_time
DEKLARATION: int query_up_time()
BESCHREIBUNG:
Gibt die Zeit in Sekunden seit dem letzten System-Start zurueck.
GRUPPEN: simul_efun, zeit
VERWEISE: time
*/
int query_up_time()
{
    return time()-get_extra_wizinfo(0)["start"];
}

// -----------------------------------------------------------
// Hier endet die neue time.inc und beginnt die alte time.inc
// Alles folgende fliegt nach dem Tag des Ueberlaufs raus.
// -----------------------------------------------------------

/*
FUNKTION: datum
DEKLARATION: string datum(int spiel_zeit)
BESCHREIBUNG:
Liefert einen String der Form Mittwoch 31. Maerz 12 18:47:15
in Spielzeit, das Analogon fuer Realzeit heisst dtime().
Diese Funktion nicht mehr verwenden!
Ersetzt durch vtimestr().
GRUPPEN: simul_efun, zeit
VERWEISE: zeit, time, vtimestr
*/
string datum(int clock) {
    string wtag, monat, uhr;
    int tag, jahr;

    sscanf(ctime(clock),"%s %s %d %s %d",wtag,monat,tag,uhr,jahr);

    /*
    h = (h + 22) % 24;
    if (h < 10)
	uhr = " 0"+h+":"+uhr;
    else
	uhr = " "+h+":"+uhr;
    */

    return wtage[wtag]+" "+tag+". "+monate[monat]+" "+(jahr-1970)+" "+uhr;
}


/*
FUNKTION: dtime
DEKLARATION: string dtime(int clock)
BESCHREIBUNG:
Gibt einen deutschen String mit dem aktuellen Datum und der aktuellen Uhrzeit
zurueck. Das Argument clock sollte die Anzahl an Sekunden seit dem
1. Januar 1970 00:00:00 sein (wird von time() geliefert). Das Analogon fuer
Spielzeit ist datum().
Diese Funktion nicht mehr verwenden!
Ersetzt durch timestr.
GRUPPEN: simul_efun, zeit
VERWEISE: time, ctime, timestr, vtimestr
*/
string dtime(int clock) {
    string wtag, monat, uhr;
    int tag, jahr;

    sscanf(ctime(clock),"%s %s %d %s %d",wtag,monat,tag,uhr,jahr);

    return wtage[wtag]+" "+tag+". "+monate[monat]+" "+jahr+" "+uhr;
}

/*
FUNKTION: kurz_datum
DEKLARATION: string kurz_datum(int clock)
BESCHREIBUNG:
Liefert einen String mit dem Datum in der Form: TT.MM.JJ hh.mm.ss
clock ist dabei die Anzahl der Sekunden seit 1970 (time()).
Das Analogon fuer Spielzeit ist spiel_kurz_datum().
Diese Funktion nicht mehr verwenden!
Sie wurde ersetzt durch shorttimestr.
GRUPPEN: simul_efun, zeit
VERWEISE: time, dtime, ctime, spiel_kurz_datum
*/
string kurz_datum(int clock) {
    string wtag, monat, uhr, *months;
    int jahr, tag;

    months = ({ "Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec" });

    sscanf(ctime(clock),"%s %s %d %s %d",wtag,monat,tag,uhr,jahr);

    return ("00"+tag)[<2..]+"."+("00"+(member_array(monat,months)+1))[<2..]+
	   "."+("  "+jahr)[<2..]+" "+uhr;
}

/*
FUNKTION: spiel_kurz_datum
DEKLARATION: string spiel_kurz_datum(int spiel_zeit)
BESCHREIBUNG:
Liefert einen String mit dem Datum in der Form: TT.MM.JJ hh.mm.ss
spiel_zeit ist dabei die Anzahl der Sekunden seit 0, in Spielzeit (zeit()).
Das Analogon fuer Realzeit ist kurz_datum().
Diese Funktion nicht mehr verwenden!
Sie wurde ersetzt durch shortvtime.
GRUPPEN: simul_efun, zeit
VERWEISE: zeit, datum, ctime, spiel_kurz_datum
*/
string spiel_kurz_datum(int clock) {
    int jahr;
    string date;

    date = kurz_datum(clock);
    sscanf(date[6..7], "%d", jahr);

    // Rechnet Jahr Realzeit (19)XX in Jahr Spielzeit um
    // Das MUD rechnet in sec nach 1.1.00, der rest in sec nach 1.1.1970...
    jahr = ((jahr+100)-70) % 100;
    return date[0..5]+("00"+jahr)[<2..]+date[8..<1];
}


/*
FUNKTION: time_to_zeit
DEKLARATION: int time_to_zeit(int time)
BESCHREIBUNG:
Rechnet Realzeit (time(), sec seit 1970) in Spielzeit (zeit(), sec seit 0) um.
Diese Funktion bitte nicht mehr verwenden.
Fuer die Umwandlung dienen jetzt time_to_vtime und vtime_to_time.
VERWEISE: zeit_to_time, time, zeit
GRUPPEN: simul_efun, zeit
*/
int time_to_zeit(int t) {
    return (t-BIRTHDAY)*TIMEWARP;
}

/*
FUNKTION: zeit_to_time
DEKLARATION: int zeit_to_time(int zeit)
BESCHREIBUNG:
Rechnet Spielzeit (zeit(), sec seit 0) in Realzeit (time(), sec seit 1970) um.
Diese Funktion bitte nicht mehr verwenden.
Fuer die Umwandlung dienen jetzt time_to_vtime und vtime_to_time.
VERWEISE: time_to_zeit, time, zeit
GRUPPEN: simul_efun, zeit
*/
int zeit_to_time(int z) {
    return z/TIMEWARP+BIRTHDAY;
}
    
/*
FUNKTION: zeit
DEKLARATION: int zeit()
BESCHREIBUNG:
Liefert die Anzahl der Sekunden seit dem UNItopia besteht.
Diese Funktion bitte nicht mehr verwenden.
Stattdessen die Funktion vtime einsetzen.
GRUPPEN: simul_efun, zeit
VERWEISE: datum, time, zeit_to_time, time_to_zeit
*/
int zeit() {
    return time_to_zeit(time());
}

/*
FUNKTION: uhrzeit
DEKLARATION: int uhrzeit()
BESCHREIBUNG:
Liefert einen Integer im Format: hhmmss mit der Spielzeit
Diese Funktion nicht mehr verwenden sondern stattdessen vclock.
GRUPPEN: simul_efun, zeit
VERWEISE: zeit, datum
*/
int uhrzeit() {
    string ti;

    ti=ctime(zeit());
    // return ((to_int(ti[11..12])+22)%24)*10000+
    return to_int(ti[11..12])*10000+
	   to_int(ti[14..15])*100+
	   to_int(ti[17..18]);
}

