// This file is part of UNItopia Mudlib.
// ----------------------------------------------------------------
// File:	/secure/simul_efun/log.inc
// Description:	Funktionen zum Logging
// Author:	Freaky
// Modified by: Freaky (08.02.1999) sys_log: check eingebaut

#pragma strict_types
#pragma save_types

/*
FUNKTION: log_file
DEKLARATION: void log_file(string file_name, string message)
BESCHREIBUNG:
Haengt den String 'message' an das file /log/<file_name> an.
Ist fuer Debuggingzwecke oder zum Mitloggen.
GRUPPEN: simul_efun, file
VERWEISE: write_file
*/
void log_file(string fil, string mess)
{
    int size;
    string file;

    if (member(fil,'/') < 0)
    {
	size=file_size(file="/log/"+fil);
	if (size > 50000)
       	{
	    rename(file,file+".old");
	    size=-1;
	}
	if (size < 5)
	    write_file(file,sprintf("PO:%O  UID:%s\n",previous_object(),
		getuid(previous_object())));
	
	write_file(file,mess);
    }
}

/*
FUNKTION: sys_log
DEKLARATION: void sys_log(string file_name, string message)
BESCHREIBUNG:
Haengt den String 'message' an das file /log/sys/<file_name> an.
Ist fuer Debuggingzwecke oder zum Mitloggen von Systemdaten.
Steht nicht fuer normale Objekte zur Verfuegung.
GRUPPEN: simul_efun, file
VERWEISE: write_file, log_file
*/
void sys_log(string fil, string mess)
{
    string dir;
    
    dir = explode(file_name(previous_object()),"/")[1];
    if (member(({"obj","secure","apps","room"}),dir) >= 0)
    {
	write_file("/log/sys/"+fil,mess);
	return;
    }
    else
    {
	switch(fil)
	{
	    case "set_weight":
	    case "shop_teuer":
	    case "SHOUTS":
		write_file("/log/sys/"+fil,mess);
	    	return;
	    default:
	    	write_file("/log/sys/SYSLOG",sprintf("invalid syslog: '%s' '%s'",fil,mess));
	}
    }
}
