// This file is part of UNItopia Mudlib.
// ----------------------------------------------------------------
// File:        /secure/simul_efun/notify_fail.inc
// Description: notify_fail - Handling
// Author:      Sissi (28.08.97)

#pragma strict_types
#pragma save_types

#if ! __EFUN_DEFINED__(query_notify_fail)
mixed notify_fail;
object notify_fail_ob;

int notify_fail(mixed fail)
{
    if (fail)
    {
	efun::notify_fail(fail);
	notify_fail = fail;
	notify_fail_ob = previous_object();
    }
    else
	notify_fail = notify_fail_ob = 0;
    return 0;
}

mixed query_notify_fail()
{
    return notify_fail;
}
#endif

#if 0
object query_notify_fail_ob()
{
    return notify_fail_ob;
}
#endif

/**
*FUNKTION: notify_fail
DEKLARATION: int notify_fail(mixed fail)
BESCHREIBUNG:
Mit notify_fail() wird eine Fehlermeldung gesetzt, die der Spieler
anstelle der Standardmeldung "Wie bitte?" bekommt, wenn die Ausfuehrung
eines seiner Kommandos fehlschlaegt.

Anstatt eines Strings kann auch eine Closure benutzt werden. Diese wird 
ausgewertet, unmittelbar bevor der Spieler die Meldung erhaelt.

Wird notify_fail() mehrmals aufgerufen (beispielsweise von mehreren
Objekten, die dasselbe Kommando definieren), so wird die zuletzt gesetzte
Meldung ausgegeben.

Nach Moeglichkeit sollte ein Kommando
        notify_fail(meldung); return 0;
    anstatt von
        write(meldung); return 1;
    benutzen, da dann andere Objekte das Kommando auch noch auswerten koennen.

notify_fail() liefert immer 0 als Returnwert. Man kann also auch schreiben:
    return notify_fail(meldung);

VERWEISE: add_action, query_verb, query_notify_fail, query_notify_fail_ob
GRUPPEN: simul_efun, grundlegendes, player
*/

/**
*FUNKTION: query_notify_fail
DEKLARATION: mixed query_notify_fail()
BESCHREIBUNG:
Falls mit notify_fail eine Meldung gesetzt wurde, so kann diese mit
query_notify_fail abgefragt werden; dies kann sowohl ein string als auch
eine closure sein.
VERWEISE: add_action, query_verb, notify_fail, query_notify_fail_ob
GRUPPEN: simul_efun, grundlegendes, player
*/

/**
*FUNKTION: query_notify_fail_ob
DEKLARATION: object query_notify_fail_ob()
BESCHREIBUNG:
Falls mit notify_fail eine Meldung gesetzt wurde, so kann das Objekt,
welches diese gesetzt hat, mit query_notify_fail abgefragt werden.
VERWEISE: add_action, query_verb, notify_fail, query_notify_fail
GRUPPEN: simul_efun, grundlegendes, player
*/

