// This file is part of UNItopia Mudlib.
// ----------------------------------------------------------------
// File:	/secure/simul_efun/search_object.inc
// Description: search_object sucht Objekt ueber Objektstring
// Author:	Freaky
// Modified by: Parsec (15.05.98)  flag == 4 eingefuehrt
// 		Freaky (01.06.1998) present() eingebaut
//		Freaky (15.02.1999) Bugfix bei 'obj:1:2'
//                     

#pragma strict_types
#pragma save_types

#define FAIL(x) { notify_fail(x); return 0; }

/*
FUNKTION: search_object
DEKLARATION: mixed search_object(string objekt_string [,int flag] )
BESCHREIBUNG:
Sucht ein Objekt ueber den angegebenen Objektstring.
Der Objektstring ist in /static/help/goetter/zauberstab/objektstring
erklaert.
Wenn flag == 1 angegeben wurde, werden auch Virtuelle Objekte gesucht.
Wenn flag == 2 angegeben wurde, wird nicht versucht das Objekt zu laden,
das in der Markierung steht.
Wenn flag == 4 gesetzt ist wird zuerst in der Umgebung und dann in
this_player() selbst gesucht (so wie bei parse_com()).
GRUPPEN: simul_efun, objekt
VERWEISE: 
*/
varargs mixed search_object(string str, int flag)
{
    mixed *parsed, ob;
    string *strs, typ, obst, mark_str;
    object ob2, me;
    int i, nr;

    if (!str || str == "")
	str = "@";

    strs = explode(str,":") - ({""});
    if (sizeof(strs)<=0)
	FAIL("Fehler im Objekt-String.\n")

    if (this_player())
	ob2 = ({object})this_player()->query_mark(0);

    /* Finde das Anfangs-Objekt */

    if (sscanf(strs[0],"%s|%s",typ,obst) == 2)  /*** Typen-Objekt ***/
	switch(lower_case(typ))
	{
	  case "s":
	    ob = find_player(obst);
	    if (!ob)
		ob = find_player(lower_case(obst));
	    if (!ob)
		FAIL("Spieler " + obst + " nicht gefunden.\n")
	    break;
	  case "l":
	    ob = find_living(obst);
	    if (!ob)
		ob = find_living(lower_case(obst));
	    if (!ob)
		FAIL("Lebewesen " + obst + " nicht gefunden.\n")
	    break;
	  case "o":
	    ob = find_object(obst);
	    if (!ob)
		FAIL("Objekt " + obst + " nicht gefunden.\n")
	    break;
	  case "t":
	    ob = touch(this_player()->add_path(obst),NO_LOG);
	    if (!ob)
		FAIL("");
	    break;
	  case "c":
	    if (!touch(this_player()->add_path(obst),NO_LOG))
		FAIL("");
	    me = this_object();
	    set_this_object(previous_object());
	    ob = clone_object(({string})this_player()->add_path(obst));
	    set_this_object(me);
	    if (!ob)
		FAIL("Das Objekt hat sich im create() zerstoert.\n");
	    break;
          default:
	    FAIL("Typ '" + typ + "' kenne ich nicht.\n")
	}
    else if (strs[0][0] == '@') /*** Markierung ***/
    {
	if (!this_player())
	    FAIL("Kann keine Markierungen holen.\n");
	if (strs[0] == "@") 
	    nr = 0;
	else 
            if (!sscanf(strs[0][1..],"%d",nr) || nr < 0 || nr > 9)
		FAIL("Markierung " + strs[0] + " kenne ich nicht.\n")
	ob = ({object})this_player()->query_mark(nr);
	if (!ob)
	{
	    mark_str = ({string})this_player()->query_mark(nr,1);
	    if (!mark_str)
		FAIL("In Markierung @" + nr + " ist nichts markiert.\n")
	    ob = find_object(mark_str);
	    if (ob)
	    	this_player()->set_mark(nr,ob);
	    else if (!(flag & 2))
	    {
		int junk;
		string st;
		if (sscanf(mark_str,"%s#%d",st,junk) != 2)
		    ob = touch(mark_str,NO_LOG);
		if (!ob)
		    FAIL("In Markierung @" + nr + " ist nichts markiert.\n")
		this_player()->set_mark(nr,ob);
	    }
	    else
		FAIL("In Markierung @" + nr + " ist nichts markiert.\n")
	}
    }
    else if (!str2int(strs[0],&nr)) /*** Objekt Nr. ***/
    {
        if (!ob2)
	    FAIL("In Markierung @0 ist nichts markiert.\n")
	for (ob = first_inventory(ob2); nr > i++ && ob; ob = next_inventory(ob))
	    ;
	if (!ob)
	    FAIL("Das Objekt Nr." + nr + " ist nicht in " + Name(ob2) + "\n")
    }
    else switch(strs[0])    /*** Umgebung, mich, hier, sonstiges ***/
    {
      case "umgebung":
      case "^":
	if (!ob2)
	    FAIL("In Markierung @0 ist nichts markiert.\n")
	ob = environment(ob2);
	if (!ob)
	    FAIL("Objekt " + Name(ob2) + " hat keine Umgebung.\n")
	break;
      case "mich":
	ob = this_player();
	break;
      case "hier":
	ob = environment(this_player());
	break;
      default:
	if (!ob)
	    ob = present(strs[0],this_player());
	if (!ob)
	    ob = present(lower_case(strs[0]),this_player());
	if (!ob)
	    ob = present(strs[0],environment(this_player()));
	if (!ob)
	    ob = present(lower_case(strs[0]),environment(this_player()));
	if (!ob)
	{
	    if (flag & 4)
		parsed = parse_com(strs[0],0,0,
			(flag & 1 ? 0 : PARSE_NO_V_ITEMS));
	    else
		parsed = parse_com(strs[0],
			({this_player(),environment(this_player())}),0,
			(flag & 1 ? 0 : PARSE_NO_V_ITEMS));
	    if (parsed[PARSE_NUM_OBS] == 1)
		ob = parsed[PARSE_OBS][0];
	}
	if (!ob)
	    ob = find_player(strs[0]);
	if (!ob)
	    ob = find_player(lower_case(strs[0]));
	if (!ob)
	    ob = find_living(strs[0]);
	if (!ob)
	    ob = find_living(lower_case(strs[0]));
	if (!ob)
	    ob = find_object(strs[0]);
	if (!ob && this_player())
       	{
	    obst = ({string})this_player()->add_path(strs[0]);
	    ob = find_object(obst);
	    if (!ob)
		if (obst = ({string})MAP_OB->get_map_file_name(obst))
		    ob = find_object(obst);
	}
	if (!ob)
	    FAIL("Sorry, " + strs[0] + " ist nicht zu finden.\n");
    }

    /* Finde Folge-Objekte */

    for (i = 1; i < sizeof(strs); i++)
    {
	ob2 = ob;
	if (strs[i] == "umgebung" || strs[i] == "^")
       	{
	    ob = environment(ob2);
	    if (!ob)
		FAIL("Objekt " + Name(ob2) + " hat keine Umgebung.\n")
	}
	else
       	{
	    if (!str2int(strs[i],&nr))
	    {
		int j;
		for (j = 0, ob = first_inventory(ob2); nr>j++ && ob;
		       ob = next_inventory(ob))
		    ;
		if (!ob)
		    FAIL("Das Objekt Nr."+nr+" ist nicht in "+Name(ob2)+"\n")
	    }
	    else
	    {
		ob = present(strs[i],ob2);
		if (!ob)
		    ob = present(lower_case(strs[0]),ob2);
		if (!ob)
		{
		    parsed = parse_com(strs[i],ob2,0,
			    (flag & 1?0:PARSE_NO_V_ITEMS));
		    if (parsed[PARSE_NUM_OBS] != 1)
			FAIL("Objekt "+strs[i]+" ist nicht in "+Name(ob2)+".\n")
		    else
			ob = parsed[PARSE_OBS][0];
		}
	    }
	}
    }

    return ob;
}
