// This file is part of UNItopia Mudlib.
// ----------------------------------------------------------------
// File:	/secure/simul_efun/util.inc
// Description: Diverse simul_efun Goodies fuer den alltaeglichen Gebrauch
// Author:	Freaky, Francis, Garthan
// Modified by: Kurdel (27.01.97) cond_present

#pragma strict_types
#pragma save_types

/**
FUNKTION: clonep
DEKLARATION: int clonep( [object ob] )
BESCHREIBUNG:
Returned 1, falls das Objekt ob mit clone_object() erschafft (gecloned) wurde,
und 0, falls es mit touch() geladen wurde.
Default fuer ob ist this_object()

ACHTUNG: clonep() bedeutet hierbei, dass geschaut wird, ob der Filename
         in der Art '/dir/file#nummer' ist. clonep() liefert also bei
	 MAP-Raeumen 0, obwohl diese von /map/map gecloned werden, und
	 dann umbenannt werden.
	 efun::clonep() liefert in diesem Fall (clone und rename) 1
	 clonep() liefert hierbei 0

Beschreibung von efun::clonep()

        The efun returns 1 if <obj> is a clone, and 0 if it is not.
        The <obj> can be given as the object itself, or by its name.
        If <obj> is omitted, the current object is tested.

GRUPPEN: simul_efun, objekt, player
VERWEISE: playerp, objectp, load_name, clone_object
*/
varargs int clonep(object ob)
{
    string file;
    int junk;

    if (!ob)
	ob = previous_object();

    return objectp(ob) && sscanf(file_name(ob),"%s#%d",file,junk) == 2;
}


/*
FUNKTION: playerp
DEKLARATION: int playerp(object ob)
BESCHREIBUNG:
Returned 1, wenn das Objekt ein Spieler ist, ansonsten 0
GRUPPEN: simul_efun, objekt
VERWEISE: clonep
*/
int playerp(object ob)
{
    return objectp(ob) && MASTER_OB->playerp(ob);
}


/*
FUNKTION: get_align_string
DEKLARATION: string get_align_string(int align)
BESCHREIBUNG:
Liefert einen String zurueck, welcher Gesinnung ein Lebewesen ist.
(von "heilig" bis "daemonisch")
GRUPPEN: simul_efun, player
VERWEISE: 
*/
string get_align_string(int i) {
    if (i > A_HEILIG)
	return "heilig";
    if (i > A_GUT)
	return "gut";
    if (i > A_NETT)
	return "nett";
    if (i >= A_MIES)
	return "neutral";
    if (i >= A_TEUFLISCH)
	return "mies";
    if (i >= A_DAEMONISCH)
	return "teuflisch";
    return "daemonisch";
}


void shout(string str)
{
   // Mal ein bisschen Aufwand, damit man auch den wirklichen Urheber eines
   // Monsterbruellers erwischt (bisher bei zwinge monstet bruelle blabla: 0
   string temp;
   if (this_player())
      temp = (string)this_player()->query_real_name();
   if (!temp && this_interactive())
      temp = (string)this_interactive()->query_real_name();
   if (!temp && previous_object())
      temp = (string)previous_object()->query_real_name();
   EVENT_MASTER->event("Gebruell", this_player(), str);
   sys_log("SHOUTS", temp+": "+str+"\n");
}

object *users()
{
   return filter_array(efun::users(), lambda(({'ob}),
      ({ #'&&,
         ({ #'strstr, ({ #'file_name, 'ob }), LOGIN_OB"#" }),   
         ({ #'strstr, ({ #'file_name, 'ob }), WIZARD_SHELL_OB"#" }) }) ));
//   return filter_array(efun::users(), lambda(({'ob}),
//	   ({ #'strstr, ({ #'file_name, 'ob }), LOGIN_OB"#" }) ));
}


/*
FUNKTION: deep_present
DEKLARATION: object deep_present(mixed was, object wo)
BESCHREIBUNG:
deep_present sucht im Objekt 'wo' und in allen darin enthaltenen Objekten
nach 'was', wobei 'was' eine ID oder ein Objekt sein kann.

deep_present wird wie present aufgerufen, benoetigt aber immer
den zweiten Parameter.
VERWEISE: present
GRUPPEN: simul_efun, objekt
*/
object deep_present(mixed was, object wo)
{
   object *inv, ob;
   int i;

   if(!wo)
      return 0;
   if(ob = present(was, wo))
      return ob;
   if(!(inv = all_inventory(wo)))
      return 0;
   for(i = 0; i < sizeof(inv); i++)
      if(ob = deep_present(was, inv[i]))
	 return ob;
}


/*
FUNKTION: cond_present
DEKLARATION: object cond_present(string was, object wo, mixed fun, [ mixed args])
BESCHREIBUNG:
cond_present (conditional present) sucht im Objekt 'wo' nach dem ersten
Objekt ob mit der id 'was', welches beim Aufruf von ob->fun(arg1, arg2, ...)
einen Wert != 0 zurueckgibt.
args koennen beliebig viele Parameter arg1, arg2, ... sein.
fun kann auch eine Closure sein, die dann mit ob als erstem Parameter und
arg1, arg2, ... als restliche Parameter aufgerufen wird.
Ist fun weder ein String noch eine Closure, liefert es present(was, wo)
zurueck.
Ist die id 'was' 0 oder "", dann wird nicht auf die id geachtet.

Anwendungsbeispiele:

Eine Fackel im Fackelhalter, hidden_until_next_move
Ist eine Fackel im Fackelhalter:
   if (cond_present("fackel",this_object(),"query_invis"))
(In den Raum gelegte sichtbare Fackeln stoeren so nicht.)
Besser noch den Fackelhalter zum echten Container machen ...

Hat der Spieler einen bestimmten Schutzmantel angezogen (!) gegen
Hitze/Kaelte/Saeure ... ?
   if (cond_present("schutzmantel",this_player(),"query_worn"))
Inkorrekt ist if das naheliegende if ((mantel = present("schutzmantel",
this_player())) && mantel->query_worn()), es koennte ja von zwei Maenteln
erst der zweite angezogen sein.

Hat ein Spieler ein reissfestes Seil aus Leder?
   cond_present("seil", player, "material", "leder")

Hat ein Spieler eine Waffe mit Wirkung gegen das Monster dabei?
   cond_present("waffe", this_player(), "query_extra_damage", monster, player)

Ist hier jemand oder etwas im Raum aggressiv ?
   cond_present(0, room, "query_aggressive")

Gibts ein Lebewesen im Raum?
   cond_present(0, room, #'living)
VERWEISE: present
GRUPPEN: simul_efun
*/
varargs object cond_present(string was, object wo, varargs mixed args)
{
   closure cl;
   object *obs;
   int i,end;

   if (stringp(args[0]))
      cl = #'call_other;
   else if (closurep(args[0]))
   {
      cl = args[0];
      args = args[1..];
   }
   else
      return present(was, wo);
   if (!wo)
      return 0;
   end = sizeof(obs = all_inventory(wo));
   if (was && was!="")
   {
      for(i = 0; i < end; i++)
         if (obs[i]->id(was) && apply(cl, obs[i], args))
            return obs[i];
   }
   else
      for(i = 0; i < end; i++)
         if (apply(cl, obs[i], args))
            return obs[i];
}


/*
FUNKTION: player_present
DEKLARATION: object player_present(object room)
BESCHREIBUNG:
Mit dieser Funktion kann man abfragen, ob ein (interaktiver) Spieler sich
in einem Raum befindet.
Wenn kein Argument uebergeben wird, wird this_object() genommen.
Die Funktion liefert den 1. Spieler, der gefunden wird (ansonsten 0)
VERWEISE:
GRUPPEN: simul_efun, player
*/
object player_present(object room) {
    int i, end;
    object *obs;

    obs=all_inventory(room || previous_object());

    for (end=sizeof(obs); i<end; i++)
	if (interactive(obs[i]))
	    return obs[i];
}


/*
FUNKTION: Name
DEKLARATION: string Name(object ob)
BESCHREIBUNG:
Liefert einen Cap-Namen des Objektes ob. (fuer Debugzwecke geeignet)
Entweder query_real_name, oder query_name oder query_short,
ansonsten den Filenamen des Objektes
GRUPPEN: simul_efun, objekt
VERWEISE:
*/
string Name(object ob) {
    string tmp;

    if (!objectp(ob))
        return "0";
    tmp=({string})ob->query_real_name();
    if (stringp(tmp) && tmp!="")
        return capitalize(tmp);
    tmp=({string})ob->query_name();
    if (stringp(tmp) && tmp!="")
        return capitalize(tmp);
    tmp=({string})ob->query_short();
    if (stringp(tmp) && tmp!="")
        return capitalize(tmp);
    return "OBJ("+file_name(ob)+")";
}


/*
FUNKTION: arr_delete
DEKLARATION: mixed *arr_delete(mixed *array, int index)
BESCHREIBUNG:
Loescht aus dem Array <array> das Feld mit dem Index <index> und
returned das neue Array.
VERWEISE: m_delete
GRUPPEN: simul_efun, array
*/
mixed *arr_delete(mixed *arr, int i) {
    int s;

    if ((s=sizeof(arr)) && i<s && i>=0)
        arr[i..i]=({});
    return arr;
}


/*
FUNKTION: query_real_player_level
DEKLARATION: int query_real_player_level(object player)
BESCHREIBUNG:
Liefert den Level eines Spielers (wenn 'ob' einer ist)
ansosnten 0
GRUPPEN: simul_efun, player
VERWEISE: playerp
*/
int query_real_player_level(object player)
{
    return playerp(player) && player->query_level();
}

#ifdef RELAYD
string query_ip_name(object ob) {
    string ip_name, real_ip_name;

    if (ip_name=efun::query_ip_name(ob))
	if (real_ip_name=({string})ob->query_real_ip_name())
	    return real_ip_name;
    return ip_name;
}

string query_ip_number(object ob) {
    string ip_number, real_ip_number;

    if (ip_number=efun::query_ip_number(ob))
	if (real_ip_number=({string})ob->query_real_ip_number())
	    return real_ip_number;
    return ip_number;
}
#endif
