/*******************
** Eldarea MUDLib **
********************
**
** /secure/udp/tell.c - remote tell service
**
** CVS DATA
** $Date: 2001/02/07 10:09:58 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: tell.c,v $
** Revision 1.2  2001/02/07 10:09:58  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "/std/player/comm";

#include <udp.h>
#include <properties.h>
#include <defines.h>

#if !defined(INETD)
#define INETD	"/secure/inetd"
#endif

string retstr, myname="";
string last_name;

void udp_tell(mapping data) {
	object ob;
	string message_string, message_prefix;
	int i;

	if (data[RECIPIENT] && (ob = find_player(
		data[RECIPIENT]=lower_case(data[RECIPIENT]))) &&
		interactive(ob)) {
		// Zeichen mit Code<32 entfernen:
                data[SENDER]=to_string(filter_array(
			to_array(data[SENDER]), #'>=, ' '));
		data[DATA]=to_string(filter_array(
			to_array(data[DATA]), #'>=, ' '));
			
		retstr="";
                last_name="";
		myname=data[SENDER]+"@"+data[NAME];

		_tell(data[RECIPIENT]+" "+data[DATA]); // Originalfun benutzen

                if(ob->QueryProp(P_INVIS) || retstr[0]=='\n') {
                  INETD->send_udp(data[NAME], ([
                    REQUEST: REPLY,
                    RECIPIENT: data[SENDER],
                    ID: data[ID],
                    DATA: sprintf(ROOTNPC"@"MUDNAME": Spieler %s finde ich "
                                  "im "MUDNAME" nicht !\n", 
                                  capitalize(data[RECIPIENT])) ]) );
                  return;
                }
                else {
                  INETD->send_udp(data[NAME], ([
				REQUEST: REPLY,
				RECIPIENT: data[SENDER],
				ID: data[ID],
				DATA: retstr
				]) );   
        	  return;
		}
    } else if (data[RECIPIENT] && data[RECIPIENT]==lower_case(ROOTNPC)) {
    	INETD->send_udp(data[NAME], ([
        	REQUEST: REPLY,
        	RECIPIENT: data[SENDER],
        	ID: data[ID],
        	DATA: break_string(ROOTNPC"@"MUDNAME": Ich bin der Erschaffer "
				"des "MUDNAME"s. Weitere Anfragen bitte an einen Spieler "
				"oder Magier oder aber per Email an "ADMIN_EMAIL,
                                0, 0, BS_FOR_COMM)
        	]) );
    } else INETD->send_udp(data[NAME], ([
        REQUEST: REPLY,
        RECIPIENT: data[SENDER],
        ID: data[ID],
        DATA: sprintf(ROOTNPC"@"MUDNAME": Spieler %s finde ich im "MUDNAME
            " nicht !\n",capitalize(data[RECIPIENT]))
        ]) );
}

// Umleiten

void write(string str) { retstr+=str; }
varargs string name() { return myname; }
mixed QueryProp(string prop) {
	switch (prop) {
	case P_PRESAY : return "";
	}
	return 0;
}

// Dummys
mixed Set() {}
mixed Query() {}
// varargs string _comm_hook(string str) {return str;}
string slurr(string str) { return str; }
