/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: www.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD Mudlib
//
// SECURE/UDP/WWW.C -- WWW Client
// 
// Basierend auf Wunderland MUDlib
//
// $Revision: 1.1.1.1 $
//
// $Log: www.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:46  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:12  en
// MUDLib CVS Preperation
//

#pragma strong_types
#pragma combine_strings

#include <udp.h>
#include <www.h>

#define MYDEBUG 1

private mixed pending; // pending udp requests

// HTMLunescape -- try to resolve %<hex> escape codes from HTML/WWW
private string HTMLunescape(string char) {
  int len;
  if(!char || !(len = strlen(char))) return "";
  if(char[0] == '%' && len = 3) {
    int val, ch;
    while(--len) {
      switch(char[len]) {
      case '0'..'9':
        val = (int)char[len..len];
        break;
      case 'A'..'F':
        val = char[len]-55;
        break;
      }
      if(len < 2) val <<= 4;
      ch += val;
    }
    return sprintf("%c", ch);
  }
  return char;
}

private string translate(string str) {
  return implode(map_array(regexplode(str, "[%].."), #'HTMLunescape), "");
}

// decode() -- decode the input cmds string
private mapping decode(string input) {
  mixed	tmp; int i;
  mapping cmds;
  cmds = ([]);
  i = sizeof(tmp = explode(translate(input), "&"));
  while(i--)
  {
    if(sizeof(tmp[i] = explode(tmp[i], "=")) == 2)
      cmds[tmp[i][0]] = tmp[i][1];
  }
//  log_file(WWWLOG, "CMDS: "+sprintf("%O\n",cmds));
  return cmds;
}

// put() -- put together a key and a value
private string put(string key, mapping val) {
  return key+"="+val[key];
}
// encode() -- encode the input cmds string
private string encode(mapping input) { 
  return implode(map_array(m_indices(input), #'put, input),"&"); 
}

void Send(mapping data, string text, mixed back) {
  if(strstr((string)previous_object(), UDPPATH+"/")) return;
  if(!data && !pending) return;
  else if(!data && pending) 
  { 
    data = pending[0]; back = pending[1]; pending = 0; 
  }
  text = PAGEHEAD +
/*	"<P><TABLE BORDER=0 CELLPADDING=5 CELLSPACING=5 WIDTH=100%><TR>" +
	"<TD ALIGN=LEFT VALIGN=MIDDLE>" +
*/	text +
/*	"</TD><TD ALIGN=RIGHT VALIGN=MIDDLE>" +
	"<img src=\"../pics/but1.jpg\""
	"alt=\"Ein grausames Foto!!! nich???\" width=75 height=100 "
	"border=0></TD></TR></TABLE><P>" +
*/	PAGETAIL;
  INETD->send_udp(data[NAME], ([
	                       REQUEST: REPLY,
                                RECIPIENT: data[SENDER],
                                ID: data[ID],
			       "URL":data[DATA],
                                DATA: "Content-Length: "+strlen(text)+"\n\n"
				 +text+"\n"
                                ]));
}

private string exch(string str, mapping to) {
  if(!to[str]) return str;
  return to[str];
}

private string xcode(string str, mapping to) {
  return implode(map_array(regexplode(str, implode(m_indices(to), "|")),
                           #'exch, to), "");
}

void udp_www(mapping data) {
  string text, error;
  string back; int size;
  mapping cmds;

  error = catch(size = sizeof(cmds = decode(data[DATA])));
  if (!error && (!cmds["EXTRA"] || strlen(cmds["EXTRA"])<5))
    error="no EXTRA field.";
  if (data[HOST]=="141.76.1.2") error="Regenbogen Schutzschild.";
  if(!error && cmds[BACK])
    back = xcode(cmds[BACK], (["XampX":"&", "XeqX":"="]));
  if (!error) 
    cmds[BACK] = xcode(encode(cmds-([BACK])), (["&":"XampX", "=":"XeqX"]));
  if (error || 
      error=catch(text=(file_name(this_object())+"."+cmds[REQ])->Request(cmds)))
  {
#ifdef MYDEBUG
    text = "<H1>Fehler: "+error+"</H1><HR><H3>Kontext:</H3>"
	 + "<PRE>"+sprintf("%O", data)+"</PRE>";
#else
    text = "<H1>Fehler: Anfrage konnte nicht bearbeitet werden!</H1>";
#endif
    log_file(WWWLOG, "ERROR: "+error[0..<2]+", DATA FOLLOWS:\n");
  }
  log_file(WWWLOG, sprintf("[%s] (%s) %s\n", ctime(time())[4..15],
    data[HOST], data[DATA]));
  if(!error && cmds[REQ] == R_INTERMUD && !text) {
    pending = ({data, back});
    return 0;
  }
  pending = 0;
  funcall(#'Send, data, text, back);
}
