/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: www.news_m.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
// WWW.NEWS.C: WWW frontend for reading mud news
// --
// MorgenGrauen MUDlib Contribution
// $Date: 1999/11/05 12:30:46 $
// $Revision: 1.1.1.1 $

#pragma strong_types
#pragma combine_strings

#include <www.h>

#define NEWSD	"/secure/news"

#define N_GROUP 0
#define N_AUTHOR 1
#define N_DATE 3
#define N_TITLE 4
#define N_ARTICLE 5

varargs private string url(string group, string article)
{
  return "\""+MUDWWW+"?"+REQ+"="+R_NEWS
        +(group?"&"+GROUP+"="+group:"")
        +(article?"&"+ARTICLE+"="+article:"")+"\"";
}

varargs private string make_link(string text, string group, string article)
{
  if(!text || !strlen(text)) text = "-Unbenannt-";
  return "<A HREF="+url(group, article)+">"+text+"</A>";
}

string GroupList()
{
  string *list, ret;
  int i, t;

  list = NEWSD->GetGroups();
  for (i = 0, ret = ""; i < sizeof(list); i++)
    ret += sprintf("[%3d Artikel, %-6s] %s\n",
		   sizeof(NEWSD->GetNotes(list[i])),
		   dtime(t = NEWSD->GetNewsTime(list[i]))[5..11],
		   make_link(list[i],list[i]+":"+t));
  return "<H2>&Uuml;bersicht</H2>"
        +"<H3>["+sizeof(list)+" Gruppen, "
        +"letzte &Auml;nderung "+dtime(NEWSD->GetNewsTime())+"]</H3>"
        +"<PRE>" + ret +"</PRE>";
}

#define THREAD(a) ("#! rn="+(a[N_AUTHOR])+" rt="+(a[N_DATE]))

private int thread(mixed article, int i, mapping t)
{
  mixed info;
  if((info = explode(article[N_ARTICLE], "\n")[0])[0..1] == "#!")
  {
    string ttmp;
    ttmp = t[THREAD(article)];
    t[info] += ttmp + 1;
    if(!t[info, 1]) t[info, 1] = "";
    t[info, 1] = sprintf("[%-12s %-6s]%-3s %s\n",
			 article[N_AUTHOR]+":",
			 dtime(article[N_DATE])[5..11],
			 ttmp ? "+"+ttmp : " - ",
			 make_link(article[N_TITLE],
				   article[N_GROUP], (string)i))
               + t[info, 1];
    return 1;
  }
}

private int expired(mixed *list, int i)
{
  mixed info;
  if((info = explode(list[i][N_ARTICLE], "\n")[0])[0..1] == "#!")
  {
    info = regexplode(info, "rn=[^ ]*|rt=[^\n ]*");
    for(i--; i >= 0; i--)
      if(list[i][N_AUTHOR] == info[1][3..] &&
	 list[i][N_DATE] == to_int(info[3][3..]))
	return 0;
  }
  return 1;
}
    
string ArticleList(string group)
{
  string *list, ret;
  mapping t;
  int i;

  list = NEWSD->GetNotes(group = explode(group, ":")[0]);
  t = allocate_mapping(0,2);
  for (i = sizeof(list)-1, ret = ""; i >= 0; i--)
  {
    if(!thread(list[i], i, t) || expired(list, i))
    {
      string ttmp;
      ttmp = t[THREAD(list[i])];
      ret = sprintf("[%-12s %-6s]%-3s %s\n",
		    list[i][N_AUTHOR]+":",
		    dtime(list[i][N_DATE])[5..11],
                    ttmp ? "+"+ttmp : " - ",
		    make_link((string)list[i][N_TITLE], group, (string)i))
	  
          + ret;
    }
  }

  return "<H2>Gruppe: "+group+"</H2>"
        +"<H3>["+sizeof(list)+" Artikel, "
	+"letzte &Auml;nderung "+dtime(NEWSD->GetNewsTime(group))+"]</H3>"
        +"<PRE>" + ret + "</PRE>"
        +make_link("<IMG BORDER=0 SRC=\""+ICONS+"/gruppenuebersicht.gif\" "
		   +"ALT=\"Gruppenuebersicht\">");
}

private varargs string Message(string group, mixed article)
{
  mixed text, tmp, next, prev;
  string art;
  mapping t;
  int i;

  if (!article)
    article = 0;
  else article = to_int(article);

  text = (tmp = NEWSD->GetNotes(group = explode(group, ":")[0]))[article];

  t = allocate_mapping(0,2);
  for(i = sizeof(tmp)-1; i > article; i--)
    thread(tmp[i], i, t);
  next = "<IMG BORDER=0 SRC=\""+ICONS+"/naechster_artikel.gif\" "
       + "ALT=\"Naechster Artikel\">";
  prev = "<IMG BORDER=0 SRC=\""+ICONS+"/voriger_artikel.gif\" "
       + "ALT=\"Voriger Artikel\">";

  art = implode(explode(text[N_ARTICLE],"\n")
		[(text[N_ARTICLE][0..1]=="#!"?1:0)..], "\n");
  return "<H1>" + text[N_TITLE] + "</H1><HR>\n"
       + "<H3>" + group + ": " + text[N_AUTHOR]
       + " (" + dtime(text[N_DATE]) + ")\n</H3>"
       + "<PRE>" + art + "</PRE>\n"
       + (t[THREAD(text)] ?
          "<HR>Weitere Artikel zu diesem Thema:"
	+ "<PRE>" + t[THREAD(text), 1] + "</PRE><HR>" : "")
       + (article < sizeof(tmp)-1 ? make_link(next, group, article+1) : next)
       + (article ? make_link(prev, group, article-1) : prev)
       + make_link("<IMG BORDER=0 SRC=\""+ICONS+"/artikelliste.gif\" "
		   +"ALT=\"Artikeluebersicht\">", group)
       + make_link("<IMG BORDER=0 SRC=\""+ICONS+"/gruppenuebersicht.gif\" "
		   +"ALT=\"Gruppenuebersicht\">");
}

string Request(mapping cmds)
{
  string text;
  if(!cmds[GROUP]) text = GroupList();
  else
    if(!cmds[ARTICLE]) text = ArticleList(cmds[GROUP]);
    else text = Message(cmds[GROUP], cmds[ARTICLE]);

  return "<H2>"+MUDNAME+" Zeitung</H2><HR>"
        +text;
}
