/*******************
** Eldarea MUDLib **
********************
**
** /secure/userupdate.c - update old user savefiles and properties
**
** CVS DATA
** $Date: 2001/06/18 15:44:02 $
** $Revision: 1.1 $
**
** CVS History
**
** $Log: userupdate.c,v $
** Revision 1.1  2001/06/18 15:44:02  elatar
** initial revision
**
**
*/

#include <userupdate.h>
#include <properties.h>
#include <wizlevels.h>
#include <ansi.h>

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")
//#define DB(x)

void UpdateUser(object user)
{
  mixed data;
  
  if ( load_name(previous_object())!="/secure/login"
    && load_name(previous_object())!="/secure/master"
    && previous_object()!=user
    && secure_level()<ARCH_LVL)
    return;
  
  switch(user->QueryProp(P_PATCHLEVEL))
  {
    case  0:
      // player was never patched, even has no patchlevel property
      user->SetProp(P_PATCHLEVEL,SECURED|PROTECTED,F_MODE_AS);
      if ( !mappingp(data=user->QueryProp(P_VISION)) 
        || sizeof(data)<10)
        user->SetProp(P_VISION,([-2:0,-1:0,0:0,1:1,2:2,3:2,4:2,5:2,6:2,7:2]));
    case  1:
      user->Set(P_COLORS, SAVE, F_MODE_AS);
      user->Set(P_COLOR_GROUPS, SAVE, F_MODE_AS);
      if (!mappingp(user->QueryProp(P_COLORS)))
      {
        user->SetProp(P_COLORS,([ 0:ANSI_NORMAL;          "normal",
                                  1:ANSI_BLACK;           "schwarz",
                                  2:ANSI_RED;             "rot",
                                  3:ANSI_GREEN;           "gruen",
                                  4:ANSI_YELLOW;          "gelb",
                                  5:ANSI_BLUE;            "blau",
                                  6:ANSI_PURPLE;          "violett",
                                  7:ANSI_CYAN;            "cyan",
                                  8:ANSI_WHITE;           "weiss",
                                  9:ANSI_BLACK+ANSI_BOLD; "schwarz und fett",
                                 10:ANSI_RED+ANSI_BOLD;   "rot und fett",
                                 11:ANSI_GREEN+ANSI_BOLD; "gruen und fett",
                                 12:ANSI_YELLOW+ANSI_BOLD;"gelb und fett",
                                 13:ANSI_BLUE+ANSI_BOLD;  "blau und fett",
                                 14:ANSI_PURPLE+ANSI_BOLD;"violett und fett",
                                 15:ANSI_CYAN+ANSI_BOLD;  "cyan und fett",
                                 16:ANSI_WHITE+ANSI_BOLD; "weiss und fett",
                                 ]));      
      }
      if (!mappingp(user->QueryProp(P_COLORS)))
      {
        user->SetProp(P_COLOR_GROUPS,([CG_COLOR:     0,
                                       CG_TELL:      6,
                                       CG_EXITS:     3,
                                       CG_INFORM:    2,
                                       CG_AWAIT:     2,
/*                                       CG_CHANNEL1:  ,
                                       CG_CHANNEL2:  ,
                                       CG_CHANNEL3:  ,
                                       CG_CHANNEL4:  ,
                                       CG_CHANNEL5:  ,
                                       CG_CHANNEL6:  ,
                                       CG_CHANNEL7:  ,
                                       CG_CHANNEL8:  ,
                                       CG_FINGER:    ,*/
                                       CG_LIVING:    4,
                                       CG_INFO_NAME: 5,
                                       CG_INFO_VAL:  6,
                                       CG_INFO_BONUS:2,
                                       CG_PATH:      13,
                                       CG_DETAILS:   11,
                                       CG_LS_DIR:    16,
                                       CG_LS_LOADED: 6,
                                       CG_LS_C:      5,
                                       CG_LS_H:      5,
/*                                       CG_WHO_AWAIT: ,
                                       CG_WHO_WIZARD:*/
                                       ]));            
      }
    case  2:
  }
  user->SetPatchLevel(ACTUAL_PLAYER_PATCH);
}