/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: wahlmaschine.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
inherit "std/thing";

#include "/secure/wizlevels.h"
#include <defines.h>
#include <properties.h>
#include <homes.h>

#define TI this_interactive()

static mixed in_use;

string thema;
string *moeglichkeiten;
mixed *ergebnis;

static void __say( string str )
{
	write ( str );
	say ( str );
	log_file( "WAHL", str );
}

void create()
{
	if ( clonep() ) destruct(this_object());
	if ( ergebnis ) return 0;
  seteuid(getuid(this_object()));
  ::create();
  AddId(({"maschine", "waehler", "wahlmaschine"}));
  SetProp(P_NAME, "Wahlmaschine");
  SetProp(P_PLURAL, "");
  SetProp(P_GENDER, FEMALE );
  in_use=0;
  ergebnis=({({}),({})});
  moeglichkeiten=({});
  restore_object("wahl/wahl");
	move( DEFAULT_HOME );
}

string _query_long()
{
	return "Eine Wahlmaschine. Mit ihr koennen geheime Wahlen durchgefuehrt werden.\n"+
	       "Aktuelles Thema: "+(stringp(thema) ? thema : "keines")+"\n";
}


string _query_read_msg() { return 0; }

save_me()
{
  save_object("wahl/wahl");
}

void init()
{
  add_action("waehle", "waehl",1);
  add_action("auswertung","auswertung");
  add_action("wahlthema", "wahlthema");
  add_action("moeglichkeit","moeglichkeit");
}

int wahlthema(string str)
{
  if (!IS_ARCH(TI))
  {
    write("NOT allowed");
    return 1;
  }
  if (!str) return 0;
  thema=str;
  say(TI->name(WER)+" setzt ein neues Abstimmungsthema fest.\n");
  ergebnis=({({}),({})});
  moeglichkeiten=({});
  write("Ok.\n");
  save_me();
  return 1;
}

int moeglichkeit(string str)
{
  if (!IS_ARCH(TI))
  {
    write("NOT allowed");
    return 1;
  }
  if (!str) return 1;
  if (member_array(str, moeglichkeiten) != -1)
  {
    write("Schon drin.\n");
    return 1;
  }
  moeglichkeiten+=({str});
  write("Ok.\n");
  save_me();
  return 1;
}

int waehle()
{
  int i;

	if (!TI)
		return 0;
	if (!IS_SEER(TI) && TI->QueryProp(P_LEVEL)<10)
	{
		notify_fail("Man kann erst ab Stufe 10 mitwaehlen :(\n");
		return 0;
	}
  if (in_use)
  {
    write(in_use+" waehlt gerade, warte also bitte einen Augenblick.\n");
    return 1;
  }
  in_use=capitalize(getuid(TI));
  say(in_use+" tritt an die Wahlmaschine.\n");
  write(_query_long());
  write("Das steht zur Auswahl:\n");
  for (i=0;i<sizeof(moeglichkeiten);i++)
    write(sprintf(" -- %d.) %s\n",i+1,moeglichkeiten[i]));
  write("Triff nun Deine Wahl (sie ist UNSICHTBAR): ");
  input_to("waehle_2",1);
  return 1;
}

static int falsch()
{
  write("Diese Auswahl ist ungueltig. Versuchs bitte gleich nochmal.\n");
  say(in_use+" hat ausgewaehlt.\n");
  in_use=0;
  return 1;
}

static int waehle_2(string str)
{
	int i;

	if (!str) return falsch();
  if (member_array(str, moeglichkeiten)==-1)
  {
  	if ( !sscanf( str, "%d", i ) ) return falsch();
  	if ( i<1 || i>sizeof(moeglichkeiten) ) return falsch();
  	ergebnis=insert_alist(getuid(TI),moeglichkeiten[i-1],ergebnis);
  }
  else
  	ergebnis=insert_alist(getuid(TI),str,ergebnis);
  write("Ok.\n");
  save_me();
  say(in_use+" hat ausgewaehlt.\n");
  in_use=0;
  return 1;
}

int auswertung()
{
  int i,j,max;
  int *stimmen;

  max=sizeof(moeglichkeiten);
  stimmen=allocate(max+1);
  __say("\n\n\nWahlergebnisse zum Thema: "+thema+"\n");
  __say("\nGewaehlt haben folgende Personen: \n");
  for (i=0;i<sizeof(ergebnis[0]);i++)
    __say(ergebnis[0][i]+"\n");
  for (i=0;i<sizeof(ergebnis[1]);i++)
  {
    j=member_array(ergebnis[1][i],moeglichkeiten);
    if (j==-1) 
      stimmen[max]++;
    else
      stimmen[j]++;
  }
  __say("*****************************************\n");
  __say("Ergebnis:\n");
  for (i=0;i<max;i++)
    __say(sprintf(" -- %d.) %s\t: %d\n", i+1, moeglichkeiten[i],
       stimmen[i]));
  __say(sprintf("Ungueltig: %d\n",stimmen[max]));
  return 1;
}


