/*******************
** Eldarea MUDLib **
********************
**
** wizlevels.h  
**
** CVS DATA
** $Date: 2001/01/03 11:52:58 $
** $Revision: 1.2 $
**
** this file defines macros to determine wizard levels and rights
**
** CVS History
**
** $Log: wizlevels.h,v $
** Revision 1.2  2001/01/03 11:52:58  elatar
** slight wizlevels change
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
#ifndef _WIZLEVELS_
#define _WIZLEVELS_

#include "/secure/config.h"

#define	SEER_LVL 		1	//Obsolet
#define INACTIVE_LVL  2
#define	LEARNER_LVL 		3
#define	WIZARD_LVL 		4
#define DOMAINMEMBER_LVL 	4 //Obsolet
#define QUEST_LVL 		5
#define SPECIAL_LVL 		6
#define	LORD_LVL 		7
#define ELDER_LVL 		8
#define	ARCH_LVL 		9
#define FOUNDER_LVL 	       10	//Obsolet, just for compatability
#define GOD_LVL                10
#define FATHER_LVL	       10       //Obsolet, just for compatability

#define SEER_GRP 1
#define LEARNER_GRP 2
#define WIZARD_GRP 3
#define DOMAINMEMBER_GRP 4
#define SPECIAL_GRP 5
#define LORD_GRP 6
#define ELDER_GRP 7
#define ARCH_GRP 8

/* user is an object which is to be checked */
/* for example, use IS_WIZARD(this_player()) to check */
/* if a player is a wizard. */
#define IS_SEER(user) (query_wiz_level(user) >= SEER_LVL) //Obsolet
#define IS_INACTIVE(user) (query_wiz_level(user) >= INACTIVE_LVL)
#define IS_LEARNER(user) (query_wiz_level(user) >= LEARNER_LVL)
#define IS_SPECIAL(user) (query_wiz_level(user) >= SPECIAL_LVL)
#define IS_WIZARD(user) (query_wiz_level(user) >= WIZARD_LVL)
#define IS_DOMAINMEMBER(user) (query_wiz_level(user) >= DOMAINMEMBER_LVL) //Obsolet
#define IS_QUEST(user) (query_wiz_level(user) >= QUEST_LVL)
#define IS_LORD(user) (query_wiz_level(user) >= LORD_LVL)
#define IS_FOUNDER(user) (query_wiz_level(user) == FOUNDER_LVL) //Obsolet
#define IS_ELDER(user) (query_wiz_level(user) >= ELDER_LVL)
#define IS_ARCH(user) (query_wiz_level(user) >= ARCH_LVL)
#define IS_GOD(user) (query_wiz_level(user) >= GOD_LVL)
#define IS_FATHER(user) (query_wiz_level(user) == FATHER_LVL) //Obsolet

#define IS_LEARNING(user) (query_wiz_level(user) >= LEARNER_LVL &&\
                           user->QueryProp(P_WANTS_TO_LEARN))

#define HURRIKAP "/secure/service" //Obsolet
#define SERVICE "/secure/service"  //New define of hurrikap
#endif
