/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: zentralbank.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD Mudlib
//
// Basierend auf Wunderland Mudlib
//
// SECURE/ZENTRALBANK -- Mud Zentralbank
//
// Autor: Holger@Wunderland
//
// $Log: zentralbank.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:46  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:12  en
// MUDLib CVS Preperation
//

// Vorerst nur Ueberwachungsfunktionen!!!

inherit "std/room";

#include <properties.h>
#include <defines.h>
#include <config.h>
#include <wizlevels.h>
#include <bank.h>

#pragma strong_types;

#define RESERVE "RESERVE"

int ResetAll();
int ShortReport();

int NewMember(string who, int amount, int zins);
int RemoveMember(string who);

int PutMoney(mixed ob, int amount);
int GetMoney(mixed ob, int amount);

int start_time;

// ([ inhaber: geld, zeit, incount, outcount, zinsen ])
mapping konten;

/////////////////////////////////////////////////////////////////////////////

private int secure() {
  if(!previous_object())
    return 0;
  if(geteuid(previous_object()) == ROOTID)
    return 1;
  if(this_interactive() != PL)
    return 0;
  if(!IS_ARCH(this_interactive()))
    return 0;
  return 1;
}

void create() {
  seteuid(getuid(this_object()));
  ::create();

  if(!restore_object(SAVEFILE))
    ResetAll();

  SetProp( P_INDOORS, 1 );
  SetProp( P_LIGHT, 1 );
  SetProp( P_INT_SHORT, "In der "MUDNAME"-Zentralbank");
  SetProp( P_INT_LONG, "Du stehst hier in der Zentralbank des "MUDNAME". "
    "Hier werden die Transaktionen der Laeden im "MUDNAME" und "
    "die Geldstroeme ueberwacht. Vorerst greift die Bank nicht in die "
    "Geldbewegungen ein, sondern zeigt nur die Einnahmen und Ausgaben "
    "der Laeden an.\n"
    "Folgende Befehle stehen Dir zur Verfuegung:\n"
    "  'report' - Zeigt einen kurzen Finanzreport an\n"
    "  'reset'  - Setzt alles auf Startwerte zurueck (ab Stadtvater)\n");

  AddExit("mkz", "/room/mkz", "ins Mudkontrollzentrum");

  AddCmd("report", "ShortReport");
  AddCmd("reset",  "ResetAll");
}

/////////////////////////////////////////////////////////////////////////////

static int ResetAll() {
  if(!secure()) {
    write("Sorry. Das ist nicht Dein Job!\n");
    return 1;
  }
  konten=([ RESERVE: BANKRESERVE; time(); 0; 0; STARTZINS ]);
  start_time=time();
  save_object(SAVEFILE);
  write("Alles zurueckgesetzt!\n");
  return 1;
}

static string make_nice_name(string pfad) {
  mixed tmp;
  if(sizeof(tmp=explode(pfad,"/"))==1)
    return pfad;
  tmp-=({DOMAINDIR,GUILDDIR,PROJECTDIR,"room","rooms"});
  return implode(tmp,"-");
}

int ShortReport() {
  string descr;
  mixed all;
  int i;
  descr  = "\nAlle Konten seit "+dtime(start_time)+":\n";
  descr += sprintf(" %-30s | %|10s | %|5s | %|4s | %s\n",
                     "Kontoinhaber",
                     "Bilanz",
                     "Haben",
                     "Soll",
                     "letzte Aktion");
  descr += sprintf("%77'-'s\n","");
  all=m_indices(konten);
  for(i=sizeof(all);i--;)
    descr += sprintf(" %-30s | %+10d | %5d | %4d | %s\n",
                     make_nice_name(all[i])[<30..],
                     konten[all[i], 0],
                     konten[all[i], 2],
                     konten[all[i], 3],
                     ctime(konten[all[i], 1])[4..18]);
  write(descr);
  return 1;
}

/////////////////////////////////////////////////////////////////////////////

int NewMember(string who, int amount, int zins) {
  if(!who || konten[who])
    return 0;
  konten+=([ who: amount; time(); 0; 0; zins ]);
  return 1;
}

int RemoveMember(string who) {
  if(!who || !konten[who])
    return 0;
  konten=m_delete(konten, who);
  return 1;
}

int PutMoney(mixed ob, int amount) {
  string inhaber;
  if(stringp(ob) && strlen(ob))
    inhaber=ob;
  else if(objectp(ob))
    inhaber=file_name(ob);
  else
    inhaber="NOBODY";

  if(!konten[inhaber])
    NewMember( inhaber, 0, STARTZINS );

  konten[inhaber, 0]+=amount;
  konten[inhaber, 1]=time();
  if(amount>0)
    konten[inhaber, 2]+=1;
  else
    konten[inhaber, 3]+=1;
  return 1;
}

int GetMoney(mixed ob, int amount) {
  return PutMoney(ob, -amount);
}

/////////////////////////////////////////////////////////////////////////////

void reset() {
  save_object(SAVEFILE);
}

int remove() {
  save_object(SAVEFILE);
  return ::remove();
}


