/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2000/12/04 11:08:51 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: armour.c,v $
** Revision 1.2  2000/12/04 11:08:51  elatar
** preliminary adaption to new P_AC format
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// M.D. MUDlib
// basierend auf der Wunderland MUDlib
//
// ARMOUR.C -- armour standard object
//
// $Log: armour.c,v $
// Revision 1.2  2000/12/04 11:08:51  elatar
// preliminary adaption to new P_AC format
//
// Revision 1.1.1.1  1999/11/05 12:30:46  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:13  en
// MUDLib CVS Preperation
//
// Revision 1.2  1999/09/09 08:43:04  Largo
// inherits geaendert
//
// Revision 1.1  1999/08/01 01:21:31  Largo
// Initial revision
//

#pragma strong_types

inherit "std/thing";
inherit "std/armour/combat";
inherit "std/armour/description";

#define NEED_PROTOTYPES

#include <config.h>
#include <properties.h>
#include <combat.h>
#include <living/combat.h>
#include <moving.h>

void create()
{
  thing::create();
  description::create();
  combat::create();
}

string long()
{
  return description::long();
}

static void initialize()
{
  switch (Query(P_MAX_LIFETIME))
  {
    case -1:   // -1 bedeutet, die Ruestung ist unzerstoerbar
      return;  // fuer unzerstoerbare ruestungen ist hier nix zu machen
    case  0:
      // es gibt ruestungen mit P_AC kleiner oder gleich 0, deshalb so umstaendlich
      Set(P_MAX_LIFETIME, (Query(P_AC)[DT_BLUDGEON] || 1) * 1000);
      Set(P_LIFETIME, Query(P_MAX_LIFETIME));
  }
}

/* Ruestungen muessen vor Bewegung und Zerstoerung ausgezogen werden */
int move(mixed dest, int method)
{
  initialize();

  if (QueryProp(P_WORN) && QueryProp(P_CURSED))
  {
    if (method & M_NOCHECK)
      SetProp(P_CURSED, 0);
    else
      return ME_CANT_BE_DROPPED;
  }
  DoUnwear(method & M_SILENT);
  return (((method & M_NOCHECK) || !(QueryProp(P_WORN))) && ::move(dest, method));
}

varargs int remove(int silent)
{
  SetProp(P_CURSED, 0);
  DoUnwear(silent);
  return (!QueryProp(P_WORN) && ::remove());
}

void init()
{
  thing::init();
  combat::init();
}

void repair()
{
  object pl;
  int new_lifetime, percent;

  percent = 97-random(5);
  new_lifetime = to_int(to_float(Query(P_MAX_LIFETIME)) * percent / 100 + 0.5);
  if (QueryProp(P_LIFETIME) < new_lifetime)
  {
    SetProp(P_LIFETIME, new_lifetime);
  }

  if (objectp(pl = QueryProp(P_WORN)))
  {
    pl->SetProp(P_TOTAL_AC, summe(map_objects(pl->QueryProp(P_ARMOURS), "QueryProp", P_AC)));
  }
}

// returnwert 0 bedeutet es gibt nix zu reparieren
int costs_for_repair()
{
  int min_value, max_value, cur_value, costs;
  float pct;

  // ruestung ist unzerstoerbar
  if (Query(P_MAX_LIFETIME) == -1) return 0;

  // ruestung ist noch zu gut zum reparieren
  if ((pct = 100.0 * (float)QueryProp(P_LIFETIME) / (float)QueryProp(P_MAX_LIFETIME) + 0.5) > 91.0) return 0;

  max_value = Query(P_VALUE);
  cur_value = to_int((float)max_value * pct / 100.0 + 0.5);

  // es gibt ruestungen mit negativen ac!
  if ((min_value = Query(P_AC)) < 0) min_value = 0;
  min_value = (min_value + 4) * 15;

  costs = to_int((float)(max_value - cur_value) * 1.5 + 0.5);
  if (min_value > costs) costs = min_value;

  return costs;
}

int _query_value()
{
  int value, min_value;

  if (!(value = Query(P_VALUE))) return 0;
  switch (Query(P_MAX_LIFETIME))
  {
    case -1: return value;
    case  0: initialize();
  }

  return to_int((float)value * (float)QueryProp(P_LIFETIME) / (float)QueryProp(P_MAX_LIFETIME) + 0.5);
}

int _query_bulkiness()
{
  if (QueryProp(P_WORN)) return 0;
  return Query(P_BULKINESS);
}

int _set_max_lifetime(int value)
{
  if (value == 0) value = -1;
  Set(P_MAX_LIFETIME, value);

  if (value == -1)
  {
    value = 0;
  }

  if (Query(P_LIFETIME) > value)
  {
    Set(P_LIFETIME, value);
  }

  return Query(P_MAX_LIFETIME);
}

int _set_lifetime(int value)
{
  int max;

  if ((max = Query(P_MAX_LIFETIME)) == -1)
  {
    Set(P_LIFETIME, 0);
    return Query(P_LIFETIME);
  }

  if (value > max) value = max;
  Set(P_LIFETIME, value);

  return Query(P_LIFETIME);
}

int _query_armour_type() {
  return Query(P_ARMOUR_TYPE);
}
