/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2000/12/04 10:33:00 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: combat.c,v $
** Revision 1.2  2000/12/04 10:33:00  elatar
** new P_AC format (mapping) implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland MUDlib
//
// STD/ARMOUR/COMBAT.C -- armour standard object
//
// basierend auf der MorgenGrauen MUDlib
//
// $Log: combat.c,v $
// Revision 1.2  2000/12/04 10:33:00  elatar
// new P_AC format (mapping) implemented
//
// Revision 1.1.1.1  1999/11/05 12:30:47  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:14  en
// MUDLib CVS Preperation
//
// Revision 1.34  1999/05/31 08:00:52  Fiona
// DoStructureDamage() versteht auch P_MAX_LIFETIME < -1
//
// Revision 1.33  1999/05/25 13:46:53  Holger
// Schilde haben jetzt immer P_NR_HANDS mindestens 1
//
// Revision 1.32  1999/04/29 15:20:59  Fiona
// Ausbau des P_USED_HANDS setzen, Einbau _set_nr_hands() zum Schutz
//
// Revision 1.31  1999/04/23 10:23:43  Holger
// SetProp(P_ARMOUR_TYPE) zu Set() gemacht, um das sinnlose mitloggen
// des ILLEGAL AT zu umgehen beim clonen
//
// Revision 1.30  1999/02/11 13:02:08  Gum
// WearFunc und UnwearFunc bekommen jetzt als zweiten parameter silent uebergeben
//
// Revision 1.29  1998/12/30 16:17:17  Gum
// beim ausziehen einer ruestung geht die entsprechende message "du ziehst .. aus" an P_WORN statt an this_player()
//
// Revision 1.28  1998/12/20 16:52:17  Gum
// wenn unsichtbare ein kleidungsstueck an-/ausziehen geht keine message mehr an den raum

#pragma strong_types
#define NEED_PROTOTYPES

#include <armour.h>
#include <combat.h>
#include <config.h>
#include <defines.h>
#include <properties.h>
#include <thing/description.h>
#include <thing/properties.h>

private string statmod_str(mapping map, int negate);
private object TestType(object *armours);
private void msg(string str, mixed fl);
private string convert(int nr);
varargs int remove(int silent);

void create()
{
  Set(P_WORN, PROTECTED, F_MODE);
  Set(P_ARMOUR_TYPE, AT_ILLEGAL);
  Set(P_NR_HANDS, 0);
}

string MaynotWear(object pl)
{
  return 0; 
}

string MaynotUnwear(object pl)
{
  return 0;   
}

void init()
{
  add_action("ziehe", "ziehe");
  add_action("ziehe", "zieh");
  add_action("do_wear", "trage");
  switch (QueryProp(P_ARMOUR_TYPE))
  {
    case AT_HELMET:
    case AT_GLASSES:
      add_action("setze", "setz");
      add_action("setze", "setze");
      break;
    case AT_AMULET:
    case AT_ARMOUR:
      add_action("an_ab_legen", "leg");
      add_action("an_ab_legen", "lege");
      break;
    case AT_RING:
      add_action("streifen", "streif");
      add_action("streifen", "streife");
      break;
    case AT_BOOT:
      add_action("schluepfen", "schluepf");
      add_action("schluepfen", "schluepfe");
      break;
    default:
  }
}

int summe(int *array)
{
  int sum, size;

  sum = 0;
  if (!array || !(size = sizeof(array))) return 0;
  while (size--) sum += array[size];
  return sum;
}

private object TestType(object *armours)
{
  int i;
  string type;

  type=QueryProp(P_ARMOUR_TYPE);
  if(sizeof(armours=filter_array(armours-({0}),
     lambda(({'o}), ({#'==, ({#'call_other, 'o, "QueryProp", P_ARMOUR_TYPE}),
                            QueryProp(P_ARMOUR_TYPE)})))))
     return armours[0];

  return 0;
}

private void msg(string str, mixed fl)
{
  if(fl) tell_object(PL, str);
  else notify_fail(str);
}

varargs int do_wear(string str, int silent)
{
  int all, hands, i, j, nr, zaehler , u_lvl;
  mixed type;
  mapping map, armours, hooks;
  object found; 
  string * ind,txt;

  all=(str=="alles");
  if (!str || (!id(str) && !all)) 
    return 0;
    
  if (all) 
    notify_fail("Alles angezogen, was ging.\n");
    
  if (environment()!=PL) 
    return msg(break_string(sprintf(
      "Ihr muesst %s erst nehmen.", name(WEN, 1)), BS_STDLEN,
      sprintf("%s: ", CAP(name(WER))), BS_LEAVE_MY_LFS), all), 0;
      
  if (QueryProp(P_WORN)) 
    return msg(break_string(sprintf(
      "Ihr tragt %s bereits.", name(WEN, 1)), BS_STDLEN,
      sprintf("%s: ", CAP(name(WER))), BS_LEAVE_MY_LFS), all), 0;
      
  if (!QueryProp(P_LIFETIME) && (Query(P_MAX_LIFETIME) > 0)) 
    return msg(break_string(sprintf(
      "%s ist vollkommen kaputt und unbrauchbar.", CAP(name(WER))), BS_STDLEN,
      sprintf("%s: ", CAP(name(WER))), BS_LEAVE_MY_LFS), all), 0;

  armours=PL->QueryProp(P_ARMOURS);
  type=QueryProp(P_ARMOUR_TYPE);

  if (txt=MaynotWear(PL))
    return msg(break_string(sprintf(
      txt) ,BS_STDLEN,
      sprintf("%s: ", CAP(name(WER))), BS_LEAVE_MY_LFS), all), 0;

  if (txt=PL->EvalHook(P_WEAR_HOOKS,this_object()))
    return msg(break_string(sprintf(
      txt) ,BS_STDLEN,
      sprintf("%s: ", CAP(name(WER))), BS_LEAVE_MY_LFS), all), 0;

  if (type==AT_RING)
  {
    if (pointerp(armours[CWL_RINGS]) && sizeof(armours[CWL_RINGS])==3)
      return msg(break_string(
        "Ihr koennt nicht mehr als vier Ringe gleichzeitig tragen.", BS_STDLEN,
        sprintf("%s: ", CAP(name(WER))), BS_LEAVE_MY_LFS), all), 0;
  }
  else if (type!=AT_MISC)
  {
    u_lvl=QueryProp(P_UNDERWEAR_LEVEL);
    for (i=sizeof(ind=QueryProp(P_HIT_LOCATIONS));i-->0;)
    {
      if (objectp(armours[ind[i],0]) && u_lvl>armours[ind[i],0]->QueryProp(P_ARMOUR_LEVEL))
        return msg(break_string(sprintf(
          "Ihr koennt %s nicht ueber %s ziehen.", name(WER),armours[ind[i],0]->name(WEN)), BS_STDLEN,
          sprintf("%s: ", CAP(name(WER))), BS_LEAVE_MY_LFS), all), 0;
    }
  }

  /*
  if(type!=AT_RING && (found=TestType(armours)) && objectp(found)
     && type!=AT_MISC)
    switch(all)
    {
      case 1:
        return msg(break_string(sprintf(
          "Du traegst bereits %s als Schutz der Sorte %s.",
          found->name(WEN, 1), type), BS_STDLEN,
          sprintf("%s: ", CAP(name(WER))), BS_LEAVE_MY_LFS), all), 0;
      default:
        if(found->DoUnwear(silent)!=ME_CANT_BE_UNWORN)
          return do_wear(str, silent);
        else return 1;
    }

  if(type==AT_RING)
  {
    for(i=sizeof(armours);i--;)
      if(armours[i]->QueryProp(P_ARMOUR_TYPE)==AT_RING) zaehler++;

    if(zaehler>1) return msg(break_string(
      "Du traegst bereits zwei Ringe.", BS_STDLEN,
      sprintf("%s: ", CAP(name(WER))), BS_LEAVE_MY_LFS), all), 0;
  }
  */
  if(type==AT_ILLEGAL)
  {
    tell_object(PL, break_string(
      "Ungueltiger Ruestungstyp, bitte Avatar 3. Kreises oder hoeher verstaendigen!",
      BS_STDLEN, sprintf("%s: ", CAP(name(WER))), BS_LEAVE_MY_LFS));
    return !all;
  }

/* Shield wird eignes Ob?

  if(type==AT_SHIELD)
  {
    nr=abs(QueryProp(P_NR_HANDS));
    hands=PL->QueryProp(P_USED_HANDS)+nr;

    if(hands>PL->QueryProp(P_MAX_HANDS))
    {
      tell_object(PL, break_string(sprintf(
        "Du benoetigst fuer %s %s freie %s.", name(WEN, 1),
        convert(nr), nr>1 ? "Haende" : "Hand"), BS_STDLEN,
        sprintf("%s: ", CAP(name(WER))), BS_LEAVE_MY_LFS));
      return !all;
    }
  }
  */

  for (i=sizeof(ind);i-->0;)
  {
    for (j=3;j>0;j--)
    {
      armours[ind[i],j]=armours[ind[i],j-1];
    }  
    armours[ind[i],0]=ME;
  }
  SetProp(P_WORN, PL);

  PL->SetProp(P_ARMOURS, armours);

/* Mods kommen auch noch, nur nicht so
  if(map=QueryProp(P_STATMOD))
  {
    if(str=statmod_str(map, 0))
      str=sprintf(" und fuehlst Dich ploetzlich %s", str);
    else str="";
    PL->AddStatMod(ME);
  }
  else str="";
*/
  str="";
  if (!silent && environment(PL))
  {
    switch (QueryProp(P_ARMOUR_TYPE))
    {
      case AT_HELMET:
      case AT_GLASSES:
        tell_object(PL,
          break_string(sprintf("Du setzt %s auf%s.", name(WEN, 1), str),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
        if (!PL->QueryProp(P_INVIS)) tell_room(environment(PL),
          break_string(sprintf("%s setzt %s auf.", CAP(PL->name(WER)), name(WEN, 0)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS), ({PL}));
        break;
      case AT_AMULET:
      case AT_ARMOUR:
        tell_object(PL,
          break_string(sprintf("Du legst %s an%s.", name(WEN, 1), str),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
        if (!PL->QueryProp(P_INVIS)) tell_room(environment(PL),
          break_string(sprintf("%s legt %s an.", CAP(PL->name(WER)), name(WEN, 0)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS), ({PL}));
        break;
      case AT_RING:
        tell_object(PL,
          break_string(sprintf("Du streifst %s auf einen Finger%s.", name(WEN, 1), str),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
        if (!PL->QueryProp(P_INVIS)) tell_room(environment(PL),
          break_string(sprintf("%s streift %s auf einen Finger.", CAP(PL->name(WER)), name(WEN, 0)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS), ({PL}));
        break;
      case AT_BOOT:
        tell_object(PL,
          break_string(sprintf("Du schluepfst in %s%s.", name(WEN, 1), str),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
        if (!PL->QueryProp(P_INVIS)) tell_room(environment(PL),
          break_string(sprintf("%s schluepft in %s.", CAP(PL->name(WER)), name(WEN, 0)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS), ({PL}));
        break;
      default:
        tell_object(PL,
          break_string(sprintf("Du ziehst %s an%s.", name(WEN, 1), str),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
        if (!PL->QueryProp(P_INVIS)) tell_room(environment(PL),
          break_string(sprintf("%s zieht %s an.", CAP(PL->name(WER)), name(WEN, 0)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS), ({PL}));
    }
  }
/* magical interaction?
  if(type==AT_RING)
  {
    for(i=sizeof(armours-({ME}));i--;)
      if(armours[i]->QueryProp(P_ARMOUR_TYPE)==AT_RING)
        armours[i]->NotifyOtherRing(ME);
  }
*/
  return !all;
}

string WhereLocation(string location)
{
  switch(location)
  {
    case CWL_HEAD:
      return "am Kopf";
      break;
    case CWL_BODY:
      return "am Koerper";
      break;
    case CWL_RIGHT_ARM:
      return "am rechten Arm";
      break;
    case CWL_RIGHT_HAND:
      return "an der rechten Hand ";
      break;
    case CWL_LEFT_ARM:
      return "am linken Arm";
      break;
    case CWL_LEFT_HAND:
      return "an der linken Hand ";
      break;
    case CWL_RIGHT_LEG:
      return "am rechten Bein";
      break;
    case CWL_RIGHT_FOOT:
      return "am rechten Fuss";
      break;
    case CWL_LEFT_LEG:
      return "am linken Bein";
      break;
    case CWL_LEFT_FOOT:
      return "am linken Fuss";
      break;
  }  
}

varargs int HitMe(int damage, mixed dam_type, object enemy, string att_type, string hit_location, int depth)
{
  int i, ndamage, size;
  object * excludes, worn, dfunc;
  mapping ac, armours;
  string where;

  if (!pointerp(dam_type))
    dam_type=({dam_type});
  ac=QueryProp(P_AC);
  if (!mappingp(ac))
   Set(P_AC,ac=([]));

  for (i=size=sizeof(dam_type);i-->0;)
  {
    ndamage+=damage-ac[dam_type[i]];
  }
  damage=ndamage/size;
  
  if ( dfunc=QueryProp(P_ARMOUR_DEFEND) 
    && objectp(dfunc))
    damage=call_other(dfunc,"DefendFunc",damage,dam_type,enemy,att_type,hit_location,depth);
  
  worn=QueryProp(P_WORN);
  if (damage<1)
  {
    excludes = filter_array(all_inventory(environment()), lambda( ({ 'ob }),
      ({ #'==, 1, ({ #'call_other, 'ob, "QueryProp", P_NO_FIGHT_TEXT }) }) ));
    excludes += ({ worn, enemy });
    
    if (QueryProp(P_NO_FIGHT_TEXT)!=1)
      tell_object(enemy,break_string(sprintf(
        "  Euer Angriff trifft %s %s, doch %s Ruestung verhindert Schlimmeres."
        , worn->name(WEN),WhereLocation(hit_location)
        , worn->QueryPossPronoun(FEMALE,WER,SINGULAR))));
    if (enemy->QueryProp(P_NO_FIGHT_TEXT)!=1)  
      tell_object(worn,break_string(sprintf(
        "  %s Angriff trifft Euch %s, doch Eure Ruestung verhindert Schlimmeres.\n"
        , enemy->Name(WESSEN), WhereLocation(hit_location))));
    tell_room(environment(),break_string(sprintf(
      "%s Angriff trifft %s %s,doch %s Ruestung verhindert Schlimmeres .\n"
      ,enemy->Name(WESSEN), worn->name(WEN), WhereLocation(hit_location)
      ,worn->QueryPossPronoun(FEMALE,WER,SINGULAR))),excludes);    
    return 0;
  }

  armours=worn->QueryProp(P_ARMOURS);
  if (depth<3 && objectp(armours[hit_location,++depth]))
  {
    return armours[hit_location,depth]->HitMe(damage, dam_type, enemy, att_type, hit_location, depth);
  }
  return worn->HitMe(damage, dam_type, enemy, att_type, hit_location);
}


varargs int DoUnwear(int silent)
{
  string str, *ind;
  mapping map, armours;
  object worn_by;
  int i,j;

  if (!(worn_by = QueryProp(P_WORN))) 
    return ME_CANT_BE_UNWORN;

  if (str=MaynotUnwear(worn_by) || str=worn_by->EvalHook(P_UNWEAR_HOOKS,ME))
  {
    if (!silent)
      tell_object(worn_by,str);
    return ME_CANT_BE_UNWORN;
  }

  if (str = QueryProp(P_CURSED))
  {
    if (!silent)
    {
      if (stringp(str)) 
        tell_object(worn_by, str);
      else 
        tell_object(worn_by, break_string(sprintf(
          "Ihr koennt %s nicht mehr ausziehen.", name(WEN, 1)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
    }
    return ME_CANT_BE_UNWORN;
  }
  
  armours = worn_by->QueryProp(P_ARMOURS);
  
  for (i=sizeof(ind=QueryProp(P_HIT_LOCATIONS));i-->0;)
  {
    if (armours[ind[i],0]!=ME )
    {
      if (!silent)
        tell_object(worn_by, break_string(sprintf(
            "Ihr muesst erst %s ausziehen, bevor Ihr %s ausziehen koennt.", 
            armours[ind[i],0]->name(WEN),name(WEN, 1)),
            BS_STDLEN, 0, BS_LEAVE_MY_LFS));
      return ME_CANT_BE_UNWORN;
    }
  }

  for (i=sizeof(ind);i-->0;)
  {
    for (j=0;j<3;j++)  
    {
      armours[ind[i],j]=armours[ind[i],j+1];  
    }
    armours[ind[i],3]=0;
  }

  worn_by->SetProp(P_ARMOURS, armours);
  SetProp(P_WORN, 0);

/* mods werden auch noch entfernt, nur nicht so
  if (map = QueryProp(P_STATMOD))
  {
    if (str = statmod_str(map, 1))
      str = sprintf(" und fuehlst Dich wieder %s", str);
    else str = "";
    worn_by->RemoveStatMod(ME);
  }
  else str = "";
*/
  str="";

  if (!silent)
  {
    switch (QueryProp(P_ARMOUR_TYPE))
    {
      case AT_HELMET:
      case AT_GLASSES:
        tell_object(worn_by,
          break_string(sprintf("Du setzt %s ab%s.", name(WEN, 1), str),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
        if (!worn_by->QueryProp(P_INVIS)) tell_room(environment(worn_by),
          break_string(sprintf("%s setzt %s ab.", CAP(worn_by->name(WER)), name(WEN, 0)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS), ({ worn_by }));
        break;

      case AT_AMULET:
      case AT_ARMOUR:
        tell_object(worn_by,
          break_string(sprintf("Du legst %s ab%s.", name(WEN, 1), str),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
        if (!worn_by->QueryProp(P_INVIS)) tell_room(environment(worn_by),
          break_string(sprintf("%s legt %s ab.", CAP(worn_by->name(WER)), name(WEN, 0)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS), ({ worn_by }));
        break;

      case AT_RING:
        tell_object(worn_by,
          break_string(sprintf("Du streifst %s vom Finger%s.", name(WEN, 1), str),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
        if (!worn_by->QueryProp(P_INVIS)) tell_room(environment(worn_by),
          break_string(sprintf("%s streift %s vom Finger.", CAP(worn_by->name(WER)), name(WEN, 0)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS), ({ worn_by }));
        break;

      case AT_BOOT:
        tell_object(worn_by,
          break_string(sprintf("Du schluepfst aus %s%s.", name(WEM, 1), str),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
        if (!worn_by->QueryProp(P_INVIS)) tell_room(environment(worn_by),
          break_string(sprintf("%s schluepft aus %s.", CAP(worn_by->name(WER)), name(WEM, 0)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS), ({ worn_by }));
        break;

      default:
        tell_object(worn_by,
          break_string(sprintf("Du ziehst %s aus%s.", name(WEN, 1), str),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS));
        if (!worn_by->QueryProp(P_INVIS)) tell_room(environment(worn_by),
          break_string(sprintf("%s zieht %s aus.", CAP(worn_by->name(WER)), name(WEN, 0)),
          BS_STDLEN, 0, BS_LEAVE_MY_LFS), ({ worn_by }));
    }
  }

  return 1;
}

varargs int do_unwear(string str, int silent)
{
  if (!str || (!id(str) && (str != "alles")) )
  {
    notify_fail("Ihr habt doch gar nichts mehr an.\n");
    return 0;
  }

  if (!QueryProp(P_WORN) && (str != "alles"))
  {
    if (!QueryProp(P_ARTICLE)) 
      notify_fail(sprintf("Ihr tragt k%s.\n", name(WEN, 0)));
    else 
      notify_fail(sprintf("Ihr tragt %s nicht.\n", name(WEN, 1)));
    return 0;
  }

  DoUnwear(silent);

  if (str == "alles")
  {
    notify_fail("Ihr habt bereits alles ausgezogen.\n");
    return 0;
  }

  return 1;
}

int ziehe(string str)
{
  string ob;

  if(!str) return 0;
  if(sscanf(str, "%s an", ob)==1) return do_wear(ob);
  if(sscanf(str, "%s aus", ob)==1) return do_unwear(ob);

  return 0;
}

int setze(string str)
{
  string ob;

  if (!str) return 0;
  if (sscanf(str, "%s auf", ob) == 1) return do_wear(ob);
  if (sscanf(str, "%s ab", ob) == 1) return do_unwear(ob);

  return 0;
}

int an_ab_legen(string str)
{
  string ob;

  if (!str) return 0;
  if (sscanf(str, "%s an", ob) == 1) return do_wear(ob);
  if ((sscanf(str, "%s ab", ob) == 1) && (QueryProp(P_WORN))) return do_unwear(ob);

  return 0;
}

int streifen(string str)
{
  string ob;

  if (!str) return 0;
  if (sscanf(str, "%s auf", ob) == 1) return do_wear(ob);
  if (sscanf(str, "%s ueber", ob) == 1) return do_wear(ob);
  if (sscanf(str, "%s ab", ob) == 1) return do_unwear(ob);

  return 0;
}

int schluepfen(string str)
{
  string ob;

  if (!str) return 0;
  if (sscanf(str, "in %s", ob) == 1) return do_wear(ob);

  return 0;
}

int allow_wear()
{
  int n, m;
  mixed guild_info, armours, ids;

  guild_info=call_other("/secure/guildmaster", "QueryGuild",
                        PL->QueryProp(P_GUILD), 1);
  if(!sizeof(guild_info)) return 1;

  armours=call_other(guild_info[0], "QueryProp", P_ARMOURS_ALLOWED);
  if(!sizeof(armours)) return 1;

  n=sizeof(ids=QueryProp(P_IDS));
  for(m=0;m<n;m++)
    if(member_array(ids[m], armours)!=-1) return 1;
  return 0;
}

mapping QueryStatMod(object pl)
{
  if(pl==QueryProp(P_WORN)) return QueryProp(P_STATMOD);
}

private string statmod_str(mapping map, int negate)
{
  int i;
  string* idx;
  mixed mix;

  negate=1-2*negate;
  mix=({});
  idx=m_indices(map);
  for (i=sizeof(idx); i--;) {
    if (map[idx[i]]==0) continue;
    switch (idx[i]) {
      case A_INT:
        if (map[idx[i]]*negate>0) mix+=({"intelligenter"});
        else mix+=({"weniger intelligent"});
        break;
      case A_CON:
        if (map[idx[i]]*negate>0) mix+=({"ausdauernder"});
        else mix+=({"weniger ausdauernd"});
        break;
      case A_STR:
        if (map[idx[i]]*negate>0) mix+=({"staerker"});
        else mix+=({"weniger stark"});
        break;
      case A_DEX:
        if (map[idx[i]]*negate>0) mix+=({"geschickter"});
        else mix+=({"weniger geschickt"});
        break;
    }
  }
  if (sizeof(mix)) mix="/std/player/soul"->CountUp(mix);
  else mix=0;
  return mix;
}

private string convert(int nr)
{
  switch(nr)
  {
    case 1:
      return "eine";
    case 2:
      return "zwei";
    default:
      return "sehr viele";
  }
}

void DoStructureDamage(int dam)
{
  int lt, old_ac, new_ac;

  // ist MAX_LIFETIME <= -1 dann ist die ruestung unzerstoerbar
  if (Query(P_MAX_LIFETIME) <= -1) return;
  if ((lt = QueryProp(P_LIFETIME)) < 1) return;
  if ((lt -= dam) < 1)
  {
    SetProp(P_LIFETIME, 0);
    tell_object(QueryProp(P_WORN), break_string(sprintf(
      "%s hat sich gerade vollstaendig aufgeloest.", CAP(name(WER, 1))),
      BS_STDLEN, 0, BS_LEAVE_MY_LFS));
    remove(1);
    return;
  }

  old_ac = QueryProp(P_AC);
  SetProp(P_LIFETIME, lt);
  new_ac = QueryProp(P_AC);

  // ist die neue ac kleiner als die alte muss total_ac neu berechnet werden
  if (old_ac != new_ac)
  {
    object obj;
    if (objectp(obj = QueryProp(P_WORN)) && obj)
    {
      object *armours;

      armours = obj->QueryProp(P_ARMOURS);
      obj->SetProp(P_TOTAL_AC, summe(map_objects(armours, "QueryProp", P_AC)));
    }

    if (!new_ac)  tell_object(QueryProp(P_WORN), break_string(sprintf(
      "%s haengt nur noch in Fetzen an Dir herum und schuetzt Dich nicht mehr.", CAP(name(WER, 1))),
      BS_STDLEN, 0, BS_LEAVE_MY_LFS));
  }
}

static mapping _query_ac()
{
  int l,m;
  mapping ac;
  
  l=QueryProp(P_LIFETIME);
  m=QueryProp(P_MAX_LIFETIME);
  ac=copy_mapping(Query(P_AC));
  walk_mapping(ac
    ,lambda(({'i,'v})
      ,({#'to_int,({#'*,'v,0.2+0.8*l/m})})));
  return ac;
}

static int _set_nr_hands(int n) {
  if (QueryProp(P_ARMOUR_TYPE) != AT_SHIELD || n<0) return -1;
  return Set(P_NR_HANDS, n);
}

int RemoveFunc(object ob) { return 1; }
