/*******************
** Eldarea MUDLib **
********************
**
** std/armour/description.c
**
** CVS DATA
** $Date: 2001/01/31 13:42:19 $
** $Revision: 1.3 $
**
** armour description
**
** CVS History
**
** $Log: description.c,v $
** Revision 1.3  2001/01/31 13:42:19  elatar
** process_string() replaced by funcall()
**
** Revision 1.2  2000/12/04 10:33:49  elatar
** new worn description handling
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "std/thing/description";

#pragma strong_types

#define NEED_PROTOTYPES

#include "/sys/armour/description.h"
#include "/sys/thing/properties.h"
#include <properties.h>

void create()
{
  ::create();
  AddId("ruestung", "ruestungen");
  Set(P_WORN_DESC,#'_query_worn_desc,F_SET_METHOD);
}

string long()
{
  string desc, str;
  int lifetime, max_lifetime, min_lifetime, pct;

  max_lifetime = Query(P_MAX_LIFETIME);
  if (max_lifetime == -2) return ::long();

  if (max_lifetime == -1) pct = 100;
  else
  {
    if (Query(P_AC) && max_lifetime)
      min_lifetime = to_int( max_lifetime /  2 );
    if ((max_lifetime -= min_lifetime) < 0) max_lifetime = 0;
    lifetime = QueryProp(P_LIFETIME);
    if ((lifetime -= min_lifetime) < 0) lifetime = 0;
    if (max_lifetime)
      pct = to_int(100 * (float)lifetime / (float)max_lifetime + 0.5);
  }

  switch (pct)
  {
    case 95..100: desc = "exzellenten"; break;
    case 90..94:  desc = "sehr guten"; break;
    case 60..89:  desc = "guten"; break;
    case 30..59:  desc = "schlechten"; break;
    case 10..29:  desc = "sehr schlechten"; break;
    case  1..9:   desc = "miserablen"; break;
    case  0:      desc = "unbrauchbaren"; break;
    default:      desc = "(P_LIFETIME ungueltig, bitte MAG rufen!)";
  }

  str = funcall(QueryProp(P_LONG));
  if (!stringp(str)) str = "";
  else if (str[<1] != '\n') str += "\n";
  return sprintf("%s%s ist in einem %s Zustand.", str,
    capitalize(name(WER, 1)), desc);
}

static string _query_descr() {
  string str, str2;
  str=funcall(Query(P_DESCR));
  if (QueryProp(P_WORN)) str2="(angezogen)";
  if (str) {
    if (str2) return str+" "+str2;
    else return str;
  }
  return str2;
}

string _query_worn_desc()
{
  string desc;
  
  if (!desc=Query(P_WORN_DESC))  
    desc=name(WEN);
    
  return desc;
}