/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 2001/01/31 13:02:13 $
** $Revision: 1.2 $
**
** longdesc
**
** CVS History
**
** $Log: behaelter.c,v $
** Revision 1.2  2001/01/31 13:02:13  elatar
** process_string removed
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// M.D. MUDlib
// basierend auf der Wunderland MUDlib
/*
 * Standardbehaelter
 * hervorgegangen aus dem Standardbehaelter von Durian@Morgengrauen
 *
 * $Date: 2001/01/31 13:02:13 $
 * $Revision: 1.2 $
 * $Log: behaelter.c,v $
 * Revision 1.2  2001/01/31 13:02:13  elatar
 * process_string removed
 *
 * Revision 1.1.1.1  1999/11/05 12:30:46  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:13  en
 * MUDLib CVS Preperation
 *
 * Revision 1.1  1999/08/01 15:26:28  Largo
 * Initial revision
 *
 */

#pragma strong_types

inherit "/std/container";

#include <container.h>
#include <properties.h>
#include <moving.h>

void create()
{
  ::create();
  AddId(({"behaelter","\nbehaelter"}), "behaelter");
  SetProp(P_NAME, "Behaelter");
  SetProp(P_GENDER, MALE);
  SetProp(P_MAX_WEIGHT, 10000);
  Set(P_CNT_KEY, 0, F_SET_METHOD);
  SetProp(P_CNT_KEY, 0);
  Set(P_CNT_KEY_CLOSE, 0, F_SET_METHOD);
  SetProp(P_CNT_KEY_CLOSE, 0);
  Set(P_CNT_FLAGS, 0, F_SET_METHOD);
  SetProp(P_CNT_FLAGS, 0);
  SetProp(P_CNT_STATUS, CNT_STATUS_CLOSED);
  SetProp(P_LONG, "Ein ganz normaler Behaelter.\n");
  AddCmd( ({"schliess", "schliesse"}), "schliesse");
  AddCmd( ({"oeffne"}), "oeffne");
  AddCmd( ({"leere", "entleere"}), "entleeren");
}

int is_open() { return !QueryProp(P_CNT_STATUS); }
int is_closed() { return QueryProp(P_CNT_STATUS) & CNT_STATUS_CLOSED; }
int is_locked() { return QueryProp(P_CNT_STATUS) & CNT_STATUS_LOCKED; }
int can_only_lock() { return QueryProp(P_CNT_FLAGS) & CNT_ONLY_LOCK; }

int BeforeOpen() { return 1; }
int BeforeClose() { return 1; }
void AfterOpen() { ; }
void AfterClose() { ; }
int ResetFunc() { return 1; }
int KeyOpenFunc() { return 1; }
int KeyCloseFunc() { return 1; }

string long()
{
  string descr, inv, pron;

  descr = QueryProp(P_LONG);
  if (descr[<1] != '\n') descr += "\n";
  pron = capitalize(QueryPronoun());
  if (is_locked()) return descr + pron + " ist abgeschlossen.\n";
  if (is_closed()) return descr + pron + " ist geschlossen.\n";
  if ((inv = make_invlist(this_player(), all_inventory(this_object()))) != "")
    descr += pron + " ist geoeffnet und enthaelt:\n" + inv;
  else descr += pron + " ist geoeffnet und leer.\n";
  return descr;
}

static string _query_descr()
{
  string str;
  str=funcall(Query(P_DESCR));
  if (str) str+=" ";
  else str="";
  if (is_open()) return str+"(geoeffnet)";
  if (is_closed()) return str+"(geschlossen)";
  return str+"(abgeschlossen)";
}

int schliesse(string str)
{
  string was, womit;
  object obj;

  notify_fail("WAS moechtest Du schliessen?\n");
  if (!str || str == "") return 0;

  if ((sscanf(str, "%s mit %s ab", was, womit) == 2) ||
      (sscanf(str, "%s mit %s zu", was, womit) == 2) ||
      (sscanf(str, "%s mit %s", was, womit) == 2))
  {
    if (!(id(was)))
    {
      notify_fail(capitalize(was) + "? Sowas siehst Du hier nicht.\n");
      return 0;
    }
    if (!(QueryProp(P_CNT_KEY_CLOSE)))
    {
      notify_fail(capitalize(name(WEN, 1)) + " kannst Du nicht abschliessen.\n");
      return 0;
    }
    if (is_locked())
    {
      write(capitalize(name(WER)) + " ist bereits abgeschlossen.\n");
      return 1;
    }
    if (!(obj = present(womit, this_player())))
    {
      write(capitalize(womit) + "? Sowas hast Du nicht bei Dir.\n");
      return 1;
    }
    if (!(obj->id(QueryProp(P_CNT_KEY_CLOSE))))
    {
      write(break_string(sprintf("Du versuchst %s mit %s abzuschliessen - aber vergeblich.\n", name(WEN, 1), obj->name(WEM)), 77));
      say(break_string(sprintf("%s versucht %s mit %s abzuschliessen - aber vergeblich.\n", this_player()->name(WER), name(WEN, 1), obj->name(WEM)), 77), ({ this_player() }) );
      return 1;
    }

    if (!KeyCloseFunc() || !BeforeClose()) return 1;

    write("Du schliesst " + name(WEN, 1) + " ab.\n");
    say(this_player()->name() + " schliesst " + name(WEN) + " ab.\n", ({ this_player() }) );
    SetProp(P_CNT_STATUS, CNT_STATUS_LOCKED);
    AfterClose();
    return 1;
  }

  if (sscanf(str, "%s ab", was) == 1)
  {
    if (!QueryProp(P_CNT_KEY_CLOSE))
    {
      write("Du kannst " + name(WEN, 1) + " nicht abschliessen!\n");
      return 1;
    }

    write("Du brauchst einen Schluessel, um etwas abschliessen zu koennen.\n");
    return 1;
  }

  if (sscanf(str, "%s zu", was) == 1)
  {
    if (!QueryProp(P_CNT_KEY_CLOSE))
    {
      write("Du kannst " + name(WEN, 1) + " nicht zuschliessen!\n");
      return 1;
    }

    write("Du brauchst einen Schluessel, um " + name(WEN, 1) + " zuschliessen zu koennen.\n");
    return 1;
  }

  if ((sscanf(str, "%s mit %s auf", was, womit) == 2))
  {
    if (!(id(was)))
    {
      notify_fail(capitalize(was) + "? Sowas siehst Du hier nicht.\n");
      return 0;
    }
    if (!QueryProp(P_CNT_KEY))
    {
      write("Du kannst " + name(WEN, 1) + " nicht aufschliessen!\n");
      return 1;
    }
    if (!is_locked())
    {
      write(capitalize(name(WER, 1)) + " ist nicht abgeschlossen.\n");
      return 1;
    }
    if (!(obj = present(womit, this_player())))
    {
      write(capitalize(womit) + "? Sowas hast Du nicht bei Dir.\n");
      return 1;
    }
    if (!(obj->id(QueryProp(P_CNT_KEY))))
    {
      write(break_string(sprintf("Du versuchst %s mit %s aufzuschliessen - aber vergeblich.\n", name(WEN, 1), obj->name(WEM)), 77));
      say(break_string(sprintf("%s versucht %s mit %s aufzuschliessen - aber vergeblich.\n", this_player()->name(WER), name(WEN), obj->name(WEM)), 77), ({ this_player() }) );
      return 1;
    }

    if (!KeyOpenFunc() || !BeforeOpen()) return 1;

    write("Du schliesst " + name(WEN, 1) + " auf.\n");
    say(this_player()->name() + " schliesst " + name(WEN) + " auf.\n", ({ this_player() }) );
    SetProp(P_CNT_STATUS, CNT_STATUS_OPEN);
    AfterOpen();
    return 1;
  }

  if (sscanf(str, "%s auf", was) == 1)
  {
    if (!QueryProp(P_CNT_KEY))
    {
      write("Du kannst " + name(WEN, 1) + " nicht aufschliessen!\n");
      return 1;
    }

    write("Du brauchst einen Schluessel, um " + name(WEN, 1) + " aufschliessen zu koennen.\n");
    return 1;
  }

  notify_fail("Das kannst Du nicht schliessen!\n");
  if (!id(str)) return 0;

  if (!is_open())
  {
    write(capitalize(name(WER, 1)) + " ist schon geschlossen.\n");
    return 1;
  }

  if (QueryProp(P_CNT_KEY_CLOSE))
  {
    write(capitalize(name(WEN, 1)) + " kannst Du nur mit einem Schluessel schliessen.\n");
    return 1;
  }

  if (!BeforeClose()) return 1;

  write("Du schliesst " + name(WEN, 1) + ".\n");
  say(this_player()->name() + " schliesst " + name(WEN) + ".\n", ({ this_player() }));
  SetProp(P_CNT_STATUS, CNT_STATUS_CLOSED);
  if (can_only_lock()) SetProp(P_CNT_STATUS, CNT_STATUS_LOCKED);
  AfterClose();
  return 1;
}

int oeffne(string str)
{
  string was, womit;
  object obj;

  notify_fail("WAS moechtest Du oeffnen?\n");
  if (!str || str == "") return 0;

  if (sscanf(str, "%s mit %s", was, womit) == 2)
  {
    if (!(id(was)))
    {
      notify_fail(capitalize(was) + "? Sowas siehst Du hier nicht.\n");
      return 0;
    }
    if (!(QueryProp(P_CNT_KEY)))
    {
      notify_fail("Zum Oeffnen " + name(WESSEN, 1) + " brauchst Du keinen Schluessel.\n");
      return 0;
    }
    if (!(obj = present(womit, this_player())))
    {
      write(capitalize(womit) + "? Sowas hast Du nicht bei Dir.\n");
      return 1;
    }
    if (!(obj->id(QueryProp(P_CNT_KEY))))
    {
      write(sprintf("Du versuchst %s mit %s zu oeffnen - aber vergeblich.\n", name(), obj->name(WEM)));
      return 1;
    }
    if (is_open())
    {
      write(capitalize(name(WER, 1)) + " ist schon geoeffnet.\n");
      return 1;
    }
    if (!KeyOpenFunc()) return 1;
  }
  else
  {
    if (!(id(str)))
    {
      notify_fail(capitalize(str) + "? Sowas siehst Du hier nicht.\n");
      return 0;
    }
    if (QueryProp(P_CNT_KEY) && is_locked())   // nur schluessel abfrage reicht nicht, da der behaelter im
    {                                          // geschlossenen zustand geoeffnet werden kann auch ohne key
      notify_fail("Zum Oeffnen " + name(WESSEN, 1) + " brauchst Du einen Schluessel.\n");
      return 0;
    }
    if (is_open())
    {
      write(capitalize(name(WER, 1)) + " ist schon geoeffnet.\n");
      return 1;
    }
    if (!BeforeOpen()) return 1;
  }

  write("Du oeffnest " + name(WEN, 1) + ".\n");
  say(this_player()->name() + " oeffnet " + name(WEN) + ".\n", ({ this_player() }) );
  SetProp(P_CNT_STATUS, CNT_STATUS_OPEN);
  AfterOpen();
  return 1;
}

int entleeren(string str)
{
  int i;
  object *inv;

  notify_fail("Was willst Du entleeren?\n");
  if (!str || !id(str)) return 0;

  notify_fail(capitalize(name(WER, 1)) + " ist noch geschlossen.\n");
  if (QueryProp(P_CNT_STATUS) != CNT_STATUS_OPEN) return 0;

  notify_fail(capitalize(name(WER, 1)) + " ist leer.\n");
  if (!(inv = all_inventory(this_object())) || !(i = sizeof(inv))) return 0;

  tell_object(this_player(), "Du entleerst " + name(WEN, 1) + " vollstaendig.\n");
  tell_room(environment(this_player()), this_player()->name(WER, 2) + " entleert " + name(WEN) + " vollstaendig.\n", ({ this_player() }) );
  //Beim move wird nicht mehr gecheckt, da in der Regel nur legale Gegenstaende
  //in Behaeltern sind
  while (i)
    inv[--i]->move(environment(this_player()), M_NOCHECK | M_SILENT);
  return 1;
}

void reset()
{
  int f;

  ::reset();

  if (!ResetFunc()) return;

  f = QueryProp(P_CNT_FLAGS);
  if (f & CNT_RESET_OPEN) SetProp(P_CNT_STATUS, CNT_STATUS_OPEN);
  if (f & CNT_RESET_CLOSED)
  {
    SetProp(P_CNT_STATUS, CNT_STATUS_CLOSED);
    if (can_only_lock()) SetProp(P_CNT_STATUS, CNT_STATUS_LOCKED);
  }
  if (f & CNT_RESET_LOCKED) SetProp(P_CNT_STATUS, CNT_STATUS_LOCKED);
}

int _query_transparent()
{
  return is_open();
}

int _set_cnt_status(int stat)
{
  if (stat & CNT_RESET_LOCKED) Set(P_CNT_STATUS, CNT_RESET_LOCKED);
  else if (stat & CNT_RESET_CLOSED) Set(P_CNT_STATUS, CNT_RESET_CLOSED);
  else if (stat & CNT_RESET_OPEN) Set(P_CNT_STATUS, CNT_RESET_OPEN);
  else Set(P_CNT_STATUS, 0);
  if (stat & CNT_ONLY_LOCK) Set(P_CNT_STATUS, Query(P_CNT_STATUS) | CNT_ONLY_LOCK);
  return Query(P_CNT_STATUS);
}

