/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: book.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/
/*
 * Wunderland MUDlib
 *
 * /OBJ/BOOK.C -- ein Buch
 *
 * Autor: Troy@Wunderland, 12.12.1995
 * Weitere Informationen in /doc/WL/book
 *
 * $Log: book.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:46  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:13  en
 * MUDLib CVS Preperation
 *
 * Revision 1.1  1999/07/02 11:45:27  Fiona
 * Initial revision
 *
 */

#pragma strong_types

#include <properties.h>
#include <books.h>

inherit "std/thing";

void create() {
  if(!clonep()) return;
  ::create();
  seteuid(getuid(this_object())); // wegen write_file()
  SetProp(P_LONG, "Der Magier, der dieses Buch schrieb, war zu faul, eine "
    "Beschreibung mitzuliefern.");
  SetProp(P_NAME,"Buch");
  SetProp(P_PLURAL, "Buecher");
  SetProp(P_GENDER, NEUTER);
  SetProp(P_WEIGHT, 250);
  SetProp(P_VALUE, 0);

// Spezialproperties fuer Buecher. Definiert in books.h:
  SetProp(P_BOOK_CONTENTS, 0);      // KEINE DATEI VORGEGEBEN!
  SetProp(P_BOOK_PAGE_HEIGHT, 0);   // P_SCREENSIZE als Seitenhoehe
  SetProp(P_BOOK_PAGE_WIDTH, 30);   // ergibt 72 Zeichen Gesamtbreite
  SetProp(P_BOOK_FRAME_CHAR, "#");  // Vorgabe ist # als Rand
  SetProp(P_BOOK_FILL_CHAR, " ");   // und Leerzeichen als Fuellung
  SetProp(P_BOOK_FLUSH_CHAR, " ");  // Rechtsbuendiges mit Leerzeichen fuellen
  SetProp(P_BOOK_BLANK_HEADERS, 0); // Leere Seitenkoepfe sind nicht erlaubt.

  SetProp(P_BOOK_PAGE, 1);          // Buch auf Seite 1 aufschlagen.
  SetProp(P_BOOK_SATZ, "^");        // default: Blocksatz.

  Set(P_BOOK_TEXT, PROTECTED, F_MODE);
  Set(P_BOOK_SATZ, PROTECTED, F_MODE);
  Set(P_BOOK_READ, PROTECTED, F_MODE);
  AddId("buch");
  AddCmd(({"lies","lese"}), "read_book");
  AddCmd("oeffne", "open_book");
  AddCmd(({"schlag","schlage"}), "hit_book");
  AddCmd(({"schliess","schliesse"}), "close_book");
  AddCmd(({"blaetter","blaettere"}), "switch_page");
  AddCmd("umblaettern", "switchpage");
}

/******
 * Hilfsmethoden
 ******/

// returns a string containing <times> times the character <char>.
private static string charstr(string char, int times) {
  return sprintf("%'"+char[0..0]+"':*s", times, "");
}

// as strstr, but include reverse search (negative pos)
varargs static int cpos(string s1, string s2, int pos) {
  int i,ls2;
  if(pos>=0)
    return strstr(s1,s2);
  for(i=strlen(s1)+pos,ls2=strlen(s2);i>=0;i--)
    if(s1[i..i+ls2]==s2) return i;
  return i;
}

/* strips spaces from <s>. Optionally <save> spaces are left in <s>. E.g.:
 * strip("This is  a   Test    !") returns "ThisisaTest!",
 * strip("This is  a   Test    !",1) returns "This is a Test !",
 * strip("This is  a   Test    !",2) returns "This is  a  Test  !" */
varargs static string strip(string s,int save) {
  string tmp1,tmp2;
  if(!stringp(s)) return 0;
  if(save<=0)
    return implode(efun::explode(s," "),"");
  tmp1=s;
  tmp2=implode(efun::explode(s,charstr(" ",save+1)),charstr(" ",save));
  while(tmp1!=tmp2) {
    tmp1=tmp2;
    tmp2=implode(efun::explode(tmp1,charstr(" ",save+1)),charstr(" ",save));
  }
  return tmp1;
}

/* this method is needed when P_BOOK_BLANK_HEADERS is set to 0. It calculates
 * the number of pages, or, if <pg> is given, returns the starting index of
 * page pg in P_BOOK_TEXT. In this function, <pageh> is assumed w/o borders. */
varargs static int full_header_pages(int pageh, int pg) {
  int cnt,i,idx,beg;
  string *t;
  if(pg<0) return 0;
  if(!(t=QueryProp(P_BOOK_TEXT))||!pointerp(t)||!sizeof(t))
    return 0;
  cnt=0;
  idx=0;
  while((pg?cnt<pg-1:1)&&idx<sizeof(t)) {
    cnt++;
    i=0;
    beg=0;
    while(idx<sizeof(t)&&(!beg||i<pageh)) {
      if(t[idx]=="%") {
        idx++;
        break;
      }
      if(beg) i++;
      else if(strlen(strip(t[idx]))) {
        beg=1;
        i++;
      }
    idx++;
    }
  }
  if(pg) {
    while(idx<sizeof(t)&&!strlen(strip(t[idx]))) idx++;
    return idx;
  }
  return cnt;
}

/******
 * Methoden zur Textformatierung
 ******/
// filter-method: special character->symbol
static string replace_symbols(string s) {
  mixed *sym;
  int i;
  for(i=0,sym=BS_REPLACE;i<sizeof(sym);i++)
    s=implode(efun::explode(s,sym[i][0]),sym[i][1]);
  return implode(efun::explode(s,HOTCHAR),"");
}

// filter-method: symbol->special character
static string restore_symbols(string s) {
  mixed *sym;
  int i;
  for(i=0,sym=BS_RESTORE;i<sizeof(sym);i++)
    s=implode(efun::explode(s,sym[i][0]),sym[i][1]);
  return s;
}

// returns strlen as if symbols were replaced by 1, hyphens by 0 characters.
static int bstrlen(string s) {
  string *arr;
  int len,i;
  for(arr=regexplode(s,"#@@....@@#"),i=0,len=0;i<sizeof(arr);i+=2)
    len+=strlen(implode(filter_array(regexplode(arr[i],
      "["+implode(SYMBOLS-({"-"}), "")+"]"), SYMBOLFILTER,arr[i]),""));
  return len+sizeof(arr)/2;
}

/* equals stringindex [], except symbols will be read as 1, hyphens as 0
 * characters. */
static int bpos(string s,int pos) {
  int len,i;
  for(i=0,len=0;len<pos;i++,len++)
    if(IS_SYMBOL(s[i+1])) i++;
    else if(s[i..i+2]=="#@@") {
      i+=9;
      if(IS_SYMBOL(s[i+1])) {
        i++;
        len++;
      }
    }
  return i;
}

/* returns array of paragraphs of text with all special characters replaced by
 * their symbols. */
static string *parse_text(string text) {
  int i;
  string *para;
  // This loop is NEEDED to be decrementive!
  for(para=efun::explode(text,"\n"),i=sizeof(para)-2;i>=0;i--)
    if(para[i][<1..]==HOTCHAR&&para[i][<2..<2]!=HOTCHAR) {
      para[i]=para[i][0..<2];
      if(para[i][<1..]!=" ") para[i]+=" ";
      para[i]+=para[i+1];
      para=para[0..i]+para[i+2..];
    }
  for(i=0;i<sizeof(para);i++) {
    if(strlen((para[i]=replace_symbols(para[i])))>1)
      para[i]=implode(efun::explode(para[i],"%"),"");
    para[i]=strip(para[i],1);
  }
  return para;
}

/* tests word s to be hyphenated within length len. If successful, returns
 * array ({this_line+hyphen_symbol,next_line}) */
static string *hyphen(string s, int len) {
  int i,j,lhyp;
  if(len<2)
    return 0;
  if(len>bstrlen(s))
    return ({s,""});
  for(i=0,j=0,lhyp=0;j<len;i++,j++)
    if(s[i+1]=='-'||s[i+1]=='~') {
      if(j+1+(s[i+1]=='~'?1:0)<len) lhyp=i;
      i++;
    }
    else if(IS_SYMBOL(s[i+1])) i++;
    else if(s[i..i+2]=="#@@") {
      i+=9;
      if(s[i-9..i]==S_HYPHEN) lhyp=i;
      if(s[i+1]=='-'||s[i+1]=='~') {
        if(j+1+(s[i+1]=='~'?1:0)<len) lhyp=i;
        i++;
        j++;
      } else if(IS_SYMBOL(s[i+1])) {
        i++;
        j++;
      }
    }
  if(!lhyp) return 0;
  if(s[lhyp-9..lhyp]==S_HYPHEN) return({s[0..lhyp],s[lhyp+1..]});
  if(s[lhyp]=='c'&&s[lhyp+2]=='k') s[lhyp]='k';
  if(s[lhyp+1]=='~') {
    s=s[0..lhyp]+s[lhyp..lhyp]+s[lhyp+1..];
    lhyp++;
  }
  return ({s[0..lhyp]+S_HYPHEN,s[lhyp+2..]});
}

/* returns int* (sizeof == i) containing all numbers from 1 to i in a special
 * pattern to determine fill point for next space (see blocksatz below) */
static int *make_spread(int i) {
  int *ret,*tmp,k,h;
  for(k=1,tmp=({}),ret=({});k<=i;k++) {
    tmp+=({k});
    ret+=({0});
  }
  for(k=0;k<(i/2);k++) {
    ret[2*k]=tmp[k];
    ret[2*k+1]=tmp[<k+1];
  }
  if(((i/2)*2)!=i) ret[<1]=tmp[k];
  return ret;
}

static string centerline(string s, int len) {
  return sprintf("%|"+len+"."+len+"s",s);
}

static string leftline(string s, int len) {
  return sprintf("%-"+len+"."+len+"s",s);
}

static string rightline(string s, int len) {
  return sprintf("%'"+QueryProp(P_BOOK_FLUSH_CHAR)+"'"+len+"."+len+"s",s);
}

static string blockline(string s, int len) {
  int slen,diff,*vert;
  string *l;
  if((slen=strlen(s))==len)
    return s;
  if(slen>len)
    return 0;
  diff=len-slen;
  if(sizeof((l=efun::explode(s," ")))==1)
    return centerline(restore_symbols(s),len);
  vert=make_spread(sizeof(l)-1);
  for(slen=0;slen<diff;slen++)
    l[vert[slen%sizeof(vert)]-1]+=" ";
  return restore_symbols(implode(l," "));
}

// formats line s within length len. padleft ist used to left-set the last
// line in a block-set paragraph.
varargs static string satz(string s, int len, int padleft) {
  int i,slen;
  string t1,*arr,ws;
  s=implode(efun::explode(s,"-"),"");
  if(padleft&&s[0..0]!="<"&&QueryProp(P_BOOK_SATZ)=="^")
    s="<"+s;
  for(arr=regexplode(s,"[<>|^]"),i=0,ws="";i<sizeof(arr);i+=2) {
    if(i) SetProp(P_BOOK_SATZ,arr[i-1]);
    slen=len-strlen(ws);
    if(sizeof(arr)>i+1) slen=bstrlen(arr[i]);
    ws+=funcall((["|":#'centerline, "<":#'leftline, ">":#'rightline,
      "^":#'blockline])[QueryProp(P_BOOK_SATZ)], restore_symbols(arr[i]),slen);
  }
  return ws;
}

/* main text formatting method.
 * INPUT: The text (normally from the file)
 * RETURN: Array containing formatted lines.
 */
varargs static string *break_text(string text) {
  int i,j,linel,h1,h2,lw;
  string *t,*para,*tmp,line,*hyp;
  if(!(para=parse_text(text))||!pointerp(para)||
     !sizeof(para)||(linel=QueryProp(P_BOOK_PAGE_WIDTH))<10)
    return 0;
  i=0; t=({});
  for(i=0,t=({});i<sizeof(para);i++) {
    SetProp(P_BOOK_SATZ,"^"); // default: Blocksatz.
    if(para[i]=="%") {
      t+=({"%"});
      continue;
    }
    tmp=efun::explode(para[i]," ")-({""});
    for (j=0,line="";j<sizeof(tmp);j++) {
      lw=(j==sizeof(tmp)-1);
      // schon was in der Zeile?
      if (h1=bstrlen(line)) {
        // passt das naechste Wort noch rein?
        if (h1+(h2=bstrlen(tmp[j]))+1<=linel) {
          line+=(" "+tmp[j]);
        } else { // wenn nicht, laesst es sich passend trennen?
          if (hyp=hyphen(tmp[j],linel-(h1+1))) {
            t+=({satz(line+" "+hyp[0],linel, (strlen(hyp[1])?0:lw))});
            line=hyp[1];
          } else { // sonst Zeile setzen und Wort in naechste Zeile.
            t+=({satz(line,linel)});
            line=tmp[j];
          }
        }
      } else { // Zeile leer
        if (h1+(h2=bstrlen(tmp[j]))<=linel) { // Wort passt rein?
          line+=tmp[j];
        } else {
          // solange Restwort laenger als Zeile
          while (bstrlen(tmp[j])>linel) {
            if (hyp=hyphen(tmp[j],linel)) { // Trennen?
              t+=({satz(hyp[0],linel, (strlen(hyp[1])?0:lw))});
              tmp[j]=hyp[1];
            } else { // sonst brutal durchschlagen.
              t+=({satz(tmp[j][0..(h2=bpos(tmp[j],linel))], linel,
                (strlen(tmp[j][h2+1..])?0:lw))});
              tmp[j]=tmp[j][h2+1..];
            }
          }
          line=tmp[j];
        }
      }
    } /* for j=0 */
    t+=({satz(line,linel,1)});
  } /* for i=0 */
  return t;
}

/******
 * Anzeigemethoden
 ******/
// returns array (sizeof == 2) with the lines of the two pages starting at
// pagenr with pageheight pageh.
static mixed *get_doublepage(int pagenr,int pageh) {
  int lnl,lnr,i,pos;
  string *t;
  if(pagenr<1)
    return 0;
  if((pagenr/2)*2==pagenr)
    pagenr--;
  t=QueryProp(P_BOOK_TEXT);
  if(QueryProp(P_BOOK_BLANK_HEADERS)) {
    for(lnl=0,i=1;i<pagenr;i+=2) {
      if ((pos=member_array("%",t[lnl..lnl+(2*pageh)]))<0) {
        lnl+=(2*pageh);
      } else {
        lnl+=(pos+1);
        if(pos+1<pageh) {
          if((pos=member_array("%",t[lnl..lnl+pageh]))<0)
            lnl+=pageh;
          else
            lnl+=(pos+1);
        }
      }
    }
    if((pos=member_array("%",t[lnl..lnl+pageh]))<0)
      lnr=lnl+pageh;
    else
      lnr=lnl+pos+1;
    if((pos=member_array("%",t[lnr..lnr+pageh]))<0)
      pos=pageh;
    if(sizeof(t)<lnl+1)
      return 0;
    return ({t[lnl..lnr-1],t[lnr..lnr+pos]});
  }
  lnl=full_header_pages(pageh,pagenr);
  lnr=full_header_pages(pageh,pagenr+1);
  if(sizeof(t)<lnl+1)
    return 0;
  i=lnr-1;
  while(lnr<sizeof(t)&&!strlen(strip(t[lnr])))
    lnr++;
  if((pos=member_array("%",t[lnr..lnr+pageh]))<0)
    pos=pageh;
  return({t[lnl..i],t[lnr..lnr+pos]});
}

// returns the picture, i.e. the string containing doublepage pagenr with
// pageheight pageh
static string picture_doublepage(int pagenr,int pageh) {
  mixed *pgs; // pages
  string frc,fic,padstr,disp,t1,t2; /* framechar,fillchar,padstring,display */
  int linel,i; /* linelength */
  if(pagenr<1)
    return 0;
  if((pagenr/2)*2==pagenr)
    pagenr--;
  if(!(pgs=get_doublepage(pagenr,pageh-6)))
    return 0;
  pgs[0]-=({"%"});
  pgs[1]-=({"%"});
  if(!stringp((frc=QueryProp(P_BOOK_FRAME_CHAR)))||!strlen(frc))
    frc="#";
  if(!stringp((fic=QueryProp(P_BOOK_FILL_CHAR)))||!strlen(fic))
    fic=" ";
  frc=frc[0..0];
  fic=fic[0..0];
  if(!intp((linel=QueryProp(P_BOOK_PAGE_WIDTH))))
    linel=30;
  if(linel<10)
    linel=10;
  disp=charstr(frc,(2*linel)+12)+"\n"+
       frc+charstr(fic,linel+4)+frc+frc+charstr(fic,linel+4)+frc+"\n";
  for(i=0;i<pageh-6;i++) {
      if(sizeof(pgs[0])<i+1)
	t1=charstr(fic,linel);
      else
	t1=pgs[0][i];
      if(sizeof(pgs[1])<i+1)
	t2=charstr(fic,linel);
      else
	t2=pgs[1][i];
      disp+=sprintf("%s"+fic+fic+"%s"+fic+fic+"%s%s"+
		    fic+fic+"%s"+fic+fic+"%s\n",frc,t1,frc,frc,t2,frc);
  }
  disp+=frc+charstr(fic,linel+4)+frc+frc+charstr(fic,linel+4)+frc+"\n";
  padstr=fic;
  if(fic=="'")     /* Sonderbehandlung wegen der Natur von sprintf */
    padstr="\\'";
  if(fic=="\\")
    padstr="\\\\";
  disp+=sprintf("%s"+fic+fic+"%|'"+padstr+"'"+linel+"."+linel+"s"+fic+fic+
		"%s%s"+fic+fic+"%|'"+padstr+"'"+linel+"."+linel+"s"+fic+fic+
		"%s\n",frc,"-"+fic+pagenr+fic+"-",frc,frc,
		"-"+fic+(pagenr+1)+fic+"-",frc);
  disp+=frc+charstr(fic,linel+4)+frc+frc+charstr(fic,linel+4)+frc+"\n"+
        charstr(frc,(2*linel)+12)+"\n";
  return disp;
}

// returns number of pages with pageheight pageh.
static int query_pages(int pageh) {
  int lines;
  if(!pointerp(QueryProp(P_BOOK_TEXT))||
     !(lines=sizeof(QueryProp(P_BOOK_TEXT))))
    return 0;
  pageh-=6;
  if(!QueryProp(P_BOOK_BLANK_HEADERS))
    return full_header_pages(pageh);
  if((lines/pageh)*pageh==lines)
    lines/=pageh;
  else
    lines=(lines/pageh)+1;
  if((lines/2)*2!=lines)
    lines++;
  return lines;
}

// returns string containing number of pages, e.g. "17".
static string pages() {
  int ph;
  if(!(ph=QueryProp(P_BOOK_PAGE_HEIGHT)))
    ph=this_player()->QueryProp(P_SCREENSIZE);
  return to_string(query_pages(ph));
}

/******
 * Kommando-Methoden
 ******/

// Funktion fuer oeffne buch
int open_book(string str) {
  notify_fail("WAS willst Du oeffnen/aufschlagen?\n");
  if(!stringp(str)||!id(lower_case(str)))
    return 0;
  if(QueryProp(P_BOOK_OPEN)) {
    write(capitalize(name(WER,1))+" ist schon aufgeschlagen.\n");
    return 1;
  }
  write("Du schlaegst "+name(WEN,1)+" auf.\n");
  say(capitalize(this_player()->name(WER,1))+" schlaegt "+name(WEN)+" auf.\n");
  return SetProp(P_BOOK_OPEN,1);
}

// Funktion fuer schliesse buch
int close_book(string str) {
  notify_fail("WAS willst Du schliessen/zuschlagen?\n");
  if(!stringp(str)||!id(lower_case(str)))
    return 0;
  if(!QueryProp(P_BOOK_OPEN)) {
    write(capitalize(name(WER,1))+" ist geschlossen.\n");
    return 1;
  }
  write("Du schlaegst "+name(WEN,1)+" zu.\n");
  say(capitalize(this_player()->name(WER,1))+" schlaegt "+name(WEN)+" zu.\n");
  SetProp(P_BOOK_OPEN,0);
  return 1;
}

// Funktion fuer lies buch/seite nr
int read_book(string str) {
  int ph,i;
  notify_fail("WAS willst Du lesen?\n");
  if(!stringp(str)) return 0;
  if(!(ph=QueryProp(P_BOOK_PAGE_HEIGHT)))
    ph=this_player()->QueryProp(P_SCREENSIZE);
  if(!id(lower_case(str))) {
    if(sscanf(str,"seite %d",i)!=1||i<1||i>query_pages(ph)) {
      return 0;
    } else {
      if((i/2)*2==i) i--; SetProp(P_BOOK_PAGE,i);
    }
  }
  if(!QueryProp(P_BOOK_OPEN)) {
    write(capitalize(name(WER,1))+" ist geschlossen.\n");
    return 1;
  }
  if((i=QueryProp(P_BOOK_PAGE))>query_pages(ph)) {
    /* kommt vor, wenn jemand P_SCREENSIZE erhoeht und dadurch die *
     * Seitenzahl abnimmt */
    i=query_pages(ph);
    if((i/2)*2==i) i--;
  }
  say(capitalize(this_player()->name(WER,1))+" liest "+name(WEN)+".\n");
  if(ph>this_player()->QueryProp(P_SCREENSIZE))
    this_player()->More(picture_doublepage(i,ph));
  else
    write(picture_doublepage(i,ph));
  if ((i+=2)<=query_pages(ph)) { // automatically set to next dblpage
    SetProp(P_BOOK_READ,1);
    SetProp(P_BOOK_PAGE,i);
  }
  return 1;
}

// Funktion fuer blaettere vor/zurueck/um
int switch_page(string str) {
  int i,i0,i1,i2,i3,ph;
  string was;
  notify_fail("WIE moechtest Du blaettern?\n");
  if(!stringp(str)||(str=lower_case(str))=="")
    return 0;
  if((i0=member_array(str,({"vor","zurueck","um"})))<0) {
    if(((i1=sscanf(str,"%s vor",was))!=1&&
	(i2=sscanf(str,"%s zurueck",was))!=1&&
	(i3=sscanf(str,"%s um",was))!=1)||!id(was))
      return 0;
  }
  if(!(ph=QueryProp(P_BOOK_PAGE_HEIGHT)))
    ph=this_player()->QueryProp(P_SCREENSIZE);
  i=QueryProp(P_BOOK_PAGE);
  if(QueryProp(P_BOOK_READ)) {
    if((i-=2)<1) i=1;
    SetProp(P_BOOK_READ,0);
  }
  if(!i0||i0==2||i1||i3) { // vorblaettern
    if(i+2>query_pages(ph)) {
      write("Das geht nicht, da ist "+name(WER,1)+" zu Ende.\n");
      return 1;
    }
    SetProp(P_BOOK_PAGE,i+2);
    write("Du blaetterst "+name(WEN,1)+" um.\n");
    say(capitalize(this_player()->name(WER,1))+" blaettert "+name(WEN)+
      " um.\n");
    return 1;
  }
  // zurueckblaettern
  if(i-2<1) {
    write("Das geht nicht, da ist der vordere Einband von "+
      name(WEM,1)+".\n");
    return 1;
  }
  SetProp(P_BOOK_PAGE,i-2);
  write("Du blaetterst in "+name(WEM,1)+" zurueck.\n");
  say(capitalize(this_player()->name(WER,1))+" blaettert "+name(WEN)+
      " um.\n");
  return 1;
}

// Funktion fuer "umblaettern"
int switchpage(string str) {
  return switch_page(QueryProp(P_IDS)[<1]+" um");
}

// Funktion fuer "schlage buch <auf,zu,...>" 8*)
int hit_book(string str) {
  int pg,ph;
  string was,wie;
  notify_fail("WAS willst Du auf/zuschlagen?\n");
  if(!stringp(str)||(str=lower_case(str))==""||
     (sscanf(str,"seite %d %s",pg,wie)!=2&&
      sscanf(str,"%s %s",was,wie)!=2)||
     member_array(wie,({"auf","zu"}))<0)
    return 0;
  if(was) {
    if(wie=="auf")
      return open_book(was);
    else
      return close_book(was);
  }
  if(!(ph=QueryProp(P_BOOK_PAGE_HEIGHT)))
    ph=this_player()->QueryProp(P_SCREENSIZE);
  if(pg<1||pg>query_pages(ph)) {
    write("Die Seite "+pg+" gibts in "+name(WEM,1)+" nicht.\n");
    return 1;
  }
  if((pg/2)*2==pg)
    SetProp(P_BOOK_PAGE,pg-1);
  else
    SetProp(P_BOOK_PAGE,pg);
  write("Du schlaegst Seite "+pg+" auf.\n");
  if(QueryProp(P_BOOK_OPEN)) {
    say(capitalize(this_player()->name(WER,1))+" blaettert "+name(WEN)+
      " um.\n");
  } else {
    SetProp(P_BOOK_OPEN,1);
    say(capitalize(this_player()->name(WER,1))+" schlaegt "+name(WEN)+
      "auf.\n");
  }
  return 1;
}

/******
 * Lokale Property-Methoden
 ******/

string _set_book_contents(string arg) {
  string text;
  if(!stringp(arg)||file_size(arg)<0||file_size(arg)>64000)
    return 0;
  if(file_size(arg+".lines")>0&&file_size(arg+".lines")<=64000&&
     (file_time(arg+".lines")>file_time(arg))) {
    if(text=read_file(arg+".lines")) {
      SetProp(P_BOOK_TEXT,efun::explode(text,"\n"));
      SetProp(P_BOOK_PAGE,1);
      return Set(P_BOOK_CONTENTS,arg+".lines");
    }
  }
  if(!(text=read_file(arg)))
    return 0;
  SetProp(P_BOOK_TEXT,break_text(text));
  SetProp(P_BOOK_PAGE,1);
  if(file_size(arg+".lines")>-1) rm(arg+".lines");
  write_file(arg+".lines",implode(QueryProp(P_BOOK_TEXT),"\n"));
  return Set(P_BOOK_CONTENTS,arg);
}

int _set_book_page_width(int arg) {
  int ret;
  if(!intp(arg)||arg<10)
    arg=10;
  ret=Set(P_BOOK_PAGE_WIDTH,arg);
  SetProp(P_BOOK_PAGE,1);

  // Dies mag sinnlos erscheinen, laedt aber den Text neu und bricht ihn
  // nochmal um.
  SetProp(P_BOOK_CONTENTS,QueryProp(P_BOOK_CONTENTS));
  return ret;
}

string _set_book_flush_char(string arg) {
  string ret;
  if(!stringp(arg)||!strlen(arg))
    return Set(P_BOOK_FLUSH_CHAR," ");
  ret=Set(P_BOOK_FLUSH_CHAR,arg[0..0]);
  SetProp(P_BOOK_PAGE,1);

  // Dies mag sinnlos erscheinen, laedt aber den Text neu und bricht ihn
  // nochmal um.
  SetProp(P_BOOK_CONTENTS,QueryProp(P_BOOK_CONTENTS));
  return ret;
}

string _set_book_fill_char(string arg) {
  if(!stringp(arg)||!strlen(arg))
    return Set(P_BOOK_FILL_CHAR," ");
  return Set(P_BOOK_FILL_CHAR,arg[0..0]);
}

string _set_book_frame_char(string arg) {
  if(!stringp(arg)||!strlen(arg))
    return Set(P_BOOK_FRAME_CHAR," ");
  return Set(P_BOOK_FRAME_CHAR,arg[0..0]);
}
