/*******************
** Eldarea MUDLib **
********************
**
** std/container/description.c - container description
**
** CVS DATA
** $Date: 2001/01/31 13:42:20 $
** $Revision: 1.3 $
**
** CVS History
**
** $Log: description.c,v $
** Revision 1.3  2001/01/31 13:42:20  elatar
** process_string() replaced by funcall()
**
** Revision 1.2  2000/12/04 10:34:22  elatar
** new color handling adapted
**
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "std/thing/description";

#pragma strong_types

#include <properties.h>
#include <defines.h>
#include <wizlevels.h>
#include <color.h>

#define NEED_PROTOTYPES

#include <container.h>

void create() { 
  ::create();
  SetProp(P_TRANSPARENT, 1);
  AddId("container");
}

string long() {
  string descr, inv_descr;

  descr = funcall(QueryProp(P_LONG));
  if (!QueryProp(P_TRANSPARENT)) return descr;

  inv_descr = make_invlist( this_player(), all_inventory(ME) );
  if( inv_descr != "" ) {
    if (descr[<1] != '\n') descr += "\n";
    descr += capitalize(QueryPronoun()) + " enthaelt:\n" + inv_descr;
  }

  return descr;
}

// called by make_invlist()
// Wird _ausschliesslich_ fuer die Inhaltsangabe in Spielern benutzt,
// also fuer Befehl 'inv'
static mixed inv_entry(mixed obj, mixed flags) {
  string sh;
  int i;
  sh=obj->short();
  if (!sh && obj->QueryProp(P_PLURAL)) {
    sh=obj->name(WER, NAME_INDEF|NAME_DESCR|NAME_UACT);
    if (sh) sh=capitalize(sh)+".\n";
  }
  if(flags[2]) {
    if(sh)
      sh=sh[0..<2]+
        flags[0]->colorize(" ["+file_name(obj)+"]", CG_PATH)+"\n";
    else
      sh="- keine Kurzbeschreibung -"+
        flags[0]->colorize(" ["+file_name(obj)+"]", CG_PATH)+"\n";
  }
  if(sh && flags[1] && member(flags[3],'m')!=-1)
    sh=((obj->QueryProp(P_NOSELL)||obj->QueryProp(P_NODROP))?"# ":
      (obj->QueryProp(P_UNSELLABLE)==flags[1]?"* ":"  "))+sh;
  if (sh && member(flags[3],'n')!=-1) {
    i=my_inv_nr(obj); // Achtung, diese Fun ist nur in Spielern definiert
    if (i) sh=sprintf("%2d. %s", i, sh);
    else sh="    "+sh;
  }
  return (sh?sh:"");
}

varargs string make_invlist(object viewer, mixed inv, mixed extra) {
  mixed euid;
  int e, z, i, j, n, l;
  if(query_once_interactive(ME)) {
     euid=geteuid(ME);
  } else {
    extra = "";
    euid = 0;
  }
  l=IS_LEARNING(viewer);
  if (euid) {
    return implode(map_array(inv, #'inv_entry, ({viewer, euid, l, extra})),"");
  }
  i=sizeof(inv);
  inv=({ inv, allocate(i), allocate(i), allocate(i) });
  /** inv enthaelt vier Arrays (vereinfacht dargestellt)
  *** zunaechst           obj,            0,        0,        0
  *** bei P_INVIS       short,           -1, filename,   living
  *** sonst               obj, name(PLURAL), filename,   living
  *** Das 3. Array enthaelt den Filenamen, wenn viewer ein Magier ist */
  for (i=sizeof(inv[0]); i--;) {
    if (l) inv[2][i]=viewer->colorize(" ["+file_name(inv[0][i])+"]", CG_PATH);
    inv[3][i]=living(inv[0][i]);
    if (inv[0][i]->QueryProp(P_INVIS)) {
      if (l) {
        inv[0][i]=inv[0][i]->short();
        if (inv[0][i]) inv[0][i]=inv[0][i][0..<3];
      } else inv[0][i]=0;
      inv[1][i]=-1;
    } else inv[1][i]=inv[0][i]->name(WER,
      NAME_INDEF|NAME_DESCR|NAME_PLURAL|NAME_UACT);
  }

  for (i=sizeof(inv[0]); i--;) {
    if (inv[1][i]==-1) continue; // Geloescht wegen Mehrzahl vorhanden
    if (inv[0][i]->QueryProp(P_PLURAL)=="") {
      inv[0][i]=inv[0][i]->name(WER, NAME_INDEF|NAME_DESCR);
      //***           name,    <undef>,  filename
      continue;
    }
    if (!inv[1][i]) {
      inv[0][i]=inv[0][i]->short();
      if (stringp(inv[0][i])) inv[0][i]=inv[0][i][0..<3];
      //***           short,         0,  filename
      continue;
    }
    /** Jetzt enthaelt inv
    *** P_INVIS, P_PLURAL=="", P_PLURAL==0  -> kommt hier gar nicht an,
    *** enthaelt            short|name,      <undef>,  filename
    *** Was hier ankommt hat       obj, name(PLURAL),  filename      */
    e=0;
    n=0; // Anzahl Gleiche bestimmen:
    while ((j=member_array(inv[1][i], inv[1]))!=i) {
      n++;
      inv[1][j]=-1;
      inv[0][j]=0;
      // Gleiche werden entfernt (ersetzt durch   0,  -1,  filename )
      if (l) {
        // 3. Array (filename) evt anpassen
        if (!e && efun::explode(inv[2][i], "#")[0]!=
          efun::explode(inv[2][j], "#")[0]) e=1;
        inv[2][j]=0;
      }
    }
    if (!n) { // Nur 1 Stueck gefunden
      inv[0][i]=inv[0][i]->name(WER, NAME_INDEF|NAME_DESCR);
      //     name(SINGULAR),  name(PLURAL),  filename
      continue;
    }
    n++; // Enthaelt nun echte Anzahl
    if (l) {
      // filenamen anpassen
      if (e) inv[2][i]=viewer->colorize(" [variiert]", CG_PATH);
      else {
        inv[2][i]=efun::explode(inv[2][i], "#");
        inv[2][i][1]="..."+inv[2][i][1][member(inv[2][i][1], ']')..];
        inv[2][i]=implode(inv[2][i], "#");
      }
    }
    if (inv[0][i]->QueryProp(P_ARTICLE)==ART_NONE) {
      // Wenn kein Artikel, auch kein Zahlwort
      // inv:   name(PLURAL),  name(PLURAL),  filename
      inv[0][i]=inv[1][i];
      continue;
    }
    inv[0][i]=to_string(n)+" "+inv[1][i];
    // inv:   Zahlwort+name(PLURAL),  name(PLURAL),  filename
  } /* for() */
  i=sizeof(inv[0]);
  if (i) inv[0]+=({""}); // Fuer letztes \n
  for (; i--;) {
    if (inv[0][i]) {
      if (inv[3][i])
        inv[0][i]=viewer->colorize(capitalize(inv[0][i])+".", CG_LIVING);
      else inv[0][i]=capitalize(inv[0][i])+".";
      if (l) inv[0][i]+=inv[2][i];
    } else if (l)
      inv[0][i]=inv[2][i];
  }
  return implode(inv[0]-({0}), "\n");
}
