/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:47 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: restrictions.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:47  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// CONTAINER/RESTRICTIONS.C -- container restrictions
// hervorgegangen aus der MorgenGrauen MUDlib Revision 2.6
//
// $Date: 1999/11/05 12:30:47 $                      
// $Revision: 1.1.1.1 $   
/*    
 * $Log: restrictions.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:47  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:14  en
 * MUDLib CVS Preperation
 *
 * Revision 1.12  1999/01/15 15:05:49  Fiona
 * present_objects() fit gemacht fuer unsichtbare neue P_PLURAL
 *
 * Revision 1.11  1998/02/21 13:58:24  Holger
 * /std/thing/restrictions.c inheritet, um P_GUILD_OBJECT-Handling
 * nicht doppelt einbauen zu muessen. Hoffe es bugt nix...
 *
 */                            

// This is a simple container to put objects in. It defines all functions
// which are necessary to describe an object which can be filled with
// other things.
//
// It will support restrictions for volume, weight etc.
//
// The following properties are defined:
// P_MAX_WEIGHT - maximum weight which container can carry
// P_TOTAL_WEIGHT - total weight, with contents.
// P_WEIGHT - the weight of the container without contents
//
// Functions for manipulation of weight
// MayAddWeight(weight) - Can <weight> be inserted?
// AddWeight(weight) - Add an amount of <weight>
//
// IMPORTANT: unit equals 1 gram

inherit "std/thing/restrictions";

#pragma strong_types

#define NEED_PROTOTYPES

#include "/sys/thing/properties.h"
#include <properties.h>
#include <defines.h>

// local properties prototypes
static int _query_total_weight();

void create()
{
  Set(P_WEIGHT_PERCENT, 50);
  Set(P_TOTAL_WEIGHT, -1, F_SET_METHOD);
  Set(P_TOTAL_WEIGHT, PROTECTED, F_MODE);
  SetProp(P_MAX_BULKINESS, 500);
  SetProp(P_BULKINESS, 20);
}

int query_weight_contents()
{
  object *objs;
  int w,w2,i;

  w=0;
  objs=all_inventory(this_object());
  i=sizeof(objs);
  while (i--)
  {
    if (!(w2=objs[i]->QueryProp(P_TOTAL_WEIGHT)))
      w2=objs[i]->QueryProp(P_WEIGHT);
    w+=w2;
  }
  return w;
}

varargs int MayAddWeight(int w)
{
  object env;
  if (w<=0) return 0;
  if (query_weight_contents() + w > ME->QueryProp(P_MAX_WEIGHT))
    return -1;
  /* Behaelter muessen auch den Living checken */
  if ((env=environment(ME)) && living(env) &&
      env->MayAddWeight(ME->QueryProp(P_WEIGHT_PERCENT)*w/100)<0)
    return -1;
  return 0;
}

static int _query_bulkiness_contents() {
  int i;
  object ob;
  ob=first_inventory();
  while (ob) {
    i+=ob->QueryProp(P_BULKINESS);
    ob=next_inventory(ob);
  }
  return i;
}

int MayAddBulkiness(int x) {
	int y;
	object ob;
	y=QueryProp(P_MAX_BULKINESS);
	if (y<=0) return 0;
	map_array(all_inventory(), lambda( ({'a, 'b}),
	  ({#'-=, 'b, ({ #'call_other, 'a, "QueryProp", P_BULKINESS }) }) ), &y);
	if (x>y) return -1;
	return 0;
}

/* Redefine PreventInsert() to prevent inserting of special objects. If
 * a value greater 0 is returned the object ob can't be inserted in the
 * container.
 */
varargs int PreventInsert(object ob) { return 0; }

/*
 * get a list of all contained objects matching a complex description
 */
object *present_objects(string complex_desc, object *exclude) 
{
  object ob, *obj, *found;
  int i;
  string was, wieviel;

  if (complex_desc == "alles" || complex_desc == "alle") 
    return filter_array(all_inventory(), lambda( ({ 'x }), ({
      #'||, ({ #'call_other, 'x, "short" }),
            ({ #'call_other, 'x, "QueryProp", P_PLURAL }) }) ));
  if ((sscanf(complex_desc, "alle %s", was) == 1) ||
      (sscanf(complex_desc, "alles %s", was) == 1) ||
      (sscanf(complex_desc, "allen %s", was) == 1))
  //if ((sscanf(complex_desc, "%s %s", wieviel, was) == 2) &&
  //     (wieviel == "alle" || wieviel == "alles" || wieviel == "allen")) 
  {
    found = ({});
    switch (was)
    {
      case "waffen": case "waf":
      {
        obj=all_inventory(this_object());
        for (i=0;i<sizeof(obj);i++)
          if (function_exists("DoUnwield", obj[i]))
            found += ({ obj[i] });
        return found;
        //Funktioniert leider nicht so wie es soll
        //return filter_objects(all_inventory(this_object()), "function_exists", "DoUnwield");
      }
      case "ruestungen": case "rue":
      {
        obj=all_inventory(this_object()); 
        for (i=0;i<sizeof(obj);i++)
          if (function_exists("DoUnwear", obj[i]))
            found += ({ obj[i] });
        return found;
        //Funktioniert leider nicht so wie es soll
        //return filter_objects(all_inventory(this_object()), "function_exists", "DoUnwear");
      }
      default:
        if (present(was, this_object()))
          return filter_objects(all_inventory(this_object()), "id", was);
        was = was[0..<2];
        if (present(was, this_object()))
          return filter_objects(all_inventory(this_object()), "id", was);
        was = was[0..<2];
        if (present(was, this_object()))
          return filter_objects(all_inventory(this_object()), "id", was);
    }
  }
  if (ob = present(complex_desc, this_object()) )
  {
    obj = filter_objects(all_inventory(this_object()), "id", complex_desc) -
      (exclude || ({ 0 }));
    if (sizeof(obj)) return ({ obj[0] });
  }
  return ({}) ;
}

/* 
 * returns a list of all found objects inside itself
 * may call same function in objects inside
 */
object *locate_objects(string complex_desc, int info, object *exclude) 
{
  object *search_obs;
  object *found_obs;
  object *found_i;
  int i;
  string was, wo;
  
  found_obs = ({});

  if (sscanf(complex_desc, "%s auf %s", was, wo) == 2)
  {
    search_obs = present_objects(wo, 0);
    for (i = 0; i < sizeof(search_obs); i++)
    {
      found_i = search_obs[i]->locate_objects(was, info, 0);
      if (pointerp(found_i)) found_obs += found_i;
    }
    return found_obs;
  }
  if (sscanf(complex_desc, "%s in %s", was, wo) == 2)
  {
    search_obs = present_objects(wo, 0);
    for (i=0; i<sizeof(search_obs); i++)
    {
      found_i = search_obs[i]->locate_objects(was, info, 0);
      if (pointerp(found_i)) found_obs += found_i;
    }
    return found_obs;
  }
  // kein "auf" oder "in" gefunden
  return present_objects(complex_desc, exclude);
}

// **** local property methods
static int _query_total_weight() 
{ 
  return QueryProp(P_WEIGHT)+
    (QueryProp(P_WEIGHT_PERCENT)*query_weight_contents()/100); 
}

