/*******************
** Eldarea MUDLib **
********************
**
** std/corpse.c - standard corpse
**
** CVS DATA
** $Date: 2000/12/15 15:34:03 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: corpse.c,v $
** Revision 1.2  2000/12/15 15:34:03  elatar
** removed channel messages
**
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "std/container";

#pragma strict_types

#include <properties.h>
#include <defines.h>
#include <moving.h>
#include <wizlevels.h>

#define NEED_PROTOTYPES

#include <corpse.h>

private string nam;
private int typ;

void create() 
{
  ::create();
    
  if(!clonep()) return;

  nam=(string)0;
  typ=0;
  SetProp(P_GENDER, FEMALE);
  SetProp(P_NAME, "Leiche");
  SetProp(P_PLURAL, "Leichen");
  SetProp(P_LONG, "Du siehst eine Leiche.");
  SetProp(P_WEIGHT, 75000);
  SetProp(P_HEAL, 0);
  SetProp(P_BULKINESS, 750); // P_WEIGHT/100
    
  SetProp(P_CORPSE_DECAY, 4);
  SetProp(P_CORPSE_DECAY_TIME, 30);

  SetProp(P_KILLER, 0);       // Kein Killer
  SetProp(P_VICTIM, 0);       // Kein Opfer

  // Default-Leiche
  SetProp(P_VICTIM_TYPE, 0);              // NPC
  SetProp(P_VICTIM_NAME, "Monster");      
  SetProp(P_VICTIM_GENDER, NEUTER);
  SetProp(P_VICTIM_MAX_HP, 100);
  SetProp(P_VICTIM_LEVEL, 1);
  SetProp(P_VICTIM_XP, 0);
  SetProp(P_VICTIM_HANDS, ({ "", 50 }));
  SetProp(P_VICTIM_MAX_HANDS, 2);
  SetProp(P_VICTIM_ARMOURS, ({}));
  SetProp(P_VICTIM_WEAPONS, ({}));
  SetProp(P_VICTIM_BODY, 0);
  SetProp(P_VICTIM_RACE, "Npc");
  SetProp(P_VICTIM_ALIGN, 0);
  SetProp(P_VICTIM_WEIGHT, 75000);
  SetProp(P_VICTIM_HEAL, 0);
  SetProp(P_VICTIM_AGGRESSIVE, 0);

  AddId(({"leiche", "rest", "ueberrest"}),
        ({"leichen", "reste", "ueberreste"}));
    
  AddCmd("iss|esse|verspeise&leiche|rest|ueberrest","mampf",
    "Was moechtest Du essen?");
    
  call_out("start", 0);
}

// Propertie-Initialisierung
void init() 
{
  ::init();
  
  if(!nam)
  {
    SetProp(P_GENDER, QueryProp(P_VICTIM_GENDER));
    SetProp(P_NAME, QueryProp(P_VICTIM_NAME));
    SetProp(P_ARTICLE, QueryProp(P_VICTIM_ARTICLE));
    nam = name(WESSEN);
    typ = (int) QueryProp(P_VICTIM_TYPE)==1;
    SetProp(P_GENDER, FEMALE);
    if (typ)
    {
      SetProp(P_NAME, ({nam+" Leiche", nam+" Leiche",
                        nam+" Leiche", nam+" Leiche"}));
      SetProp(P_PLURAL, "");
    }
    else
    SetProp(P_NAME, "Leiche");
    SetProp(P_DESCR, (typ ? 0 : nam));
    SetProp(P_ARTICLE, (typ ? ART_NONE : ART_DEF));
    SetProp(P_LONG, 
      (typ ? "Du siehst "+nam+" sterbliche Ueberreste." : 
             "Du siehst die sterblichen Ueberreste "+nam+"."));
    SetProp(P_WEIGHT, QueryProp(P_VICTIM_WEIGHT));
    SetProp(P_BULKINESS, QueryProp(P_WEIGHT) / 100);
    SetProp(P_HEAL, QueryProp(P_VICTIM_HEAL));
  }
}

// Starte Verwesungsprozess
void start()
{
    while(remove_call_out("do_decay") != -1);
    call_out("do_decay", (int) QueryProp(P_CORPSE_DECAY_TIME));
    return;
}

// Verwesung
void do_decay()
{
  int decay;
  decay = (int) QueryProp(P_CORPSE_DECAY);
  decay--;
  if(decay > 0)
  {
    switch(decay)
    {
      case 3:
	if(typ)
	{
	  SetProp(P_NAME, "Leiche");
          SetProp(P_NAME_ADJ, capitalize(nam)+" bereits ziemlich stinkend");
          SetProp(P_DESCR, 0);
          SetProp(P_LONG, "Du siehst "+nam+" sterbliche Ueberreste. "
            "Die Leiche ist bereits schon ein wenig verwest und "
            "stinkt vor sich hin.");
        }
	else
        {
          SetProp(P_NAME_ADJ, "bereits ziemlich stinkend");
          SetProp(P_DESCR, nam);
          SetProp(P_LONG, "Du siehst die sterblichen Ueberreste "+ nam+
            ". Die Leiche ist bereits schon ein wenig verwest und "
            "stinkt vor sich hin.");
        }
        SetProp(P_SMELL, "Die Leiche stinkt ekelerregend.");
        break;
        
      case 2:
	if(typ)
	{
	  SetProp(P_NAME, "Leiche");
          SetProp(P_NAME_ADJ, ({capitalize(nam)+" schimmelnd", "und halbverwest"}));
          SetProp(P_DESCR, 0);
          SetProp(P_LONG, "Du siehst "+nam+" sterbliche Ueberreste. "
            "Die Leiche ist bereits schon halb verwest und "
            "stinkt wirklich uebel."); 
        }
	else
	{
          SetProp(P_NAME_ADJ, ({"schimmelnd", "und halbverwest"}));
          SetProp(P_DESCR, nam);
          SetProp(P_LONG, "Du siehst die sterblichen Ueberreste "+ nam+
            ". Die Leiche ist bereits schon halb verwest und "
            "stinkt wirklich uebel."); 
        }
	if ((int) QueryProp(P_HEAL) >= -4)
	  SetProp(P_HEAL, -4);
        SetProp(P_SMELL, ({"Die Leiche verbreitet einen ueblen "
          "beissenden Geruch. Dir wird schlecht.","&&WER&& riecht "
          "an der Leiche und wird ganz blass."}));
        SetProp(P_SOUND, "Du hoerst die fetten Maden darin "
          "schmatzen.");
        AddDetail(({"maden","made"}),"Man kann sie zwar nicht sehen, "
          "aber dafuer kann man sie umso lauter hoeren.");
        AddSoundDetail(({"maden","made"}),"SCHMATZ, SCHLABBER... <RUELPS>");
	break;
	
      case 1: 
	if(typ)
	{
	  SetProp(P_NAME, "Einzelteile");
          SetProp(P_NAME_ADJ, capitalize(nam)+" verfault");
          SetProp(P_LONG, "Du siehst "+nam+" sterbliche Ueberreste. "
            "Die Leichenteile sind fast verfault und "
            "stinken bestialisch."); 
        }
	else
	{
          SetProp(P_NAME, ({"verfaulten Einzelteile", "verfaulten Einzelteile",
                            "verfaulten Einzelteilen", "verfaulten Einzelteile"}));
          SetProp(P_PLURAL, ({"Haufen verfaulter Einzelteile",
                              "Haufen verfaulter Einzelteile",
                              "Haufen verfaulter Einzelteile",
                              "Haufen verfaulter Einzelteile"}));
          SetProp(P_NAME_ADJ, 0);
          SetProp(P_DESCR, nam);
          SetProp(P_LONG, "Du siehst die sterblichen Ueberreste "+ nam+
            ". Die Leichenteile sind fast verfault und "
            "stinken bestialisch."); 
        }
        
        SetProp(P_SMELL, ({"Die Leichenteile stinken entsetzlich. "
          "Du uebergibst Dich fast.","&&WER&& riecht an der Leiche "
          "und uebergibt sich fast."}));
        SetProp(P_SOUND, "Du hoerst tausende Insekten, Maden und "
          "Wuermer darin kratzen und scharren.");
        AddDetail(({"insekt","insekten"}),"Die Insekten sind nur zu "
          "hoeren und Du willst Sie doch eigentlich lieber nicht "
          "bei ihrer Arbeit sehen, oder?");
        AddSoundDetail(({"insekt","insekten"}),"KRATZ, KNABBER, "
          "SCHAB...");
        AddDetail(({"wurm","wuermer"}),"Die Wuermer graben sich ihre "
          "Nester in den Leichenteilen. So schliesst sich der "
          "Kreislauf des Lebens.");
        AddSoundDetail(({"wurm","wuermer"}),"GRAB, GRAB, GRAB...");
	break;
    }
    
    SetProp(P_CORPSE_DECAY, decay);
    call_out("do_decay", QueryProp(P_CORPSE_DECAY_TIME));
    return;
  }
  if (environment()) map_objects(all_inventory(), "move", environment(),
	M_SILENT|M_NOCHECK|M_MOVE_ALL);
  remove();
}

// essen
int mampf()
{
  int heal;
  
  if(!PL->eat_food(20)) return 1;
  say(sprintf("%s wird von %s voll Hingebung verspeist.\n",
    capitalize(name(WER)), PL->name(WEM,2)));
  if((heal = QueryProp(P_HEAL))<0) {
    PL->do_damage(random(-heal));
    write("Buah, diese Leiche war zweifellos nicht besonders gesund.\n");
  }
  else
  {
    PL->heal_self(random(heal));
    write("Hmmm, lecker!\n");
  }
  if (environment()) map_objects(all_inventory(), "move", environment(),
    M_SILENT|M_NOCHECK|M_MOVE_ALL);
  ME->remove();
  return 1;
}
